#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdio.h>
#include <math.h>
#include <ddraw.h>
#include <stdlib.h>
#include "Fsound.h"
#include "Fmusic.h"
#include "intro.h"
#include "ddex.h"
#include "grf.h"
#include "fillp.h"
#include "3d1.h"
#include "kreis.dat"
//printspr function
#include "pismo.cpp"
//newgr and scrollup2 fnc.
#include "rutohen.cpp"


//external decl 
LPDIRECTDRAW            lpDD;            // DirectDraw object...
LPDIRECTDRAWSURFACE     lpDDSPrimary;    // DirectDraw primary surface...
LPDIRECTDRAWSURFACE     lpDDSBack;       // DirectDraw backbuffer...
LPDIRECTDRAWPALETTE     lpDDPal;         // Palette...
BOOL                    bActive;  //rika jestli je aplikace aktivni 
HDC                     hdc;
DWORD                   dwFillColor;
unsigned char         Vpismo[320*200];
unsigned char         palette[768];
unsigned char         palettecil[768];
int                    frame_cnt;  //global frame counter
int                    frame_cnt2;  //local frame counter
unsigned char         data[128*128];
PALETTEENTRY  pal[256];

//virtualni screen, ten pak nakopcim do backbufferu
unsigned char virtscreen[64000];
int first=0;    //for firs palette count
unsigned char Fractal[320*200];
//for 3dpart1;
int incz,pocet;
int part1=0,part2=0,part3=0,part4=0;
long patern;


//for plasma part
int incy;
int cisl;


void first3d(void);
void second3d(void);
void plasma3d(void);

#include "fract.c"
#include "3dpr1.cpp"
#include "3dpr2.cpp"
#include "plasma1.cpp"

PALETTEENTRY *set3D1pal(void);
PALETTEENTRY *set3D2pal(void);
PALETTEENTRY *setPlasmapal(void);


// Macro for releasing Objects...
#define RELEASE(x) if( x != NULL ) { x->Release(); x = NULL; }

//kopiruje obsah virt pameti primo do backsurface 
void CopyBuffer(unsigned char* virtSrc)
{
        DDSURFACEDESC           ddsd;
        HRESULT                 ddrval;
        unsigned char*        pVScreen;
        DWORD                   lPitch; //delka radky v bajtech
        int                     j;

        
        ddsd.dwSize = sizeof(ddsd);
        while(1)
        {
                ddrval=lpDDSBack->Lock(NULL, &ddsd, DDLOCK_WAIT | DDLOCK_SURFACEMEMORYPTR, NULL );
                if(ddrval == DD_OK)
                        break;
                if (ddrval != DDERR_WASSTILLDRAWING)
                        return;
                 else Error("Lock Error"); 
        }
        pVScreen=(unsigned char*)ddsd.lpSurface;  //surface write memory pointer                                                              // Get pointer to video memory
        lPitch = ddsd.lPitch;
        for (j=0;j<Yres;j++)
         {
          memcpy(pVScreen+j*lPitch,virtSrc+j*Xres,Xres);
         }    
        ddrval=lpDDSBack->Unlock(NULL);                                                                                                        // Free the surface     
        if(ddrval == DD_OK)
                      return;
         else Error("cannot unlock");

}


void putplot(int x, int y)
{
 unsigned int mistocil;
 int yloop,xloop;
 unsigned int mistozdroj=0;

 mistocil=x+y*320;         //misto x,y v buferu                   
 for(yloop=59;yloop>(-1);yloop--)
  {mistocil+=240;         //posun na dalsi radek (320-80)
   for(xloop=79;xloop>(-1);xloop--)
    {virtscreen[mistocil++]=texture[mistozdroj++]+virtscreen[mistocil];
     /*mistocil++;      // vykresli na misto v bufferu bod z textury z
      mistozdroj++*/;   // puvodniho bufferu 
     }
   } 
} 

//------------------------------------------------------------------------------------    
//---------------------HEART BEAT YA,YA-----------------------------------------------    
//------------------------------------------------------------------------------------    

void HeartBeat( void )
{
   unsigned long  timefrom,timeto;

   patern=FMUSIC_GetOrder(mod);
   timefrom=FMUSIC_GetTime(mod);

   if (frame_cnt==0)
    {
     setFirepal();
     setpal(pal);
     part1=1;
     frame_cnt2=0;
    }   
   if (patern>10 && part1==1)
    {
      memset(virtscreen,0,Xres*Yres);
      CopyBuffer(virtscreen);
      Flipscreen();
      set3D1pal();
      setpal(pal);
      part1=0;
      part2=1;
      frame_cnt2=0;
    }
   if (patern>29 && part2==1)
    {
      memset(virtscreen,0,Xres*Yres);
      CopyBuffer(virtscreen);
      Flipscreen();
      set3D2pal();
      setpal(pal);
      part2=0;
      part3=1;
      frame_cnt2=0;
    }
   if (patern>45 && part3==1)
    {
      memset(virtscreen,0,Xres*Yres);
      CopyBuffer(virtscreen);
      Flipscreen();
      setPlasmapal();
      setpal(pal);
      part3=0;
      part4=1;
      frame_cnt2=0;
    }
  if (patern>58)
    {
     PostMessage(myHwnd, WM_CLOSE, 0, 0);
    } 
   if (part1)
    {
     ohen();
     do
      {
       timeto=FMUSIC_GetTime(mod);
      } while ((timeto-timefrom)<5);
     return;
    }
   if (part2)
    {
     first3d(); 
     do
      {
       timeto=FMUSIC_GetTime(mod);
      } while ((timeto-timefrom)<5);
     return;
    }
   if (part3)
    {
     second3d(); 
     do
      {
       timeto=FMUSIC_GetTime(mod);
      } while ((timeto-timefrom)<15);
     return;
    }
   if (part4)
    {
     plasma3d(); 
     do
      {
       timeto=FMUSIC_GetTime(mod);
      } while ((timeto-timefrom)<30);
     return;
    }
}


//------------------------------------------------------------------------------------    
//------------------------------------------------------------------------------------    

void ohen( void )
{
 double xa,ya,xb,yb,xc,yc,xd,yd,xe,ye;
 int x1,x2,x3,x4,x5,y1,y2,y3,y4,y5;
 int x6,x7,x8,x9,x10,x11,x12,x13,x14,x15,x16,x17,x18,x19,x20;
 int y6,y7,y8,y9,y10,y11,y12,y13,y14,y15,y16,y17,y18,y19,y20;
 //myslim ze by slo i int, ale nevim
 int pom=500.0;
 float i;

   //del screen with blit function
   //Blackscreen();
   pom=pom+frame_cnt2;
   //abych nescital ve floatu
   i=pom;
   xa=160+sin(i/28)*15;
   ya=60+cos(i/26)*10;
   xb=190+sin(i/23)*15;
   yb=40+cos(i/27)*10;
   xc=220+sin(i/25)*15;
   yc=80+cos(i/29)*10;
   xd=250+sin(i/21)*15;
   yd=60+cos(i/24)*10; 
   xe=270+cos(i/22)*30;
   ye=40+cos(i/16)*20;


   x1=xa+sin(i/25)*18;
   y1=ya+cos(i/25)*18;
   x2=xa+sin(i/24)*18;
   y2=ya+cos(i/26)*18;
   x3=xa+sin(i/23)*18;
   y3=ya+cos(i/26.5)*18;
   x4=xa+sin(i/23)*10;
   y4=ya+cos(i/20)*10;
   x5=xa+sin(i/24)*10;
   y5=ya+cos(i/20.5)*10;
   
   
   x6=xb+sin(i/26)*18;
   y6=yb+cos(i/22)*18; 
   x7=xb+sin(i/27)*18;
   y7=yb+cos(i/23.5)*18;
   x8=xb+sin(i/27.5)*18;
   y8=yb+cos(i/23)*18;
   x9=xb+sin(i/26.5)*10;
   y9=yb+cos(i/25)*10;
   x10=xb+sin(i/26)*10;
   y10=yb+cos(i/25.5)*10;

   x11=xc+sin(i/21)*18;
   y11=yc+cos(i/21.5)*18;
   x12=xc+sin(i/22)*18;
   y12=yc+cos(i/22.5)*18;
   x13=xc+sin(i/23)*18;
   y13=yc+cos(i/23.5)*18;
   x14=xc+sin(i/29)*10;
   y14=yc+cos(i/28.5)*10;
   x15=xc+sin(i/29.5)*10;
   y15=yc+cos(i/28.5)*10;

   x16=xe+sin(i/21)*18;
   y16=ye+cos(i/21.5)*18;
   x17=xe+sin(i/22)*18;
   y17=ye+cos(i/22.5)*18;
   x18=xe+sin(i/23)*18;
   y18=ye+cos(i/23.5)*18;
   x19=xe+sin(i/29)*10;
   y19=ye+cos(i/28.5)*10;
   x20=xe+sin(i/29.5)*10;
   y20=ye+cos(i/28.5)*10;
   putplot(x1,y1);
   putplot(x2,y2);
   putplot(x3,y3);
   putplot(x4,y4);
   putplot(x5,y5); 

   putplot(x6,y6); 
   putplot(x7,y7);
   putplot(x8,y8);
   putplot(x9,y9);
   putplot(x10,y10);
   putplot(x11,y11);
   putplot(x12,y12);
   putplot(x13,y13);
   putplot(x14,y14);
   putplot(x15,y15);
   if (frame_cnt2>263 && frame_cnt2<800) printspr(6,5,68,19,160,25,254,(char *)virtscreen);
   if (frame_cnt2>528 && frame_cnt2<800) printspr(71,6,175,20,160,45,254,(char *)virtscreen);
   if (frame_cnt2>650 && frame_cnt2<800) printspr(5,22,163,35,160,65,254,(char *)virtscreen);
   if (frame_cnt2>800 && frame_cnt2<1200)printspr(177,6,290,20,120,70,254,(char *)virtscreen);
   newgr();
   scrollup2();
   memcpy(virtscreen+320*160,buffer+320*160,40*320);
   memcpy(lbuffer+320*160,buffer+320*160,42*320);
   //copy virtscreen buffer to backsurface 
   CopyBuffer(virtscreen);
   //clear buffer
   memset(virtscreen,0,Xres*Yres);
   Flipscreen();
   frame_cnt++,frame_cnt2++;
}

//------------------------------------------------------------------------------------    
//------------------------------------------------------------------------------------    

/*
flipne z backbufferu na screen
*/
void Flipscreen()
{
  HRESULT  ddrval; //navratova hodnota
  
    while( 1 )
    {
     ddrval = lpDDSPrimary->Flip( NULL, 0 );
     if( ddrval == DD_OK )
      {
       //je to v klidu, nic nedelej
       break;
      }
     if( ddrval == DDERR_SURFACELOST )
     {
      ddrval = restoreAll();
      if( ddrval != DD_OK )
      { break; }
     }
     //minulej blit se jeste nedokoncil
     if( ddrval != DDERR_WASSTILLDRAWING )
     { break; }
    }
} /* Flipscreen */

//------------------------------------------------------------------------------------    
//------------------------------------------------------------------------------------    
 
/*
** This simple void paints the whole screen into black. Nothing more.
*/
void Blackscreen()
{
 DDBLTFX             ddbltfx;
 HRESULT             ddrval;

 ddbltfx.dwSize = sizeof( ddbltfx );
 ddbltfx.dwFillColor = dwFillColor;
 while( 1 )
 {
  ddrval = lpDDSBack->Blt( NULL, NULL, NULL, DDBLT_COLORFILL, &ddbltfx );
  if( ddrval == DD_OK )
  { break; }
  if( ddrval == DDERR_SURFACELOST )
  { if( !(restoreAll()) ) return; }
  if( ddrval != DDERR_WASSTILLDRAWING )
  { return; }
 }
} /* Blackscreen */

//------------------------------------------------------------------------------------    
//------------------------------------------------------------------------------------    

/*
** If some Objects were lost, simply restore them...
*/
HRESULT restoreAll( void )
{
    HRESULT     ddrval;

    ddrval = lpDDSPrimary->Restore();
    if( ddrval == DD_OK )
    {
    }
    return ddrval;

} /* restoreAll */

//------------------------------------------------------------------------------------    
//------------------------------------------------------------------------------------    

/*
** Get the surfaces out of memory...
*/
static void finiObjects( void )
{

 if( lpDD != NULL )
    {
 
        RELEASE( lpDDSPrimary );
        RELEASE( lpDDPal );
        lpDD->Release();
        lpDD = NULL;
    }
 FMUSIC_StopSong(mod);
 FMUSIC_FreeSong(mod);
 FSOUND_Close();
} /* finiObjects */

//------------------------------------------------------------------------------------    
//------------------------------------------------------------------------------------    

/*
procedura pro obsluhu okna
tady se obslouzi klavesnice atd sem se predavaj messige oknu
*/
long FAR PASCAL WindowProc( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam )
{
  switch( message )
    {
    case WM_ACTIVATEAPP:
         bActive = wParam;
        break;

    case WM_SETCURSOR:
         SetCursor(NULL);
        return TRUE;

    case WM_KEYDOWN:
        switch( wParam )
        {
        case VK_ESCAPE:
        case VK_F12:
            PostMessage(hWnd, WM_CLOSE, 0, 0);
            break;
        }
        break;

    case WM_DESTROY:   
        // Delete the objects...
        finiObjects();
        PostQuitMessage( 0 ); 
        break;

    }

    return DefWindowProc(hWnd, message, wParam, lParam);

} /* WindowProc */

//------------------------------------------------------------------------------------    
//------------------------------------------------------------------------------------    

//nastavi paletu
PALETTEENTRY *setFirepal(void)
{
    int           j;

  for( j=255;j>26;j-- )
    {
     pal[j].peRed=255;
     pal[j].peGreen=255;
     pal[j].peBlue=255;
     pal[j].peFlags=(BYTE)0;
    }
  for( j=26;j>21;j-- )
    {
     pal[j].peRed=(j-22)*63;
     pal[j].peGreen=(j-22)*63;
     pal[j].peBlue=255;
     pal[j].peFlags=(BYTE)0;
    }
  for( j=21;j>0;j-- )
    {
     pal[j].peRed=0;
     pal[j].peGreen=0;
     pal[j].peBlue=j*12;
     pal[j].peFlags=(BYTE)0;
    }
  //0 black
  pal[0].peRed=0;
  pal[0].peGreen=0;
  pal[0].peBlue=0;
  pal[0].peFlags=(BYTE)0;
  //254 red
  pal[254].peRed=255;
  pal[254].peGreen=0;
  pal[254].peBlue=0;
  pal[254].peFlags=(BYTE)0;
  return pal;
}

//------------------------------------------------------------------------------------    
//------------------------------------------------------------------------------------    
 
// Set the actula palette...
void setpal( PALETTEENTRY *pal )
{
  lpDD->WaitForVerticalBlank( DDWAITVB_BLOCKBEGIN, NULL );
  lpDDPal->SetEntries(0, 0, 256, pal);
}

//------------------------------------------------------------------------------------    
//------------------------------------------------------------------------------------    

// Return the actual palette...
void getpal (PALETTEENTRY *pal)
{
  lpDDPal->GetEntries(0, 0, 256, pal);
}

//------------------------------------------------------------------------------------    
//------------------------------------------------------------------------------------    

void first3d(void)
{
    part3D1();
    CopyBuffer(virtscreen);
    Flipscreen();
    frame_cnt++,frame_cnt2++;
    memset(virtscreen,0,64000);
}

//------------------------------------------------------------------------------------    
//------------------------------------------------------------------------------------    

PALETTEENTRY *set3D1pal(void)
{
  int           j;
  int RED=152,GREEN=300,BLUE=200;

  for(j=255;j>0;j--)
  {
    pal[j].peRed=129+127*(-sin(j*PI/RED));
    pal[j].peGreen=129+127*(-sin(j*PI/GREEN));
    pal[j].peBlue=129+127*(-sin(j*PI/BLUE));
    pal[j].peFlags=(BYTE)0;
  }
  pal[1].peRed=255;
  pal[1].peGreen=255;
  pal[1].peBlue=255;
  pal[1].peFlags=(BYTE)0;
  return pal;
}

//------------------------------------------------------------------------------------    
//------------------------------------------------------------------------------------    

void second3d(void)
{
   int i;
    
    part3D2();
    CopyBuffer(virtscreen);
    Flipscreen();
    frame_cnt++,frame_cnt2++;
    memset(virtscreen,0,64000);
}

//------------------------------------------------------------------------------------    
//------------------------------------------------------------------------------------    

PALETTEENTRY *set3D2pal(void)
{
  int         col;

  memset(data,0,128*128);
  Vpcxloada(128*128,(char *)data,(char *)tdata,sizeof(tdata)); 
  for(col=0;col<256;col++)
  {
   pal[col].peRed=palette[col*3];
   pal[col].peGreen=palette[(col*3)+1];
   pal[col].peBlue=palette[(col*3)+2];
   pal[col].peFlags=(BYTE)0;
  }
  return pal;
}

//------------------------------------------------------------------------------------    
//------------------------------------------------------------------------------------    

void plasma3d(void)
{
   int i;
    
    plasma();
    CopyBuffer(virtscreen);
    Flipscreen();
    frame_cnt++,frame_cnt2++;
    memset(virtscreen,0,64000);
}

//------------------------------------------------------------------------------------    
//------------------------------------------------------------------------------------    

PALETTEENTRY *setPlasmapal(void)
{
  int         col;
  int         from,to;
  int         br,bg,bb,fr,fg,fb;
  int         er,eg,eb; 

  

  from=0,to=63;
  br=0,bg=0,bb=0,fr=41,fg=41,fb=41; 
  //set linear palette
  for(col=from;col<=to;col++)
   {
     er=br+((col-from)*(fr-br)/(to-from));
     eg=bg+((col-from)*(fg-bg)/(to-from));
     eb=bb+((col-from)*(fb-bb)/(to-from));
     pal[col].peRed=er;
     pal[col].peGreen=eg;
     pal[col].peBlue=eb;
   } 
  from=64,to=127;
  br=41,bg=41,bb=41,fr=121,fg=121,fb=125; 
  //set linear palette
  for(col=from;col<=to;col++)
   {
     er=br+((col-from)*(fr-br)/(to-from));
     eg=bg+((col-from)*(fg-bg)/(to-from));
     eb=bb+((col-from)*(fb-bb)/(to-from));
     pal[col].peRed=er;
     pal[col].peGreen=eg;
     pal[col].peBlue=eb;
   } 
  from=128,to=191;
  br=121,bg=121,bb=125,fr=85,fg=87,fb=255;
  //set linear palette
  for(col=from;col<=to;col++)
   {
     er=br+((col-from)*(fr-br)/(to-from));
     eg=bg+((col-from)*(fg-bg)/(to-from));
     eb=bb+((col-from)*(fb-bb)/(to-from));
     pal[col].peRed=er;
     pal[col].peGreen=eg;
     pal[col].peBlue=eb;
   } 
  from=192,to=255;
  br=85,bg=87,bb=255,fr=0/63*255,fg=0/63*255,fb=0/63*255;
  //set linear palette
  for(col=from;col<=to;col++)
   {
     er=br+((col-from)*(fr-br)/(to-from));
     eg=bg+((col-from)*(fg-bg)/(to-from));
     eb=bb+((col-from)*(fb-bb)/(to-from));
     pal[col].peRed=er;
     pal[col].peGreen=eg;
     pal[col].peBlue=eb;
   } 
  return pal;

  /*shade_pal(0,63,    0,0,0,10,10,10);
  shade_pal(64,127,  10,10,10,30,30,30);
  shade_pal(128,191, 30,30,30,21,22,63);
  shade_pal(192,255, 21,22,63,0,0,0); 
  */
}

