#include <windows.h>
#include <windowsx.h>
#include <ddraw.h>
#include "Fsound.h"
#include "Fmusic.h"
#include "ddex.h"
#include "intro.h"

#define WIN32_LEAN_AND_MEAN
#define NAME "sulfur 15CH"
#define TITLE "sulfur 15CH"

//Vpcxload function
#include "pcxload.cpp"
//charakters pcx picture
#include "pismo.dat"

int cancel=0;
//prototype
int musicsetup(void);

//--------------------------------------------------------------------------------------

/*
 * DDColorMatch
 *
 * convert a RGB color to a pysical color.
 *
 * we do this by leting GDI SetPixel() do the color matching
 * then we lock the memory and see what it got mapped to.
 */
DWORD DDColorMatch(IDirectDrawSurface *pdds, COLORREF rgb)
{
    COLORREF rgbT;
    HDC hdc;
    DWORD dw = CLR_INVALID;
    DDSURFACEDESC ddsd;
    HRESULT hres;

    //
    //  use GDI SetPixel to color match for us
    //
    if (rgb != CLR_INVALID && pdds->GetDC(&hdc) == DD_OK)
    {
        rgbT = GetPixel(hdc, 0, 0);             // save current pixel value
        SetPixel(hdc, 0, 0, rgb);               // set our value
        pdds->ReleaseDC(hdc);
    }

    //
    // now lock the surface so we can read back the converted color
    //
    ddsd.dwSize = sizeof(ddsd);
    while ((hres = pdds->Lock(NULL, &ddsd, 0, NULL)) == DDERR_WASSTILLDRAWING)
        ;

    if (hres == DD_OK)
    {
        dw  = *(DWORD *)ddsd.lpSurface;                     // get DWORD
        if(ddsd.ddpfPixelFormat.dwRGBBitCount < 32)
            dw &= (1 << ddsd.ddpfPixelFormat.dwRGBBitCount)-1;  // mask it to bpp
        pdds->Unlock(NULL);
    }

    //
    //  now put the color that was there back.
    //
    if (rgb != CLR_INVALID && pdds->GetDC(&hdc) == DD_OK)
    {
        SetPixel(hdc, 0, 0, rgbT);
        pdds->ReleaseDC(hdc);
    }

    return dw;
}

//------------------------------------------------------------------
// dialogproc
//------------------------------------------------------------------
BOOL FAR PASCAL dialogProc(HWND hwnd,unsigned msg,UINT wparam,LONG lparam)
{
    lparam = lparam;                    /* turn off warning */

    switch( msg ) {
    case WM_INITDIALOG:
        return( TRUE );

    case WM_COMMAND:
        if( LOWORD( wparam ) == IDOK )
         {
            EndDialog( hwnd, TRUE );
            return( TRUE );
         }
        if( LOWORD( wparam ) == IDCANCEL )
         {
            EndDialog( hwnd, TRUE );
            cancel=1;
            return( FALSE );
         }
         
        break;
    }
    return( FALSE );

} 

//------------------------------------------------------------------
//------------------------------------------------------------------

//procedura pro obsluhu cbyb
BOOL Error( char *err )
{
  MessageBox(myHwnd, err, "example", MB_ICONHAND+MB_OK );
  //posle oknu zpravu WM_DESTROY 
  DestroyWindow (myHwnd);
  return FALSE;
} 

//------------------------------------------------------------------
//------------------------------------------------------------------



// WinMain - inicializace, smycka udalosti,
// tady se program zacne vykonavat
int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
                   LPSTR lpCmdLine, int nCmdShow)
{
    WNDCLASS            wc;
    DDSURFACEDESC       ddsd;
    DDSCAPS             ddscaps;
    HRESULT             ddrval;
    MSG                 Msg;
    int                navrat; 

    lpCmdLine = lpCmdLine;
    hPrevInstance = hPrevInstance;
    
    
    // Register the Window-class...
    wc.style = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc = WindowProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hbrBackground =GetStockBrush(BLACK_BRUSH);
    wc.lpszMenuName = NAME;
    wc.lpszClassName = NAME;
    RegisterClass( &wc );
    
    // Create the Window...
    myHwnd = CreateWindowEx(
        0,
        NAME,
        TITLE,
        WS_POPUP,
        0,
        0,
        GetSystemMetrics(SM_CXSCREEN),
        GetSystemMetrics(SM_CYSCREEN),
        NULL,
        NULL,
        hInstance,
        NULL );

  if (!myHwnd) return Error("nejde nastavit okno");
      
  DialogBox(hInstance,"Dialog2",myHwnd,(DLGPROC)&dialogProc);

  ShowWindow (myHwnd, nCmdShow);
  UpdateWindow( myHwnd );

  //set in first dialog
  if (cancel) DestroyWindow(myHwnd); 

  ddrval=musicsetup();
  if (!ddrval) return(0);

  // vytvori ddraw object
  ddrval=DirectDrawCreate(NULL,&lpDD,NULL);
  if( ddrval != DD_OK )
   {
       return Error("DDObject creation failed! " );
   }


  // Nastavi fullscreen
  ddrval = lpDD->SetCooperativeLevel(myHwnd, DDSCL_EXCLUSIVE|DDSCL_FULLSCREEN);
  if (ddrval != DD_OK)
    {
     lpDD->Release();  // uvolnn DirectDraw object
     return Error(" SetCooperativeLevel failed! " );
    }

  // nastavi diplay mode.
  ddrval = lpDD->SetDisplayMode(320,200,8);
  if( ddrval != DD_OK )
   {
        return Error(" SetDisplayMode failed! " );
   }
 
   
  // vynyluje decription
  memset(&ddsd, 0, sizeof(ddsd));  // Clear the description
  ddsd.dwSize = sizeof(ddsd);

  // definuje primary surface s single backbufferem
  ddsd.dwFlags = DDSD_CAPS|DDSD_BACKBUFFERCOUNT;
  ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE|DDSCAPS_FLIP|DDSCAPS_COMPLEX;
  ddsd.dwBackBufferCount = 1;

  // vytvori primarni surface
  ddrval = lpDD->CreateSurface(&ddsd, &lpDDSPrimary, NULL);
  if (ddrval != DD_OK)
  {
    lpDD->Release();
    return Error("Surface creation failed!!" );
  }

  // dalsi surface je  backbuffer
  ddscaps.dwCaps = DDSCAPS_BACKBUFFER;

 // priradi backbuffer k primary surface
  ddrval = lpDDSPrimary->GetAttachedSurface(&ddscaps, &lpDDSBack);
  if (ddrval != DD_OK)
  {
   lpDDSPrimary->Release();  
   lpDD->Release();
   return Error("backbuffer creation failed!!" );
  }

  //piazen palety 
  //some palette, because SetPallete failed if lpDDPal==NULL
  setFirepal();
  lpDD->CreatePalette(DDPCAPS_8BIT,pal,&lpDDPal, NULL);
  if( lpDDPal ) lpDDSPrimary->SetPalette(lpDDPal);
   else return  Error("palette initialization!" );

  // For Blackscreen...
  dwFillColor = DDColorMatch(lpDDSBack, RGB(0,0,0));

  //for charakters
  Vpcxloada(320*200,(char*)Vpismo,(char *)pismo,sizeof(pismo)); 

  //start music
  FMUSIC_PlaySong(mod);
     
 //smycka udalosti, ktere se posilaji ve strukture
 //Msg nasi procedure pro obsluhu okna
  while( 1 )
    {
     //prevadi mesidze do struktury msg 
     if( PeekMessage(&Msg, NULL, 0, 0, PM_NOREMOVE ) )
     {
      if( !GetMessage( &Msg, NULL, 0, 0 ) )
          return Msg.wParam;
      TranslateMessage(&Msg); 
      DispatchMessage(&Msg);
     }
     // pokud neprobehne peekmessage
     else if( bActive )
     {
      //Aplikace je aktivi , neco delej, ( kresli)
      HeartBeat(); 
     }
     else
     {
      // Ok, aplikace neni aktivni, ni nedelej )
      WaitMessage();
     }

    }
}     

//---------------------------------------------------------------------
//---------------------------------------------------------------------

int musicsetup(void)
{
 int i;

 FSOUND_SetOutput(FSOUND_OUTPUT_SOFTWARE_DSOUND);
 i=FSOUND_GetNumDrivers();
 if (i==0)
  {
   FSOUND_SetOutput(FSOUND_OUTPUT_SOFTWARE_WINMM);
   i=FSOUND_GetNumDrivers();
  }
 if (i==0)
  {
   FSOUND_SetOutput(FSOUND_OUTPUT_NULL);
  }

 FSOUND_SetDriver(0);
 FSOUND_SetMixer(FSOUND_MIXER_AUTODETECT);
 FSOUND_SetUpdateRate(40);
 FSOUND_SetMixAhead(100);
 if (!FSOUND_Init(44100,32))
  {
   if (!FSOUND_Init(22000,32))
      {
       Error("sound initialization error!");
       return(0);
      }
  }

 mod = FMUSIC_LoadSong("sulfur.xm");
 if (!mod)
  {
   Error("loading module error!");
   return(0);
  }
 return(1); 
}

//---------------------------------------------------------------------
//---------------------------------------------------------------------

