; Mighty might World Creator (tm)
; (C)oded by Sergey Chaban

COMMENT ~
Cube:
 (-32,-32,-32)
 (-32,-32,32)
 (-32,32,32)
 (-32,32,-32)
 (32,-32,32)
 (32,-32,-32)
 (32,32,-32)
 (32,32,32)

Direction vectors:
 [0] Left    : (-64,0,0)
 [1] Right   : (64,0,0)
 [2] Up      : (0,-64,0)
 [3] Down    : (0,64,0)
 [4] Back    : (0,0,-64)
 [5] Forward : (0,0,64)


Script:
00xxxxxxb -- Air cube, xxxxxx=dir
01xxxxxxb -- Cube, xxxxxx=Face mask
10xxxxxxb -- Return to (0,0,0), xxxxxx doesn't matter
11xxxxxxb -- Special command #xxxxx0
 
~

CreateWorld:
 mov si,offset World
 push ds
 pop es
 mov di,offset _wcCubeFaces
 mov cl,3*2
 mov bh,6  ; size of integer vector3
GetConnections:
 lodsw
 xchg dx,ax
 lodsb
 xor ah,ah
 xchg bp,ax
 mov ch,8
Unpack8Bytes:
 mov al,7
 and al,dl
 mul bh
 add ax,offset CubeVectors_Int
 stosw
 shrd dx,bp,3
 shr bp,3
 dec ch
 jnz Unpack8Bytes
 loop GetConnections

 sub ax,ax
 mov word ptr ds:[NumPoints],ax
 mov word ptr ds:[Num3DPolys],ax


Return2Origin:
 push si
 call StartUp
 ; DI=offset CreatorPos
 xor al,al      ; Set pos to (0,0,0)
 mov cl,SIZE Vector3 SHR 1
 rep stosw
 ; DI = offset DirVectors_Float
 mov si,offset RotatedDirVectors
 mov cx,((8+6)*SIZE Vector3) SHR 1
 rep movsw
 pop si

 mov bx,offset Camera_Data
 mov [bx].Camera_AngleX,ax
 mov [bx].Camera_AngleY,ax
 mov [bx].Camera_AngleZ,ax
 mov al,0Fh
 and byte ptr ds:[HiLighted_Flag],al ; 0Fh
 mov byte ptr ds:[_wcRotFlag],al

ProcessScript:
 lodsb
 test al,11000000b  ; Check bits 7, 6
 jz AirCube         ; 00
 jp SpecialCode     ; 11
 js Return2Origin   ; 10
 ; bits 7&6=01 -- we have cube mask in AL
 sub ebx,ebx ; index in connections list
MakeFaces:
 shr al,1           ; check faces bits
 jz CubeDone        ; possible only when bit 6 is wipped out
 mov bp,4           ; 4 points per face
 jnc SkipFace       ; Blank face - skip it.
 imul di,word ptr ds:[Num3DPolys],10
 add di,offset Polygons3D
 push ax
 lodsb              ; lit (bits 7..5) / texture (4..0)
 mov ah,al
 and ah,1Fh         ; Texture#
 add ah,ah          ; TextureNum*2
 shr al,1           ; Lit (0..7)
 or al,0Fh          ; Lit=0?Fh  (bit 7 indicates 'highlighted' poly)
HiLighted_Flag EQU $-1
 stosw
 push si
CreateFace:
 mov si,word ptr [ebx+ebx+_wcCubeFaces]       ; Point# * 6
;;;;;;already done by generator  --  add si,offset CubeVectors_Int
 mov dx,word ptr ds:[NumPoints]
 push di
 mov di,offset Points_List
 mov ax,offset Rotated_Points ; Assume point #0
 test dx,dx
 jz NewPoint
 ; Check if we already has this point.
ScanPointsList:
 mov cx,3
 push si
 rep cmpsw
 pop si
 jz UseThisPoint
 add cx,cx
 add di,cx
 add ax,SIZE Vector3   ; polygon connection defined as (pnt#*12)+offset Rot_Pts
 dec dx
 jnz ScanPointsList
NewPoint:
 movsw   ; Add new point to list
 movsw
 movsw
 inc word ptr ds:[NumPoints]
UseThisPoint:
 pop di
 stosw   ; Offset Rotated_Points + Point#*12
 inc bx  ; next vertex
 dec bp
 jnz CreateFace
 pop si
 pop ax
 inc word ptr ds:[Num3DPolys]
SkipFace:
 add bx,bp  ; this adds 4 in case of skipped face and otherwise zero
 jmp MakeFaces
SpecialCode:
 mov bp,offset ProcessScript
 mov bx,0Eh ; place for 8 codes, make sure it will be even
 and bx,ax
 jmp word ptr ds:[SpecCodes_JumpTable+bx]
AirCube:
 db 0A8h   ; TEST AL,xx  - skip the following opcode
CubeDone:
 lodsb     ; next step direction
 mov bx,7  ; lower 3 bits = direction vector #
 and bl,al ; 0..5 - direction vector #
 mov di,bx
 imul bx,SIZE Vector3
 add bx,offset RotatedDirVectors
 ; move further
 fld dword ptr ds:[CreatorPos].VecX
 fadd dword ptr [bx].VecX
 fstp dword ptr ds:[CreatorPos].VecX
 fld dword ptr ds:[CreatorPos].VecY
 fadd dword ptr [bx].VecY
 fstp dword ptr ds:[CreatorPos].VecY
 fld dword ptr ds:[CreatorPos].VecZ
 fadd dword ptr [bx].VecZ
 fstp dword ptr ds:[CreatorPos].VecZ
 test al,00111000b  ; bit 5-X, 4-Y, 3-Z
 jz NoRotation
 xor dx,dx          ; assume zeros for all rotation angles
 mov cx,dx
 mov bx,dx
 shl ax,3+8
 jnc AngleX0
 lodsb       ; get angle X
 mov ch,al
AngleX0:
 jns AngleY0
 lodsb       ; get angle Y
 mov dh,al
AngleY0:
 bt ax,6+8
 jnc AngleZ0
 lodsb
 mov bh,al
AngleZ0:
 push si
 mov si,offset Camera_Data
 sub ax,ax
 or al,0Fh
_wcRotFlag EQU $-1
 jnz _wcRelativeRot
 ; Absolute rotation -> clear angles befor addidition
 mov [si].Camera_AngleX,ax
 mov [si].Camera_AngleY,ax
 mov [si].Camera_AngleZ,ax
_wcRelativeRot:
 add [si].Camera_AngleX,cx
 add [si].Camera_AngleY,dx
 add [si].Camera_AngleZ,bx
 call Rotate_Camera
 lea bx,[si].Camera_RotationMatrix
 call Transpose_Matrix
 mov bx,offset Rotate_SelfModi
 push word ptr [bx]
 push bx
 mov byte ptr [bx],0C3h ; near RET
 ;*** rotate cube and direction vectors
 push di
 mov bx,offset DirVectors_Float
 mov di,offset RotatedDirVectors
 mov cx,6+8          ; 6 direction vectors + 8 vertices
RotateCreatorVectors:
 fld dword ptr [bx].VecX
 fld dword ptr [bx].VecY
 fld dword ptr [bx].VecZ
 add bx,SIZE Vector3-SIZE Vec3int
 call Rotate_Vector
 jnz RotateCreatorVectors
 pop di
 pop bx
 pop word ptr [bx]
 pop si
NoRotation:
 push si
 shl di,3
 add di,offset _wcCubeFaces
 mov al,4
FlipFaces:
 push di
 mov si,word ptr [di]
 mov di,word ptr [di+4*6*2] ; DI=[DI+VerticesPerFace*FacesPerCube*WordSize]
 push si
 movsw            ; "flip" one vertex
 movsw
 movsw
 pop si
 Temp=offset CubeVectors_Int
 Temp = - Temp
 lea di,[si+Temp] ; Substract offset CubeVectors3
 add di,di        ;) Float Vector3 is two times longer
 mov bx,offset CreatorPos
 mov cx,3
MoveFace:
 fld dword ptr [bx]
 fadd dword ptr ds:[RotatedCubeVectors+di]
 fistp word ptr [si]
 add bx,4
 add di,4
 inc si
 inc si
 loop MoveFace
 pop di
 inc di
 inc di
 dec al
 jnz FlipFaces
 pop si
 jmp ProcessScript
HiLighted_On:
 or byte ptr ds:[HiLighted_Flag],80h
 jmp bp
HiLighted_Off:
 and byte ptr ds:[HiLighted_Flag],7Fh
Jump_BP:
 jmp bp
DoRepeat:
 dec byte ptr ds:[_wcRepeatCount]
 jz Jump_BP
 mov si,0
_wcRepeatPtr EQU $-2
 jmp bp
SetRepeatStart:
 lodsb
 mov byte ptr ds:[_wcRepeatCount],al
 mov word ptr ds:[_wcRepeatPtr],si
 jmp bp
RememberPos:
 pusha
 mov di,100h
_wcSP EQU $-2
 mov si,offset _wcVars
 mov cx,_wcVarsSize SHR 1
 rep movsw
 mov si,offset Camera_Data.Camera_Rotation
 movsw
 movsw
 movsw
 mov word ptr ds:[_wcSP],di
 popa
 jmp bp
RecallPos:
 pusha
 mov si,word ptr ds:[_wcSP]
 mov di,offset _wcVars
 mov cx,_wcVarsSize SHR 1
 sub si,_wcVarsSize+SIZE EulerAngles
 mov word ptr ds:[_wcSP],si
 rep movsw
 mov di,offset Camera_Data.Camera_Rotation
 movsw
 movsw
 movsw
 popa
 jmp bp
FlipRotationFlag:
 xor byte ptr ds:[_wcRotFlag],0Fh
 jmp bp


Startup:
 sub dh,dh
 ; create dir vectors
 mov si,offset CubeVectors_Int
 mov di,offset RotatedDirVectors
 mov eax,100100010010001001b OR (0DAh SHL 18)
 mov bx,64
 mov bp,offset GenDirCoord
 push si
 call CreateCoords
 pop si
 ; create cube
 ; DI=offset RotatedCubeVectors
 mov eax,000100110010101001011111b or 0DA000000h
 mov bx,32
 mov bp,offset GenCubeCoord
CreateCoords:
 shr eax,1
 setc dl
 sbb cx,cx
 call bp
 mov [si],cx
 fild word ptr [si]
 inc si
 inc si
 fstp dword ptr [di]
 add di,4
 cmp al,0DAh
 jnz CreateCoords
CreationDone:
 ret

GenCubeCoord:
 xor cx,bx   ; Change sign if carry is set
 add cx,dx
 ret


GenDirCoord:
 xor bx,cx  ; Change sign if carry is set, use 0 if no carry
 add bx,dx
 and cx,bx
 ret
