; Texture generators for DviJoke 3D engine
; Mainly maiking noise and applaing some filter...
; (c) Sergey Chaban

texture_0:
 mov al,8
 push es
 call MakeGranit
 mov di,40h*2
 mov cx,40h*44h-40h*2
 mov si,3
Txt0_Loop:
 call Random_Interval
 add al,es:[di-40h]
 add al,es:[di-3Fh]
 shr al,1
 and al,01Fh
 stosb
 loop Txt0_Loop
 pop di
 mov dx,1020h
 jmp CopyTextureFromBuf

texture_1:
 mov al,16 ;8
 push es
 call MakeGranit
 pop di
 mov dx,0C18h
 call CopyTextureFromBuf
 mov word ptr ds:[DrawColorAdd],0
 jmp DrawBorder


MakeGranit:
 call FillTextureBuf
 mov cx,40h*40h
 mov si,1000h
Txt1_Loop1:
 call Random_Interval
 xchg di,ax
 shr al,6
 add es:[di+40h*2],al
 loop Txt1_Loop1
 ret


texture_2:
 push es
 call RandomizeTextureBuf
 call Smooth8
 call Smooth8
 pop di
 mov dx,0c8cCh ; 4050h
CopyTextureFromBuf:
 mov ax,es
 mov es,di
 push ds
 mov ds,ax
 xor di,di
 mov si,40h*2
 mov cx,40h*40h SHR 1
 rep movsw
 pop ds
 jmp Texture_Adjust


texture_3:
 push es
 call RandomizeTextureBuf
 ;;;;;;;;;;;;;
 call Smooth4
 call Smooth4
 push es
 pop gs
 pop es
 mov cx,40h*40h
 xor di,di
t3_loop2:
 mov al,gs:[di+40h*2]
 stosb
 loop t3_loop2
 mov dx,1020h
 jmp Texture_Adjust


texture_4:
 push 0E0F0h
Marble:
 push es
 call RandomizeTextureBuf
 mov cx,8
txt4_loop1:
 push cx
 mov bl,18h
 call Vertical_Cleft
 call Horizontal_Cleft
 pop cx
 loop txt4_loop1
 call Smooth8
 call Smooth4
 pop di
 pop dx
 ;mov dx,0E0F0h ;090a0h ;080Ah
 jmp CopyTextureFromBuf

texture_5:
 push es
 mov al,6
 call FillTextureBuf
 mov cx,20
txt5_loop1:
 push cx
 mov bl,14h
 call Vertical_Cleft
 mov bl,10h
 call Horizontal_Cleft
 pop cx
 loop txt5_loop1
 call Smooth4
 call Smooth4
 pop di
 mov dx,4862h
 call CopyTextureFromBuf
 mov word ptr ds:[DrawColorAdd],4040h
 jmp DrawBorder

texture_6:
 mov al,9
 push es
 call MakeGranit
 pop di
 xor dx,dx
 jmp CopyTextureFromBuf

texture_7:
 push es
 call RandomizeTextureBuf
 call Smooth8
 pop di
 mov dx,6460h ;4860h
 jmp CopyTextureFromBuf

texture_8:  ; LAMP
 call texture_6
 push ds
 mov ds,word ptr ds:[Spot]
 sub di,di
 mov cl,40h
t8_yloop:
 mov ch,40h
t8_xloop:
 mov al,ch
 sub al,40h/2
 imul al
 xchg dx,ax
 mov al,cl
 sub al,40h/2
 imul al
 add ax,dx
 mov word ptr ds:[FPU_Temp],ax
 fild word ptr ds:[FPU_Temp]
 fsqrt       ; r=sqrt(x*x+y*y)
 fistp word ptr ds:[FPU_Temp]
 mov ax,word ptr ds:[FPU_Temp]
 cmp al,10h
 setae ah
 mov al,[di]
 or al,es:[di]
 test ah,ah
 jz t8_stos  ; r<10h
 ; r>=10h -> clamp
 cmp al,12h
 jb t8_stos
 mov al,12h
t8_stos:
 stosb
 dec ch
 jnz t8_xloop
 loop t8_yloop
 pop ds
 mov dx,1020h
 jmp Texture_Adjust

texture_9:
 call texture_6
 mov dx,1020h
 jmp Texture_Adjust

texture_10:
 call texture_0
 mov di,((64-16)/2-1)*64+(64-16)/2-1
 mov cx,18
t10loop1:
 mov byte ptr es:[di],38h
 mov byte ptr es:[di+17*64],14h
 inc di
 loop t10loop1
 mov byte ptr es:[di-1],14h
 mov byte ptr es:[di-18+17*64],38h
 mov di,((64-16)/2)*64+(64-16)/2
 mov eax,04F6F4040h
 mov edx,0F8FE4040h
 mov cl,16
t10loop2:
 mov byte ptr es:[di-1],38h
 mov es:[di],eax
 mov es:[di+4],edx
 mov es:[di+8],eax
 mov es:[di+12],edx
 mov byte ptr es:[di+16],14h
 ror eax,8
 ror edx,8
 add di,64
 loop t10loop2
 ret

texture_11:
 call texture_7
 push ds
 mov ds,word ptr ds:[Spot]
 sub di,di
 mov cx,40h*40h
t11_loop:
 mov al,[di]
 cmp al,10h
 sbb ah,ah
 and al,ah
 or es:[di],al
 inc di
 loop t11_loop
 pop ds
 mov dx,1080h
 jmp Texture_Adjust

texture_12:
 mov si,offset BrickWall
 mov cx,10
 jmp txtDrawBrick

texture_16:
 mov si,0C0h
 jmp CutFractal
texture_15:
 mov si,80h
 jmp CutFractal
texture_14:
 mov si,40h
 jmp CutFractal
texture_13:
 xor si,si
CutFractal:
 push ds
 mov ds,word ptr ds:[Landscape_ColorMap]
 sub di,di
 mov cl,40h
t13_Yloop:
 mov ch,40h
t13_Xloop:
 lodsb
 shr al,3
 stosb
 dec ch
 jnz t13_Xloop
 add si,100h-40h
 loop t13_Yloop
 pop ds
 mov dx,1020h
 jmp Texture_Adjust

texture_17:
 push 090A0h
 jmp Marble

texture_18:
 call texture_13
 sub di,di
 mov cx,8
 mov al,5Ah
 mov bl,00001111b
t18_loop:
 push cx
 mov cl,40h
 rep stosb
 pop cx
 shr bl,1
 setc ah
 add al,ah
 add al,ah
 dec ax
 loop t18_loop
 mov al,52h
 mov cl,40h*3
 rep stosb
 ret

;**************************************************************
FillTextureBuf:
 mov es,word ptr ds:[TextureBuf]
 sub di,di
 mov cx,40h*44h
 push di cx
 rep stosb
 pop cx di
 ret

RandomizeTextureBuf:
 mov es,word ptr ds:[TextureBuf]
 sub di,di
 mov cx,40h*44h
 mov si,1Fh
RndTxtMem_Loop:
 call Random_Interval
 stosb
 loop RndTxtMem_Loop
 ret

Random:
 mov ax,0
 mov dx,4Dh
 inc ax
 jz Rnd_1
 mul dx
Rnd_1:
 sub ax,dx
 adc ax,0
 mov word ptr ds:[Random+1],ax
 ret

Random_Interval:
 call Random
 mul si
 xchg ax,dx
 ret

; IN: DH=Dark add, DL=bright add
Texture_Adjust:
 sub di,di
 mov cx,40h*40h
TxtAdj_Loop:
 mov al,es:[di]
 mov ah,dh
 cmp al,10h
 jb TxtAdj_Add
 mov ah,dl
TxtAdj_Add:
 add al,ah
 stosb
 loop TxtAdj_Loop
 ret

Adjust_TextureBuf:
 sub di,di
 mov cx,40h*44h
 jmp TxtAdj_Loop


Smooth4:
 mov di,40h
 mov cx,40h*44h-40h*2
Smooth4_Loop:
 mov al,es:[di-1]
 add al,es:[di+1]
 add al,es:[di-40h]
 add al,es:[di+40h]
 shr al,2
 stosb
 loop Smooth4_Loop
 ret

Smooth8:
 mov di,40h
 mov cx,40h*44h-40h*2
 mov bp,40h
Smooth8_Loop:
 movzx ax,byte ptr es:[di-1]
 movzx dx,byte ptr es:[di+1]
 add ax,dx
 mov dl,es:[di+bp-1] ; +3Fh
 add ax,dx
 neg bp
 mov dl,es:[di+bp+1] ; -3Fh
 add ax,dx
 mov dl,es:[di+bp]   ; -40h
 add ax,dx
 neg bp
 mov dl,es:[di+bp]   ; +40h
 add ax,dx
 shr ax,3
 stosb
 loop Smooth8_Loop
 ret

Vertical_Cleft:
 mov si,40h
 call Random_Interval
 xchg di,ax
 mov cx,44h
VertCleft_Loop:
 call Random
 and ax,3
 jz VertCleft_Loop
 mov es:[di],bl
 dec ax
 dec ax
 add ax,40h
 add di,ax
 loop VertCleft_Loop
 ret

Horizontal_Cleft:
 mov si,40h
 call Random_Interval
 inc ax
 mov cx,si
 mul si
 xchg di,ax
HorzCleft_Loop:
 call Random
 and ax,3
 jz HorzCleft_Loop
 mov es:[di],bl
 dec ax
 dec ax
 mul si
 inc ax
 add di,ax
 loop HorzCleft_Loop
 ret

SetupLine:
 push es di cx
 push dx
 mov al,10
 call MakeGranit
 pop dx
 call Adjust_TextureBuf
 push es
 pop gs
 pop cx di es
 ret

HorzLine:
 call SetupLine
HorzLine_Loop:
 mov al,gs:[di+40h*2]
 stosb
 loop HorzLine_Loop
 ret

VertLine:
 call SetupLine
VertLine_Loop:
 mov al,gs:[di+40h*2]
 stosb
 add di,40h-1
 loop VertLine_Loop
DrawDone:
 ret

DrawBorder:
 mov si,offset BorderImg
Draw_Loop:
 xor ah,ah
 lodsb
 cmp al,0FFh
 jz DrawDone
 add al,al
 xchg cx,ax
 mov bx,offset HorzLine
 jnc DrawHorz
 mov bx,offset VertLine
DrawHorz:
 shr cl,1
 lodsw
 xchg di,ax
 lodsw
 add ax,1234h ;4040h
DrawColorAdd EQU $-2
 xchg dx,ax
 push si
 call bx
 pop si
 jmp Draw_Loop


;>> ugly fastmade routines

txtDrawStrip:
 mov ch,0
txtStripWidth EQU $-1
 push bx
txtStripWLoop:
 cmp bl,3Fh
 jg txtStripOut
 test bl,bl
 js txtStripOut
 cmp bh,3Fh
 jg txtStripOut
 test bh,bh
 js txtStripOut
 mov al,dh
 cmp cl,0  ; H-2
txtBorderPosH EQU $-1
 ja txtStripBorder
 cmp cl,2
 jbe txtStripBorder
 cmp ch,0
txtBorderPosW EQU $-1
 ja txtStripBorder
 cmp ch,2
 jbe txtStripBorder
 mov al,dl
txtStripBorder:
 push bx dx
 push ax
 call Random
 pop dx
 mov ah,al
 and al,1
 cmp ah,79h
 sbb ah,ah
 xor al,ah
 add dl,al
 sub ah,ah
 xchg ah,bl
 shr bx,2
 or bl,ah
 mov es:[bx],dl
 pop dx bx
txtStripOut:
 inc bl
 dec ch
 jnz txtStripWLoop
 pop bx
 inc bh
 loop txtDrawStrip
 ret

txtDrawBrick:
 push cx
 lodsw      ; XY
 xchg bx,ax
 lodsw      ; WH
 mov cl,ah  ; height
 mov byte ptr ds:[txtStripWidth],al
 sub al,2
 mov byte ptr ds:[txtBorderPosW],al
 sub ah,2
 mov byte ptr ds:[txtBorderPosH],ah
 lodsw      ; colors
 xchg dx,ax
 push si
 call txtDrawStrip
 pop si
 pop cx
 loop txtDrawBrick
 ret
