;-)      4DOF fractal landscape rendering
;   (aka height field map, aka voxel landscape)
;-)          (C)oded by Sergey Chaban


Landscape_FractalCalc proc
 push ax dx
 push ds
 push cs
 pop ds
 call Random_Interval
 pop ds
 mov bp,si
 shr bp,1
 neg bp
 add bp,ax

 add di,bp
 jns @@Clamp1
 xor di,di
@@Clamp1:
 cmp di,255
 jle @@Clamp2
 mov di,255
@@Clamp2:
 pop dx ax
 ret
Landscape_FractalCalc endp

DrawLandscape proc
 mov ax,word ptr ds:[Landscape_RenderBuffer]
 mov fs,ax
 mov es,ax
 push ds
 mov ds,word ptr ds:Textures[12*2]  ; Use texture #12 as background
 mov ax,8                           ; 4x2 animated textures
 xor di,di
@@CopyBackground:
 mov cx,(40h*40h) SHR 2
 sub si,si
 rep movsd
 dec ax
 jnz @@CopyBackground
 push es
 pop ds
 mov bp,LANDSCAPE_BuffOrgPtr-LANDSCAPE_BytesPerLine*2-2
 mov cx,(LANDSCAPE_ScreenWidth+4) SHR 1
 mov dx,0E9E9h ;03131h
 mov si,offset XlatAddress
@@DrawHorz:
 mov bx,bp
 call si
 mov [di],dx
 lea bx,[bp+LANDSCAPE_BytesPerLine]
 call si
 mov [di],dx
 lea bx,[bp+LANDSCAPE_BytesPerLine*(LANDSCAPE_ScreenHeight+2)]
 call si
 mov [di],dx
 lea bx,[bp+LANDSCAPE_BytesPerLine*(LANDSCAPE_ScreenHeight+2+1)]
 call si
 inc bp
 mov [di],dx
 inc bp
 dec cx
 jnz @@DrawHorz
 mov dl,0FBh
 lea bx,[bp-2+LANDSCAPE_BytesPerLine*(LANDSCAPE_ScreenHeight+2)+1]
 call si
 mov [di],dl
 lea bx,[bp-2+LANDSCAPE_BytesPerLine*(LANDSCAPE_ScreenHeight+2)-LANDSCAPE_ScreenWidth-2]
 call si
 mov [di],dl
 lea bx,[bp-2+LANDSCAPE_BytesPerLine+1]
 call si
 mov [di],dl
 lea bx,[bp-2+LANDSCAPE_BytesPerLine-LANDSCAPE_ScreenWidth-2]
 call si
 mov [di],dl
 ;************
 mov bp,LANDSCAPE_BuffOrgPtr-2
 mov bx,8
 mov dx,0EEEFh ;0F2F3h
@@DrawVert:
 push bx
 mov cl,LANDSCAPE_ScreenHeight/8
@@DrawV_outter:
 mov bx,bp
 call si
 inc bp
 mov word ptr [di],0FCFCh
 inc bp
 mov ch,LANDSCAPE_ScreenWidth/2
@@DrawV_inner:
 mov bx,bp
 call si
 inc bp
 mov [di],dx
 inc bp
 dec ch
 jnz @@DrawV_inner
 xchg dl,dh
 mov bx,bp
 call si
 mov word ptr [di],0FBFBh
 add bp,LANDSCAPE_BytesPerLine-LANDSCAPE_ScreenWidth-2
 loop @@DrawV_outter
 pop bx
 add dx,0101h
 dec bx
 jnz @@DrawVert
 pop ds

 fild word ptr ds:[Landscape_ViewAngle]
 fmul dword ptr ds:[Landscape_Radians] ; Get ViewAngle in radii
 mov es,word ptr ds:[Landscape_HeightMap]
 fld st(0)
 fsincos         ; cos, sin, ViewAngle
 fld dword ptr ds:[Landscape_MoveSpeed]
 fmul dword ptr ds:[TimeFactor]
 fmul st(2),st   ; cos, sin*MovSpeed, ViewAngle
 fmulp st(1),st  ; cos*MovSpeed, sin*MovSpeed, ViewAngle
 ;*> NewViewX=ViewX+cos(ViewAngle)*MovSpeed
 fistp dword ptr ds:[Landscape_ViewXStep]
 ;*> NewViewY=ViewY+sin(ViewAngle)*MovSpeed
 fistp dword ptr ds:[Landscape_ViewYStep]
 fld st(0)
 fadd dword ptr ds:[Landscape_negFOV] ; a+(-PI/4)=(a-FOV)
 fxch
 fsub dword ptr ds:[Landscape_negFOV] ; a-(-PI/4)=(a+FOV)
 fsincos         ; cos(a+FOV), sin(a+FOV), (a-FOV)
 fxch st(2)      ; (a-FOV), sin(a+FOV), cos(a+FOV)
 fsincos         ; cos(a-FOV), sin(a-FOV), sin(a+FOV), cos(a+FOV)
 fld dword ptr ds:[fp_Scale16]
 ;* Convert all those trigs into fixed point.
 fmul  st(1),st
 fmul  st(2),st
 fmul  st(3),st
 fmulp st(4),st
 fistp dword ptr ds:[Landscape_cos_left]
 fistp dword ptr ds:[Landscape_sin_left]
 fistp dword ptr ds:[Landscape_sin_right]
 fistp dword ptr ds:[Landscape_cos_right]
 ;*...........reset LastY & LastColor arrays
 xor eax,eax
 cdq
 sub ebx,ebx
 mov bx,offset Landscape_LastY
 mov dx,offset Landscape_LastColor
Landscape_ResetArrays:
 mov byte ptr ds:[ebx+eax],LANDSCAPE_ScreenHeight
 mov word ptr ds:[edx+eax*2],-1
 inc ax
 cmp ax,LANDSCAPE_ScreenWidth
 jb Landscape_ResetArrays

;IF 0;******* ViewPoint height computation ********
 mov bl,byte ptr ds:[Landscape_ViewX+2] ; integer part of ViewX
 mov bh,byte ptr ds:[Landscape_ViewY+2] ; integer part of ViewY
 mov ch,byte ptr ds:[Landscape_ViewX+1]
 mov cl,byte ptr ds:[Landscape_ViewY+1]
 call Landscape_Interpolate
 shr ebp,16
 sub bp,24
 mov word ptr ds:[Landscape_ViewHeight],bp
;ENDIF

 xor ecx,ecx      ; z from 0 to 100
 ; inc cx
Landscape_zloop:
 push ecx
 mov esi,LANDSCAPE_ScreenWidth
 mov ebp,12345678h
Landscape_ViewX EQU $-4
 mov eax,12345678h
Landscape_cos_left EQU $-4
 imul ecx
 add eax,ebp  ; x0=ViewX+(z*cos(ViewAngle-FOV)*65536)
 xchg ebx,eax ; EBX=x0 (16.16 fixed point)
 mov eax,12345678h
Landscape_cos_right EQU $-4
 imul ecx
 add eax,ebp ; x1=ViewX+(z*cos(ViewAngle+FOV)*65536)
 sub eax,ebx ; delta_x=x1-x0
 cdq
 idiv esi
 mov dword ptr ds:[Landscape_LineXinc],eax ; delta_x/ScreenWidth
 mov ebp,12345678h
Landscape_ViewY EQU $-4
 mov eax,12345678h
Landscape_sin_left EQU $-4
 imul ecx
 add eax,ebp ; y0
 xchg edi,eax
 mov eax,12345678h
Landscape_sin_right EQU $-4
 imul ecx
 add eax,ebp ; y1
 sub eax,edi ; y1-y0
 cdq
 idiv esi
 mov dword ptr ds:[Landscape_LineYinc],eax
 inc cx
 mov ax,100 SHL 8  ; 8.8
 sub dx,dx
 div cx
 xchg si,ax        ; scaling factor  8.8 fixed point

 xor cx,cx         ; Draw columns from left to right
Landscape_xloop:
 push ebx edi si cx
 ;** compute height
 shr ebx,8
 mov ecx,edi
 shr ecx,8
 xchg ch,bl
 xchg bh,bl
 mov es,word ptr ds:[Landscape_HeightMap]
 call Landscape_Interpolate
 shr ebp,16
 mov ax,si
 sub bp,1234h                  ; AutoAlt
Landscape_ViewHeight EQU $-2
 imul bp
 shrd ax,dx,8+3
 add ax,LANDSCAPE_ScreenCenterY
 xchg ax,di ; y
 mov es,word ptr ds:[Landscape_ColorMap]
 call Landscape_Interpolate
 shr ebp,8+1  ; Color in 8.8
 mov dx,bp
 pop bx       ; Current screen x
 push bx
 movzx bp,byte ptr ds:[Landscape_LastY+bx]
 add bx,bx
 mov ax,word ptr ds:[Landscape_LastColor+bx]
 mov word ptr ds:[Landscape_LastColor+bx],dx ; New LastColor for this column
 sub bp,di  ; LastY - y
 jbe Landscape_SkipColumn
 test ax,ax
 jns Landscape_ColorChange
 sub si,si
 jmp Landscape_ColorStepOk
Landscape_ColorChange:
 push dx
 sub ax,dx  ; dc=LastColor - NewColor
 cwd
 idiv bp    ; AX=dc/dy -- color interpolation step
 xchg si,ax
 pop dx
Landscape_ColorStepOk:
IF 0
 lea ax,[bp+di]
 cmp al,LANDSCAPE_ScreenHeight
 jnz Landscape_UsedColumn
 dec bp
Landscape_UsedColumn:
ENDIF
 shr bx,1
 mov ax,di
 imul di,LANDSCAPE_BytesPerLine
 mov byte ptr ds:[Landscape_LastY+bx],al
 lea di,[di+bx+LANDSCAPE_BuffOrgPtr]
Landscape_DrawColumn:
 push di
 mov bx,di
 call XlatAddress
 
 mov al,dh
 shr al,2

 cmp al,10h
 sbb ah,ah
 mov bh,ah
 xor ah,0FFh
 and ah,020h
 and bh,010h
 add al,ah
 add al,bh

 add dx,si      ; interpolate color
 mov fs:[di],al
 pop di
 add di,LANDSCAPE_BytesPerLine
 dec bp
 jnz Landscape_DrawColumn

Landscape_SkipColumn:
 pop cx si edi ebx
 add ebx,12345678h
Landscape_LineXinc EQU $-4
 add edi,12345678h
Landscape_LineYinc EQU $-4
 inc cx
 cmp cx,LANDSCAPE_ScreenWidth
 jb Landscape_xloop
 pop ecx
 mov ax,cx
 shr ax,6
 inc cx
 add cx,ax  ; Z=Z+1+Z>>6
 cmp cx,100
 jb Landscape_zloop
 add dword ptr ds:[Landscape_ViewAngleFrac],12345678h
Landscape_ViewAngleStep EQU $-4
 add dword ptr ds:[Landscape_ViewX],12345678h
Landscape_ViewXStep EQU $-4
 add dword ptr ds:[Landscape_ViewY],12345678h
Landscape_ViewYStep EQU $-4
 ret
DrawLandscape endp


Comment ~******************************************************************
BL, BH - u,v coords of the left corner of the square the point is in.
CH, CL - x,y position of the point inside the square (frac(u0), frac(v0)).
Compute the value at (CH,CL) using bilinear interpolation.
The square itself is nothing else than a single map cell and looks
like this:

 (BL,BH)--------*----(BL+1,BH)
   |            |         |
   |     (CH,CL)|         |
   *------------x---------|
   |            |         |
   |            |         |
(BL,BH+1)------------(BL+1,BH+1)

Return 16.16 fixed point value in EBP.
Used for height/color values computation inside the single map cell.
~
Landscape_Interpolate proc
 push bx cx
 sub eax,eax
 cwd              ; DX=0
 mov al,es:[bx]
 mov ebp,eax      ; [u0,v0]
 shl bp,8         ; BP=[u0,v0]<<8
 inc bl
 mov dl,es:[bx]   ; [u1,v0]
 sub dx,ax        ; [u1,v0]-[u0,v0]
 mov al,ch
 imul dx
 add bp,ax        ; BP=[u0,v0]<<8+frac(u0)*([u1,v0]-[u0,v0])
 inc bh
 movzx ax,es:[bx] ; [u1,v1]
 dec bl
 movzx dx,es:[bx] ; [u0,v1]
 sub ax,dx        ; [u1,v1]-[u0,v1]
 push dx
 mov dl,ch
 imul dx
 pop dx
 xchg dl,dh       ; DX=[u0,v1]<<8
 add ax,dx        ; AX=[u0,v1]<<8+frac(v0)*([u1,v1]-[u0,v1])
 movzx ecx,cl
 sub eax,ebp
 imul ecx
 shl ebp,8
 add ebp,eax
 pop cx bx
 ;* shr ebp,16
 ret
Landscape_Interpolate endp
