;*   DviJoke 3D
;* Small 3D Engine
;* Camera routines
;* (C)oded by Sergey Chaban

; In: SI=Cam structure ptr
;     AL=Camera flags
Init_Camera proc
 fldpi         ; PI=180 degrees
 IFDEF _QUATCAM
 mov byte ptr ds:[si].Camera_Flags,al
 test al,CamFlag_QUATERNIONS
 jnz @@Quats   ; We need angles/2 for quaternions
 ENDIF
 fadd st,st(0) ; 2*PI=360
@@Quats:
 fdiv dword ptr ds:[Camera_AngleFactor]       ; 2*PI/10000h
 mov word ptr ds:[si].Camera_FocalDistance,14 ;12 ;10 ;14 ;25
 fstp dword ptr [si].Camera_Radians
 ret
Init_Camera endp

; SI=Ptr on camera structure
; Calc Y*X*Z matrix using Euler angles
Rotate_Camera proc
 sub sp,SIZE Trigonometric
 mov bp,sp
 fild word ptr [si].Camera_AngleX
 fmul dword ptr [si].Camera_Radians
 fsincos
 fxch
 fst dword ptr [bp].__SinX
 fst dword ptr [bp].__CosX
 fild word ptr [si].Camera_AngleY
 fmul dword ptr [si].Camera_Radians
 fsincos
 fstp dword ptr [bp].__CosY
 fstp dword ptr [bp].__SinY
 fild word ptr [si].Camera_AngleZ
 fmul dword ptr [si].Camera_Radians
 fsincos
 fxch
 fst dword ptr [bp].__SinZ
 fmul st,st(3) ; sin(z)*cos(x)
 fchs          ; -cos(x)*sin(z)
 fstp dword ptr [si].Camera_RotationMatrix.matr_Yx
 fst dword ptr [bp].__CosZ
 fmul st,st(2) ; cos(z)*cos(x)
 fstp dword ptr [si].Camera_RotationMatrix.matr_Yy
 fld dword ptr [bp].__CosY
 fmul st,st(2) ; cos(y)*cos(x)
 fstp dword ptr [si].Camera_RotationMatrix.matr_Zz
 fstp dword ptr [si].Camera_RotationMatrix.matr_Yz ; Yz=sin(x)
 fmul dword ptr [bp].__SinY ; cos(x)*sin(y)
 fstp dword ptr [si].Camera_RotationMatrix.matr_Xz


 fld dword ptr [bp].__CosY
 fld st(0) ; save cos(y) for future
 fld dword ptr [bp].__CosZ
 fmul  ;  cos(y)*cos(z)
 fld dword ptr [bp].__SinY
 fmul dword ptr [bp].__SinZ
 fld dword ptr [bp].__SinX
 fld st(0)
 fmul st,st(2)
 fadd st,st(3); sx*sy*sz+cy*cz
 fstp dword ptr [si].Camera_RotationMatrix.matr_Xx
 fchs
 fmulp st(2),st ; -sx*cy*cz
 fsubp st(1),st ; st=-sx*cy*cz-sy*sz
 fstp dword ptr [si].Camera_RotationMatrix.matr_Zy


 ;! cos(y) is already loaded
 fmul dword ptr [bp].__SinZ ; cy*sz
 fld dword ptr [bp].__SinY
 fmul dword ptr [bp].__CosZ ; sy*cz
 fchs ; -sy*cz
 fld dword ptr [bp].__SinX
 fld st(0)
 fmul st,st(2) ; -sx*sy*cz
 fadd st,st(3) ; -sx*sy*cz+cy*sz
 fstp dword ptr [si].Camera_RotationMatrix.matr_Xy
 fmulp st(2),st ; st(1)=sx*cy*sz
 faddp st(1),st ; sx*cy*sz-sy*cz
 fstp dword ptr [si].Camera_RotationMatrix.matr_Zx
 lea sp,[bp+SIZE Trigonometric]
 ret
Rotate_Camera endp
