{ Mode13-Unit - Copyright (C) Hellfire/FJ aka. Christoph Grote              }
{ the .gif-reader is stolen from pcu, credits to the respective author...   }

unit mode13;

Interface

type PalString=    Array[0..255,0..2] of Byte;

const clr=         256;

var palette,pal1,pal2,pal3:  PalString;
    vram_pos,rest,ErrorNr:   Word;
    gifx,gify:               Word;
    GifName:                 String;
    free,breite,max,stackp,
    restbits,restbyte,code,
    sonderfall,old_code,bits,
    readbyt,bits2get,lbyte,
    mask,PufInd,Handle:      Word;
    ab_prfx,ab_tail:         Array[0..4096] of word;
    Stack:                   Array[0..1280] of byte;
    Puf:                     Array[0..1024*3] of Byte;

procedure WaitVR;
procedure SetRGB(color, red,green,blue: Word);
procedure SetPal(Palette: PalString);

procedure Display(dst: Pointer);
procedure Vmode(modus: Word);
procedure LoadGif(name: String; zielvar: Pointer);


Implementation


procedure SetRGB(color, red, green, blue: Word); assembler;
asm mov dx,03c8h
    mov ax,color
    out dx,al

    mov dx,03c9h
    mov ax,red
    out dx,al

    mov ax,green
    out dx,al

    mov ax,blue
    out dx,al
end;


procedure SetPal(Palette: PalString); assembler;
asm les si,dword ptr Palette
    mov cx,256*3
    xor al,al
    mov dx,03c8h
    out dx,al
    inc dx
    rep outsb
end;


procedure Display(dst: Pointer); assembler;
asm         push ds
            mov  es,sega000
            xor  di,di

            lds  si,dst

            mov  cx,16000
    db 66h; rep  movsw
            pop  ds
end;


procedure WaitVR; assembler;
asm         mov  dx,3dah
    @wait1: in   al,dx
            test al,08h
            jnz  @wait1
    @wait2: in   al,dx
            test al,08h
            jz   @wait2
end;


procedure vmode(modus: Word); assembler;
asm mov ax,modus
    int $10
end;


procedure GifOpen; assembler;
asm mov ax,03d00h
    lea dx,gifname + 1
    int 21h
    mov handle,ax
end;

procedure GifRead(n: Word); assembler;
asm mov ax,03f00h
    mov bx,handle
    mov cx,n
    lea dx,puf
    int 21h
end;

procedure GifSeekdelta(delta: Longint); assembler;
asm mov ax,04200h
    mov bx,handle
    mov cx,word ptr delta + 2
    mov dx,word ptr delta
    int 21h
end;

procedure GifClose; assembler;
asm mov ax,03e00h
    mov bx,handle
    int 21h
end;

procedure ShiftPal;assembler;
asm push ds
    pop es
    mov si,offset Puf
    mov di,offset Palette
    mov cx,768
@l1:lodsb
    shr al,2
    stosb
    loop @l1
end;

procedure FillPuf;
begin
  GifRead(1);
  restbyte:=puf[0];
  GifRead(restbyte);
end;

function GetPhysByte: Byte; assembler;
asm push bx
    cmp restbyte,0
    ja @restda
    pusha
    call fillpuf
    popa
    mov pufind,0
@restda:
    mov bx,PufInd
    mov al,byte ptr Puf[bx]
    inc pufind
    pop bx
end;

function GetLogByte:Word; assembler;
asm push si
    mov ax,breite
    mov si,ax
    mov dx,restbits
    mov cx,8
    sub cx,dx
    mov ax,lByte
    shr ax,cl
    mov code,ax
    sub si,dx
@nextbyte:
    call getphysbyte
    xor ah,ah
    mov lByte,ax
    dec restbyte
    mov bx,1
    mov cx,si
    shl bx,cl
    dec bx
    and ax,bx
    mov cx,dx
    shl ax,cl
    add code,ax
    sbb dx,breite
    add dx,8
    jns @positiv
    add dx,8
@positiv:
    sub si,8
    jle @fertig
    add dx,breite
    sub dx,8
    jmp @nextbyte
@fertig:
    mov restbits,dx
    mov ax,code
    pop si
end;


procedure LoadGif(name: String; zielvar: Pointer);
var ziel,quelle,qseg:     Word;
    pic_height,pic_width: Word;
    x_count:              Word;
begin
  gifName:=Name+#0;
  GifOpen;
  gifseekdelta(13);
  gifread(768);
  Shiftpal;
  gifread(1);
  while Puf[0]=$21 do
  begin
    gifread(2);
    gifread(puf[1]+1);
  end;
  GifRead(10);
  pic_width:=puf[4]+puf[5]*256;
  pic_height:=puf[6]+puf[7]*256;
  gifx:= pic_width;
  gify:= pic_height;
  if Puf[8] and 128 = 128 then
  begin
    gifread(768);
    Shiftpal;
  end;
  lByte:=0;

  asm
              les di,zielvar

              mov free,258
              mov breite,9
              mov max,511
              mov stackp,0
              mov restbits,0
              mov restbyte,0
           @mainloop:
              call getlogByte
              cmp ax,257
              je @abbruch
              cmp ax,clr
              je @clear
              mov readbyt,ax
              cmp ax,free
              jb @code_in_ab
              mov ax,old_code
              mov code,ax
              mov bx,stackp
              mov cx,sonderfall
              mov word ptr stack[bx],cx
              inc stackp
           @code_in_ab:
              cmp ax,clr
              jb @konkret
           @fillstack_loop:
              mov bx,code
              shl bx,1
              push bx
              mov ax,word ptr ab_tail[bx]
              mov bx,stackp
              shl bx,1
              mov word ptr stack[bx],ax
              inc stackp
              pop bx
              mov ax,word ptr ab_prfx[bx]
              mov code,ax
              cmp ax,clr
              ja @fillstack_loop
           @konkret:
              mov bx,stackp
              shl bx,1
              mov word ptr stack[bx],ax
              mov sonderfall,ax
              inc stackp
              mov bx,stackp
              dec bx
              shl bx,1
           @readstack_loop:
              mov ax,word ptr stack[bx]

              stosb

              dec bx
              dec bx
              jns @readstack_loop
              mov stackp,0
              mov bx,free
              shl bx,1
              mov ax,old_code
              mov word ptr ab_prfx[bx],ax
              mov ax,code
              mov word ptr ab_tail[bx],ax
              mov ax,readbyt
              mov old_code,ax
              inc free
              mov ax,free
              cmp ax,max
              jbe @mainloop
              cmp byte ptr breite,12
              jae @mainloop
              inc breite
              mov cl,byte ptr breite
              mov ax,1
              shl ax,cl
              dec ax
              mov max,ax
              jmp @mainloop
           @clear:
              mov breite,9
              mov max,511
              mov free,258
              call getlogbyte
              mov sonderfall,ax
              mov old_code,ax

              stosb

              jmp @mainloop

           @abbruch:
   end;
  gifclose;
end;


begin
  ErrorNr:=0;
end.
