{$M 8096,0,190000}

{$A+,B-,E+,F-,G+,N+,Q-,R-,S-}

program mov98intro;

uses mse_tp;

Const VGA=$A000;
      Npages=2;
      MinX=0;
      MaxX=319;
      MinY=0;
      MaxY=199;

Type RgbItem=Record
                   R,G,B:Byte;
             End;
     RgbList=Array[0..255] of RgbItem;
     Chars=Array[' '..''] of pointer;

Var Virt:Array[1..Npages] Of Pointer;
    VP:Array[1..Npages] Of Word;
    Font:Chars;

Procedure video_mode (mode : Byte); Assembler;
Asm
  mov  AH,00
  mov  AL,mode
  int  10h
end;

Procedure PutPixel(X,Y:word;Col:Byte;Where:Word);
Begin
     if x>-1 then if x<320 then if y>-1 then if y<200 then
     Mem[Where:(y*320)+x]:=Col;
End;

Function GetPixel(X,Y:word;Where:Word):Byte;
Begin
     GetPixel:=Mem[Where:(y*320)+x];
End;

Procedure Cls(Col:Byte;Where:Word);
Begin
     Fillchar(Mem[Where:0000],64000,Col);
End;

Procedure WaitVBL; Assembler;
Label A1,A2;
Asm
   Mov DX,3DAh
   A1:
      In AL,DX
      And AL,08h
      Jnz A1
   A2:
      In AL,DX
      And AL,08h
      Jz A2
End;

Function GetKey (Var Key : Word) : Boolean; Assembler;
{ determine if key pressed and return it as a Word }
{ if Lo(key) = 0 and Hi(key) <> 0 then we have a FN key ! }
Asm
  MOV     AH, 1
  INT     16H
  MOV     AL, 0
  JE      @@1
  xor     AH, AH
  INT     16H
  LES     DI, Key
  MOV     Word PTR ES : [DI], AX
  MOV     AL, 1
 @@1 :
end;

Function GetChar (Var Key : Char) : Boolean;
var c : Word;
begin
  Key := #0;
  if GetKey (c) then
  begin
    GetChar := True;
    if (LO (c) = 0) and (HI (c) <> 0) then
      Key := CHR ( HI (c) + 128 )  { add 128 For FN keys }
    else
      Key := CHR (LO (c) );
  end
  else
    GetChar := False;
end;

Procedure SetColor(Col,R,G,B:Byte);
Begin
     Port[$3C8]:=Col;
     Port[$3C9]:=R;
     Port[$3C9]:=G;
     Port[$3C9]:=B;
End;

Procedure SetPalette(Pal:RgbList);
Var A:Byte;
Begin
     WaitVBL;
     For A:=0 To 255 do SetColor(A,Pal[A].R,Pal[A].G,Pal[A].B);
End;

Procedure InitVirt;
Var A:Byte;
Begin
     For A:=1 To Npages Do
     Begin
          GetMem(Virt[A],64000);
          VP[A]:=Seg(Virt[A]^);
     End;
End;

Procedure CloseVirt;
Var A:Byte;
Begin
     For A:=1 To Npages Do
     Begin
          Freemem(Virt[A],64000);
          VP[A]:=$A000;
     End;
End;

Procedure LoadPCX(Filename:String;Where:Word);
Var Fil:File;
    Dx,Dy:Word;
    J,M:Byte;
    Ph:Word;
    Buff:Array[0..127] of byte;
    PCXPal:RgbList;
Begin
     Assign(Fil,Filename);
     Reset(Fil,1);
     Blockread(Fil,Buff,128);
     Dy:=0;
     Repeat
           Dx:=0;
           Repeat
                 BlockRead(Fil,J,1);
                 If J>192 Then
                 Begin
                      BlockRead(Fil,M,1);
                      Dec(J,192);
                      For Ph:=1 To J Do
                      Begin
                           PutPixel(Dx,Dy,M,Where);
                           Inc(Dx);
                      End;
                 End
                 Else
                 Begin
                      PutPixel(Dx,Dy,J,Where);
                      Inc(Dx);
                 End;
           Until Dx>=320;
           Inc(Dy);
     Until Dy=200;
     BlockRead(Fil,M,1);
     If M=12 Then
     Begin
          BlockRead(Fil,PCXPal,768);
          For M:=0 To 255 Do
          Begin
               PCXPal[M].R:=PCXPal[M].R Div 4;
               PCXPal[M].G:=PCXPal[M].G Div 4;
               PCXPal[M].B:=PCXPal[M].B Div 4;
          End;
          SetPalette(PCXPal);
     End;
     Close(Fil);
End;

Procedure GetImage(x1,y1,x2,y2:Word;Var Img:Pointer;Where:Word);
Var Dx,Dy:Word;
    A,B:Word;
    Segm,Offs:Word;
Begin
     Dx:=Abs(x2-x1)+1;
     Dy:=Abs(y2-y1)+1;
     GetMem(Img,Dx*Dy+4);
     Segm:=Seg(Img^);
     Offs:=Ofs(Img^);
     Move(Dx,Mem[Segm:Offs],2);
     Move(Dy,Mem[Segm:Offs+2],2);
     Offs:=Offs+4;
     For A:=y1 to y2 Do
     For B:=x1 to x2 Do
     Begin
          Mem[Segm:Offs]:=GetPixel(B,A,Where);
          Inc(Offs);
     End;
End;

Procedure KillImage(Var Img:Pointer);
Var Dx,Dy:Word;
    Segm,Offs:Word;
Begin
     Segm:=Seg(Img^);
     Offs:=Ofs(Img^);
     Move(Mem[Segm:Offs],Dx,2);
     Move(Mem[Segm:Offs+2],Dy,2);
     FreeMem(Img,Dx*Dy+4);
End;

Procedure PutImage(X,Y,C:Integer;Var Img:Pointer;Where:Word);
Var Dx,Dy:Word;
    A,B:integer;
    Segm,Offs:Word;
Begin
     Segm:=Seg(Img^);
     Offs:=Ofs(Img^);
     Move(Mem[Segm:Offs],Dx,2);
     Move(Mem[Segm:Offs+2],Dy,2);
     Offs:=Offs+4;

     for a:=y to (Y+DY-1) do
     begin
          for b:=x to (X+DX-1) do
          begin
               If (b>=MinX) then if (a>=MinY) Then
               If (b<=MaxX) then if (a<=MaxY) Then
               if Mem[Segm:Offs]<>c then
                 PutPixel(B,A,Mem[Segm:Offs],Where);
               Inc(Offs);
          end;
     End;
End;

Procedure Putchar(X,Y,C:Integer;N:Char;Where:Word);
Var Dx,Dy:Word;
    D,B:Word;
    Segm,Offs:Word;
    Img:Pointer;
Begin
     Img:=Font[N];
     Segm:=Seg(Img^);
     Offs:=Ofs(Img^);
     Move(Mem[Segm:Offs],Dx,2);
     Move(Mem[Segm:Offs+2],Dy,2);
     Offs:=Offs+4;
     D:=Y;
     While (D<=Y+DY-1) And (D<MaxY) Do
     Begin
          B:=X;
          While (B<=X+DX-1) And (B<MaxX) Do
          Begin
               If (X>=MinX) And (Y>=MinY) Then
               if Mem[Segm:Offs]<>c then
                 Mem[Where:(d*320)+b]:=Mem[Segm:Offs];
               Inc(Offs);
               Inc(B);
          End;
          Inc(D);
     End;
End;

Procedure Putstring(x,y,col,lx,s:integer;n:string;Where:word);
var index:byte;
    dx:integer;
begin
     Dx:=x;
     for index:=0 to length(n)-1 do
         begin
              putchar (Dx,y,col,n[index+1],Where);
              dx:=dx+lx+s;
         end;
end;

type stars=record
                 x:real;
                 y,c:integer;
           end;

var c:char;
    banana,chik,pineapple: pointer;
    star:array[1..1000] of stars;
    xxx,yyy,xx,color,muzak,mrow,morder: integer;
    color2: array [0..319] of integer;

procedure diagonals;
begin
      for xxx:=0 to 319 do
       begin
        xx:=xxx;
        for yyy:=0 to 199 do
         begin
              mem[vp[1]:xx+yyy*320]:=color2[xxx];
              xx:=xx-1;
              if xx<0 then xx:=319;
         end;
       end;
end;

procedure mupdate(check:integer); {1 means fast, 2 means normal}
begin
     if muzak=1 then mrow:=musicrow;
     if muzak=1 then morder:=musicorder($FF);
     if muzak=0 then if random(check)=0 then mrow:=mrow+1;
     if muzak=0 then if mrow>63 then
        begin
             mrow:=mrow-63;
             morder:=morder+1;
        end;
end;

Var
  SoundCardName : String;
  DMA, IRQ : Byte;
  BaseIO : Word;
  SampleRate : Word;
  DMABuffer : Word;
  Handle : File;
  Header : GDMHeader;
  EMSFlag : Word;
  MusicChannels : Word;
  ChannelCount : Word;
  ExitProgram : Boolean;
  n1:char;

Procedure EndProg(ErrorString : String);
{ Prints the error string and Halts the program }
Begin
  Writeln;
  Writeln(ErrorString);
  If IOResult <> 0 then Close(Handle);
  Halt(0);
End;

Function GetSoundCardName : String;
Begin
  Writeln;
  Writeln(' Select Sound Card: ');
  Writeln('   0. No Sound');
  Writeln('   1. Gravis Ultrasound');
  Writeln('   2. Sound Blaster 1.0');
  Writeln('   3. Sound Blaster 2.0');
  Writeln('   4. Sound Blaster Pro');
  Writeln('   5. Sound Blaster 16');
  Writeln('   6. Pro Audio Spectrum');
  repeat until getchar(n1)=true;
    if n1='0' then GetSoundCardName := 'none';
    if n1='1' then GetSoundCardName := 'GUS.MSE';
    if n1='2' then GetSoundCardName := 'SB1X.MSE';
    if n1='3' then GetSoundCardName := 'SB2X.MSE';
    if n1='4' then GetSoundCardName := 'SBPRO.MSE';
    if n1='5' then GetSoundCardName := 'SB16.MSE';
    if n1='6' then GetSoundCardName := 'PAS.MSE';
End;

Function GetIRQNumber : Byte;
Begin
  Writeln;
  Writeln(' Select IRQ: ');
  Writeln('   1. IRQ 2');
  Writeln('   2. IRQ 3');
  Writeln('   3. IRQ 5');
  Writeln('   4. IRQ 7');
  Writeln('   5. IRQ 11');
  Writeln('   6. IRQ 12');
  Writeln('   7. auto-detect');
  repeat until getchar(n1)=true;
  if n1='1' then GetIRQNumber := 2;
  if n1='2' then GetIRQNumber := 3;
  if n1='3' then GetIRQNumber := 5;
  if n1='4' then GetIRQNumber := 7;
  if n1='5' then GetIRQNumber := 11;
  if n1='6' then GetIRQNumber := 12;
  if n1='7' then GetIRQNumber := $FF;
End;

Function GetDMAChannel : Byte;
Begin
  Writeln;
  Writeln(' Select DMA Channel: ');
  Writeln('   1. DMA Channel 1');
  Writeln('   2. DMA Channel 2');
  Writeln('   3. DMA Channel 3');
  Writeln('   4. DMA Channel 5');
  Writeln('   5. auto-detect');
  repeat until getchar(n1)=true;
  if n1='1' then GetDMAChannel := 1;
  if n1='2' then GetDMAChannel := 2;
  if n1='3' then GetDMAChannel := 3;
  if n1='4' then GetDMAChannel := 5;
  if n1='5' then GetDMAChannel := $FF;
End;

Function GetBaseIO : Word;
Begin
  Writeln;
  Writeln(' Select Base I/O Address: ');
  Writeln('   1. 210h');
  Writeln('   2. 220h');
  Writeln('   3. 230h');
  Writeln('   4. 240h');
  Writeln('   5. 250h');
  Writeln('   6. 260h');
  Writeln('   7. auto-detect');
  repeat until getchar(n1)=true;
  if n1='1' then GetBaseIO := $210;
  if n1='2' then GetBaseIO := $220;
  if n1='3' then GetBaseIO := $230;
  if n1='4' then GetBaseIO := $240;
  if n1='5' then GetBaseIO := $250;
  if n1='6' then GetBaseIO := $260;
  if n1='7' then GetBaseIO := $FFFF;
End;

Function ToHex(Num : Word) : String;
{ Converts a decimal number to Hexidecimal }
Const HexChars : String = '0123456789ABCDEF';
Var   Temp : String;
Begin
  Temp := '';
  Temp := Temp + HexChars[((Num Shr 8) And 15) + 1];
  Temp := Temp + HexChars[((Num Shr 4) And 15) + 1];
  Temp := Temp + HexChars[((Num Shr 0) And 15) + 1];
  ToHex := Temp + 'h';
End;

{start}

Begin
  SoundCardName := GetSoundCardName; { Get the Sound card to be used      }

if soundcardname<>'none' then
 begin

  BaseIO := GetBaseIO;               { Get the Base port address          }
  IRQ := GetIRQNumber;               { Get IRQ number                     }
  DMA := GetDMAChannel;              { Get DMA Channel                    }
  SampleRate := 45;                  { Initially set at 45Khz             }
  DMABuffer := 4096;                 { DMA Buffer of 4096 bytes           }
  Case LoadMSE(SoundCardName, 0, SampleRate, DMABuffer, BaseIO, IRQ, DMA) of
    1 : EndProg('Base I/O address autodetection failure');
    2 : EndProg('IRQ level autodetection failure');
    3 : EndProg('DMA channel autodetection failure');
    4 : EndProg('DMA channel not supported');
    6 : EndProg('Sound device does not respond');
    7 : EndProg('Memory control blocks destroyed');
    8 : EndProg('Insufficient memory for mixing buffers');
    9 : EndProg('Insufficient memory for MSE file');
    10: EndProg('MSE has invalid identification string');
    11: EndProg('MSE disk read failure');
    12: EndProg('MVSOUND.SYS not loaded');
  End;
  ExitProc := @FreeMSE;              { Call FreeMSE on abnormal program end }
  If EMSExist                      { Check for EMS }
    Then EMSFlag := 1              { Yes, EMS exists, so use it }
    Else EMSFlag := 0;             { EMS does not exist }

{$I-}                              { Turn off I/O checking }
  Assign(Handle, 'mov98.gdm');   { Open the file for loading }
  Reset(Handle);
{$I+}                              { Turn I/O checking back on }
  If IOResult <> 0 Then
     EndProg('Module does not exist');    { File not found, exit program }

  Case LoadGDM(Handle, 0, EMSFlag, Header) of
    1 : EndProg('Module is corrupt');
    2 : EndProg('Could not autodetect module type (N/A)');
    3 : EndProg('Bad file format ID string');
    4 : EndProg('Insufficient memory to load module');
    5 : EndProg('Can not unpack samples');
    6 : EndProg('AdLib instruments not supported');
  End;
  Close(Handle);

    MusicChannels := 0;            { Calculate the number of channels in song }
  For ChannelCount := 1 to 32 do
    Begin
      If Header.PanMap[ChannelCount] <> $FF
        Then MusicChannels := MusicChannels + 1;
    End;
  SampleRate := StartOutput(MusicChannels, 0);

  muzak:=1;

 end

else muzak:=0;

{-------------begins here------------}

     writeln ('module loaded!');

     c:=' ';

     video_mode ( $13);
     initvirt;

     cls (0,vp[1]);
     loadpcx ('mov98gfx.pcx',vp[2]);

     getimage (0,0,15,15,font['a'],vp[2]);
     getimage (15,0,30,15,font['b'],vp[2]);
     getimage (30,0,45,15,font['c'],vp[2]);
     getimage (45,0,60,15,font['d'],vp[2]);
     getimage (60,0,75,15,font['e'],vp[2]);
     getimage (75,0,90,15,font['f'],vp[2]);
     getimage (90,0,105,15,font['g'],vp[2]);
     getimage (105,0,120,15,font['h'],vp[2]);
     getimage (120,0,135,15,font['i'],vp[2]);
     getimage (135,0,150,15,font['j'],vp[2]);
     getimage (150,0,165,15,font['k'],vp[2]);
     getimage (165,0,180,15,font['l'],vp[2]);
     getimage (180,0,195,15,font['m'],vp[2]);
     getimage (195,0,210,15,font['n'],vp[2]);
     getimage (210,0,225,15,font['o'],vp[2]);
     getimage (225,0,240,15,font['p'],vp[2]);
     getimage (240,0,255,15,font['q'],vp[2]);
     getimage (255,0,270,15,font['r'],vp[2]);
     getimage (270,0,285,15,font['s'],vp[2]);
     getimage (285,0,300,15,font['t'],vp[2]);
     getimage (300,0,315,15,font['u'],vp[2]);

     getimage (0,15,15,30,font['v'],vp[2]);
     getimage (15,15,30,30,font['w'],vp[2]);
     getimage (30,15,45,30,font['x'],vp[2]);
     getimage (45,15,60,30,font['y'],vp[2]);
     getimage (60,15,75,30,font['z'],vp[2]);
     getimage (75,15,90,30,font['0'],vp[2]);
     getimage (90,15,105,30,font['1'],vp[2]);
     getimage (105,15,120,30,font['2'],vp[2]);
     getimage (120,15,135,30,font['3'],vp[2]);
     getimage (135,15,150,30,font['4'],vp[2]);
     getimage (150,15,165,30,font['5'],vp[2]);
     getimage (165,15,180,30,font['6'],vp[2]);
     getimage (180,15,195,30,font['7'],vp[2]);
     getimage (195,15,210,30,font['8'],vp[2]);
     getimage (210,15,225,30,font['9'],vp[2]);
     getimage (225,15,240,30,font['!'],vp[2]);
     getimage (240,15,255,30,font['?'],vp[2]);
     getimage (255,15,270,30,font['.'],vp[2]);
     getimage (270,15,285,30,font[','],vp[2]);
     getimage (285,15,300,30,font['='],vp[2]);
     getimage (300,15,315,30,font[')'],vp[2]);

     getimage (0,30,15,45,font['/'],vp[2]);
     getimage (15,30,30,45,font[' '],vp[2]);
     getimage (30,30,45,45,font['-'],vp[2]);

     c:=' ';

     randomize;

     for xxx:=0 to 1000 do
         begin
              star[xxx].x:=random(320);
              star[xxx].y:=random(200);
              star[xxx].c:=random(16);
         end;

     if muzak=1 then startmusic;
     if muzak=0 then
        begin
             mrow:=0;
             morder:=0;
        end;

     repeat
      mupdate(1);
      cls (0,vp[1]);
      for xxx:=0 to 1000 do
         begin
          star[xxx].x:=star[xxx].x+0.125*(star[xxx].c div 4);
          if star[xxx].x<0 then star[xxx].x:=320;
          color:=mem[vp[1]:round(star[xxx].x)+star[xxx].y*320]+star[xxx].c;
          if color>16 then color:=16;
          mem[vp[1]:round(star[xxx].x)+star[xxx].y*320]:=color;
         end;

            if morder=1 then putstring (20,20,0,0,15,'they come',vp[1]);
            if morder=1 then putstring (20,40,0,0,15,'from the void',vp[1]);
            if morder=2 then putstring (20,60,0,0,15,'claiming',vp[1]);
            if morder=2 then putstring (20,80,0,0,15,'the galaxy',vp[1]);
            if morder=3 then putstring (20,100,0,0,15,'your worst',vp[1]);
            if morder=3 then putstring (20,120,0,0,15,'nightmare',vp[1]);
            if morder=4 then putstring (20,140,0,0,15,'now on 64k',vp[1]);
            if morder=4 then putstring (20,160,0,0,15,'- where available -',vp[1]);

      move (mem[vp[1]:0],mem[vga:0],64000);
      if getchar(c)=true then c:=#27;
            if morder>4 then c:=#27;
     until c=#27;

     c:=' ';

     getimage (0,80,79,199,banana,vp[2]);
     getimage (80,80,159,199,chik,vp[2]);
     getimage (160,80,239,199,pineapple,vp[2]);

     repeat
      mupdate(1);

      cls (0,vp[1]);
      for xxx:=0 to 319 do color2[xxx]:=random(256);
      if morder>4 then if morder<16 then diagonals;
      if morder>15 then if morder<22 then for yyy:=0 to 199 do for xxx:=0 to 319 do mem[vp[1]:xxx+yyy*320]:=color2[yyy];
      if morder>21 then if morder<24 then diagonals;

      if morder=6 then putimage (320-round(mrow*1.5),round(mrow*1.5)-75,0,banana,vp[1]);
      if morder>6 then if morder<16 then putimage (320-95,20,0,banana,vp[1]);
      if morder>7 then if morder<16 then putstring (20,20,0,0,15,'hail to the',vp[1]);
      if morder>8 then if morder<16 then putstring (20,40,0,0,15,'bad-ass',vp[1]);
      if morder>9 then if morder<16 then putstring (20,60,0,0,15,'mean-looking',vp[1]);
      if morder>10 then if morder<16 then putstring (20,80,0,0,15,'earth-invading',vp[1]);
      if morder>11 then if morder<16 then putstring (20,100,0,0,15,'alien bananas',vp[1]);
      if morder>12 then if morder<16 then putstring (20,120,0,0,15,'from kruptunn!',vp[1]);
      if morder>13 then if morder<16 then putstring (20,140,0,0,15,'tremble now!',vp[1]);
      if morder>14 then if morder<16 then putstring (20,160,0,0,15,'ah ah ah ah',vp[1]);

      if morder>15 then if morder<22 then putimage (mrow+(morder-17)*63,80,0,chik,vp[1]);
      if morder=16 then putstring (20,20,0,0,15,'oh no!',vp[1]);
      if morder=17 then putstring (20,20,0,0,15,'oh no!',vp[1]);
      if morder=18 then putstring (20,20,0,0,15,'we are doomed!',vp[1]);
      if morder=19 then putstring (20,20,0,0,15,'we are doomed!',vp[1]);
      if morder=20 then putstring (20,20,0,0,15,'help! help!',vp[1]);
      if morder=21 then putstring (20,20,0,0,15,'help! help!',vp[1]);

      if morder>21 then if morder<24 then putimage (320-95,20,0,banana,vp[1]);
      if morder=22 then putstring (20,20,0,0,15,'no one can',vp[1]);
      if morder=22 then putstring (20,40,0,0,15,'     save you!',vp[1]);
      if morder=23 then putstring (20,20,0,0,15,'oh no!!!',vp[1]);
      if morder=23 then putstring (20,40,0,0,15,'a pine-apple!',vp[1]);

      if morder=24 then putimage (320-95,95-75,0,pineapple,vp[1]);
      if morder=24 then putstring (20,60,0,0,15,'fuckin hei',vp[1]);

      if morder>24 then if morder<28 then putimage (320-95,20,0,banana,vp[1]);
      if morder=25 then putstring (20,20,0,0,15,'retreat',vp[1]);
      if morder=25 then putstring (20,40,0,0,15,'   bananas',vp[1]);
      if morder=26 then putstring (20,60,0,0,15,'retreat !!!',vp[1]);
      if morder=27 then putstring (20,80,0,0,15,'back to',vp[1]);
      if morder=27 then putstring (20,100,0,0,15,'    kruptunn',vp[1]);

      if morder>27 then if morder<30 then putimage (20,20,0,chik,vp[1]);
      if morder=28 then putstring (120,40,0,0,15,'my saviour',vp[1]);
      if morder=29 then putstring (120,80,0,0,15,'your so cool!',vp[1]);

      if morder>29 then if morder<33 then putimage (320-95,20,0,pineapple,vp[1]);
      if morder=30 then putstring (20,40,0,0,15,'fuckin hei',vp[1]);
      if morder=31 then putstring (20,80,0,0,15,'i know babe',vp[1]);
      if morder=32 then putstring (20,120,0,0,15,'i know! =)',vp[1]);

      waitvbl;
      move (mem[vp[1]:0],mem[vga:0],64000);
      if getchar(c)=true then c:=#27;
      if morder>32 then c:=#27;
     until c=#27;

     c:=' ';

     for c:='a'  to 'z' do killimage (font[c]);
     for c:='0'  to '9' do killimage (font[c]);
     killimage (font['!']);
     killimage (font['?']);
     killimage (font['.']);
     killimage (font[',']);
     killimage (font['=']);
     killimage (font[')']);
     killimage (font['/']);
     killimage (font[' ']);
     killimage (font['-']);

     killimage (banana);
     killimage (chik);
     killimage (pineapple);

     closevirt;
     video_mode ( 03);

     if muzak=1 then
     begin
     stopmusic;
     stopoutput;
     unloadmodule;
     freemse;
     end;

     cls (0,vga);
     writeln;
     writeln('<pshyshkabab (tm) ohad ''98> on das code unt design!');
     writeln('<iron_maze> on das "bad-ass" banana!');
     writeln('<aGi> with das "affraid from banana" chik!');
     writeln('unt <zThee> with das "fucking hei" pineapple!');
     writeln('<distance> on das banana chip-tune!');
     writeln;
     writeln('BRILLIANT!');
     writeln('FANTASTICCCCCCCCCCCCCCCCCCCCCCCCCC!!!!!!!!!!');
     writeln;
end.