program Vstarfield;

uses mode13h,crt;

type star=record
                x,y:integer;
                color:byte;
                end;

var stars:array [1..1000] of star;
    a:integer;

procedure initstars;
var a:integer;
begin
      cls (0,vp[1]);
      for a:=0 to 15 do setcolor (a,a*4,a*4,a*4);
      for a:=1 to 1000 do
      begin
           stars[a].x:=random(320);
           stars[a].y:=random(200);
           stars[a].color:=random(15)+1;
      end;
end;

procedure clearstars;
var a:integer;
begin
     for a:=1 to 1000 do putpixel(stars[a].x,stars[a].y,0,vp[1]);
end;

procedure movestars(ix,iy:integer);
var a:word;
begin
      for a:=1 to 1000 do
      begin
            stars[a].x:=stars[a].x+ix*(stars[a].color div 4);
            stars[a].y:=stars[a].y+iy*(stars[a].color div 4);
            if stars[a].x<0 then stars[a].x:=319;
            if stars[a].x>319 then stars[a].x:=0;
            if stars[a].y<0 then stars[a].y:=199;
            if stars[a].y>199 then stars[a].y:=0;
      end;
end;

procedure drawstars;
var a:integer;
begin
      for a:=1 to 1000 do
      putpixel(stars[a].x,stars[a].y,stars[a].color,vp[1]);
end;

procedure movearound(ix,iy:integer);
begin
     clearstars;
     movestars (ix,iy);
     drawstars;
     waitvbl;
     copypage(vp[1],vga);
end;

procedure startinit;
begin
     initgraph;
     initvirt;
end;

procedure endinit;
begin
     closegraph;
     closevirt;
end;

begin
     startinit;
     loadpcx ('crush02.pcx',vp[2]);
     loadpcx ('crush03.pcx',vp[3]);
     copypage (vp[2],vga);
     delay (3000);
     copypage (vp[3],vga);
     delay (2000);
     initstars;
     for a:=1 to 100 do movearound(-1,0);
     for a:=1 to 100 do movearound(-1,1);
     for a:=1 to 100 do movearound(0,1);
     for a:=1 to 100 do movearound(1,1);
     for a:=1 to 100 do movearound(1,0);
     for a:=1 to 100 do movearound(1,-1);
     for a:=1 to 100 do movearound(0,-1);
     for a:=1 to 100 do movearound(-1,-1);
     endinit;
end.