{$M 22048,0,263550}

{$A+,B-,E+,F-,G+,N+,Q-,R-,S-}

{ time log: }
{ started december 1997 made the engine, with a games unit and a crappy AI }
{ january 1997 sorted some bugs: using same var in 3 sub procedures and in main. oops!}
{ february 1997 corrected pcx and upgraded AI... still crappy }
{ july 1998 moved procedures from crush13h unit to main .pas}
{ september 1998 no change... just checking some old files!}
{ Psychic Symphony / Label }

{to do:
    put movepac, movem and moveg all in the same move! it was ok but i mess
     with it when sorting out the january error and never got the patience
     to re-optimize!
    enable dots for eating!
    enable 2 pacmans on screen! (2p contest)
    colision test!
    enable the other 2 monsters!
    score counter
    hiscore table sorting!
    save and reload hiscore table
    decent AI fro the monsters (they are just moving rather randomly without
     going through any walls and stuff)
    more levels (txt edited! 20*20)
    GUI on the remaining 120*200 with status! (need gfx)
    implement musical score (this is supposed to be a 100k game so im looking
     for a cool s3m/mod chiptune! i can put it playing/looping with bwsb!)
     only bwsb drivers take at least 25k per sound device! so what i need to
     do is only use sb and gus (50k) plus the chiptune (30k) which leaves
     20k for the gfx GUI and whole code!
    aim for a demoparty with a 100k game compo!}

program pacmanclone;

uses games;

Const VGA=$A000;
      Npages=2;
      MinX=0;
      MaxX=319;
      MinY=0;
      MaxY=199;

Type RgbItem=Record
                   R,G,B:Byte;
             End;
     RgbList=Array[0..255] of RgbItem;

Var Virt:Array[1..Npages] Of Pointer;
    VP:Array[1..Npages] Of Word;

Procedure video_mode (mode : Byte); Assembler;
Asm
  mov  AH,00
  mov  AL,mode
  int  10h
end;

Procedure PutPixel(X,Y:word;Col:Byte;Where:Word);
Begin
     Mem[Where:(y*320)+x]:=Col;
End;

Function GetPixel(X,Y:word;Where:Word):Byte;
Begin
     GetPixel:=Mem[Where:(y*320)+x];
End;


Procedure Cls(Col:Byte;Where:Word);
Begin
     Fillchar(Mem[Where:0000],64000,Col);
End;

Procedure WaitVBL; Assembler;
Label A1,A2;
Asm
   Mov DX,3DAh
   A1:
      In AL,DX
      And AL,08h
      Jnz A1
   A2:
      In AL,DX
      And AL,08h
      Jz A2
End;

Procedure GetColor(Col:Byte;Var R,G,B:Byte);
Begin
     Port[$3C7]:=Col;
     R:=Port[$3C9];
     G:=Port[$3C9];
     B:=Port[$3C9];
End;

Procedure SetColor(Col,R,G,B:Byte);
Begin
     Port[$3C8]:=Col;
     Port[$3C9]:=R;
     Port[$3C9]:=G;
     Port[$3C9]:=B;
End;

Procedure GetPalette(Var Pal:RgbList);
Var A:Byte;
Begin
     For A:=0 To 255 do GetColor(A,Pal[A].R,Pal[A].G,Pal[A].B);
End;

Procedure SetPalette(Pal:RgbList);
Var A:Byte;
Begin
     WaitVBL;
     For A:=0 To 255 do SetColor(A,Pal[A].R,Pal[A].G,Pal[A].B);
End;

procedure swapcolors (a,b:integer; where:word);
var x,y,c:integer;
begin
     for x:=0 to 319 do
         begin
         for y:=0 to 199 do
             begin
                  c:= getpixel (x,y,where);
                  if c=a
                  then putpixel (x,y,b,where)
                  else if c=b then putpixel (x,y,a,where);
             end;
         end;
end;

Procedure swapcolors_p (a,d:integer);
var r,g,b,s,h,c:byte;
begin
     getcolor(a,r,g,b);
     getcolor(d,s,h,c);
     setcolor(a,s,h,c);
     setcolor(d,r,g,b);
end;

Procedure Circle(X,Y,R:Integer;Col:Byte;Where:Word);
Var Px,Py:Integer;
    Deg:Word;
Begin
     For Deg:=0 to 1799 Do
     Begin
          Px:=Trunc(R*Sines^[Deg]+X);
          Py:=Trunc(R*Cosines^[Deg]+Y);
          PutPixel(Px,Py,Col,Where);
     End;
End;

Function Sgn(A:Real):Integer;
Begin
     If A<0 then Sgn:=-1;
     If A=0 then Sgn:=0;
     If A>0 then Sgn:=+1;
End;

Procedure Line(X1,Y1,X2,Y2,Col:Integer;Where:Word);
Var Deltax,S,Deltay,Dx1,Dy1,Dx2,Dy2,S1,S2:Real;
    I:Integer;
Begin
     Deltax:=X2-X1;
     Deltay:=Y2-Y1;
     Dx1:=Sgn(Deltax);
     Dy1:=Sgn(Deltay);
     Dx2:=Sgn(Deltax);
     Dy2:= 0;
     S1:=Abs(Deltax);
     S2:=Abs(Deltay);
     If Not (S1>S2) Then
     Begin
          Dx2:=0;
          Dy2:=Sgn(Deltay);
          S1:=Abs(Deltay);
          S2:=Abs(Deltax);
     End;
     S:=Int(S1/2);
     For I:=0 To Round(S1) Do
     Begin
          PutPixel(X1,Y1,Col,Where);
          S:=S+S2;
          If Not (S<S1) Then
          Begin
               S:=S-S1;
               X1:=X1+Round(Dx1);
               Y1:=Y1+Round(Dy1);
          End
          Else
          Begin
               X1:=X1+Round(dx2);
               Y1:=Y1+Round(Dy2);
          End;
     End;
End;

Procedure InitTables;
Var A:Word;
    B:Real;
Begin
     Getmem(Sines,Sizeof(Sines^));
     Getmem(Cosines,Sizeof(Cosines^));
     B:=0;
     For A:=0 To 1799 Do
     Begin
          Sines^[A]:=Sin(B);
          Cosines^[A]:=Cos(B);
          B:=B+0.005;
     End;
End;

Procedure ClearTables;
Begin
     Freemem(Sines,Sizeof(Sines^));
     Freemem(Cosines,Sizeof(Cosines^));
End;

Procedure InitVirt;
Var A:Byte;
Begin
     For A:=1 To Npages Do
     Begin
          GetMem(Virt[A],64000);
          VP[A]:=Seg(Virt[A]^);
     End;
End;

Procedure CloseVirt;
Var A:Byte;
Begin
     For A:=1 To Npages Do
     Begin
          Freemem(Virt[A],64000);
          VP[A]:=$A000;
     End;
End;

Procedure CopyPage(From,Too:Word);
Begin
     WaitVbl;
     Move(Mem[From:0],Mem[Too:0],64000);
End;

Procedure LoadPCX(Filename:String;Where:Word);
Var Fil:File;
    Dx,Dy:Word;
    J,M:Byte;
    Ph:Word;
    Buff:Array[0..127] of byte;
    PCXPal:RgbList;
Begin
     Assign(Fil,Filename);
     Reset(Fil,1);
     Blockread(Fil,Buff,128);
     Dy:=0;
     Repeat
           Dx:=0;
           Repeat
                 BlockRead(Fil,J,1);
                 If J>192 Then
                 Begin
                      BlockRead(Fil,M,1);
                      Dec(J,192);
                      For Ph:=1 To J Do
                      Begin
                           PutPixel(Dx,Dy,M,Where);
                           Inc(Dx);
                      End;
                 End
                 Else
                 Begin
                      PutPixel(Dx,Dy,J,Where);
                      Inc(Dx);
                 End;
           Until Dx>=320;
           Inc(Dy);
     Until Dy=200;
     BlockRead(Fil,M,1);
     If M=12 Then
     Begin
          BlockRead(Fil,PCXPal,768);
          For M:=0 To 255 Do
          Begin
               PCXPal[M].R:=PCXPal[M].R Div 4;
               PCXPal[M].G:=PCXPal[M].G Div 4;
               PCXPal[M].B:=PCXPal[M].B Div 4;
          End;
          SetPalette(PCXPal);
     End;
     Close(Fil);
End;

Procedure LoadPCX_nopal(Filename:String;Where:Word);
Var Fil:File;
    Dx,Dy:Word;
    J,M:Byte;
    Ph:Word;
    Buff:Array[0..127] of byte;
Begin
     Assign(Fil,Filename);
     Reset(Fil,1);
     Blockread(Fil,Buff,128);
     Dy:=0;
     Repeat
           Dx:=0;
           Repeat
                 BlockRead(Fil,J,1);
                 If J>192 Then
                 Begin
                      BlockRead(Fil,M,1);
                      Dec(J,192);
                      For Ph:=1 To J Do
                      Begin
                           PutPixel(Dx,Dy,M,Where);
                           Inc(Dx);
                      End;
                 End
                 Else
                 Begin
                      PutPixel(Dx,Dy,J,Where);
                      Inc(Dx);
                 End;
           Until Dx>=320;
           Inc(Dy);
     Until Dy=200;
     Close(Fil);
end;

Procedure GetImage(x1,y1,x2,y2:Word;Var Img:Pointer;Where:Word);
Var Dx,Dy:Word;
    A,B:Word;
    Segm,Offs:Word;
Begin
     Dx:=Abs(x2-x1)+1;
     Dy:=Abs(y2-y1)+1;
     GetMem(Img,Dx*Dy+4);
     Segm:=Seg(Img^);
     Offs:=Ofs(Img^);
     Move(Dx,Mem[Segm:Offs],2);
     Move(Dy,Mem[Segm:Offs+2],2);
     Offs:=Offs+4;
     For A:=y1 to y2 Do
     For B:=x1 to x2 Do
     Begin
          Mem[Segm:Offs]:=GetPixel(B,A,Where);
          Inc(Offs);
     End;
End;

Procedure KillImage(Var Img:Pointer);
Var Dx,Dy:Word;
    Segm,Offs:Word;
Begin
     Segm:=Seg(Img^);
     Offs:=Ofs(Img^);
     Move(Mem[Segm:Offs],Dx,2);
     Move(Mem[Segm:Offs+2],Dy,2);
     FreeMem(Img,Dx*Dy+4);
End;

Procedure PutImage(X,Y,C:Integer;Var Img:Pointer;Where:Word);
Var Dx,Dy:Word;
    A,B:Word;
    Segm,Offs:Word;
Begin
     Segm:=Seg(Img^);
     Offs:=Ofs(Img^);
     Move(Mem[Segm:Offs],Dx,2);
     Move(Mem[Segm:Offs+2],Dy,2);
     Offs:=Offs+4;
     A:=Y;
     While (A<=Y+DY-1) And (A<MaxY) Do
     Begin
          B:=X;
          While (B<=X+DX-1) And (B<MaxX) Do
          Begin
               If (X>=MinX) And (Y>=MinY) Then
               if Mem[Segm:Offs]<>c then
                 PutPixel(B,A,Mem[Segm:Offs],Where);
               Inc(Offs);
               Inc(B);
          End;
          Inc(A);
     End;
End;

Procedure SaveImage(Var F:File;Img:Pointer);
Var Dx,Dy:Word;
    Segm,Offs:Word;
Begin
     Segm:=Seg(Img^);
     Offs:=Ofs(Img^);
     Move(Mem[Segm:Offs],Dx,2);
     Move(Mem[Segm:Offs+2],Dy,2);
     BlockWrite(F,Img^,Dx*Dy+4);
End;

Procedure LoadImage(Var F:File;Var Img:Pointer);
Var Dx,Dy:Word;
    Segm,Offs:Word;
Begin
     BlockRead(F,Dx,2);
     BlockRead(F,Dy,2);
     GetMem(Img,Dx*Dy+4);
     Segm:=Seg(Img^);
     Offs:=Ofs(Img^);
     Move(Dx,Mem[Segm:Offs],2);
     Move(Dy,Mem[Segm:Offs+2],2);
     Offs:=Offs+4;
     BlockRead(F,Mem[Segm:Offs],Dx*Dy);
End;

{------------------------crush13h is over-------------------------}

{games for keyboard and timing}

const
     nlevel=1;
     nim=30;

type
    pacrec=record
                 d:integer;
                 x:integer;
                 y:integer;
           end;
    levelrec=record
                name:string[20];
                author:string[20];
             end;

var    pacman  : pacrec;
       monster : pacrec;
       ghost   : pacrec;
       screen  : array [1..nlevel,0..19,0..19] of integer;
       level   : array [1..nlevel] of levelrec;
       clevel  : integer;
       a,b     : integer;
       c,m,g   : integer;
       dirm    : integer;
       dirg    : integer;
       x,y     : integer;
       image   : array [1..nim] of pointer;

procedure terminate;
begin
     closevirt;                 {close vp's}
     video_mode ( 03);          {back to normal mode}
     setoldtimint;              {returning timer to normal}
     for a:=1 to nim do killimage(image[a]);
     halt;
end;

procedure movedown;
begin
     if c=1 then b:=1;
     if c=2 then b:=2;
     if c=3 then b:=3;
     if c=4 then b:=2;
     c:=c+1;
     if c>4 then c:=1;
     putimage(pacman.x,pacman.y,255,image[b+17],vp[1]);
end;

procedure moveup;
begin
     if c=1 then b:=1;
     if c=2 then b:=2;
     if c=3 then b:=3;
     if c=4 then b:=2;
     c:=c+1;
     if c>4 then c:=1;
     putimage(pacman.x,pacman.y,255,image[b+20],vp[1]);
end;

procedure moveleft;
begin
     if c=1 then b:=1;
     if c=2 then b:=2;
     if c=3 then b:=3;
     if c=4 then b:=2;
     c:=c+1;
     if c>4 then c:=1;
     putimage(pacman.x,pacman.y,255,image[b+14],vp[1]);
end;

procedure moveright;
begin
     if c=1 then b:=1;
     if c=2 then b:=2;
     if c=3 then b:=3;
     if c=4 then b:=2;
     c:=c+1;
     if c>4 then c:=1;
     putimage(pacman.x,pacman.y,255,image[b+11],vp[1]);
end;

procedure movedownm;
begin
     m:=m+1;
     if m>2 then m:=1;
     putimage(monster.x,monster.y,255,image[m+24],vp[1]);
end;

procedure moveupm;
begin
     m:=m+1;
     if m>2 then m:=1;
     putimage(monster.x,monster.y,255,image[m+24],vp[1]);
end;

procedure moveleftm;
begin
     m:=m+1;
     if m>2 then m:=1;
     putimage(monster.x,monster.y,255,image[m+24],vp[1]);
end;

procedure moverightm;
begin
     m:=m+1;
     if m>2 then m:=1;
     putimage(monster.x,monster.y,255,image[m+24],vp[1]);
end;

procedure movedowng;
begin
     g:=g+1;
     if g>2 then g:=1;
     putimage(ghost.x,ghost.y,255,image[g+26],vp[1]);
end;

procedure moveupg;
begin
     g:=g+1;
     if g>2 then g:=1;
     putimage(ghost.x,ghost.y,255,image[g+26],vp[1]);
end;

procedure moveleftg;
begin
     g:=g+1;
     if g>2 then g:=1;
     putimage(ghost.x,ghost.y,255,image[g+26],vp[1]);
end;

procedure moverightg;
begin
     g:=g+1;
     if g>2 then g:=1;
     putimage(ghost.x,ghost.y,255,image[g+26],vp[1]);
end;

procedure readpac;
begin
           if keydown[leftscan]=true then
              if pacman.d<>4 then
              if pacman.d=2 then
              begin
              pacman.x:=pacman.x-1;
              pacman.d:=4;
              end
              else
              begin
              if pacman.x mod 10 =0 then if pacman.y mod 10 =0 then
              if screen[clevel,trunc(pacman.x div 10) -1,trunc(pacman.y div 10)]=0 then
              begin
              pacman.x:=pacman.x-1;
              pacman.d:=4;
              end
              end;

           if keydown[rightscan]=true then
              if pacman.d<>2 then
              if pacman.d=4 then
              begin
              pacman.x:=pacman.x+1;
              pacman.d:=2;
              end
              else
              begin
              if pacman.x mod 10 =0 then if pacman.y mod 10 =0 then
              if screen[clevel,trunc(pacman.x div 10) +1,trunc(pacman.y div 10)]=0 then
              begin
              pacman.x:=pacman.x+1;
              pacman.d:=2;
              end
              end;

           if keydown[upscan]=true then
              if pacman.d<>1 then
              if pacman.d=3 then
              begin
              pacman.y:=pacman.y-1;
              pacman.d:=1;
              end
              else
              begin
              if pacman.x mod 10 =0 then if pacman.y mod 10 =0 then
              if screen[clevel,trunc(pacman.x div 10),trunc(pacman.y div 10) -1]=0 then
              begin
              pacman.y:=pacman.y-1;
              pacman.d:=1;
              end
              end;

           if keydown[downscan]=true then
              if pacman.d<>3 then
              if pacman.d=1 then
              begin
              pacman.y:=pacman.y+1;
              pacman.d:=3;
              end
              else
              begin
              if pacman.x mod 10 =0 then if pacman.y mod 10 =0 then
              if screen[clevel,trunc(pacman.x div 10),trunc(pacman.y div 10) +1]=0 then
              begin
              pacman.y:=pacman.y+1;
              pacman.d:=3;
              end
              end;


           dirm:=random (9)+1;
           if dirm=4 then
              if monster.x mod 10 =0 then if monster.y mod 10 =0 then
              if screen[clevel,trunc(monster.x div 10) -1,trunc(monster.y div 10)]=0 then
              begin
              monster.x:=monster.x-1;
              monster.d:=4;
              end;

           if dirm=2 then
              if monster.x mod 10 =0 then if monster.y mod 10 =0 then
              if screen[clevel,trunc(monster.x div 10) +1,trunc(monster.y div 10)]=0 then
              begin
              monster.x:=monster.x+1;
              monster.d:=2;
              end;

           if dirm=1 then
              if monster.x mod 10 =0 then if monster.y mod 10 =0 then
              if screen[clevel,trunc(monster.x div 10),trunc(monster.y div 10) -1]=0 then
              begin
              monster.y:=monster.y-1;
              monster.d:=1;
              end;

           if dirm=3 then
              if monster.x mod 10 =0 then if monster.y mod 10 =0 then
              if screen[clevel,trunc(monster.x div 10),trunc(monster.y div 10) +1]=0 then
              begin
              monster.y:=monster.y+1;
              monster.d:=3;
              end;

           dirg:=random (9)+1;
           if dirg=4 then
              if ghost.x mod 10 =0 then if ghost.y mod 10 =0 then
              if screen[clevel,trunc(ghost.x div 10) -1,trunc(ghost.y div 10)]=0 then
              begin
              ghost.x:=ghost.x-1;
              ghost.d:=4;
              end;

           if dirg=2 then
              if ghost.x mod 10 =0 then if ghost.y mod 10 =0 then
              if screen[clevel,trunc(ghost.x div 10) +1,trunc(ghost.y div 10)]=0 then
              begin
              ghost.x:=ghost.x+1;
              ghost.d:=2;
              end;

           if dirg=1 then
              if ghost.x mod 10 =0 then if ghost.y mod 10 =0 then
              if screen[clevel,trunc(ghost.x div 10),trunc(ghost.y div 10) -1]=0 then
              begin
              ghost.y:=ghost.y-1;
              ghost.d:=1;
              end;

           if dirg=3 then
              if ghost.x mod 10 =0 then if ghost.y mod 10 =0 then
              if screen[clevel,trunc(ghost.x div 10),trunc(ghost.y div 10) +1]=0 then
              begin
              ghost.y:=ghost.y+1;
              ghost.d:=3;
              end;
end;

procedure updatepac;
begin

     if pacman.d=3 then
        if pacman.y mod 10 =0 then
           begin
        if pacman.x mod 10 =0 then
           if screen[clevel,trunc(pacman.x div 10),trunc(pacman.y div 10) +1]=0 then
           pacman.y:=pacman.y+1;
           end
        else pacman.y:=pacman.y+1;

     if pacman.d=4 then
        if pacman.x mod 10 =0 then
           begin
        if pacman.y mod 10 =0 then
           if screen[clevel,trunc(pacman.x div 10) -1,trunc(pacman.y div 10)]=0 then
           pacman.x:=pacman.x-1;
           end
        else pacman.x:=pacman.x-1;

     if pacman.d=2 then
        if pacman.x mod 10 =0 then
           begin
        if pacman.y mod 10 =0 then

           if screen[clevel,trunc(pacman.x div 10) +1,trunc(pacman.y div 10)]=0 then
           pacman.x:=pacman.x+1;
           end
        else pacman.x:=pacman.x+1;

     if pacman.d=1 then
        if pacman.y mod 10 =0 then
           begin
        if pacman.x mod 10 =0 then
           if screen[clevel,trunc(pacman.x div 10),trunc(pacman.y div 10) -1]=0 then
           pacman.y:=pacman.y-1;
           end
        else pacman.y:=pacman.y-1;


     if monster.d=3 then
        if monster.y mod 10 =0 then
           begin
        if monster.x mod 10 =0 then
           if screen[clevel,trunc(monster.x div 10),trunc(monster.y div 10) +1]=0 then
           monster.y:=monster.y+1;
           end
        else monster.y:=monster.y+1;

     if monster.d=4 then
        if monster.x mod 10 =0 then
           begin
        if monster.y mod 10 =0 then
           if screen[clevel,trunc(monster.x div 10) -1,trunc(monster.y div 10)]=0 then
           monster.x:=monster.x-1;
           end
        else monster.x:=monster.x-1;

     if monster.d=2 then
        if monster.x mod 10 =0 then
           begin
        if monster.y mod 10 =0 then
           if screen[clevel,trunc(monster.x div 10) +1,trunc(monster.y div 10)]=0 then
           monster.x:=monster.x+1;
           end
        else monster.x:=monster.x+1;

     if monster.d=1 then
        if monster.y mod 10 =0 then
           begin
        if monster.x mod 10 =0 then
           if screen[clevel,trunc(monster.x div 10),trunc(monster.y div 10) -1]=0 then
           monster.y:=monster.y-1;
           end
        else monster.y:=monster.y-1;

     if ghost.d=3 then
        if ghost.y mod 10 =0 then
           begin
        if ghost.x mod 10 =0 then
           if screen[clevel,trunc(ghost.x div 10),trunc(ghost.y div 10) +1]=0 then
           ghost.y:=ghost.y+1;
           end
        else ghost.y:=ghost.y+1;

     if ghost.d=4 then
        if ghost.x mod 10 =0 then
           begin
        if ghost.y mod 10 =0 then
           if screen[clevel,trunc(ghost.x div 10) -1,trunc(ghost.y div 10)]=0 then
           ghost.x:=ghost.x-1;
           end
        else ghost.x:=ghost.x-1;

     if ghost.d=2 then
        if ghost.x mod 10 =0 then
           begin
        if ghost.y mod 10 =0 then
           if screen[clevel,trunc(ghost.x div 10) +1,trunc(ghost.y div 10)]=0 then
           ghost.x:=ghost.x+1;
           end
        else ghost.x:=ghost.x+1;

     if ghost.d=1 then
        if ghost.y mod 10 =0 then
           begin
        if ghost.x mod 10 =0 then
           if screen[clevel,trunc(ghost.x div 10),trunc(ghost.y div 10) -1]=0 then
           ghost.y:=ghost.y-1;
           end
        else ghost.y:=ghost.y-1;

end;

procedure loadscreen;
var f:text;
    x,y:integer;
begin
     assign (f,'level.dat');
     reset (f);

     for a:=1 to nlevel do
     begin
     for y:=0 to 19 do
         begin
              for x:=0 to 19 do
                  begin
                       read (f,screen[a,x,y]);
                  end;
         end;
     readln (f,level[a].name);
     readln (f,level[a].author);
     end;
     close (f);

     clevel:=1;
end;

procedure putpac;
var x,y:integer;
begin
     copypage (vp[2],vp[1]);

     if pacman.d=1 then moveup;
     if pacman.d=2 then moveright;
     if pacman.d=3 then movedown;
     if pacman.d=4 then moveleft;

     if monster.d=1 then moveupm;
     if monster.d=2 then moverightm;
     if monster.d=3 then movedownm;
     if monster.d=4 then moveleftm;

     if ghost.d=1 then moveupg;
     if ghost.d=2 then moverightg;
     if ghost.d=3 then movedowng;
     if ghost.d=4 then moveleftg;

     copypage (vp[1],vga);
end;

begin
     initnewtimint;             {using timer sync instead of music}
     tickwait(0);               {}
     INITNEWKEYINT;             { keydown scan :) }
     video_mode ( $13);         {change to 13h}
     initvirt;                  {vp[1] and vp[2]}

     loadpcx ('images.pcx',vp[1]);
     getimage (0,0,9,9,image[1],vp[1]);
     getimage (10,0,19,9,image[2],vp[1]);
     getimage (20,0,29,9,image[3],vp[1]);
     getimage (30,0,39,9,image[4],vp[1]);
     getimage (40,0,49,9,image[5],vp[1]);
     getimage (0,10,9,19,image[6],vp[1]);
     getimage (10,10,19,19,image[7],vp[1]);
     getimage (20,10,29,19,image[8],vp[1]);
     getimage (0,20,9,29,image[9],vp[1]);
     getimage (10,20,19,29,image[10],vp[1]);
     getimage (20,20,29,29,image[11],vp[1]);
     getimage (50,0,59,9,image[12],vp[1]);
     getimage (60,0,69,9,image[13],vp[1]);
     getimage (70,0,79,9,image[14],vp[1]);
     getimage (80,0,89,9,image[15],vp[1]);
     getimage (90,0,99,9,image[16],vp[1]);
     getimage (100,0,109,9,image[17],vp[1]);
     getimage (110,0,119,9,image[18],vp[1]);
     getimage (110,10,119,19,image[19],vp[1]);
     getimage (110,20,119,29,image[20],vp[1]);
     getimage (120,0,129,9,image[21],vp[1]);
     getimage (120,10,129,19,image[22],vp[1]);
     getimage (120,20,129,29,image[23],vp[1]);
     getimage (40,10,49,19,image[24],vp[1]);
     getimage (50,10,59,19,image[25],vp[1]);
     getimage (60,10,69,19,image[26],vp[1]);
     getimage (70,10,79,19,image[27],vp[1]);
     getimage (80,10,89,19,image[28],vp[1]);
     getimage (90,10,99,19,image[29],vp[1]);
     getimage (100,10,109,19,image[30],vp[1]);

     loadscreen;

     pacman.x:=10;
     pacman.y:=10;
     monster.x:=10;
     monster.y:=10;
     ghost.x:=10;
     ghost.y:=10;

     randomize;

     cls (0,vp[2]);

     for x:=0 to 19 do
              begin
                   for y:=0 to 19 do
                       begin
                             if screen[clevel,x,y]<>0 then
                             putimage (x*10,y*10,255,image[screen[clevel,x,y]],vp[2]);
                       end;
              end;

     copypage (vp[2],vp[1]);

     repeat

           readpac;
           updatepac;
           putpac;

     until keydown[escscan]=true;

     terminate;

end.
