{************************************************************************}
{*                  A math unit by TELEMACHOS^PXD                       *}
{*                   Cossinus, Sinus and Tangens                        *}
{*                                                                      *}
{*   Realize that these functions are UN_AVAILABLE in standard TP 7.0   *}
{*   I had to do quite some research to find them so please give me     *}
{*   credits if you use this units for other purposes than PXDTUT7.PAS  *}
{************************************************************************}

UNIT cossin;
{$X+}

INTERFACE

USES crt;


FUNCTION Tan(x:real) : real;
FUNCTION Tandrg(x:real) : real;
FUNCTION SinDrg(x:real) : real;
FUNCTION CosDrg(x:real) : real;
FUNCTION ArcTanDrg(x:real) : real;
FUNCTION ArcSin(x:real) : real;
FUNCTION ArcSindrg(x:real) : real;
FUNCTION ArcCos(x:real) : real;
FUNCTION ArcCosDrg(x:real) : real;


IMPLEMENTATION

FUNCTION Tan(x: real) : real;
BEGIN
 TAN:=SIN(x)/COS(X);
END;

FUNCTION TanDrg(x: real) : real;
BEGIN
 x:=((2*pi)/360)*x;
 TANDRG:=SIN(x)/COS(X);
END;

FUNCTION SinDrg(x:real) : real;
BEGIN
 x:=((2*pi)/360)*x;
 SinDrg:=sin(x);
END;

FUNCTION CosDrg(x:real) : real;
BEGIN
 x:=((2*pi)/360)*x;
 CosDrg:=Cos(x);
END;

FUNCTION ArcTanDrg(x:real) : real;
BEGIN
  arctandrg:=(arctan(x)*360)/(2*pi);
END;

FUNCTION Arcsin(x:real) : real;
BEGIN
 Arcsin:=arctan(x/SQRT(1-x*x));
END;

FUNCTION ArcSinDrg(x:real) : real;
BEGIN
 ArcSinDrg:=Arctandrg(x/SQRT(1-x*x));
END;

FUNCTION ArcCos(x:real) : real;
BEGIN
 ArcCos:=(pi/2)-arcsin(x);
END;

FUNCTION ArcCosDrg(x : real) : real;
BEGIN
 ArcCosDrg:=90-ArcSinDrg(x);
END;


END.