#include "surface.h"

#include "keyb_hnd.h"

float nzi;          // 1/z del vrtice ms cercano. Se usa para seleccionar
                    //  el mipmapping adecuado

// Pasa todas las paletas de las texturas de un formato de 32 bits al formato
//  de video actual.

FIXED16 lightmap_r[17*17];
FIXED16 lightmap_g[17*17];
FIXED16 lightmap_b[17*17];

void convert_texture_pal(void) {

    DWORD i;

    for(i=0;i<world_mesh.no_maps;i++) {
        convert_pal((BYTE *)(world_mesh.maps+i)->pal[0]);
        convert_pal((BYTE *)(world_mesh.maps+i)->pal[1]);
        convert_pal((BYTE *)(world_mesh.maps+i)->pal[2]);
        convert_pal((BYTE *)(world_mesh.maps+i)->pal[3]);
    }

}

CACHE_BLOCK *surf_base,*last_block;
DWORD surf_size;
DWORD cached_surfaces;

void init_surface_cache(DWORD size) {

    surf_size=size*sizeof(BYTE);
    surf_base=malloc(surf_size);

    if(surf_base==NULL) fatal_error("No hay memoria (surface_cache)");

    // Al principio un nico bloque libre con toda la memoria

    last_block=surf_base;
    last_block->next=NULL;
    last_block->owner=NULL;
    last_block->size=surf_size;


}

CACHE_BLOCK *surface_malloc(DWORD size) {

    CACHE_BLOCK *ret;

    if(size>65536*sizeof(WORD)) {
        fatal_error("Bloque incorrecto (surface_malloc)");
    }

//    if(size==0) fatal_error("BLoque Nulo");

    size+=sizeof(CACHE_BLOCK)+40;

    if(size>surf_size) fatal_error("Bloque muy grande (surface_malloc)");

    // Si no queda espacio al final es necesario empezar por el principio
    if(last_block==NULL || surf_size-size < (BYTE *)last_block - (BYTE *)surf_base)
        last_block=surf_base;

    ret=last_block;
    if(ret->owner) *ret->owner=NULL;

    // Vamos cogiendo bloques hasta conseguir el tamao pedido

    while(ret->size<size) {

        last_block=last_block->next;        // Otro bloque ms
        if(last_block==NULL) fatal_error("surface_malloc: Fin de memoria");

        if(last_block->owner) *last_block->owner=NULL;
        ret->size+=last_block->size;
        ret->next=last_block->next;

    }

    // Buscamos algo de espacio libre al final del bloque. Si no hay, se pasa
    //  al siguiente.

    if(ret->size-size>sizeof(CACHE_BLOCK)+200) {
        last_block=(CACHE_BLOCK *)((BYTE *)ret+size);
        last_block->size=ret->size-size;
        last_block->next=ret->next;
        last_block->owner=NULL;
        ret->next=last_block;
        ret->size=size;
    }
    else last_block=ret->next;

    // Alinear el bloque a 32 bytes
    ret->data=(BYTE *)(((DWORD)((BYTE*)ret+sizeof(CACHE_BLOCK)+31))&~31);

    return ret;

}



void calc_texture(NGON *poly,VECTOR *wp, VECTOR *wm, VECTOR *wn,
               CAMERA *cam) {

    DWORD maxu,maxv;
    WORD *pal;
    DWORD color;
    DWORD i,j;
    DWORD u,v,csize;
    BYTE *map;
    VECTOR p,m,n;
    float twidth,theight;
    CACHE_BLOCK *cache;
    DWORD miplevel=0;
    float mipscale=1;

// Luces

    VECTOR luz={0,0,0};
    VECTOR hit;
    float dist;
    DWORD lwidth,lheight,mwidth;
    float det1,det2,det3,localu,localv;
    FIXED16 light_left,light_right;
    FIXED16 light_left_dx,light_right_dx;
    FIXED16 light_step,cur_light;
    DWORD uleft;
    DWORD ii,jj;
    DWORD blockh,blockv;
    DWORD size,shift;


    if(nzi*cam->xscale*poly->mipadjust<0.05) {
        miplevel=3;
        mipscale=8;
    }
    else if(nzi*cam->xscale*poly->mipadjust<0.1) {
        miplevel=2;
        mipscale=4;
    }
    else if(nzi*cam->xscale*poly->mipadjust<0.25) {
        miplevel=1;
        mipscale=2;
    }

    if(K_1) {
        miplevel=0;
        mipscale=1;
    }
    if(K_2) {
        miplevel=1;
        mipscale=2;
    }
    if(K_3) {
        miplevel=2;
        mipscale=4;
    }
    if(K_4) {
        miplevel=3;
        mipscale=8;
    }

    pal=(WORD *)(world_mesh.maps+poly->texture)->pal[miplevel];
    map=world_mesh.bitmap+(world_mesh.maps+poly->texture)->offset[miplevel];

    mwidth=(DWORD)(world_mesh.maps+poly->texture)->width/mipscale;

    // Transformar ejes de la textura a coordenadas de cmara

    transform(wp,cam->w_cam,&p);
    vr_transform(wm,cam->w_cam,&m);
    vr_transform(wn,cam->w_cam,&n);

    p.x*=cam->xscale;
    m.x*=cam->xscale;
    n.x*=cam->xscale;

    p.y*=cam->yscale;
    m.y*=cam->yscale;
    n.y*=cam->yscale;

    // N x P
    Ha=n.y*p.z-n.z*p.y;
    Va=n.z*p.x-n.x*p.z;
    Oa=n.x*p.y-n.y*p.x;

    // M x P
    Hb=p.y*m.z-p.z*m.y;
    Vb=p.z*m.x-p.x*m.z;
    Ob=p.x*m.y-p.y*m.x;

    // M x N
    Hc=m.y*n.z-m.z*n.y;
    Vc=m.z*n.x-m.x*n.z;
    Oc=m.x*n.y-m.y*n.x;

    maxu=(((DWORD)((world_mesh.maps+poly->texture))->width)>>miplevel)-1;
    maxv=((((DWORD)((world_mesh.maps+poly->texture))->height)>>miplevel)-1)*mwidth;

    twidth=poly->width/mipscale;
    theight=poly->height/mipscale;

    lwidth=((DWORD)(ceil(poly->width))+15)&0xfffffff0;
    lheight=((DWORD)(ceil(poly->height))+15)&0xfffffff0;
    iwidth=lwidth>>miplevel;

    Oa*=twidth;
    Ha*=twidth;
    Va*=twidth;

    Ob*=theight;
    Hb*=theight;
    Vb*=theight;

    a0=Oa-cam->centerx*Ha-cam->centery*Va;
    b0=Ob-cam->centerx*Hb-cam->centery*Vb;
    c0=Oc-cam->centerx*Hc-cam->centery*Vc;

    uadjust=((poly->minu>>miplevel)&0xffff);
    vadjust=((poly->minv>>miplevel)&0xffff);

    ulimit=(poly->width/mipscale)*65536.0-1.0;
    vlimit=(poly->height/mipscale)*65536.0-1.0;

    if(poly->scache[miplevel]) {
        cached_surfaces++;
        texel=(WORD *)poly->scache[miplevel]->data;
        return;
    }

    csize=(lwidth*lheight)>>(2*miplevel);

    cache=surface_malloc(csize*sizeof(WORD));
    poly->scache[miplevel]=cache;
    cache->owner=&poly->scache[miplevel];

    texel=(WORD *)cache->data;

// Luces dinmicas


    get_world_position(cam->w_cam,&luz);

    dist=poly->eq.d-luz.x*poly->eq.a-luz.y*poly->eq.b-luz.z*poly->eq.c;
    hit.x=luz.x + poly->eq.a*dist;
    hit.y=luz.y + poly->eq.b*dist;
    hit.z=luz.z + poly->eq.c*dist;

    det1=poly->m.x*poly->n.y-poly->n.x*poly->m.y;
    det2=poly->m.x*poly->n.z-poly->n.x*poly->m.z;
    det3=poly->m.y*poly->n.z-poly->n.y*poly->m.z;

    if(!zero(det1)) {
      localu=((hit.x-poly->p.x)*poly->n.y - poly->n.x*(hit.y-poly->p.y))/det1;
      localv=(poly->m.x*(hit.y-poly->p.y) - (hit.x-poly->p.x)*poly->m.y)/det1;
    }
    else if(!zero(det2)) {
      localu=((hit.x-poly->p.x)*poly->n.z - poly->n.x*(hit.z-poly->p.z))/det2;
      localv=(poly->m.x*(hit.z-poly->p.z) - (hit.x-poly->p.x)*poly->m.z)/det2;
    }
    else if(!zero(det3)) {
      localu=((hit.y-poly->p.y)*poly->n.z - poly->n.y*(hit.z-poly->p.z))/det3;
      localv=(poly->m.y*(hit.z-poly->p.z) - (hit.y-poly->p.y)*poly->m.z)/det3;
    }
//    else fatal_error("light hitting error");
    else {
        localu=localv=-100;
    }

    blockv=(lheight>>4)+1;
    blockh=(lwidth>>4)+1;

/*    memset(lightmap_b,0,blockh*blockv*sizeof(DWORD));

    for(i=0;i<blockv;i++) for(j=0;j<blockh;j++) {

        ly=(float)i*16.0/(poly->height);
        ly=(ly-localv)*32;

        lx=(float)j*16.0/(poly->width);
        lx=(lx-localu)*32;

        if(lx<0) lx=-lx;
        if(ly<0) ly=-ly;
        if (lx>ly) l=lx+ly/2; else l=lx/2+ly;

            if(l<0) l=0.0;
            if(l>31) l=31.0;

        lightmap_b[i*blockh+j]+=(DWORD)((31-l)*65536.0);
    }   */

//

    // Interpolacin del mapa de luz


    size=16>>miplevel;
    shift=4-miplevel;

    u=(poly->minu)>>(16+miplevel);

    for(i=0;i<blockh-1;i++) {

        light_left=lightmap_b[i];
        light_right=lightmap_b[i+1];

        uleft=u;

        v=((poly->minv)>>(16+miplevel))*mwidth;

        for(j=0;j<blockv-1;j++) {

            light_left=lightmap_b[j*blockh+i];
            light_right=lightmap_b[j*blockh+i+1];

            light_left_dx=(lightmap_b[(j+1)*blockh+i]-lightmap_b[j*blockh+i])>>shift;
            light_right_dx=(lightmap_b[(j+1)*blockh+i+1]-lightmap_b[j*blockh+i+1])>>shift;

            for(jj=0;jj<size;jj++) {

                u=uleft;
                light_step=(light_right-light_left)>>shift;
                cur_light=light_left;

                for(ii=0;ii<size;ii++) {

                    if(u>maxu) u=0;

                    color=*(pal+((*(map+v+u))<<1));

//                    color=cur_light>>16;
                    *(texel+(j*size+jj)*iwidth+i*size+ii)=color;

                    u++;
                    cur_light+=light_step;

                }

                v+=mwidth;
                if(v>maxv) v=0;

                light_left+=light_left_dx;
                light_right+=light_right_dx;

            }

        }
    }
}
