#include <types.h>
#include <stdio.h>
#include <stdlib.h>
#include <graphs.h>
#include <conio.h>
#include <string.h>
#include <math.h>
#include <font.h>
#include <keyb_hnd.h>

#include "..\seal\music.h"
#include "matrix.h"
#include "part.h"

extern BYTE *virtual;

static BYTE *bitmap;
static WORD *premul;
static DWORD xbitmap,ybitmap;

static PARTICLE *mass1,*mass2;
static WORD *densidad1,*densidad2;
static RGB_32 color1[MAX_DENSIDAD],color2[MAX_DENSIDAD];
static SDWORD i;
static MATRIZ camara;
static SDWORD blend1,blend2;

static float centerx1,centery1,centerz1;       // Centro de masas 1
static float centervx1,centervy1,centervz1;
static float centerx2,centery2,centerz2;       // Centro de masas 2
static float centervx2,centervy2,centervz2;

static BYTE fps_info[15];
static DWORD last_frame,temp_frame;
static float last_time,temp_time,fps,stime;

init_part(DWORD xres, DWORD yres) {

    init_matriz(camara);            // Colocar cmara inicialmente
    translation(camara,0,0,500);

    if((virtual=lib_set_mode(xres,yres,16,GLFB|GBANKS|GVIRTUAL))==NULL)
        fatal_error("Can't init graphics mode");

    // El bitmap se escala a la resolucin de pantalla actual
    xbitmap=(BSIZE*graphics_system.xresolution)/320;
    ybitmap=(BSIZE*graphics_system.yresolution)/200;

    bitmap=malloc(xbitmap*ybitmap*sizeof(BYTE));
    mass1=malloc(NO_PARTICLES*sizeof(PARTICLE));
    densidad1=malloc(graphics_system.xresolution*graphics_system.yresolution
                    *sizeof(WORD));
    memset(densidad1,0,graphics_system.xresolution*graphics_system.yresolution
                    *sizeof(WORD));

    mass2=malloc(NO_PARTICLES*sizeof(PARTICLE));
    densidad2=malloc(graphics_system.xresolution*graphics_system.yresolution
                    *sizeof(WORD));
    memset(densidad2,0,graphics_system.xresolution*graphics_system.yresolution
                    *sizeof(WORD));

    premul=malloc(64*256*sizeof(WORD));

    if(bitmap==NULL || mass1==NULL || densidad1==NULL || premul==NULL
                    || mass2==NULL || densidad2==NULL)
        fatal_error("Not enouhg memory");


    precalc_mul();
    make_bitmap(xbitmap,ybitmap,bitmap);        // Construccin del bitmap

    make_color1(color1);           // Paleta de colores de sistema 1
    make_color2(color2);           // Paleta de colores de sistema 2


    for(i=0;i<NO_PARTICLES;i++) {
        (mass1+i)->vida=0;
        (mass2+i)->vida=0;
    }

    last_time=stime=lib_get_time();
    frames_dr=0;
    last_frame=0;

    centerx1=centery1=centerz1=0.0;
    centervx1=200;
    centervy1=250;
    centervz1=14;

    centerx2=centery2=centerz2=0.0;
    centervx2=150;
    centervy2=200;
    centervz2=30;

    blend1=0;
    blend2=256;

}

#define PI 3.141592653589793238462643383279502884197169399375105820975

frame_part(void) {

    float tf=lib_get_time();

    if(icg_boss) {

        if(K_UP) translation(camara,0,0,-800);
        if(K_DOWN) translation(camara,0,0,800);
        if(K_LEFT) rotation_y(camara,-0.025);
        if(K_RIGHT) rotation_y(camara,0.025);
        if(K_Z) pre_rotation_z(camara,0.25);
        if(K_W) blend1+=5;
        if(K_S) blend1-=5;
        if(K_E) blend2+=5;
        if(K_D) blend2-=5;
    }

    if(tf-stime<0.9) {
        blend2=(SDWORD)(255*(tf-stime)/0.9);
        blend1=0;
    }
    else {
        blend2=(SDWORD)((cos(((tf-stime)*PI)/12))*128+128);
        if(blend2>255) blend2=255;
        if(blend2<0) blend2=0;
        blend1=255-blend2;
    }

    if(get_song_pos()>0x390000)
        translation(camara,0,0,-2850*(tf-temp_time));

    // Avanzar cada sistema
    calc_system(&centervx1,&centervy1,&centervz1,&centerx1,&centery1,&centerz1,
                densidad1,NO_PARTICLES,mass1,camara);
    calc_system(&centervx2,&centervy2,&centervz2,&centerx2,&centery2,&centerz2,
                densidad2,NO_PARTICLES,mass2,camara);

    temp_frame=frames_dr;
    temp_time=lib_get_time();
    if (temp_time-last_time>0.25) {
        fps=(float)(temp_frame-last_frame)/(temp_time-last_time);
        last_time=temp_time;
        last_frame=temp_frame;
    }

    // Volcar
    render(densidad1,densidad2,blend1,blend2,color1,color2);

    if(K_F && icg_boss) {
        sprintf(fps_info,"Fps: %4.3f  %d %d %d",fps,blend1,blend2,frequency);
        lib_write_string(fps_info,0,0,255*256,virtual);
    }

}

end_part(void) {

    free(mass1);
    free(densidad1);
    free(mass2);
    free(densidad2);
    free(bitmap);
    free(premul);

}

void calc_system(float *centervx, float *centervy, float *centervz,
                 float *centerx, float *centery, float *centerz,
                 WORD *densidad, DWORD npart, PARTICLE *mass,MATRIZ *camara) {

        float mx,my,mz,x,y,z,inv;
        SDWORD px,py,i;

        // Movimiento del centro del sistema de partculas

        if (*centerx>0) *centervx-=20; else *centervx+=20;
        if (*centery>0) *centervy-=20; else *centervy+=20;
        if (*centerz>0) *centervz-=20; else *centervz+=20;

        *centerx+=*centervx;
        *centery+=*centervy;
        *centerz+=*centervz;

        for(i=0;i<npart;i++) {

            if((mass+i)->vida==0) {

                (mass+i)->x=*centerx+(rand()-16384)/100;
                (mass+i)->y=*centery+(rand()-16384)/100;
                (mass+i)->z=*centerz+(rand()/2);

                (mass+i)->vx=-*centervx*(rand()%250)/250;
                (mass+i)->vy=-*centervy*(rand()%250)/250;
                (mass+i)->vz=-*centervz*(rand()%250)/250;

                (mass+i)->ax=0;
                (mass+i)->ay=0;
                (mass+i)->az=0;

                (mass+i)->masa=rand()%3;
                (mass+i)->vida=1+rand()%MAX_VIDA;
            }

            (mass+i)->x+=(mass+i)->vx;
            (mass+i)->y+=(mass+i)->vy;
            (mass+i)->z+=(mass+i)->vz;

            (mass+i)->vy+=GRAVEDAD;
            (mass+i)->vida--;

            mx=(mass+i)->x;
            my=(mass+i)->y;
            mz=(mass+i)->z;

            x=mx*(*camara)[0][0]+my*(*camara)[1][0]+mz*(*camara)[2][0]
                    +(*camara)[3][0];
            y=mx*(*camara)[0][1]+my*(*camara)[1][1]+mz*(*camara)[2][1]
                    +(*camara)[3][1];
            z=mx*(*camara)[0][2]+my*(*camara)[1][2]+mz*(*camara)[2][2]
                    +(*camara)[3][2];

            inv=1/z;

            px=graphics_system.centerx+x*graphics_system.xratio*inv;
            py=graphics_system.centery+y*graphics_system.yratio*inv;
            if(px>=0 && px < graphics_system.xresolution-xbitmap && py>=0 &&
                py<graphics_system.yresolution-ybitmap && inv >0)
                    draw_bitmap2(bitmap,px,py,densidad,xbitmap,ybitmap);

        }

}

// Convierte una paleta de 32 bits a la correspondiente al modo activo.

static void convert_pal(BYTE *pal, DWORD number) {

    DWORD i;
    DWORD red,green,blue;
    SBYTE redpos=graphics_system.redpos;
    BYTE redmask=((2<<graphics_system.redsize)-1)<<(8-graphics_system.redsize);
    SBYTE greenpos=graphics_system.greenpos;
    BYTE greenmask=((2<<graphics_system.greensize)-1)
                 <<(8-graphics_system.greensize);
    SBYTE bluepos=graphics_system.bluepos;
    BYTE bluemask=((2<<graphics_system.bluesize)-1)
                 <<(8-graphics_system.bluesize);
    DWORD *dpal=(DWORD *)pal;

    redpos-=8-graphics_system.redsize;
    greenpos-=8-graphics_system.greensize;
    bluepos-=8-graphics_system.bluesize;

    for(i=0;i<number;i++) {
        blue=(*(pal+i*4+1))&bluemask;
        green=(*(pal+i*4+2))&greenmask;
        red=(*(pal+i*4+3))&redmask;
        red=(redpos>=0)?red<<redpos:red>>-redpos;
        green=(greenpos>=0)?green<<greenpos:green>>-greenpos;
        blue=(bluepos>=0)?blue<<bluepos:blue>>-bluepos;
        *(dpal+i)=red+green+blue;
    }
}

// Dibujar el gradiente circular de cada partcula

void make_bitmap(DWORD xs, DWORD ys,BYTE *bitmap) {

    DWORD x,y;
    BYTE pix;

    for(y=0;y<ys;y++) for(x=0;x<xs;x++) {
        pix=y;      // Si se quita esto el procedimiento falla dando valores
                    //  extraos para la y. Esto ocurre al compilar con la
                    //  opcin /ol
                    // BUG de WATCOM? Estoy casi seguro
                    // v10.0a
        pix=sqrt((x-xs/2)*(x-xs/2)+(y-ys/2)*(y-ys/2));
        if(pix<xs/2) *(bitmap+y*xs+x)=(((xs/2-pix)*BSIZE/2)/(xs/2))*5;
        else *(bitmap+y*xs+x)=0;
    }
}

// Interpola entre dos colores de 32 bits

void gradient(DWORD *c, BYTE r1, BYTE g1, BYTE b1, BYTE r2, BYTE g2, BYTE b2,
              SDWORD len,RGB_32 (*color)[MAX_DENSIDAD]) {

    DWORD i;
    SDWORD r,g,b;

    for(i=0;i<len;i++) {
        r=(r2-r1)*i;
        g=(g2-g1)*i;
        b=(b2-b1)*i;
        (*color)[*c].r=r1+r/len;
        (*color)[*c].g=g1+g/len;
        (*color)[*c].b=b1+b/len;
        *c=*c+1;
    }
}

// Paleta 1

void make_color1(RGB_32 (*color)[MAX_DENSIDAD]) {

    DWORD i;

        //i  R:0  G:0  B:0
        //f  R:50 G:50 B:50

    i=0;

    gradient(&i,0,0,0      ,25,25,25   ,100,color);
    gradient(&i,25,25,25      ,100,100,150   ,100,color);
    gradient(&i,100,100,150        ,0,0,100  ,50,color);
    gradient(&i,0,0,100        ,200,50,20  ,100,color);
    gradient(&i,200,50,20  ,200,175,0    ,650,color);

    gradient(&i,200,175,0  ,240,155,0    ,100,color);
    gradient(&i,240,155,0  ,220,210,20    ,200,color);

    convert_pal((BYTE *)color,MAX_DENSIDAD);
}

// Paleta 2

void make_color2(RGB_32 (*color)[MAX_DENSIDAD]) {

    DWORD i;

        //i  R:0  G:0  B:0
        //f  R:50 G:50 B:50

    i=0;

    gradient(&i,0,0,0      ,25,25,25   ,100,color);
    gradient(&i,25,25,25      ,150,100,100   ,100,color);
    gradient(&i,150,100,100        ,0,100,0  ,50,color);
    gradient(&i,0,100,0        ,50,200,20  ,100,color);
    gradient(&i,50,200,20  ,175,200,0    ,650,color);

    gradient(&i,175,200,0  ,155,240,0    ,100,color);
    gradient(&i,155,240,0  ,210,220,20    ,200,color);

    convert_pal((BYTE *)color,MAX_DENSIDAD);


}

void draw_bitmap(BYTE *bitmap, DWORD x, DWORD y,WORD *densidad, DWORD xs,
                 DWORD ys) {

    DWORD xc,yc,di=0,start=y*graphics_system.xresolution+x;

    for(yc=0;yc<ys;yc++,start+=graphics_system.xresolution)
        for(xc=0;xc<xs;xc++,di++)
            *(densidad+start+xc)+=*(bitmap+di);

}

void get_component15(DWORD color, DWORD *r, DWORD *g, DWORD *b);
#pragma aux get_component15=    \
    "mov edi,eax"               \
    "mov esi,eax"               \
    "shr edi,5"                 \
    "and eax,31"                \
    "shr esi,10"                \
    "and edi,31"                \
    "mov [ebx],eax"             \
    "and esi,31"                \
    "mov [ecx],edi"             \
    "mov [edx],esi"             \
    modify[edi esi]             \
    parm[eax][ebx][ecx][edx];

void get_component16(DWORD color, DWORD *r, DWORD *g, DWORD *b);
#pragma aux get_component16=    \
    "mov edi,eax"               \
    "mov esi,eax"               \
    "shr edi,5"                 \
    "and eax,31"                \
    "shr esi,11"                \
    "and edi,63"                \
    "mov [ebx],eax"             \
    "and esi,31"                \
    "mov [ecx],edi"             \
    "mov [edx],esi"             \
    modify[edi esi]             \
    parm[eax][ebx][ecx][edx];


static void render(WORD *densidad1, WORD *densidad2,SDWORD fa1,SDWORD fa2,
           RGB_32 (*color1)[MAX_DENSIDAD],RGB_32 (*color2)[MAX_DENSIDAD]) {

    WORD *wvirtual=(WORD *)virtual;
    DWORD *cl1=(DWORD *)color1;
    DWORD *cl2=(DWORD *)color2;
    DWORD i;
    DWORD r1,g1,b1;
    DWORD r2,g2,b2;
    DWORD rs,gs,bs;

    if(graphics_system.bbp==15) {

        for(i=0;i<graphics_system.xresolution*graphics_system.yresolution;i++) {

            if(*(densidad1+i)==0 && *(densidad2+i)==0) continue;

            if (*(densidad1+i)>=MAX_DENSIDAD)
                get_component15(*(cl1+MAX_DENSIDAD-1),&r1,&g1,&b1);
            else get_component15(*(cl1+*(densidad1+i)),&r1,&g1,&b1);

            if (*(densidad2+i)>=MAX_DENSIDAD)
                get_component15(*(cl2+MAX_DENSIDAD-1),&r2,&g2,&b2);
            else get_component15(*(cl2+*(densidad2+i)),&r2,&g2,&b2);

//            rs=(r1*fa1+r2*fa2)>>8;
//            gs=((g1*fa1+g2*fa2)>>3)&(31<<5);
//            bs=((b1*fa1+r2*fa2)<<2)&(31<<10);

            rs=((*(premul+(r1<<8)+fa1)+*(premul+(r2<<8)+fa2))>>8);
            gs=((*(premul+(g1<<8)+fa1)+*(premul+(g2<<8)+fa2))>>3)&(31<<5);
            bs=((*(premul+(b1<<8)+fa1)+*(premul+(b2<<8)+fa2))<<2)&(31<<10);

            *(wvirtual+i)=gs+rs+bs;

            (*(densidad1+i))>>=1;
            (*(densidad2+i))>>=1;
        }
    }
    else if(graphics_system.bbp==16) {
        for(i=0;i<graphics_system.xresolution*graphics_system.yresolution;i++) {

            if(*(densidad1+i)==0 && *(densidad2+i)==0) continue;

            if (*(densidad1+i)>=MAX_DENSIDAD)
                get_component16(*(cl1+MAX_DENSIDAD-1),&r1,&g1,&b1);
            else get_component16(*(cl1+*(densidad1+i)),&r1,&g1,&b1);

            if (*(densidad2+i)>=MAX_DENSIDAD)
                get_component16(*(cl2+MAX_DENSIDAD-1),&r2,&g2,&b2);
            else get_component16(*(cl2+*(densidad2+i)),&r2,&g2,&b2);

//            rs=(r1*fa1+r2*fa2)>>8;
//            gs=((g1*fa1+g2*fa2)>>3)&(63<<5);
//            bs=((b1*fa1+r2*fa2)<<3)&(31<<11);

            rs=((*(premul+(r1<<8)+fa1)+*(premul+(r2<<8)+fa2))>>8);
            gs=((*(premul+(g1<<8)+fa1)+*(premul+(g2<<8)+fa2))>>3)&(63<<5);
            bs=((*(premul+(b1<<8)+fa1)+*(premul+(b2<<8)+fa2))<<3)&(31<<11);

            *(wvirtual+i)=rs+gs+bs;

            (*(densidad1+i))>>=1;
            (*(densidad2+i))>>=1;
        }
    }
}

void precalc_mul(void) {

    DWORD i,j;

    for(i=0;i<64;i++)
        for(j=0;j<256;j++) {
            *(premul+i*256+j)=i*j;
    }
}
