/*************************************************************************************/
/* DXSTART.H                                                                         */
/*                                                                                   */
/* This file was created by the DirectX Application Wizard. It's for easy use of all */
/* DirectX functions.                                                                */
/*                                                                                   */
/* Do not change this generated file!                                                */
/*                                                                                   */
/* (C)1997 by Franz Polzer & Peter Koen                                              */
/*************************************************************************************/

#ifndef __DEF_DX_UTIL_FRANZ_
#define __DEF_DX_UTIL_FRANZ_	100

#include <ddraw.h>
#include "dxstart.h"


HRESULT DDCopyBitmap(IDirectDrawSurface *pdds, HBITMAP hbm, int dx, int dy)
{
	HDC hdcImage;
	HDC hdc;
	HRESULT hr;
	HBITMAP hbmOld;

	hdcImage = CreateCompatibleDC(NULL);
	hbmOld=(HBITMAP)SelectObject(hdcImage, hbm);
	if ((hr=pdds->GetDC(&hdc))==DD_OK)
	{
		BitBlt(hdc,0,0,dx,dy,hdcImage,0,0,SRCCOPY);
		pdds->ReleaseDC(hdc);
	}
	SelectObject(hdcImage, hbmOld);
	DeleteDC(hdcImage);
	return hr;
}




IDirectDrawPalette * DDLoadPalette(IDirectDraw *pdd, LPCSTR szBitmap)
{
	IDirectDrawPalette* ddpal;
	int i;
	int n;
	int fh;
	PALETTEENTRY ape[256];
	
	if (szBitmap&&(fh=_lopen(szBitmap, OF_READ))!=-1)
	{
		BITMAPFILEHEADER bf;
		BITMAPINFOHEADER bi;

		_lread(fh,&bf,sizeof(bf));
		_lread(fh,&bi,sizeof(bi));
		_lread(fh,ape,sizeof(ape));
		_lclose(fh);
		if (bi.biSize!=sizeof(BITMAPINFOHEADER)) n=0;
		else if (bi.biBitCount>8) n=0;
		else if (bi.biClrUsed==0) n=1<<bi.biBitCount;
		else n=bi.biClrUsed;

		for(i=0;i<n;i++)
		{
			BYTE r=ape[i].peRed;
			ape[i].peRed=ape[i].peBlue;
			ape[i].peBlue=r;
		}
	}
	if (pdd->CreatePalette(DDPCAPS_8BIT, ape, &ddpal, NULL) !=DD_OK)
	{
		return NULL;
	}
	else
	{
		return ddpal;
	}
}


void PutPal(LPCSTR szBitmap)
{
	LPDIRECTDRAWPALETTE     lpDDPal;
	lpDDPal = DDLoadPalette(lpDD, szBitmap);
	if (lpDDPal) lpDDSView->SetPalette(lpDDPal);
}



#endif // __DEF_DX_UTIL_FRANZ_
