{ The well known mode $13 putpixel. You don't want to make a unit for the }
{ purpose of plotting single pixels, do you? ;-)                          }

unit pixel;
interface

procedure putpixel (X,Y: Integer;Color: byte);

implementation

procedure putpixel (X,Y: Integer;Color: byte);register;assembler;
asm
  shl edx,6
  add eax,edx
  mov gs:[eax+edx*4],cl
end;

begin
{ get the selector to video memory using DPMI }
{ This one shows the long way. For the shorter solution, look at the
  "segment to selector"- DPMI function. }

  asm
    push ebx  {no permission to trash ebx}
    sub eax,eax
    mov cx,1
    int 31h
    mov ebx,eax
    mov ax,8

{ limit set to 4G, that doesn't hurt either }
    stc
    sbb ecx,ecx
    sbb edx,edx
    int 31h
    jnc @@01

@@00:
{abort program on DPMI error}
    mov ax,4cffh
    int 21h

@@01:
{this one sets the access rights and type - not really needed}
    lar cx,bx
    mov cl,ch
    and cl,60h
    or cl,92h
    mov ch,0cfh
    mov ax,9
    int 31h
    jc @@00

{this one sets the base to $a0000}
    sub ecx,ecx
    mov cl,0ah
    sub edx,edx
    mov ax,7
    int 31h
    jc @@00

{store selector into GS and never touch again}
    mov gs,bx
    pop ebx
  end;
end.
