
// Programa VIRTUAL.CPP
// por FAC

// Este programa corresponde al cuarto tutorial de grficos FAC

// Ejemplo del uso de pantallas virtuales para evitar parpadeos


#include <iostream.h>           // cout
#include <conio.h>              // clrscr, getch
#include "mode13.h"
#include "mode13.cpp"


void Bloque(word xpos, byte color, word where)
{
     for (word ypos = 10; ypos <= 50; ypos++)
         HLine(xpos, xpos + 40, ypos, color, where);
}


void main()
{
     PTVirtual VirScr;
     word VirSeg, i;

     clrscr();
     cout << "\nEste programa muestra cmo se reduce el parpadeo mediante\n"
          << "el uso de una pantalla virtual.\n"
          << "\nEn el ejemplo se mueve un bloque de tres formas diferentes:\n"
          << "\n1.- Simplemente se dibuja y se borra el bloque\n"
          << "2.- Se espera al retrazado vertical antes de dibujar el bloque\n"
          << "3.- Se dibuja el bloque en una pantalla virtual y luego se\n"
          << "    copia a VGA despus de un retrazado vertical\n"
          << "\nPresiona una tecla para continuar...";
     getch();

     SetupVirtual(VirScr, VirSeg);
     SetMode13();

     for (i = 0; i <= 100; i++)
     {
          Bloque(i * 2, 15, VGA);
          delay(15);
          Bloque(i * 2, 0, VGA);
     }

     for (i = 0; i <= 100; i++)
     {
          Bloque(i * 2, 15, VGA);
          VRetrace();
          Bloque(i * 2, 0, VGA);
     }

     ClearScreen(0, VirSeg);
     for (i = 0; i <= 100; i++)
     {
          Bloque(i * 2, 15, VirSeg);
          VRetrace();
          CopyScreen(VirSeg, VGA);
          Bloque(i * 2, 0, VirSeg);
     }

     ShutDownVirtual(VirScr);
     SetTextMode();
}
