// Programa BASICO2.CPP
// por FAC

// Este programa corresponde al primer tutorial de grficos FAC
// Sugerencia:  Compilar con el modo de memoria LARGE para que todos
//              los apuntadores sean de tipo FAR

// Ejemplo del uso de PutPixel

// Reconocimientos a Denthor (Grant Smith) y Snowman (Christopher Mann)

#include <conio.h>           // getch, clrscr
#include <dos.h>             // MK_FP, geninterrupt
#include <mem.h>             // memset
#include <stdio.h>           // printf
#include <time.h>            // se necesita para randomize
#include <stdlib.h>          // random, randomize


// Constantes de uso frecuente:

unsigned char *VGA = (unsigned char *) MK_FP(0xA000, 0);


void SetMode13()   // Activa el modo grfico 13h
{
        _AX = 0x0013;
        geninterrupt(0x10);
}


void SetTextMode()   // Regresa al modo texto de 80 * 25 caracteres
{
        _AX = 0x0003;
        geninterrupt(0x10);
}


void PutPixel(int x, int y, unsigned char color)
{
        memset(VGA + y * 320 + x, color, 1);
}


void main()
{
        int x, y;

        randomize();

        clrscr();
        printf("\nEste programa llena la pantalla con pxels de diferentes colores.\n\n");
        printf("Oprime cualquier tecla para empezar...\n");
        getch();

        SetMode13();

        for(x = 0; x < 320; x++)
              for(y = 0; y < 200; y++)
                    PutPixel(x, y, random(256));

        getch();
        SetTextMode();
}
