// Programa BASICO1.CPP
// por FAC

// Este programa corresponde al primer tutorial de grficos FAC
// Sugerencia:  Compilar con el modo de memoria LARGE para que todos
//              los apuntadores sean de tipo FAR

// Ejemplo de cmo activar el modo grfico, borrar la pantalla con
// un color determinado y regresar al modo de texto.

// Reconocimientos a Denthor (Grant Smith) y Snowman (Christopher Mann)

#include <conio.h>           // getch, clrscr
#include <dos.h>             // MK_FP, geninterrupt
#include <mem.h>             // memset
#include <stdio.h>           // printf


void SetMode13()   // Activa el modo grfico 13h
{
        _AX = 0x0013;
        geninterrupt(0x10);
}


void SetTextMode()   // Regresa al modo texto de 80 * 25 caracteres
{
        _AX = 0x0003;
        geninterrupt(0x10);
}


void main()
{
        unsigned char i;
        clrscr();
        printf("\nEste programa activa el modo 13h y llena la pantalla\n");
        printf("con un color diferente cada vez que se oprime una tecla.\n");
        printf("Luego regresa al modo de texto.\n\n");
        printf("Oprime cualquier tecla para empezar...\n");
        getch();

        SetMode13();
        getch();

        for(i = 15; i >= 8; i--)
        {
                memset(MK_FP(0xA000, 0), i, 64000);
                getch();
        }

        SetTextMode();
}
