{
  Programa que muestra cmo hacer scroll en una regin de la pantalla

  Aparece una columna deslizndose hacia arriba y un letrero hacia la
  izquierda sobre un fondo fijo.

  Se necesitan los archivos: -  fondo.pcx  - (la imgen de fondo)
                             - columna.pcx - (la columna de la izquierda)
                             - letrero.pcx - (el letrero a desplazar)

  Copyright (C) 1997 -- FAC

  *** NO COPIES ESTE CODIGO --- APRENDE DE EL (y dame crdito) ***
}


program Scroll2;

uses Mode_13, Crt;

{ Tipos de datos utilizados: }
type TRow = array[0..23] of byte;
     PTEstatico = ^TEstatico;
     TEstatico = array[0..319] of TRow;
     PTMovil = ^TMovil;
     TMovil = array[80..319] of TRow;

{ TRow almacena un arreglo de 24 bytes que se usa para cada lnea vertical
  del letrero.

  TEstatico almacena la imagen completa del letrero

  TMovil almacena la imagen del letrero que aparece en la pantalla
}


var VirScr, FondoScr : PTVirtual; { Nuestras pantallas virtuales }
    VirSeg, FondoSeg : word;      { Segmentos de las pantallas virtuales }
    pal : TPalette;               { Para almacenar la paleta }
    Estatico : PTEstatico;        { Almacena el letrero esttico }
    Movil : PTMovil;              { Almacena el letrero mvil }
    Lpos : word;                  { Posicin actual del letrero }


procedure CargaImagenes;
var x, y : integer;
begin
     Estatico := new(PTEstatico); { Reservamos espacio para las matrices }
     Movil := new(PTMovil);

     LoadPCX('fondo.pcx', FondoSeg, 320, 200, 0, 0, pal);
     LoadPCX('columna.pcx', FondoSeg, 80, 200, 0, 0, pal);
     { Cargamos las imgenes de fondo }
     { fondo.pcx   -> 320 x 200 x 256 }
     { columna.pcx ->  80 x 200 x 256 }

     LoadPCX('letrero.pcx', VirSeg, 320, 24, 0, 0, pal);
     { Cargamos el letrero y lo almacenamos en la matriz Estatico }
     { letrero.pcx -> 320 x 24 x 256 }
     for y := 0 to 23 do
         for x := 0 to 319 do
             Estatico^[x][y] := GetPixel(x, y, VirSeg);

     for y := 0 to 23 do for x := 80 to 319 do Movil^[x][y] := 0;
     { Borramos la matriz Movil }

     {*** NOTA: Las tres imgenes PCX usan la MISMA paleta de colores }
end;

{ El siguiente procedimiento desplaza la columna de la izquierda
  una lnea hacia arriba }
procedure ScrollColumna;
var y : integer;
    buffer : array[0..79] of byte;
begin
     Move(mem[FondoSeg:0], buffer, 80);
     { Guardamos la parte superior en un buffer. Esto equivale a:

       for i := 0 to 79 do buffer[i] := GetPixel(i, 0, FondoSeg);   }

     for y := 0 to 198 do
         Move(mem[FondoSeg:(y+1) * 320], mem[FondoSeg:y * 320], 80);
     { Desplazamos todo el bloque una lnea hacia arriba. }

     Move(buffer, mem[FondoSeg:63680], 80);
     { Copiamos la informacin del buffer a la parte inferior del bloque }
end;


{ El siguiente procedimiento desplaza el letrero hacia la izquierda }
procedure ScrollLetrero;
var x, y : integer;
begin
     for x := 80 to 318 do Movil^[x] := Movil^[x+1];
     { Desplazamos la parte visible del letrero hacia la izquierda }

     Movil^[319] := Estatico^[Lpos];
     { Copiamos la informacin de la siguiente lnea a la parte
       derecha del letrero. }

     inc(Lpos);
     if Lpos = 320 then Lpos := 0;
     { Incrementamos la posicin del letrero y checamos que est dentro
       del rango (0 - 319) }

     CopyScreen(FondoSeg, VirSeg);
     { Copiamos el fondo a la pantalla virtual }

     for y := 0 to 23 do
         for x := 80 to 319 do
             if Movil^[x, y] <> 0 then
                PutPixel(x, y + 160, Movil^[x, y], VirSeg);
     { Y dibujamos el letrero. (Slamente los pxeles cuyo color NO es 0 ) }
end;


{ Programa principal }
begin
     clrscr;
     writeln;
     writeln('El ltimo ejemplo del Tutorial #5 muestra un fondo esttico');
     writeln('sobre el cual se desplaza una columna en la parte izquierda');
     writeln('de la pantalla hacia arriba y un letrero flotante en la parte');
     writeln('inferior se desplaza hacia la izquierda.');
     writeln;
     writeln('Oprime una tecla para continuar y otra para terminar...');

     readkey;
     clrscr;
     writeln;
     writeln('Cargando imgenes...');

     { Reservamos memoria para las dos pantallas virtuales }
     SetupVirtual(VirScr, VirSeg);
     SetupVirtual(FondoScr, FondoSeg);
     CargaImagenes; { Cargamos las imgenes necesarias }
     SetMode13;     { Activamos el modo 13h }
     for Lpos := 0 to 255 do SetPal(Lpos, 0, 0, 0);
     { ponemos todos los colores a negro }
     CopyScreen(FondoSeg, VGA); { copiamos el fondo a VGA }
     FadeTo(pal, 1); { y presentamos la imagen con un Fade In }

     Lpos := 0; { El letrero comienza en la posicin 0 (parte izquierda) }

     while not keypressed do { mientras no se oprima una tecla... }
     begin
          ScrollColumna;   { Desplazamos la columna }
          ScrollLetrero;   { Desplazamos el letrero }
          VRetrace;        { Esperamos el retrazado vertical }
          CopyScreen(VirSeg, VGA); { Y mostramos la imgen }
     end;

     { Y para terminar... }
     FadeOut(1); { Oscurecemos la imagen }
     SetTextMode;         { Regresamos al modo de texto }
     ShutDownVirtual(VirScr);   { Liberamos la memoria de las p. virtuales }
     ShutDownVirtual(FondoScr);
     dispose(Estatico);        { y tambin liberamos la memoria de  }
     dispose(Movil);           { los arreglos que contenan el letrero }
end.
