/*
   GFX.CPP written in Borland C++ 3.1                     (25th Jan 1997) 
   Coded by Karma (email: cc6pwa@isis.sunderland.ac.uk)                   
  
   This is a conversion of denthors GFX3.PAS for Borland C++ users.       
   Since I'm converting Phobos 'Turbo Pascal' tutors to C++ I had to      
   convert denthors unit too :-)                                          
   So, I take no credit to the original routines.                         
  */

// Headers
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <alloc.h>

// Defines
#define vga 0xA000
#define pi 3.1415927

// Typedefs
typedef unsigned char byte;
typedef unsigned int word;

// Global Variables
byte far *virscr=NULL;
word vaddr;
word scr_ofs[199]; // Lookup table

// Declare function prototypes
void setmcga();
void settext();
void cls(word where, byte col);
void setupvirtual();
void shutdown();
void flip(word source, word dest);
void pal(byte col, byte r, byte g, byte b);
void getpal(byte col, byte &r, byte &g, byte &b);
void waitretrace();
void hline(word x1, word x2, word y, byte col, word where);
void line(int a, int b, int c, int  d, int col, word where);
void drawpoly(int x1,int y1,int x2,int y2,int x3,int y3,int x4,int y4, byte colour, word where);
float rad(float theta);
void putpixel(word x, word y, byte col, word where);
byte getpixel(word x, word y, word where);
void loadpalette(char *filename);
void lookuptable();

//

// This puts you in 320x200x256c mode
void setmcga() {
  asm {
    mov ax, 0x0013
    int 0x10
    }
   lookuptable(); // Setup lookup table
 }

// This returns you to textmode
void settext() {
  asm {
    mov ax, 0x0003
    int 0x10
    }
 }

// This clears the screen to the specified colour
void cls(word where, byte col) {
  asm {
   push    es
   mov     cx, 32000;
   mov     es,[where]
   xor     di,di
   mov     al,[col]
   mov     ah,al
   rep     stosw
   pop     es
   }
 }

// This sets up the memory needed for the virtual screen
void setupvirtual() {
  virscr = (byte far *) farcalloc(64000, 1);
  vaddr = FP_SEG(virscr);
  if(virscr==NULL){
     settext();
     printf("Not enough memory for virtual screen!\n");
     exit(1);
    }
 }

// This frees the memory used by the virtual screen
void shutdown() {
  farfree(virscr);
 }

// This copies the entire screen at "source" to destination
void flip(word source, word dest) {
  asm {
   push    ds
   mov     ax, [dest]
   mov     es, ax
   mov     ax, [source]
   mov     ds, ax
   xor     si, si
   xor     di, di
   mov     cx, 32000
   rep     movsw
   pop     ds
   }
  }

// This sets the Red, Green and Blue values of a certain colour
void pal(byte col, byte r, byte g, byte b) {
  asm {
    mov    dx,0x03c8
    mov    al,[col]
    out    dx,al
    inc    dx
    mov    al,[r]
    out    dx,al
    mov    al,[g]
    out    dx,al
    mov    al,[b]
    out    dx,al
   }
  }

// This gets the Red, Green and Blue values of a certain colour
void getpal(byte col, byte &r, byte &g, byte &b) {
  byte rr, gg, bb;
   asm {
     mov    dx, 0x03C7
     mov    al, [col]
     out    dx, al
     add    dx, 2
     in     al, dx
     mov    [rr],al
     in     al, dx
     mov    [gg],al
     in     al, dx
     mov    [bb],al
     }
   r = rr;
   g = gg;
   b = bb;
  }

// This waits for a vertical retrace to reduce snow on the screen
void waitretrace() {
  _DX = 0x03da;
  l1: asm {
	in  al,dx
	and al,8
	jnz l1
       }
  l2: asm {
	in  al,dx
	and al,8
	jz  l2
       }
  }

// This draws a horizontal line from x1 to x2 on line y in colour col
void hline(word x1, word x2, word y, byte col, word where) {
  asm {
   mov   ax,where
   mov   es,ax
   mov   ax,y
   mov   di,ax
   shl   ax,8
   shl   di,6
   add   di,ax
   add   di,x1
   mov   al,col
   mov   ah,al
   mov   cx,x2
   sub   cx,x1
   shr   cx,1
   jnc   start
   stosb
   }
   start: asm {
    rep  stosw
   }
  }

// Check sign of integer
int sgn (int a) {
  if (a > 0) return(+1);
  if (a < 0) return(-1);
   return(0);
}

// This draws a solid line from a,b to c,d in colour col
void line(int a, int b, int c, int d, int col, word where) {
  int i,u,s,v,d1x,d1y,d2x,d2y,m,n;
  u = c-a;
  v = d-b;
  d1x = sgn(u);
  d1y = sgn(v);
  d2x = sgn(u);
  d2y = 0;
  m = abs(u);
  n = abs(v);
  if (m<=n) {
    d2x = 0;
    d2y = sgn(v);
    m = abs(v);
    n = abs(u);
    }
   s = m/2;
   for(i=0;i<m;i++) {
    putpixel(a,b,col,where);
    s += n;
    if (s >= m) {
      s -= m;
      a += d1x;
      b += d1y;
      }
     else {
      a += d2x;
      b += d2y;
      }
    }
  }

// This draw a polygon with 4 points at x1,y1 , x2,y2 , x3,y3 , x4,y4
// in colour col
void drawpoly(int x1,int y1,int x2,int y2,int x3,int y3,int x4,int y4, byte colour, word where) {
  int x,
      mny,mxy,mnx,mxx,
      yc,
      mul1,div1,
      mul2,div2,
      mul3,div3,
      mul4,div4;
     mny=y1; mxy=y1;
    if (y2<mny) mny=y2;
    if (y2>mxy) mxy=y2;
    if (y3<mny) mny=y3;
    if (y3>mxy) mxy=y3;    // Choose the min y mny and max y mxy
    if (y4<mny) mny=y4;
    if (y4>mxy) mxy=y4;
    if (mny<0) mny=0;
    if (mxy>199) mxy=199;
    if (mny>199) exit(1);
    if (mxy<0) exit(1);        // Vertical range checking
    mul1=x1-x4; div1=y1-y4;
    mul2=x2-x1; div2=y2-y1;
    mul3=x3-x2; div3=y3-y2;
    mul4=x4-x3; div4=y4-y3;  // Constants needed for intersection calc
    for(yc=mny;yc<mxy;yc++) {
      mnx=320;
      mxx=-1;
      if((y4>=yc) || (y1>=yc))
       if((y4<=yc) || (y1<=yc))    // Check that yc is between y1 and y4
	if(y4!=y1) {
	 x=((yc-y4) * mul1/div1+x4); // Point of intersection on x axis
	 if(x<mnx) mnx=x;
	  if(x>mxx) mxx=x;  // Set point as start or end of horiz line
	  }
	 if((y1>=yc) || (y2>=yc))
	  if((y1<=yc) || (y2<=yc)) // Check that yc is between y1 and y2
	   if(y1!=y2) {
	   x=((yc-y1)*mul2/div2+x1); // Point of intersection on x axis
	   if(x<mnx) mnx=x;
	    if(x>mxx) mxx=x;  // Set point as start or end of horiz line
	   }
	 if((y2>=yc) || (y3>=yc))
	  if((y2<=yc) || (y3<=yc))  // Check that yc is between y2 and y3
	   if(y2!=y3) {
	   x=((yc-y2)*mul3/div3+x2); // Point of intersection on x axis
	   if (x<mnx) mnx=x;
	    if (x>mxx) mxx=x;  // Set point as start or end of horiz line
	   }
	  if((y3>=yc) || (y4>=yc))
	   if((y3<=yc) || (y4<=yc))  // Check that yc is between y3 and y4
	    if(y3!=y4) {
	    x=((yc-y3)*mul4/div4+x3); // Point of intersection on x axis
	    if(x<mnx) mnx=x;
	     if (x>mxx) mxx=x;  // Set point as start or end of horiz line
	   }
	  if(mnx<0) mnx=0;
	   if(mxx>319) mxx=319;  // Range checking on horizontal line
	    if(mnx<=mxx)
	     hline (mnx,mxx,yc,colour,where); // Draw the horizontal line
	   }
  }

// This calculates the degrees of an angle
float rad(float theta) {
  return((theta*pi)/180);
 }

// This puts a pixel on the screen by writing directly to memory.
void putpixel(word x, word y, byte col, word where) {
  asm {
    mov  ax,where
    mov  es,ax
    mov  bx,[y]
    shl  bx,1
    mov  di,word ptr [scr_ofs + bx]
    add  di,[x]
    mov  al,[col]
    mov  es:[di],al
    }
  }

// This gets a pixels colour from the screen
byte getpixel(word x, word y, word where) {
  asm {
    mov  ax,where
    mov  es,ax
    mov  bx,[y]
    shl  bx,1
    mov  di,word ptr [scr_ofs + bx]
    add  di,[x]
    mov  al,es:[di]
    }
  return(_AL);
 }

// Load a palette
void loadpalette(char *filename) {
   FILE *fp;
   byte pall[255][3];
   int loop1;
   fp = fopen(filename,"rb");
   if (fp==NULL) {
     settext();
     printf("Error opening %s\n", filename);
     exit(1);
    }
    fread((char*) pall,768,1,fp);
    fclose(fp);
    for(loop1=0;loop1<256;loop1++)
     pal(loop1,pall[loop1][1],pall[loop1][2],pall[loop1][3]);
  }

// Lookup table to speedup put/get-pixel etc.
void lookuptable() {
  int loop1;
  for(loop1=0;loop1<199;loop1++)
    scr_ofs[loop1]=(loop1*320);
  }
