
program paleta3;
{ Hola mundo! Aqui tienen otro programa para que se traumen tratando de
  descifrarlo...

  Esto muestra lo fcil que es usar la rotacin de paleta para obtener
  la ilusion de movimiento...

  This software is copyrighted by the Federal Law of Tutorial Shit and
  The Big Ass Hip Hop Society of Sobriety...

  Por: FAC
}


uses Mode_13, Crt;


var paleta : TPalette;
{ esta variable contiene la paleta que vamos a usar }


procedure DibujaTunel;
{ Dibuja un tnel usando los colores del 1 al 160 }
{ La razn por la que se usan tantos colores para el tnel es porque
  el tnel se estar oscureciendo e iluminando constantemente, por lo
  tanto, necesitamos ms colores para guardar los gradientes de iluminacion

  La verdad es que yo solamente estaba experimentando con el efecto y
  cuando sali algo no tan malo, pues as lo dej }

var x, y : word;
    color, flag : byte;

begin
     color := 1; { color inicial }
     flag := 0;  { indicador de cambio de color }

     for x := 9 to 159 do
     begin
          y := x div 3 + 6;

          VLine(160 - x, 140 - y, 140 + y, color);
          VLine(160 + x, 140 - y, 140 + y, color);
          HLine(160 - x, 160 + x, 140 + y, color);
          { Las lneas anteriores dibujan el tnel, los procedimientos
            HLine y VLine dibujan lneas horizontales y verticales,
            respectivamente. Se encuentran en MODE_13.PAS.

            El tnel es solamente un experimento, por lo que no es
            muy bueno. A ustedes les toca disear un mejor tnel }

          inc(flag);  { incrementamos el flag }
     { La variable flag sirve para hacer que los colores del tnel cambien
       con ms frecuencia al final del tnel (o sea, en el centro de la
       pantalla) y con menor frecuencia al inicio del tnel (en las
       orillas). Esto da una pequea impresin (muy pequea) de tres
       dimensiones }

          if flag > (x div 16) then
          begin
               { Si flag es mayor que un valor que aumenta cada vez ms,
                 entonces cambiamos al siguiente color y reseteamos flag }
               inc(color);
               flag := 0;
          end;
     end;
end;


procedure DibujaBarra;
{ Este procedimiento dibuja la barra que aparece en la parte superior de
  la pantalla.

  En la barra hay algunos puntos iluminados que se mueven sobre ella.

  Idea tomada del auto increble... :)


  La barra usa los colores del 161 al 200...
  }

var i, j, pos : word;

begin
     for i := 0 to 39 do
     { Hay 40 puntos en la barra... cada punto tiene 7 pxels de ancho
       y 2 pxels de altura }
     begin
          pos := i * 8; { La posicin X del punto que vamos a dibujar }

          for j := 0 to 6 do { Con este ciclo dibujamos el punto }
          begin
               PutPixel(pos + j, 10, i + 161); { Dibuja el punto de la }
               PutPixel(pos + j, 11, i + 161); { barra superior }

               PutPixel(pos + j, 13, 200 - i); { Dibuja el punto de la }
               PutPixel(pos + j, 14, 200 - i); { barra inferior }
          end;
     end;
end;


procedure DibujaArbol;
{ Este procedimiento dibuja un rbol utilizando el famoso movimiento
  browniano... o algo as.

  El rbol usa los colores del 201 al 240...

  }

var i, j : word;
    x, y : word;

begin
     { Primero hacemos un ciclo que se repita tantas veces como ramas
       en el rbol... en este caso 20 }
     for i := 1 to 20 do
     begin
          x := 160; { Posicin X inicial de las ramas (centro de la pantalla) }
          y := 100; { Posicin Y inicial }

          { Ahora hacemos un ciclo para dibujar cada rama }
          for j := 1 to 40 do { Para cada pxel en la rama }
          begin
               PutPixel(x, y, 200 + j); { Dibujamos el pxel }

               { Y ahora calculamos la posicin del siguiente pxel }
               x := x + random(7) - 3; { Movemos X al azar }
               dec(y); { decrementamos y }

               { Despus de un rato, algunas ramas se caen }
               if j > (42 - i) then inc(y, 2); { incrementamos y en 2 }
          end;
     end;
end;



procedure HacerPaleta;
{ Este procedimiento prepara la paleta de colores que se va a usar en
  las rotaciones. Los colores estn de la siguiente forma:


  color 0            :  Color de fondo (Negro)

  colores 1 a 160    :  Colores usados en el tnel.
                        Contienen un degradado de colores azules claros y
                        oscuros de la siguiente forma:

                        Azul Oscuro
                        Azul Oscuro
                        Azul Claro
                        Azul Oscuro (menos intenso)
                        Azul Oscuro (menos intenso)
                        Azul Claro  (menos intenso)
                        ...
                        etc...

  colores 161 a 200  :  Colores usados en la barra de puntos:
                        Todos contienen un rojo muy oscuro, excepto
                        los colores 180 y 200, los cuales contienen
                        amarillo y rojo intenso, respectivamente.

  colores 201 a 240  :  Colores usados en el rbol.
                        Del 201 al 208 contienen un degradado de verde.
                        Del 209 al 240 estn todos en negro.

  colores 241 a 255  :  No se utilizan...
  }

var i, cambio : byte;

begin
     paleta[0, 0] := 0;  { Color 0 = Negro }
     paleta[0, 1] := 0;
     paleta[0, 2] := 0;


     for i := 1 to 160 do
     begin
          cambio := i mod 3;
          if cambio = 0 then cambio := 2;
          { Si cambio = 1 entonces es un color azul claro }
          { Si cambio = 2 entonces es un color azul oscuro }

          paleta[i, 0] := 0; { nada de rojo }
          paleta[i, 1] := 0; { nada de verde }
          paleta[i, 2] := 63; { y toda la intensidad del azul }

          paleta[i, cambio] := round(sin(i * 3.14159265 / 80) * 24) + 38;
          { Si cambio = 2 entonces el nico color activado es el azul
            Si cambio = 1 entonces el azul queda con la mxima intensidad
            y adems aadimos un poco de verde, lo cual resulta en un
            color azul cielo.

            Adems hacemos que la intensidad vare entre 14 y 62 para
            aparentar que el tnel se oscurece y se ilumina }
     end;


     { Para la barra... }
     for i := 161 to 200 do
     begin
          paleta[i, 0] := 8; { Ponemos un rojo muy oscuro }
          paleta[i, 1] := 0; { nada de verde }
          paleta[i, 2] := 0; { y nada de azul }
     end;

     paleta[180, 0] := 63; { El color 180 queda con amarillo }
     paleta[180, 1] := 63;

     paleta[200, 0] := 63; { y el color 200 queda con rojo intenso }

     { Para el rbol }
     for i := 201 to 240 do
     begin
          paleta[i, 0] := 0; { Todos los colores del 201 al 240  }
          paleta[i, 1] := 0; { quedan en negro }
          paleta[i, 2] := 0;
     end;

     { y hacemos un degradado de verde en los colores del 201 al 208 }
     for i := 1 to 8 do
         paleta[200 + i, 1] := i * 8 - 1;


end;

{ procedimiento para rotar la paleta hacia adelante }
procedure RotateForward(var pal : TPalette; first, last : byte);

var rl, gl, bl, i : byte;

begin
     rl := pal[last, 0];   { Almacenamos los colores del ltimo }
     bl := pal[last, 1];   { color que vamos a rotar }
     gl := pal[last, 2];

     for i := last downto (first+1) do
     begin
          pal[i, 0] := pal[i-1, 0];  { Hacemos que cada color sea }
          pal[i, 1] := pal[i-1, 1];  { igual al color anterior en }
          pal[i, 2] := pal[i-1, 2];  { la paleta }
     end;

     pal[first, 0] := rl;   { Hacemos que el primer color }
     pal[first, 1] := bl;   { sea igual al que era el ltimo }
     pal[first, 2] := gl;
end;



begin
     clrscr;
     writeln('Este programa de ejemplo muestra algunos efectos que se');
     writeln('pueden obtener mediante la rotacin de la paleta de colores.');
     writeln;
     writeln('Simplemente se dibujan algunas figuras en la pantalla y');
     writeln('entonces se hace rotar la paleta hasta que se oprime una tecla.');
     writeln('Ningn pxel ha tenido que ser redibujado para obtener las');
     writeln('animaciones...');
     writeln;
     writeln('Que esperas? Oprime lo que sea...');

     readkey;

     Randomize; { Ya que vamos a usar nmeros aleatorios, mejor reseteamos
                  la semilla }

     SetMode13; { Iniciamos el modo 13 }
     HacerPaleta; { Preparamos la paleta }
     SetPalette(paleta); { Y la activamos }
     DibujaTunel; { Dibujamos el tnel }
     DibujaBarra; { y la barra de luces }
     DibujaArbol; { y el rbol }

     { y entonces, mientras no se oprima ninguna tecla }
     while not keypressed do
     begin
          RotateForward(paleta, 1, 160);   { rotamos los colores del tnel }
          RotateForward(paleta, 161, 200); { rotamos los colores de la barra }
          RotateForward(paleta, 201, 240); { rotamos los colores del rbol }

{          VRetrace; { Esperamos al retrazo vertical }

          SetPalette(paleta); { Y activamos la paleta }
          delay(60); { hacemos una pausa }
     end;

     SetTextMode; { y terminamos cuando se oprime una tecla }
     clrscr;
end.