
; Traveller, by CrysTalHeaD(Jonas Aaberg) '97.
;
;
; This 4kb intro was mainly coded in July-August '97 before I was forced to 
; do my military service. When I joined the airdefence part of the army
; 3 kb was finished. I was planing to add a voxel landscape, but I didn't
; have the time.
; 
; See travell.txt


total	equ	1000			; movements for plasma

	.model tiny
	.code
	.386				; a Pentium is recommened
	.387
	org	100h			; com file
start:
	mov	ax,cs
	cmp	ax,0a000h-1000h-1000h-2580h-0FAh-0ECh-1000h-1000h
	jb	ok_mem
	mov	ah,9
	mov	dx,offset mem
	int	21h
	retn				; quit if not enough memory
ok_mem:

	mov	di,offset work_seg	; save mem segment
	add	ax,1000h
	stosw				; Work seg
	add	ax,1000h
	stosw				; Mandel seg
	add	ax,1000h
	stosw				; plasma_seg
	add	ax,2580h
	stosw				; Move_seg
	add	ax,0FAh	
	stosw				; Colour seg
	add	ax,0ECh			
	stosw				; PLACiDiA Seg

	mov	ah,9			; Please wait..
	mov	dx,offset please_wait	; while calculating.
	int	21h


	call	init_traveller		; Set up text

	call	make_lins_data		; calc lins data

	call	init_sbob		; calc slidebob movements

	call	init_land		; Calc data for Landscape

	mov	es,[pla_seg]
	call	make_placidia		; make placidia logo

	mov	bx,offset plasma_data	; this will save a byte every time
					; a memory address is axcessed
	mov	ax,[plasma_seg]
	mov	es,ax
	xchg	si,ax
	call	init_plasma		; Make plasma (take long time..)

	mov	ax,[mandel_seg]
	mov	fs,ax
	mov	es,ax			; Mandel seg

	xor	di,di
	call	CalcMandel		; Calc a mandelbrot fractal

	mov	ax,13h			; Sets 320x200 in 256 colours.
	int	10h			; Do it! 
					; Mode-x isn't required when you have
					; a pentium or better.
; PLACiDiA
	mov	[start_colour],0h	; text 
	mov	[red],0Ah		; 10
	mov	[green],14h		; 20
	mov	[blue],1Eh		; 30
	call	make_palette		; Set a "phong" palette

	mov	[start_colour],40h	; Lins colour
	mov	[red],20		; 0
	mov	[green],10		; 40
	mov	[blue],50		; 50
	call	make_palette


	mov	fs,[pla_seg]
	push	fs
	pop	ds

	push	0a000h
	pop	es

	xor	si,si
	mov	di,si
	mov	cx,320*200/4
	rep	movsd
	push	cs
	pop	ds

	xor	dx,dx
main_lins:
	push	dx

	mov	ax,[xv]			; bouncing lins
	add	[xp],ax

	cmp	[xp],320-120
	jbe	xp_ok

	neg	[xv]
	neg	ax

	add	[xp],ax
xp_ok:
	mov	ax,[yv]
	add	[yp],ax

	cmp	[yp],2B7h		; Magic value
	jbe	yp_ok

	neg	[yv]
	neg	ax
	add	[yp],ax
yp_ok:

	inc	[yv]

	mov	ax,[yp]
	shr	ax,3
	xchg	al,ah
	mov	di,ax
	shr	ax,2
	add	di,ax
	mov	ax,[xp]
	add	di,ax
	mov	[addr],di
; Do_lins
	mov	bp,di

	mov	si,[addr]
	and	si,not 3
	mov	[old_addr],si


	xor	ax,ax
	mov	dx,120			; Calc soap bubble/lins
	mov	bx,offset lins
	mov	di,offset lins_buff
next_line:
	mov	cx,120
next_column:
	mov	si,[bx]
	push	ax
	push	cx
	push	dx

	mov	cx,ax
	mov	al,fs:[si+bp]

	
	add	cx,di
	sub	cx,offset lins_buff

	cmp	si,cx
	je	no_add

	cmp	al,0
	je	no_add
	add	al,3fh
no_add:
	mov	[di],al
	inc	di

	pop	dx
	pop	cx
	pop	ax

	inc	bx
	inc	bx
	loop	next_column

	add	ax,320-120

	dec	dx
	jnz	next_line

	pop	dx
	or	dx,dx
	jz	not_first_loop

	push	dx
	mov	di,[old_addr]
	mov	dx,120
	call	vsync

replace_next_line:
	mov	cx,124/4		; Remove bubble
a_line:
	mov	eax,fs:[di]
	mov	es:[di],eax
	add	di,4
	loop	a_line

	add	di,320-124
	cmp	di,320*200
	ja	skip3
	dec	dx
	jnz	replace_next_line
skip3:
not_first_loop:
	mov	dx,120
	mov	di,[addr]
	mov	si,offset lins_buff


update_line:
	mov	cx,120/2
store_line:
	rep	movsw			; Draw new

	add	di,320-120
	cmp	di,320*200
	ja	skip2
	dec	dx
	jnz	update_line
skip2:
	call	vsync

	pop	dx
	inc	dx
	cmp	dx,500
	je	done_main_lins
	in	al,60h
	cmp	al,1
	jz	done_main_lins
	jmp	main_lins
done_main_lins:

; mandelbrot rotation
	mov	[start_colour],0
	mov	[red],0eh
	mov	[green],2ch
	mov	[blue],3fh

	call	make_palette		; set up a palette

	mov	es,[work_seg]
	mov	fs,[mandel_seg]

	mov	bx,offset const_data
	mov	bp,100
	mov	si,bp
	xor	dx,dx			; angle
main_loop:
	
	pusha
	call	rotate			; rotate mandel picture

	mov	cx,320*200/4

	push	es
	pop	ds
	xor	si,si
	call	put_traveller		; Put the "Traveller" text on screen


	push	es

	push	0a000h
	pop	es

	xor	di,di

	call	vsync
	rep	movsd
	pop	es
	push	cs
	pop	ds
	popa


	push	si
	mov	si,[where]

	dec	[counter]
	jnz	skip_new

	xor	ah,ah
	lodsb
	cmp	al,-1
	jz	quit_rotate		; done ?
	mov	[counter],ax
	lodsb
	movsx	ax,al
	mov	[add_scale],ax
	lodsb
	mov	[add_deg],al
	mov	[where],si
skip_new:
	add	dl,[add_deg]
	
	mov	ax,[add_scale]
	add	word ptr [bx+scale],ax

	
	
	pop	si

	jmp	main_loop
quit_rotate:
	pop	ax



; Plasma movements (The nices plasma in a 4kb I've seen.)

	push	0a000h
	pop	es			; es points to video segment

	xor	bp,bp			; counter=bp
main_plasma:
	mov	dx,3DAh			; half vsync
vsync1:
	in	al,dx
	and	al,8
	jz	vsync1

	mov	si,bp			; Source = count*3
	shl	si,1
	add	si,bp		

	mov	dx,3C8h
	mov	al,1			; start at colour 1
	out	dx,al

	inc	dx
	cld
					; set 254 colours (1 saved for traveller
	mov	cx,254*3		; text)
	mov	ds,cs:[colour_seg]
	rep	outsb

	mov	di,bp			; source = count *4
	shl	di,2

	mov	ds,cs:[move_seg]
	mov	si,ds:[di]		; Load point 1
	mov	bx,ds:[di+2]		; Load point 2

	mov	ds,cs:[plasma_seg]
	xor	di,di

	mov	ch,200			; X=200
pl1:
	mov	cl,80			; 80*4 = 320
pl2:
	lodsd
	add	eax,ds:[si+bx]	; Hahaha
	stosd
	dec	cl
	jnz	pl2

	sub	si,320			; reset 
	mov	dx,ds
	add	dx,32			; 32*16 = 512 down
	mov	ds,dx
	dec	ch
	jnz	pl1

	push	ds
	push	es
	pop	ds
	call	put_traveller
	

	pop	ds

	in	al,60h			; esc pressed ?
	cmp	al,1
	jz	quit

	inc	bp
	cmp	bp,1000
	jnz	main_plasma
	push	cs
	pop	ds

; Slide bob
	mov	ax,13h			; clean seg
	int	10h


	mov	[start_colour],255-10
	mov	[red],63
	mov	[green],12
	mov	[blue],45

	call	make_palette		; palette

	mov	dx,3c8h
	xor	al,al
	out	dx,al
	inc	dx
	out	dx,al
	out	dx,al
	out	dx,al


	mov	ax,[work_seg]	
	mov	es,ax
	xor	di,di
	xor	ax,ax
	mov	cx,320*200/2
	rep	stosw			; a xor ax,ax and a rep stosw
					; are two bytes smaller then xor eax,eax
					; rep stosd
	
;	push	0a000h
;	pop	es
	mov	cx,1000
	xor	bx,bx
main_slidebob:
	push	cx
	mov	di,[bx+offset sbobdata]


	mov	si,offset circle
	mov	dx,19
s_y:
	mov	cx,23
s_x:
	lodsb
	add	byte ptr es:[di],al
	inc	di
	loop	s_x

	add	di,320-23
	dec	dx
	jnz	s_y	


	cmp	bx,40*2
	jb	no_sub

	mov	di,[bx+offset sbobdata-40*2]

	mov	si,offset circle
	cld
	mov	dx,19
_y_s:
	mov	cx,23
_x_s:
	lodsb
	sub	byte ptr es:[di],al
	inc	di
	loop	_x_s
	add	di,320-23
	dec	dx
	jnz	_y_s

no_sub:
	push	es
	push	ds
	push	es
	pop	ds

	call	put_traveller
	push	0a000h
	pop	es

	xor	si,si
	xor	di,di
	mov	cx,320*200/4
	call	vsync
	rep	movsd
	pop	ds
	pop	es
	inc	bx
	inc	bx
	pop	cx
	loop	main_slidebob

	call	init_tunnel		; Calculates data for the tunnel.
					; (There was no room in memory before.
					; Now plasma data memory is used.)
				


	mov	[start_colour],0	; Start at colour number zero 

	mov	[red],10h
	mov	[green],3fh
	mov	[blue],0Ch

	call	make_palette		; Set palette


	mov	gs,[work_seg]

	xor	bx,bx
tunnel_me:
	add	bx,202h
	mov	[step],bx
	push	bx
	
	xor	di,di			; Saves some bytes
again:
	mov	es,[plasma_seg]		; Get deep x seg
	mov	bl,es:[di]
	mov	bh,fs:[di]

	add	bx,[step]
	mov	es,[mandel_seg]
	mov	al,es:[bx]

	mov	gs:[di],al		; set pix in work_seg
	inc	di
	cmp	di,320*200
	jnz	again


	push	ds			; save ds

	push	gs
	pop	ds			; ds=work seg
	xor	si,si
	call	put_traveller

	push	0A000h
	pop	es			; es= screen
	xor	di,di

	mov	cx,320*200/4
	call	vsync

	rep	movsd			; "Zopy me-I want to travell"
	pop	ds			; restore ds

	pop	bx

	cmp	bx,0FF00h
	jb	not_add
	inc	[tunnel_loops]
	cmp	[tunnel_loops],9
	jz	quit_tunnel

not_add:
	jmp	tunnel_me
quit_tunnel:


; Landscape (or a floor)
land_scape:

	push	cs
	pop	ds
	mov	[start_colour],0
	mov	[red],56
	mov	[green],23
	mov	[blue],23
	call	make_palette


	push	0a000h
	pop	es
	xor	ax,ax
	xor	di,di
	mov	cx,320*100/2
	rep	stosw

	mov	fs,[mandel_seg]

	mov	di,offset land_move
main_land:
	mov	cx,[di]
	jcxz	quit_land

inner_land:
	mov	ax,[di+2]		; angle
	add	[landangle],ax
	and	[landangle],1023

	mov	ax,[di+4]		; xpos
	add	[Xpos],ax

	mov	ax,[di+6]		; ypos
	add	[Ypos],ax

	push	di
	push	cx
	call	display_land

	push	es
	pop	ds


	push	0a000h
	pop	es
	mov	di,320 * 200 / 2
	xor	si,si
	mov	cx,320 * (200/2) / 4

	call	vsync
	rep	movsd                       ; Spew buffer to screen on vsync
	push	es
	pop	ds
	call	put_traveller

	push	cs
;	push	cs
;	pop	es
	pop	ds

	pop	cx
	pop	di

	in	al,60h
	cmp	al,1
	jz	quit

	loop	inner_land

	add	di,8
	jmp	main_land
quit_land:

; A peace sign(a total nuclear disarmed sign)
; I did this on my first cristmas hollyday away from the army.
; (I've got more than five month left in the army. And I am fed up with it!)

	push	cs
	pop	ds
	mov	es,[work_seg]

	xor	di,di
	xor	ax,ax
	mov	cx,320*200/2
	rep	stosw


	mov	dx,3c8h
	xor	al,al
	out	dx,al
	inc	dx
	mov	cx,20*3
	xor	al,al
set_black:
	out	dx,al
	loop	set_black

	mov	[red],55
	mov	[green],55
	mov	[blue],55
	mov	[start_colour],20
	call	make_palette


	mov	[r],95			; radius
	mov	[colour],64;+20
	call	dcircle


	mov	[r],75
	mov	[colour],0
	call	dcircle

	mov	di,320*20+160-10
	mov	dx,160
	mov	al,64;+20

main_line:
	mov	cx,20
	rep	stosb
	add	di,320-20
	dec	dx
	jnz	main_line


	mov	di,320*105+146
	mov	dx,58
left:
	mov	cx,25
	rep	stosb
	add	di,320-24
	dec	dx
	jnz	left



	mov	di,320*105+149
	mov	dx,58
right:
	mov	cx,25
	rep	stosb
	add	di,320-26
	dec	dx
	jnz	right



	mov	di,320*105+146
	xor	al,al
	stosb
	stosb
	stosb
	add	di,22
	stosb
	stosb
	stosb
	add	di,320-5-22
	stosb
	add	di,24
	stosb



	mov	cx,8
soft_peace:				; Soft
	xor	di,di
inner_peace:
	mov	al,es:[di-1]		; Get X-1
	add	al,es:[di+1]		; Get X+1
	add	al,es:[di-320]		; Get Y-1
	add	al,es:[di+320]		; Get Y+1
	shr	al,2			; /4
	mov	es:[di],al		; Set softed pixel
	inc	di
	jnz	inner_peace

	loop	soft_peace

	xor	di,di
make_dust:
	call	get_rnd
	and	al,7
	add	es:[di],al		; pixel * 4 +rnd#(and)7
	inc	di
	cmp	di,320*200		
	jne	make_dust

	push	es
	pop	ds
	push	0a000h
	pop	es
	xor	si,si
	xor	di,di
	mov	cx,320*200/2
	rep	movsw

	mov	cx,70*3
show_peace:
	call	vsync
	in	al,60h
	cmp	al,1
	je	quit
	loop	show_peace



quit:
	push	cs
	pop	ds
	mov	ax,3
	int	10h
	mov	ah,9
	mov	dx,offset msg
	int	21h
	int	20h
;	retn				; The stack pointer must be 0FFFEh
					; and sometimes it isn't so a int 20h
					; will save me 2 bytes..
					; (No MOV SP,0FFFEh  ;-)

vsync	proc
	mov	dx,3dah
v1:
	in	al,dx
	and	al,8
	jnz	v1
v2:
	in	al,dx
	and	al,8
	jz	v2
	in	al,60h
	cmp	al,1
	jz	quit
	
	retn
vsync	endp
	db	"I hate the army",0

; Draws a filled circle (No X,Y outside screen check)
dcircle	proc
	mov	[c_value],0
	finit
	mov	cx,[r]
	shl	cx,2
	mov	[divs],cx
	inc	cx
	

	fldpi
	fild	[divs]
	fdivp	st(1),st
	fstp	[addvalue]
round:
	fld	[c_value]
	fsincos
	fild	[r]
	fmul	st(2),st
	fmulp	st(1),st
	frndint
	fistp	[c_x]
	frndint
	fistp	[c_y]

	mov	ax,100
	add	ax,[c_y]
	mov	bx,320
	mul	bx
	shr	bx,1
	add	bx,[c_x]
	add	ax,bx
	xchg	si,ax
	mov	al,[colour]
	mov	es:[si],al

	mov	ax,100
	sub	ax,[c_y]
	mov	bx,320
	mul	bx
	shr	bx,1
	add	bx,[c_x]
	add	ax,bx
	xchg	di,ax
	cmp	di,si
	jz	no_fill
	mov	al,[colour]
fill:
	stosb
	add	di,319
	cmp	di,si
	jnz	fill
no_fill:	

	fld	[c_value]
	fadd	[addvalue]
	fstp	[c_value]

	dec	cx
	jnz	round
	retn
dcircle	endp



; Rotate and displays a floor.
display_land	proc

	mov	ax,[Xpos]				; int xpos
	mov	[dmXPos],al

	mov	ax,[Ypos]				; int ypos
	mov	[dmYPos],al

	mov	di,320/2              ; es:di = buffer pointer

	mov	[dmLineCounter],200/2
	mov	[dmDistPtr],offset Distance

dm01:
	finit

	mov	bx,[dmDistPtr]
	add	[dmDistPtr],2

	mov	ax,[bx]

	mov	[tmp1],ax
	fldpi
	fild	word ptr [landconst1]
	fdivp	st(1),st
	fild	word ptr [landangle]
	fmulp	st(1),st
	fcos
	fild	word ptr [tmp1]
	fmulp	st(1),st
	fsub	[dist_const2]
	frndint
	fist	dword ptr [tmp1]
	mov	cx,[tmp1]

	mov	[tmp1],ax
	fldpi
	fild	word ptr [landconst1]
	fdivp	st(1),st
	fild	word ptr [landangle]
	fmulp	st(1),st
	fsin
	fild	word ptr [tmp1]
	fmulp	st(1),st
	fsub	[dist_const2]
	frndint
	fist	dword ptr [tmp1]

	mov	dx,[tmp1]

	mov	si,dx
	mov	bp,cx
	neg	bp

	shl	cx,8
	shl	dx,8

	add	ch,[dmXPos]
	add	dh,[dmYPos]             ; Displace starting point by (XPos,YPos)

	push	cx
	push	dx
	cld

	mov	es,[work_seg]

	mov	ax,(320/2)
unroll112:
	push	ax

	mov	bl,ch
	mov	bh,dh

	mov	al,byte ptr fs:[bx]

	stosb

	add	cx,si
	add	dx,bp             ; Displace position (dx,cx) by (bp,si)

	pop	ax
	dec	ax
	jnz	unroll112


	sub	 di,161
	pop	 dx
	pop	 cx
	std

	mov	ax,320/2
unroll2:
	push	ax

	sub	cx,si
	sub	dx,bp
	mov	bl,ch
	mov	bh,dh

	mov	al,fs:[bx]

	stosb


	pop	ax
	dec	ax
	jnz	unroll2


	add 	di,161+320

	dec	[dmLineCounter]
	jz	dm02
	jmp	dm01                        ; Move on to next line
dm02:

	cld


	retn
	
display_land	endp


; Make distance table
init_land	proc
	mov	di,offset distance
	mov	ax,32767
	stosw
	mov	ax,28000
	stosw
	mov	cx,2
make_dist:
	finit
	fild	dword ptr [dist_const1]		; 51200
	fld	dword ptr [dist_const2]		; 0.5
	mov	[dist_temp],cx
	fild	word ptr [dist_temp]
	faddp	st(1),st
	fdivp	st(1),st
	frndint
	fist	word ptr [dist_temp]
	mov	ax,[dist_temp]
	stosw
	inc	cx
	cmp	cx,200
	jb	make_dist
	retn
init_land	endp


;es:0 empty seg
; Make PLACiDiA logo
make_placidia	proc

	xor	di,di
	xor	al,al
	mov	cx,0ffffh
	rep	stosb
	mov	si,offset placidia

	mov	ax,[font_seg]
	mov	fs,ax			; fs=font seg

	mov	ax,[text_Y]
	shl	ax,6			; * 64
	mov	di,ax
	shl	ax,2			; * 256
	add	di,ax
	add	di,[text_X]		; di = where to put text

main_text_put:
	xor	bh,bh
	mov	bl,[si]			; Get letter
	shl	bx,4			; *16
	add	bx,[font_ofs]		; Go to letter in font

	mov	cl,16
make_y:
	mov	dh,4			; four times
make_4Y:
	mov	ax,[text_X]
	mov	[temp_X],ax		; Where to put in X
	mov	al,fs:[bx]		; Get part of bit packed font
	mov	ah,80h			; bit to check
test_next:
	mov	dl,4			; make it 4 as large as it should be
four_times:

	test	al,ah
	jz	not_put
	mov	byte ptr es:[di],3Fh	; Set colour
not_put:
	inc	[temp_X]
	inc	di			; Next pixel
	dec	dl			; Make x*4
	jnz	four_times

	shr	ah,1
	jnz	test_next

	add	di,320-32
	dec	dh
	jnz	make_4Y
	inc	bx

	dec	cl
	jnz	make_y

	sub	di,320*63+(320-32)
	add	[text_X],20h		; to next

	inc	si			; Go to next letter

	cmp	byte ptr [si],0		; End marker ?
	jne	main_text_put



	mov	cx,8
soften_more:				; Soften the text
	xor	di,di
inner_soft:
	mov	al,es:[di-1]		; Get X-1
	add	al,es:[di+1]		; Get X+1
	add	al,es:[di-320]		; Get Y-1
	add	al,es:[di+320]		; Get Y+1
	shr	al,2			; /4
	mov	es:[di],al		; Set softed pixel
	inc	di
	jnz	inner_soft

	dec	cx			; Eight times
	jnz	soften_more

	xor	di,di
make_background:
	call	get_rnd
	and	al,7
	add	es:[di],al		; pixel * 4 +rnd#(and)7
	inc	di
	cmp	di,320*200		
	jne	make_background
	retn
make_placidia	endp


; A decent random generator. (Small, but no good)
get_rnd		proc	near
	mov	eax,41FBF0E7h
	mul	[rnd_seed]
	add	eax,17B99h
	mov	[rnd_seed],eax
	shr	eax,0Fh
	and	ax,1FFFh
	sub	ax,1000h
	retn
get_rnd		endp



; Calculate lins data
; Somebody now how to do an arcsin or an arccos with the fpu?
; Please mail me!
make_lins_data	proc
	finit

	mov	di,-60			; y=di
linsouter:
	mov	si,-60			; x=si
linsinner:
	finit
	mov	[linsy],di
	mov	[ny],di
	mov	[linsx],si
	mov	[nx],si
	fld	[linsconst1]
	fild	[linsx]
	fdiv	st(0),st(1)		; x/60
	fmul	st(0),st(0)
	fild	[linsy]
	fdiv	st(0),st(2)
	fmul	st(0),st(0)
	faddp	st(1),st(0)

	fcom	[one]

	fstsw	ax
	sahf
	ja	above_1

	fcom	[zeroval]
	fstsw	ax
	sahf
	jnz	continue
zero:
	mov	[nx],0
	mov	[ny],0
	jmp	linsdone
above_1:
	mov	[ny],di
	mov	[nx],si
	jmp	linsdone
continue:
	fst	st(1)
	fsqrt
	fld	[one]
	fpatan
	fmul	[two]
	fptan
	fsin
	fdivp	st(1),st(0)		
	fst	st(1)
	fabs
	fcom	[ten]
	fstsw	ax
	sahf
	jbe	not_above_10

	mov	[linsy],di
	mov	[linsx],si
	jmp	linsdone
not_above_10:
	fst	st(1)
	fild	[linsx]
	fmulp	st(1),st(0)
	fld	[five]
	fdivp	st(1),st(0)
	frndint

	fistp	[nx]

	fild	[linsy]
	fmulp	st(1),st(0)
	fld	[five]
	fdivp	st(1),st(0)

	frndint
	fistp	[ny]
linsdone:
	xor	dx,dx
	mov	ax,[ny]
	add	ax,60
	mov	cx,320
	mul	cx
	add	ax,[nx]
	add	ax,60
	mov	bx,[linswhere]
	mov	[bx],ax
	add	[linswhere],2

	inc	si
	cmp	si,60
	jl	linsinner

	inc	di
	cmp	di,60
	jl	linsouter
	retn
make_lins_data	endp


; Make data for the tunnel (a seg for X and one for Y)
init_tunnel	proc
	mov	ax,[plasma_seg]
	mov	es,ax
	add	ax,1000h
	mov	fs,ax

	xor	di,di
	mov	dx,200
tmain_y:
	mov	cx,320/2		; Do 2 pixel a run.
tmain_x:
	mov	ax,cx
	mov	[temp1],ax	
	mov	ax,200/2		; x width /2
	sub	ax,dx
	mov	[temp2],ax		
	finit
	fild	[temp2]
	fidiv	[temp1]
	fld1
	fpatan
	fimul	[tconst]
	fldpi
	fdivp	st(1),st
	fist	[tresult]
	mov	ax,[tresult]
	stosb

	mov	si,320*200
	sub	si,di
	add	al,128			; To 2nd half of palette
	mov	es:[si],al		; Do the other side

	loop	tmain_x

	add	di,320/2
	dec	dx
	jnz	tmain_y

	push	fs
	pop	es
	xor	di,di
	mov	bp,200
main_y_deep2:
	mov	cx,320
main_x_deep2:
	mov	ax,cx
	sub	ax,320/2		; Center X
	mul	ax			; 
	mov	bx,ax
	mov	ax,bp
	sub	ax,200/2		; Center Y
	mul	ax			;
	add	ax,bx
	mov	[tresult],ax		; Save Y*320+X

	finit
	fild	[tresult]
	fsqrt
	fist	[temp1]
	mov	al,byte ptr [temp1]	;temp2
	not	al
	stosb
	loop	main_x_deep2
	dec	bp
	jnz	main_y_deep2

	retn
init_tunnel	endp



; Make movements for the slidebob
init_sbob	proc
	mov	di,offset sbobdata
	mov	cx,1000

make_movements:
; 149+149*cos(a*pi/180)+(90+90*sin(b*pi/180))*320
; a=a+1.7
; b=b+3

	finit
	fldpi
	fild	word ptr [sconst3]	;180
	fdivp	st(1),st
	fld	dword ptr [a]
	fmulp	st(1),st
	fcos
	fild	word ptr [sconst1]	;149
	fmul	st(1),st
	faddp	st(1),st
	fsub	[sconst5]
	frndint

	fldpi
	fild	word ptr [sconst3]	;180
	fdivp	st(1),st
	fld	dword ptr [b]
	fmulp	st(1),st
	fsin
	fild	word ptr [sconst2]	;90
	fmul	st(1),st
	faddp	st(1),st
	fsub	[sconst5]
	frndint
	fild	word ptr [sconst4]	;320
	fmulp	st(1),st
	faddp	st(1),st
	fistp	dword ptr [result]
	mov	ax,word ptr [result]

	stosw

	fld	dword ptr [a]
	fld	dword ptr [aadd]
	faddp	st(1),st
	fstp	dword ptr [a]

	fld	dword ptr [b]
	fld	dword ptr [badd]
	faddp	st(1),st
	fstp	dword ptr [b]

	loop	make_movements	

	retn
init_sbob	endp


; Calculates plasma data
; ES must be set to plasma face seg
; and BX must point to plasma_data
; This routine is nice! 

init_plasma	proc

	xor	di,di

;value=64+10*( sin(x/p1) + cos(y/p2) + cos(x/p3) + sin(y/p4) + sin((x+y)/p5) +
;cos(hypot(256-x,150-y)/p6));
	xor	dx,dx
outer_map:
	mov	[bx+_y],dx
	xor	cx,cx
inner_map:
	finit

	mov	[bx+_x],cx
	fild	word ptr [bx+_x]
	fild	word ptr [bx+_p1]
	fdivp	st(1),st
	fsin				; sin(x/p1)

	fild	word ptr [bx+_y]
	fild	word ptr [bx+_p2]
	fdivp	st(1),st
	fcos				; cos(y/p2)
	fadd	st(1),st		; sin(x/p1)+cos(y/p2)
	fstp	st


	fild	word ptr [bx+_x]
	fild	word ptr [bx+_p3]
	fdivp	st(1),st
	fcos				; cos(x/p3)
	fadd	st(1),st		
	fstp	st

	fild	word ptr [bx+_y]
	fild	word ptr [bx+_p4]
	fdivp	st(1),st
	fsin				; sin(y/p4)
	fadd	st(1),st		
	fstp	st
	
	fild	word ptr [bx+_y]
	fild	word ptr [bx+_x]
	faddp	st(1),st
	fild	word ptr [bx+_p5]
	fdivp	st(1),st
	fsin				; sin((x+y)/p5)
	fadd	st(1),st		
	fstp	st

	fild	word ptr [bx+_pl_const1]	; 256
	fild	word ptr [bx+_x]	; x
	fsubp	st(1),st		; 256-x
	fmul	st,st			; (256-x)
	fild	word ptr [bx+_pl_const2]	; 150
	fild	word ptr [bx+_y]	; y
	fsubp	st(1),st		; 150-y
	fmul	st,st			; (150-y)
	faddp	st(1),st		; (256-x)+(150-y)
	fsqrt				; ((256-x)+(150-y))
	fild	word ptr [bx+_p6]	; p6
	fdivp	st(1),st		; ((256-x)+(150-y))/p6
	fcos				; cos(((256-x)+(150-y))/p6));
	fadd	st(1),st		; add it all together
	fstp	st
	fild	word ptr [bx+_pl_const3]	; 10
	fmulp	st(1),st		; *10
	frndint				; to int
	fist	word ptr [bx+_value]	
	mov	ax,[bx+_value]
	add	al,64			; +64
	
	stosb				; save a char

	rcl	di,0ch			; if 10 bytes has passed increase
	adc	si,0			; the segment with one
	mov	es,si
	shr	di,0ch

	inc	cx
	cmp	cx,512
	jb	inner_map

	inc	dx
	cmp	dx,300
	jb	outer_map


	mov	es,[move_seg]
	xor	di,di

;lead = 96+90*cos(count/m1) + 512*(int)(48+47*sin(count/m2));
;	finit
	xor	cx,cx
plasma_movements:
	finit

	mov	[bx+_count],cx		; save it for math-processor

	fild	word ptr [bx+_count]
	fild	word ptr [bx+_m1]	; count/m1
	fdivp	st(1),st
	fcos				; cos(count/m1)
	fild	word ptr [bx+_pl_const4]	; get 90
	fmulp	st(1),st		; 90*cos(count/m1)

	fild	word ptr [bx+_count]	
	fild	word ptr [bx+_m2]
	fdivp	st(1),st		; count/m2
	fsin				; sin(count/m2)
	fild	word ptr [bx+_pl_const5]	; get 47
	fmulp	st(1),st		; 47*sin(count/m2)
	fild	word ptr [bx+_pl_const6]	; get 48
	faddp	st(1),st		; 48+47*sin(count/m2)
	fld	dword ptr [bx+_pl_const11]	; get 0.5 to make a "C" down roundment
	fsubp	st(1),st		; -0.5
	frndint				; to integer

	fild	word ptr [bx+_pl_const7]	; get 512
	fmulp	st(1),st		; 512*(48+47*sin(count/m2))
	faddp	st(1),st		; add it 
	fild	word ptr [bx+_pl_const8]	; get 96
	faddp	st(1),st		; add 96
	fld	dword ptr [bx+_pl_const11]	; round downwards
	fsubp	st(1),st
	frndint
	fist	dword ptr [bx+_value2]
	mov	ax,[bx+_value2]
	stosw


; offset = 96+92*sin(count/m3)+512*(int)(48+47*cos(count/m4))-lead;


	fild	word ptr [bx+_count]	;
	fild	word ptr [bx+_m3]
	fdivp	st(1),st		; count/m3
	fsin				; sin(count/m3)
	fild	word ptr [bx+_pl_const9]	; get 92
	fmulp	st(1),st		; 92*count/m3

	fild	word ptr [bx+_count]
	fild	word ptr [bx+_m4]
	fdivp	st(1),st		; count/m4
	fcos				; cos(count/m4)
	fild	word ptr [bx+_pl_const5]	; get 47
	fmulp	st(1),st		; 47*cos(count/m4)
	fild	word ptr [bx+_pl_const6]	; 48
	faddp	st(1),st		; 48+47*cos(count/m4)
	fld	dword ptr [bx+_pl_const11]	; round downwards
	fsubp	st(1),st		; -0.5
	frndint


	fild	word ptr [bx+_pl_const7]	; get 512
	fmulp	st(1),st		; 512*(48+47*cos(count/m4))
	faddp	st(1),st		; add it!
	fild	word ptr [bx+_pl_const8]	; get 96
	faddp	st(1),st		; 96+512*(48+47*cos(count/m4))
	fsub	st,st(1)		; 
	fld	dword ptr [bx+_pl_const11]	; round downwards
	fsubp	st(1),st
	frndint
	fist	dword ptr [bx+_value2]	
	mov	ax,[bx+_value2]
	stosw

	inc	cx
	cmp	cx,total
	jb	plasma_movements


	mov	es,[colour_seg]
	xor	di,di
	xor	cx,cx
colourmap:
	finit

	mov	[bx+_count],cx		; make it available to the math
					;-processor
	fild	word ptr [bx+_count]
	fild	word ptr [bx+_c11]	;
	fdivp	st(1),st		; count/c11
	fsin				; sin(count/c11)

	fild	word ptr [bx+_count]
	fild	word ptr [bx+_c1]
	fdivp	st(1),st		; count/c1
	fsin				; sin(count/c1)
	fmulp	st(1),st		; sin(count/c1)* sin(count/c11)
	fild	word ptr [bx+_pl_const10]	; get 31
	fmul	st(1),st		; 31*sin(count/c1)* sin(count/c11)
	faddp	st(1),st		; 31*sin(count/c1)* sin(count/c11)+31
	frndint
	fist	word ptr [bx+_value]
	mov	ax,[bx+_value]
	stosb
 
	fild	word ptr [bx+_count]
	fild	word ptr [bx+_c21]
	fdivp	st(1),st		; count/c21
	fsin				; sin(count/c21)

	fild	word ptr [bx+_count]
	fild	word ptr [bx+_c2]
	fdivp	st(1),st		; count/c2
	fsin				; sin(count/c21)
	fmulp	st(1),st		; sin(count/c21)*sin(count/c21)
	fild	word ptr [bx+_pl_const10]	; get 31
	fmul	st(1),st		; 31*sin(count/c21)*sin(count/c21)
	faddp	st(1),st		; 31*sin(count/c21)*sin(count/c21)+31
	frndint
	fist	word ptr [bx+_value]
	mov	ax,[bx+_value]
	stosb
	

	fild	word ptr [bx+_count]
	fild	word ptr [bx+_c31]
	fdivp	st(1),st		; count/c31
	fsin				; sin(count/c31)

	fild	word ptr [bx+_count]
	fild	word ptr [bx+_c3]
	fdivp	st(1),st		; count/c3
	fsin				; sin(count/c3)
	fmulp	st(1),st		; sin(count/c3)*sin(count/c31)
	fild	word ptr [bx+_pl_const10]	; get 31
	fmul	st(1),st		; 31*sin(count/c3)*sin(count/c31)
	faddp	st(1),st		; 31*sin(count/c3)*sin(count/c31)+31
	frndint
	fist	word ptr [bx+_value]
	mov	ax,[bx+_value]
	stosb

	inc	cx

	cmp	cx,1256			;(total/256+1)*256
	jb	colourmap

	retn
init_plasma	endp

; ds seg to put text (Traveller)
put_traveller	proc
	push	ds
	push	es
	pusha


	mov	dx,3c8h
	mov	al,255
	out	dx,al
	inc	dx
	mov	al,34
	out	dx,al
	mov	al,0
	out	dx,al
	mov	al,56
	out	dx,al

	dec	dx
	xor	al,al
	out	dx,al
	inc	dx
	out	dx,al
	out	dx,al
	out	dx,al

	push	ds
	pop	es
	push	cs
	pop	ds
	mov	di,320*180+2
	mov	si,offset traveller_pic

	mov	dx,16
o:
	mov	cx,11*8
inner_o:
	lodsb
	cmp	al,1
	je	skip
	cmp	al,15
	jne	store
	mov	al,255
store:
	stosb
	dec	di
skip:
	inc	di
	loop	inner_o

	add	di,320-11*8
	dec	dx
	jnz	o

	popa
	pop	es
	pop	ds

	retn
put_traveller	endp

; Make traveller pic
init_traveller	proc
	cld
	
	mov	ax,1130h		; Get address to 8x8 Font
	mov	bh,6
	int	10h

	mov	[font_seg],es
	mov	[font_ofs],bp

	push	es
	pop	fs			; fs:bp = font

	push	cs
	push	cs
	pop	ds			; I care
	pop	es

	mov	di,offset traveller_pic
	mov	si,offset traveller
main_text:
	lodsb
	or	al,al
	jz	done
	xor	ah,ah
	shl	ax,4
	xchg	ax,bx
	add	bx,bp

	mov	cx,16
a16:
	mov	dh,fs:[bx]
	mov	ah,10000000b
make_inner:
	mov	al,1			; 1 is no colour at all
	test	dh,ah
	jz	black
	mov	al,15;255			; is font colour
black:
	stosb
	shr	ah,1
	jnz	make_inner
	add	di,8*11-8
	inc	bx
	loop	a16
	sub	di,11*8*16-8
	jmp	main_text
done:



	mov	si,offset traveller_pic
	mov	dx,16
o1:

	mov	cx,11*8
inner:
	lodsb
	cmp	cx,11*8
	jz	not_s
	cmp	dx,16
	jz	not_s

	cmp	al,1
	jnz	not_s

	mov	al,[si-11*8-2]			; 322
	add	al,[si-11*8-1]			; 321
	cmp	al,15
	jb	not_s


	mov	al,0
	mov	[si-1],al
not_s:
	loop	inner


	dec	dx
	jnz	o1


	retn
init_traveller	endp




; Picture rotation.
; My first athempt to use the math processor.

; Entry:
; ax = ?
; bx = offset const_data
; cx = ?
; dx = angle 0-255
; di = ?
; si = y
; bp = x

; fs:0 = seg with 256x256 picture
; es:0 = work seg
; ds = const_data seg

; Returns:

; ax = Same as entried
; bx = offset const_data
; cx = 0 
; dx = 0

; di = 320*200
; si = last Y pos
; bp = last X pos
; 
; fs:0 = seg with 256x256 picture
; es:0 = seg with rotated picture
; ds = const_data seg

rotate:

	finit					; Clear the math processor
	mov	word ptr [bx+angle],dx		; Makes the 0-255 angle
						; axcessable to the mathpro

	fild	word ptr [bx+angle]		; angle to math processor
	fldpi					; get pi
	fmul	st,st(1)			; pi*angle
	fild	word ptr [bx+const1]		; Load 128
	fdivp	st(1),st			; pi*angle/128 (it should be:
						; 2pi*angle/256)
	fst	st(2)				; save the radius angle for
						; future use
	fsincos					; get the sin and cos of the
						; angle
	fild	word ptr [bx+scale]		; rx=cos()*scale
	fmul	st,st(1)
	frndint	
	fistp	word ptr [_rx+bx]

	fild	word ptr [bx+scale]		; ry=sin()*scale
	fmul	st,st(2)
	frndint
	fistp	word ptr [_ry+bx]

	fldpi					; get pi again
	fild	word ptr [bx+div2]		; get 2
	fdivp	st(1),st			; pi/2
	fadd	st,st(4)			; (pi/2+)
	; changing the line above to fadd st,st(2) makes a nice movement too..
	fsincos					; make cos and sin

	fild	word ptr [bx+scale]
	fmul	st,st(1)
	frndint
	fistp	word ptr [_dx+bx]		; 

	fild	word ptr [bx+scale]
	fmul	st,st(2)
	frndint
	fistp	word ptr [_dy+bx]

	mov	cx,[bx+_rx]
	add	cx,[bx+_dx]
	shl	cx,7
	sub	bp,cx

	; bp=i

	mov	cx,[bx+_ry]
	add	cx,[bx+_dy]
	shl	cx,7
	sub	si,cx

	; cx=j

	xor	di,di
	mov	dx,200
main_y:
	push	si
	push	bp
	mov	cx,320
main_x:
	add	bp,[bx+_rx]
	add	si,[bx+_ry]
	push	bp
	push	si
	shr	bp,8
	and	si,0FF00h
	mov	al,fs:[si+bp]
	stosb
	pop	si
	pop	bp
	loop	main_x

	pop	bp
	pop	si
	add	bp,[bx+_dx]
	add	si,[bx+_dy]

	dec	dx
	jnz	main_y
	
	retn



; Draws Mandelbrot Fractal.
; x = x - y + cx
; y = 2xy + cy
; infinty (x+y) > 2


CalcMandel	proc	near

	mov	cx,256
mmain_y:
	push	cx
	mov	cx,256
	mov	ax,[m_cx]
	push	ax

; esi=x
; ebp=y
mmain_x:
	push	cx
	xor	cx,cx			; Clear colour

	xor	bp,bp			; y=0
	xor	si,si			; x=0


calc_colour:
	mov	ax,si	
	imul	si			; x
	shrd	ax,dx,13
	mov	bx,ax

	mov	ax,bp
	imul	bp			; y
	shrd	ax,dx,13

	mov	dx,ax
	add	dx,bx			; edx=y+x
	sub	bx,ax			; ebx=x-y

	cmp	dx,4 shl 13		; inifinity ?
	ja	breakMand
	

	mov	ax,si
	imul	bp			; y=2*x*y
	shrd	ax,dx,13-1

	add	ax,[m_cy]		;  
	add	bx,[m_cx]		;
	mov	bp,ax			; y
	mov	si,bx			; x

	inc	cx
	cmp	cl,63
	jb	calc_colour

	xor	cx,cx	
breakMand:

	xchg	ax,cx
	stosb
	
	mov	ax,[m_dx]
	add	[m_cx],ax

	pop	cx
	loop	mmain_x


	mov	ax,[m_dy]
	add	[m_cy],ax

	pop	ax
;	mov	ax,[xO]
	mov	[m_cx],ax

	pop	cx

	dec	cx
	jnz	mmain_y
	
	retn
CalcMandel	endp

; Make a "phong" palette
make_palette	proc
	mov	dx,3C8h
	mov	al,[start_colour]
	out	dx,al			; Set start colour
	inc	dx			; To set Palette

	xor	cx,cx
make_colour1:
	mov	al,cl
	mul	[red]
	shr	ax,5
	out	dx,al			; Set red value

	mov	al,cl
	mul	[green]
	shr	ax,5
	out	dx,al			; Set 

	mov	al,cl
	mul	[blue]
	shr	ax,5
	out	dx,al
	inc	cx
	cmp	cx,32
	jne	make_colour1

	xor	cx,cx
make_colour2:
	mov	bl,cl
	shl	bl,1
	mov	al,20h
	sub	al,cl
	mul	[red]
	shr	ax,5
	add	al,bl
	out	dx,al			; Set red value

	mov	al,20h
	sub	al,cl
	mul	[green]
	shr	ax,5
	add	al,bl
	out	dx,al			; Set Green value

	mov	al,20h
	sub	al,cl
	mul	[blue]
	shr	ax,5
	add	al,bl
	out	dx,al			; Set Blue value

	inc	cx
	cmp	cx,32			; make 33
	jbe	make_colour2
	retn
make_palette	endp



; Data
m_cx	dw	-17203			; -2.1*2^13
m_cy	dw	-9830			; -1.2*2^13
m_dx	dw	106			; (1.2--2.1)/200 * 2^13
m_dy	dw	70			; (1.2--1.2)/200 * 2^13



land_move:
	dw	100		; num of
	dw	0		; Xpos
	dw	0		; Ypos
	dw	10		; Angle

	dw	60		; num of
	dw	10		; Xpos
	dw	0		; Ypos
	dw	0		; Angle

	dw	50		; num of
	dw	5		; Xpos
	dw	0		; Ypos
	dw	-10		; Angle


	dw	40		; num of
	dw	0		; Xpos
	dw	10		; Ypos
	dw	0		; Angle

	dw	90		; num of
	dw	0		; Xpos
	dw	10		; Ypos
	dw	5		; Angle

	dw	100		; num of
	dw	0		; Xpos
	dw	1		; Ypos
	dw	2		; Angle

	dw	90		; num of
	dw	0		; Xpos
	dw	-8		; Ypos
	dw	0		; Angle

	dw	100
	dw	0
	dw	0
	dw	-12


	dw	0		; end



movements:
	db	45			; counter
	db	10			; scale
	db	2

	db	45
	db	-4
	db	3

	db	45
	db	1
	db	-4

	db	60
	db	-8
	db	-2

	db	70
	db	10
	db	0


	db	90
	db	-3
	db	3

	db	250
	db	5
	db	0

	db	250
	db	5
	db	0

	db	250
	db	-10
	db	-6


	db	80
	db	1
	db	1


	db	-1

counter	dw	1
where	dw 	offset movements
mem:
	db	"Out of Memory!",0dh,0ah,24h
please_wait:
	db	"Decrypting your fantasies...$"
msg:
	db	0dh,0ah,"Traveller, by CrysTalHeaD of "
placidia db	"PLACiDiA",0
	db	"Productions '97.",0dh,0ah,0dh,0ah
	db	"Travelling to Andromeda 2.2*10^6 lightyears or more than 2*10^22 meters away...",0dh,0ah,24h
traveller	db	"*Traveller*",0


text_X		dw	160-16*8
text_Y		dw	68



Xpos		dw	100
Ypos		dw	100
landAngle	dw	25
landconst1	dw	1024

dist_const1	dd	51200
dist_const2	dd	0.5


dmDistPtr	dw offset distance	; Pointer to place in Distances array



tunnel_loops	db	0

sconst1	dw	149
sconst2	dw	90
sconst3	dw	180
sconst4	dw	320
sconst5	dd	0.5

a	dd	10.0
b	dd	10.0
aadd	dd	1.6		; 1.7
badd	dd	2.9		; 3.0


rnd_seed	dd	19781997h
linsconst1	dd	60.0
zeroval		dd	0.0
one		dd	1.0
two		dd	2.0
five		dd	5.0
ten		dd	10.0
linswhere	dw	offset lins



xv              dw	1
yv		dw	0
xp              dw	100
yp              dw	100
addr		dw	0
old_addr	dw	0



include	cir.inc			; A circle
				; could be drawn but, this rotine is old


const_data:
plasma_data:
_pl_const1				equ	0
pl_const1	dw	256
_pl_const2				equ	2
pl_const2	dw	150
_pl_const3				equ	4
pl_const3	dw	10
_pl_const4				equ	6
pl_const4	dw	90
_pl_const5				equ	8
pl_const5	dw	47
_pl_const6				equ	10
pl_const6	dw	48
_pl_const7				equ	12
pl_const7	dw	512
_pl_const8				equ	14
pl_const8	dw	96
_pl_const9				equ	16
pl_const9	dw	92
_pl_const10			equ	18
pl_const10 dw	31
_pl_const11			equ	20
pl_const11	dd	0.5

_p1				equ	24
p1	dw	65
_p2				equ	26
p2	dw	82
_p3				equ	28
p3	dw	21
_p4				equ	30
p4	dw	12
_p5				equ	32
p5	dw	18
_p6				equ	34
p6	dw	6

_m1				equ	36
m1	dw	71
_m2				equ	38
m2	dw	88
_m3				equ	40
m3	dw	29
_m4				equ	42
m4	dw	11

_c1				equ	44
c1	dw	97
_c11				equ	46
c11	dw	17
_c2				equ	48
c2	dw	38
_c21				equ	50
c21	dw	76
_c3				equ	52
c3	dw	43
_c31				equ	54
c31	dw	83



const1				equ	56
tconst	dw	128
scale				equ	58
	dw	800
div2				equ	60
	dw	2
; temporary saved data, not allocated	
angle				equ	62
	dw	?
_ry				equ	64
	dw	?
_rx				equ	66
	dw	?
_dy				equ	68
	dw	?
_dx				equ	70
	dw	?

_x				equ	72
x	dw	?
_y				equ	74
y	dw	?
_value				equ	76
value	dw	?
_count				equ	78
count	dw	?
_value2				equ	80
value2	dw	?,?



font_ofs	dw	?
font_seg	dw	?
temp_x		dw	?

nx		dw	?
ny		dw	?
linsx		dw	?
linsy		dw	?

tmp1		dw	?,?

dmXPos		db ?	; Origin's x coordinate within a tile
dmYPos		db ?	; Origin's y coordinate within a tile
dist_temp	dw	?
dmLineCounter	db ?	; Keep track of number of lines to draw

start_colour	db	?
red		db	?
green		db	?
blue		db	?

add_scale	dw	?
add_deg		db	?

step		dw	?

work_seg	dw	?
mandel_seg	dw	?
plasma_seg	dw	?
move_seg	dw	?
colour_seg	dw	?
pla_seg		dd	?


; for peace sign.
c_value	dd	?
colour	db	?
divs	dw	?
r	dw	?
c_x	dw	?
c_y	dw	?
addvalue dd	?


tresult		dw	?
temp1		dw	?
temp2		dw	?
result		dw	?,?
sbobdata	dw	1000 dup (?)
traveller_pic	db	12*16*8 dup (?)

lins		dw	120*120 dup (?)
lins_buff	db	120*120 dup (?)
distance	dw	200 dup (?)

; I hope you learnt something!
	end	start