COMMENT _

     //----------------------------------------------------------------\
     |  Sound Deluxe System 5                                          |
     |  by Maple Leaf (a.k.a Gruian Radu), 1996,1997                   |
     |   SoundBlaster Pro driver                                      |
     \----------------------------------------------------------------//
_

sbpDesc    db       "SB Pro driver v1.04, by Maple Leaf, 1996-1997."

;
;   Functions-Offsets Table
;

sbp_driver dw       offset drvg_InitDriver
           dw       offset drvg_DoneDriver
           dw       offset sbp_StartMixer
           dw       offset sbp_StopMixer
           dw       offset mx_SetVoiceVolume
           dw       offset mx_GetVoiceVolume
           dw       offset mx_SetVoicePanning
           dw       offset mx_GetVoicePanning
           dw       offset mx_SetVoiceFreq
           dw       offset mx_GetVoiceFreq
           dw       offset mx_PlayVoice
           dw       offset mx_StopVoice
           dw       offset mx_SetGlobalVolume
           dw       offset mx_SetAmplification
           dw       offset mx_DoPoll_stereo
           dw       offset sb_SetMasterVolume
           dw       offset mx_TickAwaited

;
;   StartMixer (DX=Mixing speed, AX=# of voices)
;

sbp_StartMixer proc near

        ClipFreq 8000, 44100   ; min 8000 Hz, max 44.1 kHz

        and      edx,0FFFFh
        mov      cs:mxmixspd,edx ; Store mix speed for future calculations
        call     sb_CorrectFrq
        shr      dx,1           ; div 2
        mov      cs:cmixspd,dx  ; !!! mono: cmixspd=sbmixspd, stereo: cmixspd=mxMixspd/2 !!!

        ClipVoices 4, 32       ; min 4 voices, max 32 voices

        mov      cs:mxVoices,ax        ; Store max # of active voices
        mov      cs:dmAutoInit,1       ; autoinit-dma mode !

        call     mxBuildPeriods_stereo ; Build the periods table
        call     mxBuildProcTab_stereo ; Build the Post-Processing Table

        call     mxInitVars_stereo     ; Init all internal counters

        call     sbResetDSP      ; Reset SoundBlaster's DSP
        call     sbSetDSPMixRate ; Setup DSP (timing, volumes(for stereo), etc)
        call     sbSpeakerOn     ; Turn the speaker on
        call     sbpStereoOn     ; Turn Stereo mode on

        mov      dx,offset sbpMainIRQ
        call     irqRedirectIRQ

        call     dmStartDMA      ; Start 8-bit DMA using channel sbpDMA
        call     sbpStartDSP     ; Start DMA Play

        retn
sbp_StartMixer endp

;
;   StopMixer ()
;

sbp_StopMixer proc near
        push     ax
        mov      al,0d0h
        call     dsp_command   ; Stop 8/16-bit DMA receiving
        call     dmStopDMA     ; Stop DMA transmission
        call     sbpStereoOff
        call     irqRestoreIRQ
        pop      ax
        retn
sbp_StopMixer endp

;
;   Main IRQ routine
;

sbpMainIRQ proc near
        pushf
        cli
        push     ax dx
        mov      dx,cs:mxPort
        add      dx,0Eh
        in       al,dx

        ; Initialize another DMA play

;       call     dmStartDMA      ; v5.04: WE'RE IN AUTOINIT DMA MODE,
;       call     sbpStartDSP     ; THIS SHIT ISN'T NECESSARY ANYMORE !

        mov      al,20h
        out      20h,al
        cmp      cs:mxIRQ,7
        jbe      sbpe20
        out      0a0h,al
sbpe20: pop      dx ax
        sti ; Quite useless ...
        popf
        iret
sbpMainIRQ endp

; Other rouines (internally used) 

sbpStartDSP proc  near
        mov      al,48h      ; set transfer block size
        call     dsp_command
        mov      ax,DMABufSize*16
        call     dsp_command
        mov      al,ah
        call     dsp_command
        mov      al,90h      ; v5.04: 8bit unsigned PCM, Autoinit mode!
        call     dsp_command
        retn
sbpStartDSP endp

sbpStereoOn proc near
        push     dx ax
        mov      dx,cs:mxPort
        add      dx,4
        mov      al,0eh
        out      dx,al  ; Access register 0Eh
        inc      dx
        in       al,dx  ; Read register 0Eh
        or       al,2   ; Bit #1 = "STEREO" flag
        mov      ah,al
        dec      dx
        mov      al,0eh
        out      dx,al  ; Access it again for writing
        inc      dx
        mov      al,ah
        out      dx,al  ; Set stereo
        pop      ax dx
        retn
sbpStereoOn endp

sbpStereoOff proc near
        push     dx ax
        mov      dx,cs:mxPort
        add      dx,4
        mov      al,0eh
        out      dx,al  ; Access reg 0Eh
        inc      dx
        in       al,dx
        and      al,0FDh ; Clear bit #1
        mov      ah,al
        dec      dx
        mov      al,0eh
        out      dx,al
        inc      dx
        mov      al,ah
        out      dx,al  ; Set mono (default mode for all SB cards I know)
        pop      ax dx
        retn
sbpStereoOff endp
