COMMENT _

     /-----------------------------------------------------------------\
     |  Sound Deluxe System 5                                          |
     |  by Maple Leaf (a.k.a Gruian Radu), 1996,1997                   |
     |   SoundBlaster 1.0/2.0 driver                                  |
     \-----------------------------------------------------------------/
_

sbDesc    db       "SB and SB 2.0 driver v1.05, by Maple Leaf, 1996-1997"

;
;   Functions-Offsets Table
;

sb_driver dw       offset drvg_InitDriver
          dw       offset drvg_DoneDriver
          dw       offset sb_StartMixer
          dw       offset sb_StopMixer
          dw       offset mx_SetVoiceVolume
          dw       offset mx_GetVoiceVolume
          dw       offset mx_SetVoicePanning
          dw       offset mx_GetVoicePanning
          dw       offset mx_SetVoiceFreq
          dw       offset mx_GetVoiceFreq
          dw       offset mx_PlayVoice
          dw       offset mx_StopVoice
          dw       offset mx_SetGlobalVolume
          dw       offset mx_SetAmplification
          dw       offset mx_DoPoll_mono
          dw       offset sb_SetMasterVolume
          dw       offset mx_TickAwaited

;
;   Driver's internal data
;

sb20    db       0              ; No DSP2 as default ( => SB 1.0 )

;
;   StartMixer (DX=Mixing speed, AX=# of voices)
;

nproc   sb_StartMixer

        ClipFreq 8000,44100

        and      edx,0FFFFh
        mov      cs:mxmixspd,edx ; Store mix speed for future calculations
        mov      cs:cmixspd,dx   ; !!! mono: cmixspd=mxmixspd, stereo: cmixspd=mxmixspd/2 !!!
        call     sb_CorrectFrq
        mov      cs:sb20,0      ; Default is SB 1.0 (mix rate <= 23 KHz)
        mov      cs:dmAutoInit,0 ; single cycle mode, no autoinit
        cmp      dx,22222       ; Is frequence greater than 23 KHz ?
        jbe      sbe3           ; No, skip next line
        mov      cs:sb20,1      ; Yes, set sb20 flag accordingly, there is a SB 2.0 present
        mov      cs:dmAutoInit,1 ; autoinit dma

sbe3:   ClipVoices 4, 32

        mov      cs:mxVoices,ax ; Store max # of active voices

        call     mxBuildPeriods_mono ; Build the periods table
        call     mxBuildProcTab_mono ; Build the Post-Processing Table

        call     mxInitVars_mono     ; Init all internal counters

        call     sbResetDSP          ; Reset SoundBlaster's DSP
        call     sbSetDSPMixRate     ; Setup DSP (timing, volumes(for stereo), etc)
        call     sbSpeakerOn         ; Turn the speaker on

        mov      dx,offset sbMainIRQ
        call     irqRedirectIRQ

        call     dmStartDMA          ; Start 8-bit DMA using channel mxDMA
        call     sbStartDSP          ; Start DMA Play

        retn
nendp   sb_StartMixer

;
;   StopMixer ()
;

nproc   sb_StopMixer
        push     ax
        mov      al,0d0h       ;
        call     dsp_command   ; Stop 8-bit DMA receiving
        call     dmStopDMA     ; Deactivate DMA transmission
        call     irqRestoreIRQ
        pop      ax
        retn
nendp   sb_StopMixer

;
;   SetMasterVolume ( AL=volume (0-255) )
;

nproc   sb_SetMasterVolume
        push     ax dx
        test     al,8   ; (AL shr 3) is odd ?
        pushf
        mov      ah,al
        and      ah,0F0h
        shr      al,4
        or       ah,al
        mov      dx,cs:mxPort
        add      dx,4
        mov      al,32h
        out      dx,al  ; register 32h = "master volume"
        inc      dx
        mov      al,ah
        out      dx,al  ; set register 32h
        dec      dx
        mov      al,14h
        out      dx,al  ; register 14h = "wave volume"
        inc      dx
        popf
        sjnz     sbSMV1
        and      ah,0Fh
        dec      ah
        sjge     sbSMV2
        mov      ah,0
sbSMV2: mov      al,ah
        shl      al,4
        or       ah,al
sbSMV1: mov      al,ah
        out      dx,al  ; set register 14h
        pop      dx ax
        retn
nendp   sb_SetMasterVolume

;
;   Main IRQ routine
;

nproc   sbMainIRQ
        pushf
        cli
        push     ax dx
        mov      al,20h
        out      20h,al
        cmp      cs:mxIRQ,7
        jbe      sbe20
        out      0a0h,al
sbe20:  mov      dx,cs:mxPort
        add      dx,0Eh
        in       al,dx

        ; Initialize another DMA play

        cmp      cs:dmAutoInit,1  ; v5.04: AUTOINIT MODE? (SB 2.0 uses
        sje      sbe2x            ; autoinit while SB/SB 1.5 doesn't...)
        call     dmStartDMA       ; These must be done only when SB or SB 1.5
        call     sbStartDSP       ; (when no Autoinit DMA is used)
sbe2x:

        pop      dx ax
        sti ; Quite useless ...
        popf
        iret
nendp   sbMainIRQ

; Other routines (internally used) 

nproc   sbResetDSP
        push     ax dx
        mov      dx,cs:mxPort
        add      dx,06h
        mov      al,1
        out      dx,al
        in       al,dx
        in       al,dx
        in       al,dx
        in       al,dx
        in       al,dx
        in       al,dx
        in       al,dx
        in       al,dx
        sub      al,al
        out      dx,al
        pop      dx ax
        retn
nendp   sbResetDSP

nproc   dsp_command   ; Sends a command to DSP
                      ; In:   AL=command
                      ; Out:  CF if error
        push     cx dx ax
        mov      dx,cs:mxPort
        add      dx,0Ch
        mov      cx,1000
sbe15:  in       al,dx
        test     al,al
        jns      sbe16
        dec      cx
        sjnz     sbe15
        jmp      short sbe17   ; Do not perform it ...
sbe16:  pop      ax
        push     ax
        out      dx,al
sbe17:  pop      ax dx cx
        retn
nendp   dsp_command

nproc   sbStartDSP
        mov      al,14h      ; 8bit DMA play for DSP 1.0
        cmp      cs:sb20,0   ; Is DSP 2.0 present ?
        je       sbe13
        mov      al,48h      ; Yes, command is 48h
sbe13:  call     dsp_command
        mov      ax,DMABufSize*16-1
        call     dsp_command
        mov      al,ah
        call     dsp_command
        cmp      cs:sb20,0
        je       sbe14
        mov      al,1Ch ; DSP 2.0, Start DMA Play, 8bit, unsigned, AUTOINIT!
        call     dsp_command
sbe14:  retn
nendp   sbStartDSP

nproc   sbSetDSPMixRate
        push     eax ecx edx
        mov      ecx,cs:mxMixSpd ; The same (8000-44100) for both mono and stereo !
        mov      eax,0F4240h
        xor      edx,edx
        div      ecx
        neg      al
        mov      ah,al
        mov      al,40h
        call     dsp_command
        mov      al,ah
        call     dsp_command
        pop      edx ecx eax
        retn
nendp   sbSetDSPMixRate

nproc   sbSpeakerOn
        push     ax
        mov      al,0d1h
        call     dsp_command
        pop      ax
        retn
nendp   sbSpeakerOn

nproc   sbSpeakerOff
        push     ax
        mov      al,0d3h
        call     dsp_command
        pop      ax
        retn
nendp   sbSpeakerOff

nproc   sb_CorrectFrq       ; kind of approximation of the REAL sb/sbpro replay rate
        push     eax ecx edx
        mov      dx,0Fh
        mov      ax,4240h
        mov      ecx,cs:mxMixSpd
        div      cx
;---------------------------------
        and      edx,0ffffh
        add      edx,edx
        cmp      edx,ecx
        jb       @sbcf1
        inc      al  ; increment result if modulo >= 0.5 (up-rounding)
@sbcf1:
;---------------------------------
        movzx    ecx,al
        mov      eax,0F4240h
        xor      edx,edx
        div      ecx
        mov      cs:mxMixSpd,eax
        mov      cs:cMixSpd,ax
        pop      edx ecx eax
        mov      dx,cs:cMixSpd
        retn
nendp   sb_CorrectFrq
