COMMENT _

     //----------------------------------------------------------------\
     |  Sound Deluxe System 5                                          |
     |  by Maple Leaf (a.k.a Gruian Radu), 1996                        |
     |   Media Vision Pro Audio Spectrum driver                       |
     \----------------------------------------------------------------//
_

pasDesc   db     "Pro Audio Spectrum driver v0.15,"
          db     " by Maple Leaf, 1996. "

;
;  YYOOO ! this is just a BETA version, this driver has never been tested,
;  because, unfortunately, I haven't found any PAS owner/user around ...
;  A big part of the PAS specific code was ripped and compiled from various
;  sources, so I'm not sure whether it will work absolutely okay or not.
;

;*****************************************************************************
;   Functions-Offsets Table
;*****************************************************************************

pas_driver  dw       offset drvg_InitDriver
            dw       offset drvg_DoneDriver
            dw       offset pas_StartMixer
            dw       offset pas_StopMixer
            dw       offset mx_SetVoiceVolume
            dw       offset mx_GetVoiceVolume
            dw       offset mx_SetVoicePanning
            dw       offset mx_GetVoicePanning
            dw       offset mx_SetVoiceFreq
            dw       offset mx_GetVoiceFreq
            dw       offset mx_PlayVoice
            dw       offset mx_StopVoice
            dw       offset mx_SetGlobalVolume
            dw       offset mx_SetAmplification
            dw       offset mx_DoPoll_stereo
            dw       offset pas_SetMasterVolume
            dw       offset mx_TickAwaited

;*****************************************************************************
;   Driver's internal data
;*****************************************************************************

pasDMAMask       db 0Ah,0Ah,0Ah,0Ah,0D4h,0D4h,0D4h,0D4h
pasRate          dw 0

;*****************************************************************************
;   StartMixer (DX=Mixing speed, AX=# of voices)
;*****************************************************************************

nproc   pas_StartMixer

        ClipFreq 8000, 44100

        and      edx,0FFFFh
        mov      cs:cmixspd,dx   ; actual frequency/2
        add      edx,edx         ; make it double !
        mov      cs:mxmixspd,edx ; Store mix speed for future calculations
        call     pas_CorrectFrq ; Added in SDS 5.01, Mixer v1.91

        ClipVoices 4, 32

        mov      cs:mxVoices,ax        ; Store max # of active voices
        mov      cs:dmAutoInit,1       ; I guess that PAS supports autoinit mode, doesn't it ?

        call     mxBuildPeriods_stereo ; Build the periods table, same as SBPro's
        call     mxBuildProcTab_stereo ; Build the Post-Processing Table, -"-

        call     mxInitVars_stereo     ; Init all internal counters, -"-

        call     pasSetDSPMixRate; Set DSP timing
        call     pasResetDSP     ; Reset PAS's DSP
        mov      dx,offset pasMainIRQ
        call     irqRedirectIRQ  ; Set IRQ entry

        call     pasStartDSP     ; Start DSP
        call     pasStartDMA     ; Start 8/16-bit DMA using channel
        retn
nendp   pas_StartMixer

;*****************************************************************************
;   StopMixer ()
;*****************************************************************************

nproc   pas_StopMixer
        push     ax
        call     pasDSP_Off
        call     dmStopDMA
        call     irqRestoreIRQ
        pop      ax
        sti
        retn
nendp   pas_StopMixer

;*****************************************************************************
;   SetMasterVolume ( AL=volume (0-255) )
;*****************************************************************************

nproc   pas_SetMasterVolume
        push     dx ax
        mov      ah,al
        mov      dx,78Bh
        mov      al,95h
        out      dx,al    ; Left/Right PCM mixer volume
        mov      al,1Fh
        out      dx,al    ; set it to 1Fh
        mov      al,81h   ; Left/Right master volume
        out      dx,al    ; write the index
        mov      al,ah
        shr      al,2     ; convert it to PAS volume
        out      dx,al    ; set desired mastervolume
        pop      ax dx
        retn
nendp   pas_SetMasterVolume

;*****************************************************************************
;   Main IRQ routine
;*****************************************************************************

pasMainIRQ:
        pushf
        cli
        push     ax dx
        mov      dx,0B89h       ; clear the interrupt
        xor      dx,cs:mxPort   ; xlate the board address
        in       al,dx
        test     al,8           ; is the PAS's interrupt ?
        jz       pas_not        ; no, get the fuck out
        out      dx,al          ; yeh, flush it
        mov      al,20h
        out      20h,al
        cmp      cs:mxIRQ,7
        jbe      pase20
        out      0a0h,al
pase20:

        ; Initialize another DMA play

        call     pasStartDSP
        call     pasStartDMA

        pop      dx ax
        sti ; Quite useless ...
        popf
        iret
pas_not:pop      dx ax
        sti
        popf
        jmp      dword ptr cs:irqOldIRQ  ; do the old IRQ routine

;*****************************************************************************
;   Other routines (used internally)
;*****************************************************************************

nproc   pasDSP_Off
        push     dx ax
        mov      dx,78Bh               ; palallel audio mixer interface
        mov      al,95h                ; left/right PCM mixer volume
        out      dx,al
        xor      dx,dx                 ; min volume
        out      dx,al
        pop      ax dx
        retn
nendp   pasDSP_Off

nproc   pasMixerInit
        push     dx ax
        mov      dx,78Bh              ; parallel audio mixer interface
        mov      al,95h
        out      dx,al
        mov      al,1Fh               ; set L/R volume (1/2 max)
        out      dx,al
        pop      ax dx
        retn
nendp   pasMixerInit

nproc   pasResetDSP
        push     ax dx si
        ; minimize the volume
        call     pasDSP_Off
        ; clear the audio filter sample bits
        cli
        mov      dx,0B8Ah
        xor      dx,cs:mxPort          ; xlate the board address
        mov      al,21h                ; flush the sample timer bits
        out      dx,al
        ; clear the PCM enable bit
        mov      al,99h
        mov      dx,0F8Ah
        xor      dx,cs:mxPort          ; xlate the board address
        out      dx,al
        ; disable the 16 bit stuff
        mov      dx,8389h
        xor      dx,cs:mxPort          ; xlate the board address
        in       al,dx
        and      al,0F3h               ; flush the 16 bit stuff (and 12 bit also)
        out      dx,al
        ; clear the appropriate Interrupt Control Register bit
        mov      dx,0B8Bh
        xor      dx,cs:mxPort          ; xlate the board address
        in       al,dx
        and      al,0F3h               ; kill the sample timer interrupt
        out      dx,al
        ; deactivate DMA
        movzx    si,cs:mxDMA           ; load DMA channel #
        movzx    dx,cs:pasDMAMask[si]  ; load mask register
        mov      al,cs:mxDMA
        or       al,4
        out      dx,al                 ; mask DMA channel
        ; remove control on the DRQ line
        mov      al,19h
        mov      dx,0F8Ah
        xor      dx,cs:mxPort          ; xlate the board address
        out      dx,al                 ; end to the hardware
        mov      dx,0B89h              ; flush any pending PCM irq
        xor      dx,cs:mxPort          ; xlate the board address
        in       al,dx
        jmp      short $+2             ; small delay
        out      dx,al
        sti
        call     pasMixerInit          ; init hardware stereo mixer
        clc
        pop      si dx ax
        retn
nendp   pasResetDSP

nproc   pasSetDSPMixRate
        push     ecx edx eax
        movzx    ecx,cs:cMixSpd
        add      ecx,ecx            ; a frequency of 44.1 kHz means 88.2 kHz total (Left+Right)
        xor      edx,edx
        mov      eax,1234DCh
        div      ecx
        mov      cs:pasRate,ax      ; store rate for later usage
        pop      eax edx ecx
        retn
nendp   pasSetDSPMixRate

nproc   pasLoadTimer0      ; setup the sample timer (T0 and square wave output)
        mov      al,36h                ; 36h = timer 0 and square wave
        mov      dx,138Bh              ; timer controller port
        xor      dx,cs:mxPort          ; xlate the board address
        cli
        out      dx,al                 ; setup the mode
        mov      ax,cs:pasRate         ; precalculated
        mov      dx,1388h
        xor      dx,cs:mxPort          ; xlate the board address
        out      dx,al                 ; output lower byte of mixing rate
        jmp      short $+2             ; small delay
        xchg     al,ah
        out      dx,al                 ; output higher byte of mixing rate
        sti                            ; enable int
        retn
nendp   pasLoadTimer0

nproc   pasLoadTimer1       ; setup the Sample Buffer Counter timer (T1 & rate generator)
        push     ax
        mov      al,74h                ; 74h = timer 1 and rate generator
        mov      dx,138Bh              ; timer controller port
        xor      dx,cs:mxPort          ; xlate the board address
        cli
        out      dx,al                 ; setup the mode
        pop      ax
        mov      dx,1389h              ; sample counter (size) port
        xor      dx,cs:mxPort          ; xlate the board address
        out      dx,al                 ; send lower byte of size
        jmp      short $+2             ; small delay
        xchg     al,ah
        out      dx,al                 ; xlate the board address
        sti                            ; enable int
        retn
nendp   pasLoadTimer1

nproc   pasStartDSP          ; prepare a block output in DMA mode
        push     ax cx dx
        call     pasLoadTimer0        ; set sample rate timer 0
        mov      ax,DMABufSize*16-1   ; size of DMA buffer
        call     pasLoadTimer1        ; set sample counter (size)

        ; setup the Interrupt Control Register
        cli

        mov      dx,0B89h             ; flush any pending interrupts of the
        xor      dx,cs:mxPort         ; PCM circuitry.
        in       al,dx                ;*************************************
        jmp      $+2                  ;*** I'm not sure this is correct. ***
        out      dx,al                ;*************************************

        mov      dx,0B8Bh
        xor      dx,cs:mxPort         ; xlate the board address
        in       al,dx                ; get real mask
        or       al,8                 ; interrupt on sample buffer count
        out      dx,al                ; do it
        ; enable the 16 bit stuff (for MV101 chip only)
        mov      cx,0E308h
        mov      dx,8389h
        xor      dx,cs:mxPort         ; xlate the board address
        in       al,dx
        and      al,ch                ; clear the unwanted bits
        or       al,cl                ; set the appropriate bits
        out      dx,al
        ; setup the direction, stereo/mono and DMA enable bits
        mov      al,0D9h
        mov      dx,0F8Ah
        xor      dx,cs:mxPort          ; xlate the board address
        xor      al,40h                ; disable the PCM bit
        out      dx,al                 ; send it
        xor      al,40h                ; enable the PCM bit again
        out      dx,al                 ; send it
        ; setup the audio filter sample bits
        mov      al,0E1h               ; enable the sample count/buff counters
        mov      dx,0B8Ah
        xor      dx,cs:mxPort          ; xlate the board address
        out      dx,al                 ; set bits
        sti                            ; and start it ...
        pop      dx cx ax
        retn
nendp   pasStartDSP

nproc   pasStartDMA
        push     ax dx
        call     dmStartDMA
        ; check whether the DRQ is controlled or floating
        mov      dx,0F8Ah
        xor      dx,cs:mxPort ; xlate the board address
        mov      al,80h       ; set the DRQ bit to control it
        out      dx,al
        pop      dx ax
        retn
nendp   pasStartDMA

nproc   pas_CorrectFrq
        push     eax edx ecx
        mov      eax,1234dch
        mov      ecx,cs:mxMixSpd  ; in ecx -> the "full" frequency (max 88.2 kHz) !!!
        xor      edx,edx
        div      ecx
        mov      ecx,eax
        mov      eax,1234dch
        xor      edx,edx
        div      ecx
        mov      cs:mxMixSpd,eax
        shr      eax,1
        mov      cs:cMixSpd,ax
        pop      ecx edx eax
        mov      dx,cs:cMixSpd
        retn
nendp   pas_CorrectFrq
