;-----------------------------------------------------------------------------
; Sound Deluxe System 5, a Maple Leaf production, 1996-1997
; Small demo of using poll/timer modes in protected mode asm (PMODE)
;-----------------------------------------------------------------------------
; Do whatever you want with this piece of code, but if you use it in your
; productions, give the proper credits...
;-----------------------------------------------------------------------------
        .386p

include pmodesds.inc   ; the interface declarations

public  _main

; DATA 

m1              db      "Playing in TIMER mode. Wait...",13,10,"$"
m2              db      "Playing in POLL mode. Wait...",13,10,"$"
m4              db      "Back to TIMER mode. Sliding volume down. Wait...",13,10,"$"
m5              db      "Sliding volume up. Wait...",13,10,"$"
m6              db      "The song has been jumped to order 8. Press a key to exit...",13,10,"$"
m3              db      'SDS 5 PMODE support demo, by Maple Leaf, 1997',13,10,'$'
merr            db      'Sorry, SDS is not present. Run _PMODE!.BAT instead.',13,10,'$'

; CODE 

ShowMessage:
        add eax,_code32a        ; adjust to an absolute address
        shld ebx,eax,28         ; shift bits 4-31 of EAX into 0-28 of EBX
                                ;  though we only care for bits 4-19 of EAX
                                ;  that is the segment from the absolute addx
        and eax,0fh             ; and off the segment from EAX
                                ;  now BX:AX is the seg:off of the message
        mov v86r_ds,bx          ; put segment into virtual reg for real mode
        mov v86r_dx,ax          ; put offset into virtual reg for real mode
        mov v86r_ah,9           ; AH=9 for call to real mode INT 21h
        mov al,21h              ; interrupt number to call
        int 33h                 ; do real mode INT AL
        ret

; since Tran's ";"-type comments became so popular, why shouldn't I use
; them, too ?????
;

Retrace:
        mov edx,3dah
vrend:  in al,dx
        test eax,8
        jnz vrend
vrgo:   in al,dx
        test eax,8
        jz vrgo
        ret

;
_main:
        sti


    ; the following call will detect whether a SDS background session is
    ; active or not. The result is returned into DL (1=found,0=not found).
    ; If SDS has been found, the routine will automatically find the
    ; addresses of ESB, API #1 and real-mode far poll-mixing routine.

        call    SDS_DetectSession

        mov     eax,offset merr
        or      dl,dl
        jz      Bye

    ; In this point, SDS has been detected and your program may start
    ; to interract with it. First, we switch SDS into TIMER mode, and
    ; we display a message which says this.

        call    SDS_SetTimer

        mov     eax,offset m1
        call    ShowMessage

    ; Now we do a loop in which we let SDS playing in background, until
    ; the "UserCounter" (an ESB specific field, see docs) becomes, let's
    ; say, 500

    loop1:
        call    SDS_GetUsrCounter  ; read counter in EAX (incremented by SDS)
        cmp     eax,500            ; is is 500 ?
        jl      loop1

    ; Then SDS is switched into POLL mode, and we start mixing the sound
    ; with SDS_Poll. This operation will last until the "UserCounter"
    ; becomes, let's say, 1000

        call    SDS_SetPoll       ; we've switched it into POLL mode

        mov     eax,offset m2
        call    ShowMessage       ; acknowledge user what have we just done

     loop2:
        call    SDS_Poll          ; mix a bit of sound!
        call    Retrace           ; Wait for a vertical retrace
        call    SDS_GetUsrCounter ; get counter in EAX
        cmp     eax,1000          ; is it 1000 ?
        jl      loop2

    ; Now we switch SDS into TIMER mode again, and, while it is mixing in
    ; background, we slide down the volume.

        call    SDS_SetTimer      ; switch to timer mode

        mov     eax,offset m4
        call    ShowMessage       ; acknowledge user what have we just done

        mov     ecx,100
    loop3:
        call    SDS_SlideVolumeDn  ; slide the global volume
        call    Retrace
        call    Retrace
        loop    loop3

    ; The volume has been cut off, now start to increase it slowly

        mov     eax,offset m5
        call    ShowMessage       ; acknowledge user what we're gonna do

        mov     ecx,100
    loop4:
        call    SDS_SlideVolumeUp ; slide the global volume
        call    Retrace
        call    Retrace
	call	Retrace
        loop    loop4

    ; Okay now, one more thing: a little and nice jump in the song's normal
    ; playing process will be performed, using SDS_Jump. We'll jump, let's
    ; say, to order 8 in the song:

        mov     eax,offset m6
        call    ShowMessage       ; acknowledge user what we're gonna do

        mov     ah,8              ; order number
        call    SDS_Jump          ; jump!

    ; wait for a keypress, and re-enter the dull world of real-mode MS-DOS...

        mov     v86r_ah,0         ; wait for key with INT 16h AH=0
        mov     al,16h            ; exec real-mode INT 16h
        int     33h		  ; go!

        mov     eax,offset m3

  Bye:  call    ShowMessage
        jmp     _exit             ; bye bye blue sky, bye bye... 

code32  ends
        end

        
<><><><><><><><><><><>< pmode REALLY IS great ! ><><><><><><><><><><><><><><><>