#include <allegro.h>

#define BANNER "TV < TeleVision Viewer > by BullHead / Plastic Surgery\n"
#define BANNER_END "TV < TeleVision Viewer > ... see ya !\n"


void main ( int argc, char *argv[] )
{
    BITMAP *bmp_resized, *bmp_original, *bmp_raster ;
    PALETTE bmp_pal, raster_pal;
    int x,y,i,r,g,b;
    RGB c;

    if ( argc < 2 )
    {
         printf( BANNER );
         printf( "Usage: tvv filename \n" );
         printf( " Known file formats : BMP, PCX, TGA, LBM. \n");
         exit(1);
    }

    allegro_init();
    install_keyboard();

    bmp_original = load_bitmap ( argv[1], bmp_pal );
    if (bmp_original == NULL)
    {
         printf(BANNER);
         printf(" ERROR - Unknown format or file not found \n");
         printf(" Known file formats : BMP, PCX, TGA, LBM. \n");
         exit(1);
    }

    set_gfx_mode (GFX_MODEX, 320, 600, 0, 0);
    bmp_resized = create_bitmap ( 320, 200 );
    bmp_raster  = create_bitmap ( 320, 600 );
    clear ( bmp_resized );
    clear( bmp_raster );
    // resize the picture to fit in 320x200
    stretch_blit(bmp_original,bmp_resized,0,0,bmp_original->w,bmp_original->h,
                                         0,0,bmp_resized->w,bmp_resized->h);

    // build the television pallete
    for(i = 0; i < 64; i++)
    {
         raster_pal[i].r = i;
         raster_pal[i].g = 0;
         raster_pal[i].b = 0;

         raster_pal[i+64].r = 0;
         raster_pal[i+64].g = i;
         raster_pal[i+64].b = 0;

         raster_pal[i+128].r = 0;
         raster_pal[i+128].g = 0;
         raster_pal[i+128].b = i;

         // the other 64 entries don't make any difference ...
         // so forget'em
    }

    set_pallete(raster_pal);

    for (y = 0; y < 200; y ++)
        for (x = 0; x < 320; x ++)
        {
            // the color of the pixel in the bitmap ...
            c=bmp_pal[bmp_resized->line[y][x]];
            // set the colors of the 3 pixels to replace the original ...
            r = c.r + 0;
            g = c.g + 64;
            b = c.b + 128;
            // put the pixels
            bmp_raster -> line[3*y][x]   = r;
            bmp_raster -> line[3*y+1][x] = g;
            bmp_raster -> line[3*y+2][x] = b;
        }

    blit( bmp_raster, screen, 0, 0, 0, 0, bmp_raster->w, bmp_raster->h );
    readkey();
    set_gfx_mode( GFX_TEXT, 0, 0, 0, 0);
    printf( BANNER_END );
}