.386
.model flat, pascal  ; module for TMT Pascal. Example how to add tasm code.
                     ; compile with tasm 4.0 to *.obj file
.code

Public MoveD,SetMode,FlipScreen,FillDWord

;-----------------------------------
;----- fast moving four byte at once
;-----------------------------------
MoveD proc near
arg src : DWord, dest : Dword, sizes : Dword
     cld
     mov  ESI, src
     mov  EDI, dest
     mov  ECX, sizes
     rep  movsd
     ret
MoveD endp

;--------------------------------
;---set video mode, text or graph.
;--------------------------------
SetMode proc near
arg tryb : word
     mov  AX, tryb
     int  10h
     ret
SetMode endp

;-----------------------------------------------------------------
;--- wait for vertical retrace, then flip buffer into video memory
;-----------------------------------------------------------------
FlipScreen proc near
arg adres : dword
     cli             ;to jest wazne, gdy ma np. grac muzyka w tle
     mov  DX, 3DAh   ;pobierz wartosc z portu $3DA - znaczenie 4 bitu:
l3:                 ;0 - display mode, 1 - vertical retrace
      in  AL, DX     ;bajt z DX do AL
     and  AL, 08h    ;porwnaj czy bajt 4 jest ustawiony
     jnz  l3         ;jesli jest to skocz do @l1 (czekaj az wyzeruje)
l4:   in  AL, DX
     and  AL, 08h
      jz  l4
     mov  ESI, adres
     mov  EDI, 0A0000h
     mov  ECX, 16000
     rep  movsd
     sti
     ret
FlipScreen endp

;----------------------------------
;--- fill memory four bytes at once
;----------------------------------
FillDWord proc near
arg src : Dword, sizes : Dword, what : Dword
     mov  EDI, src
     mov  ECX, sizes
     mov  EAX, what
     rep  stosd
     ret
FillDWord endp

end