Program THE_GAME_OF_LIFE(input,output);

(* CS 050 : Final Programming Assignment
            Written by Everett "Kelt" Sloan
            December 1, 1997
            St. Lawrence College: Kingston Campus
            Coded in Borland Turbo Pascal 6.0 and 7.0 and 80286 assembly

This program executes John Conways 3 rules of life on a 10x10 grid. the
rules are:
        (1) Every empty cell with 3 living neighbours will come to life
            in the next generation
        (2) Any cell with 1 or 0 neighbours will die of loneliness, while
            any cell with four or more neighbours will die of overcrowding
        (3) Any cell with two or three neighbours will continue living.

NOTE: Neighbours can be diagonal!!
Global variables have not been used for two reasons.
       1) Ease of code understanding
       2) Ease of code portability.

This has made the program slightly longer but in the long run it was
worth it. *)

Uses CRT;       {for various screen procedure}

Const MAX_ROW=10;     {the X size of the grid}
      MAX_COL=10;     {the Y size of the grid}

Type  LIFE_ARRAY=array[1..3,0..(MAX_ROW+1),0..(MAX_COL+1)] of boolean;
      { LIFE_ARRAY is a 12 by 12 array because you need a border around
        the array in order to perform the checks properly
        the first part of the array is the history before SWAPping
          #1 Old array
          #2 Current array
          #3 Future array  }

{}
procedure INIT_VARIABLES(var LIFE:LIFE_ARRAY;var LIMIT_10:boolean;var GENERATION:integer);
(* clears all variables to zero or sets them as invalid. Also sets the three
 entire arrays to "dead" *)
var COUNTER:integer;
    ROW,COL: integer;             {for array loops}
begin
  checkbreak:=false;                     {don't allow ctrl+C while running}
  LIMIT_10:=false;                       {initialize Limit_10}
  GENERATION:=0;                         {zero the generation counter}
  for COUNTER:=1 to 3 do
    for ROW:= 0 to (MAX_ROW+1) do
      for COL:= 0 to (MAX_COL+1) do
          begin
            LIFE[COUNTER,ROW,COL]:=false;
          end;
end;
{}
procedure DISPLAY_MESSAGE(var LIMIT_10:boolean);
(* writes a prompt for user input *)
var KEY:char;      {record user input}
begin
   asm mov ax,03h; int 10h; end;          {clears the screen to 80x25}
   textcolor(11);                         {textcolor bright cyan}
   writeln(' The Game of Life');
   textcolor(3);                          {textcolor cyan}
   writeln(' Written by Everett Sloan');
   writeln(' December 1, 1997',#13,#10);{extra LF and CR}
   textcolor(11);
   writeln('Would you like to only proceed 10 generations? [Y/N]',#13,#10);
   textcolor(3);
   writeln('If NO then the life simulation will continue until:');
   writeln('           1) All life dies');
   writeln('           2) Life pattern becomes static');
   writeln('           3) Life pattern oscillates');
   writeln('           4) Esc key is pressed');
    repeat
     KEY:=readkey;
    until upcase(KEY) in ['Y','N',#27]; {allow Esc key to exit}
    if upcase(KEY)='Y' then LIMIT_10:=not(LIMIT_10);
    if KEY=#27 then halt;
end;
{}
procedure GET_LIFE_INPUT(var LIFE:LIFE_ARRAY);
(* gets the user input for the starting life grid. This contains many nested
  procedures  and functions*)

var ROW,COL:integer; {row and column counters}
    KEY:char;        {record user input}
{----------------------------------------------------------------------------}
procedure USER_INPUT;
(* allows the user to input the data using #1 and #0 *)
var ROW,COL:integer;  {row and column counters}
    KEY:char;         {record user input}
begin
  textcolor(3);           {light cyan}
  write(#13,#10,#13,#10,'Input the ',MAX_ROW,'x',MAX_COL,' life pattern using 0 or 1:');
  textcolor(11);  {two blank lines before the message}
  for ROW:= 1 to MAX_ROW do
      begin
        writeln;
        for COL:= 1 to MAX_COL do
          begin
           repeat
            KEY:=readkey;
           until KEY in ['0','1',#27];  {allow user to press Esc to quit}
          if KEY='1' then LIFE[2,COL,ROW]:=true;
          if KEY='0' then LIFE[2,COL,ROW]:=false;
{must be read in this pattern to allow horizontal reading of the pattern}
          if KEY=#27 then halt;
          write(KEY:2);
        end;
     end;
end;
{----------------------------------------------------------------------------}
procedure RANDOM_INPUT;
(* generates a random pattern *)
var NUMBER:integer;  {a random number slot}
    ROW,COL:integer; {row and column counters}
    KEY:char;        {record user input}
begin
  randomize;                    {generates a new random seed}
  for ROW:=1 to MAX_ROW do
    for COL:= 1 to MAX_COL do
      begin
        number:=random(2);                 {never actually generates a 2}
         case number of
           0 : LIFE[2,ROW,COL]:=false;
           1 : LIFE[2,ROW,COL]:=true;
         end;
      end;
end;
{----------------------------------------------------------------------------}
procedure FILE_INPUT;
(* reads the input from a the file LIFE.DAT and performs full error checking*)

function FileExists(FileName: String): Boolean;
(* checks to see if a file exists on the current directory, if file exists,
  returns true, else, returns false *)
var
 F: file;       {file variable}
begin
 {$I-}                  {disable error checking}
 Assign(F, FileName);   {assign file variable to filename}
 Reset(F);              {try opening file}
 Close(F);              {close file}
 {$I+}                  {enable error checking}
 FileExists := (IOResult = 0) and (FileName <> '');
            {if no problems, file exists, else, file doesnt exist}
end; {F:FileExists}

var LIFE_DATA:text;
    FILE_INPUT:char;   {what is read from the file}
    ROW,COL:integer; {row and column counters}
    KEY:char;        {record user input}

begin
     writeln(#10,#13,'Reading data from LIFE.DAT');
       if not FILEEXISTS('LIFE.DAT')  then
       begin
         textcolor(15);                   {white}
         writeln(#13,#10,'LIFE.DAT was not found, generating file...');
         delay(2000);
         assign(LIFE_DATA,'LIFE.DAT');
         Rewrite(LIFE_DATA);    {create a file}
         writeln(LIFE_DATA,'0000000000');
         writeln(LIFE_DATA,'0000000000');
         writeln(LIFE_DATA,'0000000000');
         writeln(LIFE_DATA,'0001110000');
         writeln(LIFE_DATA,'0001010000');
         writeln(LIFE_DATA,'0001110000');
         writeln(LIFE_DATA,'0000000000');
         writeln(LIFE_DATA,'0000000000');
         writeln(LIFE_DATA,'0000000000');
         writeln(LIFE_DATA,'0000000000'#13,#10,#13,#10); {2 blank lines}
         writeln(LIFE_DATA,'/* You put it in grid format or as a continous line, the program adapts');
         writeln(LIFE_DATA,'/* to the type of user input',#13,#10);
         writeln(LIFE_DATA,'/* This the data for the game of life. It does not matter the order or the');
         writeln(LIFE_DATA,'/* length of the data. It only reads a MAX_ROW x MAX_COL grid. This file');
         writeln(LIFE_DATA,'/* must contain at least a grid of that size.');
         close(LIFE_DATA);
       end;

     if FILEEXISTS('LIFE.DAT') then
       begin
         assign(LIFE_DATA,'LIFE.DAT');
         reset(LIFE_DATA);                {open file}
         for ROW:=1 to MAX_ROW do
           for COL:=1 to MAX_COL do
             begin
               repeat
               read(LIFE_DATA,FILE_INPUT);
{               delay(1000);                debugging step
               write(file_input);}
{ the input must be read in COL,ROW format because the data is being read from
  left to right, top to bottom }
               case FILE_INPUT of
                 '0' : LIFE[2,COL,ROW]:=false;
                 '1' : LIFE[2,COL,ROW]:=true;
                 #13 : begin end;       {ignore EOLN}
                 #10 : begin end;       {ignore LF}
                 else begin
                        textcolor(15);                   {white}
                        writeln('Invalid Data! ... Generating Random Life.');
                        delay(2000);  {allow user to read message}
                        RANDOM_INPUT;
                      end;
             end;
             until FILE_INPUT in ['0','1']  {repeat until valid character}
             end;
         close(LIFE_DATA);                {close file}
       end;
end;
{----------------------------------------------------------------------------}
begin
  textcolor(11);                        {light cyan}
  write(#10,#13,'Do you want User input, Random array, or read from a File [U/R/F]?');
  repeat
   KEY:=readkey;
  until upcase(KEY) in ['U','R','F',#27]; {allow user to press Esc}
    case upcase(KEY) of
       'U' : USER_INPUT;
       'R' : RANDOM_INPUT;
       'F' : FILE_INPUT;
       #27 : halt;              {terminate the program}
    end;
end;
{}
function TOTAL_LIFE(LIFE:LIFE_ARRAY;POSITION:integer):integer;
(* scans through the life grid and counts the number of "lives" *)
var COUNTER:integer;
    ROW,COL:integer; {row and column counters}
    KEY:char;        {record user input}

begin
  COUNTER:=0;
  for ROW:= 1 to MAX_ROW do
    for COL:= 1 to MAX_COL do
      begin
        if LIFE[POSITION,ROW,COL] then inc(counter);
      end;
  TOTAL_LIFE:=COUNTER;
end;
{}
function NO_LIFE(var LIFE:LIFE_ARRAY;GEN1:integer):boolean;
(* scans the current array to determine if there is any life left *)
var ROW,COL:integer; {row and column counters}
    KEY:char;        {record user input}
begin
  NO_LIFE:=true;
  for ROW:= 1 to MAX_ROW do
    for COL:= 1 to MAX_COL do
       if LIFE[GEN1,ROW,COL] then NO_LIFE:=false;
end;
{}
function STATIC(var LIFE:LIFE_ARRAY;GEN1,GEN2:integer):boolean;
(* by comparing the new array with the old array this function determines
 wether the life has stopped changing *)
var ROW,COL:integer; {row and column counters}
    KEY:char;        {record user input}
begin
  STATIC:=true;
  for ROW:= 1 to MAX_ROW do
    for COL:= 1 to MAX_COL do
       if LIFE[GEN1,ROW,COL]<>LIFE[GEN2,ROW,COL] then STATIC:=false;
end;
{}
function OSCILLATE(LIFE:LIFE_ARRAY;GEN1,GEN2:integer):boolean;
(* this return true if the patterns are oscillating. This only checks back
 for a history of 3 buffers. I started of checking back 10 arrays but the
 size grew to large and the speed was severely hampered *)
var ROW,COL:integer;  {counter for row and column}
begin
 OSCILLATE:=true;
 for ROW:=1 to MAX_ROW do
   for COL:=1 to MAX_COL do
     begin
       if (LIFE[GEN1,ROW,COL]) <> (LIFE[GEN2,ROW,COL]) then OSCILLATE:=false;
     end;
end;
{}
procedure STATUS(var LIFE_GRID:LIFE_ARRAY;LIMIT_10:boolean);
(* this procedure displays the current status of the on the screen and returns
 a value for debugging and ending message properties *)
begin
   textcolor(15);
   gotoxy(46,5);
   writeln('STATUS:');
{----------------------------------------------------------------------------}
   gotoxy(48,6);                  {go to position on screen}
   textcolor(3);                  {textcolor cyan}
   write('[');
   textcolor(11);                 {textcolor bright cyan}
   if TOTAL_LIFE(LIFE_GRID,3) > TOTAL_LIFE(LIFE_GRID,2) then {is population growing}
      write('') else write(' ');
      textcolor(3);
      write('] Population growing');
{----------------------------------------------------------------------------}
   gotoxy(48,7);                  {go to position on screen}
   textcolor(3);                  {textcolor cyan}
   write('[');
   textcolor(11);                 {textcolor bright cyan}
   if TOTAL_LIFE(LIFE_GRID,3) < TOTAL_LIFE(LIFE_GRID,2) then {is population shrinking}
      write('') else write(' ');
      textcolor(3);
      write('] Population shrinking');
{----------------------------------------------------------------------------}
   gotoxy(48,8);                  {go to position on screen}
   textcolor(3);                  {textcolor cyan}
   write('[');
   textcolor(11);                 {textcolor bright cyan}
   if TOTAL_LIFE(LIFE_GRID,3) = TOTAL_LIFE(LIFE_GRID,2) then {is population same}
      write('') else write(' ');
      textcolor(3);
      write('] Population unchanged');

{----------------------------------------------------------------------------}
   gotoxy(48,10);                  {go to position on screen}
   textcolor(3);                  {textcolor cyan}
   write('[');
   textcolor(11);                 {textcolor bright cyan}
   if LIMIT_10 then               {procedure only 10 generations}
      write('') else write(' ');
      textcolor(3);
      write('] Stop at generation #10');
{----------------------------------------------------------------------------}
   gotoxy(48,12);                  {go to position on screen}
   textcolor(3);                  {textcolor cyan}
   write('[');
   textcolor(11);                 {textcolor bright cyan}
   if NO_LIFE(LIFE_GRID,3) then     {entire array is "dead"}
      write('') else write(' ');
      textcolor(3);
      write('] All life has died');
{----------------------------------------------------------------------------}
   gotoxy(48,13);                  {go to position on screen}
   textcolor(3);                  {textcolor cyan}
   write('[');
   textcolor(11);                 {textcolor bright cyan}
   if STATIC(LIFE_GRID,2,3) and not(NO_LIFE(LIFE_GRID,3)) then {old array is the same as new array}
      write('') else write(' ');
      textcolor(3);
      write('] Life pattern static');
{this step must check also to see if there is no life. because if all life
dies then the arrays become static, but there should only be one output.}
{----------------------------------------------------------------------------}
   gotoxy(48,14);                  {go to position on screen}
   textcolor(3);                  {textcolor cyan}
   write('[');
   textcolor(11);                 {textcolor bright cyan}
   if not STATIC(LIFE_GRID,2,3) and OSCILLATE(LIFE_GRID,1,3) then  {life pattern is oscillating}
      write('') else write(' ');
      textcolor(3);
      write('] Life pattern oscillating');
{----------------------------------------------------------------------------}
   gotoxy(48,15);                  {go to position on screen}
   textcolor(3);                   {textcolor cyan}
   write('[ ] Aborted by User');   {for abortion procedure}
end;
{}
procedure DRAW_LIFE(var LIFE:LIFE_ARRAY;GENERATION:integer;var LIMIT_10:boolean);
(* draws the headers, grid, and life pattern on the screen in color, this
  grid and pattern is configured for a 10x10 grid. If you change the size
  of the grid then you need to change this procedure. The 10x10 grid will
  only work on this screen and grid resolution. *)
var ROW,COL:integer; {row and column counters}
    KEY:char;        {record user input}

begin
    clrscr;                          {clears the screen}
    textcolor(15);                   {textcolor white}
    writeln('Game of Life  Written by Everett Sloan  CS 050');
    textcolor(11);                   {textcolor bright cyan}
    writeln('Generation: #',GENERATION);
    writeln('Alive amoebas: ',TOTAL_LIFE(LIFE,3),' out of ',MAX_ROW*MAX_COL);
    textcolor(1);                   {textcolor blue}
     writeln('    Ŀ');
    for ROW:= 1 to MAX_ROW-1 do
     begin
       writeln('                                  ');
       writeln('    Ĵ');
     end;
     writeln('                                  ');
     writeln('    ');
{the above algorithm draws a grid for the life arrays to be displayed on
the screen. This is only suitable for a 10 x 10 grid. Because if it got
any bigger then you would need a bigger screen}
     for ROW:= 1 to MAX_ROW do
       for COL:= 1 to MAX_COL do
       begin
          textcolor(15);
          gotoxy((row*4)+3,(col*2)+3);
          if generation=0 then begin if LIFE[2,ROW,COL] then write(#2) else write(' '); end else
          begin
           if LIFE[3,ROW,COL] then write(#2) else write(' ');
          end;
       end;
{this algorithm draws the life arrays in their appropriate grid position}
 if GENERATION>0 then status(LIFE,LIMIT_10);
 {don't display the status bar if it is generation #0}
end;

{}
procedure SWAP(var LIFE:LIFE_ARRAY);
(* swaps input arrays positions.

 Final output is LIFE_POSITION1=LIFE_POSITION2
                 LIFE_POSITION2=LIFE_POSITION3
                 LIFE_POSITION3=LIFE_POSITION1
 *)
var TEMP:array[1..MAX_ROW,1..MAX_COL] of boolean;
    ROW,COL:integer; {row and column counters}
    KEY:char;        {record user input}

begin
  for ROW:=1 to MAX_ROW do        {swaps array one into temp}
    for COL:=1 to MAX_COL do
      TEMP[ROW,COL]:=LIFE[1,ROW,COL];

  for ROW:=1 to MAX_ROW do        {swaps array two into array one}
    for COL:=1 to MAX_COL do
      LIFE[1,ROW,COL]:=LIFE[2,ROW,COL];

  for ROW:=1 to MAX_ROW do        {swaps array three into array two}
    for COL:=1 to MAX_COL do
      LIFE[2,ROW,COL]:=LIFE[3,ROW,COL];

  for ROW:=1 to MAX_ROW do        {swaps array one into array three}
    for COL:=1 to MAX_COL do
      LIFE[3,ROW,COL]:=TEMP[ROW,COL];

end;
{}
procedure ACTIVATE_LIFE(VAR LIFE:LIFE_ARRAY);
(* this procedure applies John Conway's 3 rules of life to the LIFE grid, any
 changes are written to TEMP grid because of the linear fashion of the
 calculations two arrays are necesary. See the 3 rules at the top of the
 program. *)
var ROW,COL:integer; {row and column counters}
    KEY:char;        {record user input}

{}
function NEIGHBOURS(ROW,COL:integer):integer;
(* returns with the number of neighbours surrounding the position *)
var COUNTER:integer;
begin
  counter:=0;
  if LIFE[2,ROW-1,COL+1] then inc(COUNTER); {upper right}
  if LIFE[2,ROW-1,COL]   then inc(COUNTER); {upper}
  if LIFE[2,ROW-1,COL-1] then inc(COUNTER); {upper left}
  if LIFE[2,ROW,COL-1]   then inc(COUNTER); {left}
  if LIFE[2,ROW,COL+1]   then inc(COUNTER); {right}
  if LIFE[2,ROW+1,COL-1] then inc(COUNTER); {bottom left}
  if LIFE[2,ROW+1,COL]   then inc(COUNTER); {bottom}
  if LIFE[2,ROW+1,COL+1] then inc(COUNTER); {bottom right}
  NEIGHBOURS:=COUNTER;
end;
{}
begin
  for ROW:=1 to MAX_ROW do        {clears array buffer}
    for COL:=1 to MAX_COL do
      LIFE[3,ROW,COL]:=false;

(*  for ROW:=1 to MAX_ROW do
    for COL:= 1 to MAX_COL do   {debugging step}
       begin
         gotoxy(1,1);
         write(neighbours(row,col));
         delay(250);
         temp[row,col]:=life[row,col];
{         if neighbours(row,col)=1 then temp[row,col]:=true;}
         {if life_grid[row,col] then
         begin
           temp[row,col]:=false;
         end else temp[row,col]:=true;}
       end;*)
  for ROW:=1 to MAX_ROW do
    for COL:= 1 to MAX_COL do
       begin
          if LIFE[2,ROW,COL] then
            begin
              case NEIGHBOURS(ROW,COL) of
 {RULE #2}      0..1 : LIFE[3,ROW,COL]:=false;
 {RULE #3}      2..3 : LIFE[3,ROW,COL]:=true;
 {RULE #2}      4..8 : LIFE[3,ROW,COL]:=false;
              end;
            end else
            begin
 {RULE #1}    if NEIGHBOURS(ROW,COL)=3 then LIFE[3,ROW,COL]:=true;
            end;
       end;
end;
{}
procedure HIDE_CURSOR;assembler;
(* hides the cursor *)
asm
 mov ah,01h   {subfunction 01h - Set Text-mode cursor size}
 mov ch,04    {top scan line}
 mov cl,00    {bottom scan line}
 int 10h      {call video interrupt}
end;
{}
procedure SHOW_CURSOR;assembler;
(* makes the cursor visible again *)
asm
 mov ah,01h   {subfunction 01h - Set Text-mode cursor size}
 mov ch,04    {top scan line}
 mov cl,04    {bottom scan line}
 int 10h      {call video interrupt}
end;
{}
procedure MAIN;
var KEY:char;             {record user input}
    GENERATION:integer;   {a loop counter}
    LIMIT_10:boolean;     {proceed only 10 generations}
    LIFE_GRID: LIFE_ARRAY;{array for the current life}
    POSITION:integer;     {current array position}
begin
   INIT_VARIABLES(LIFE_GRID,LIMIT_10,GENERATION);   {clears the arrays and variables}
   DISPLAY_MESSAGE(LIMIT_10);          {gives info and 10 generation choice}
   HIDE_CURSOR;                        {hide the cursor form the user}
   GET_LIFE_INPUT(LIFE_GRID);          {allows the user to input the pattern}
   DRAW_LIFE(LIFE_GRID,GENERATION,LIMIT_10); {draws the life grid}
   KEY:=readkey;
     repeat
       ACTIVATE_LIFE(LIFE_GRID);         {applies Conways rules}
       inc(GENERATION);                  {increases the year by one}
       DRAW_LIFE(LIFE_GRID,GENERATION,LIMIT_10); {draws the life grid}
       KEY:=readkey;                     {read input from the user}
      SWAP(LIFE_GRID);                  {moves buffer to life grid and clears buffer}
     until (KEY=#27) or (LIMIT_10 and (GENERATION=10)) or STATIC(LIFE_GRID,1,2) or NO_LIFE(LIFE_GRID,2) or
     OSCILLATE(LIFE_GRID,2,3);
   if KEY=#27 then
   begin                      {put a check in the "user abort" field"}
     textcolor(11);
     gotoxy(49,15);
     write('');
   end;
   SHOW_CURSOR;
   textcolor(7);textbackground(0);         {return textcolor to normal}
   gotoxy(1,24);                           {goto bottom of screen}
end;
{}
begin
  MAIN;         {call the main procedure}
end.
