Program Gouraud_Shaded_Triangles;          { By Vulture/OT }

Uses Crt;

Const Vga = $0a000;                        { Vga segment }

Var Loop1: Byte;
    Delta: Word;                           { Global delta value }

Procedure VideoMode(Mode: Byte); Assembler;
Asm
    xor     ah,ah
    mov     al,Mode                        { Load vgamode }
    int     10h
End;

Procedure Set_Color(Color,R,G,B: Byte); Assembler;
Asm
    mov     dx,03c8h
    mov     al,Color                       { Load colorvalue (0..255) to alter }
    out     dx,al
    inc     dx
    mov     al,R                           { Red }
    out     dx,al
    mov     al,G                           { Green }
    out     dx,al
    mov     al,B                           { Blue }
    out     dx,al
End;

Procedure HLine(x1,x2,y: Word; C1,C2: Word; Where: Word);
Var Temp,Loop1,Offset,Color: Word;
Begin
  If x1 > x2 then                          { Swap x values if necessary }
  Begin
    Temp := x1;
    x1 := x2;
    x2 := Temp;
    Temp := c1;
    c1 := c2;
    c2 := Temp;
  End;

{  Calculate the horizontal stepvalue per scanline; this is the slow method }
{  If x2-x1 <> 0 then Delta := ((c2-c1) shl 8) div (x2-x1) else Exit;}

  Offset := (Y shl 8) + (Y shl 6);         { Calculate vga offset (y*320) }
  Color := c1 shl 8;                       { Draw the horizontal line }
  For Loop1 := x1 to x2 do
  Begin
    Mem[Where:Offset+Loop1] := Color shr 8;
    Inc(Color,Delta);
  End;
End;

Procedure Gouraud_Triangle(X1,Y1,X2,Y2,X3,Y3: Longint; C1,C2,C3: Longint; Where: Word);
Var LeftX: Array[0..199] of Word;
    RightX: Array[0..199] of Word;
    Color_L: Array[0..199] of Word;
    Color_R: Array[0..199] of Word;
    Temp,Loop1,
    DeltaX_Left1,
    DeltaX_Left2,
    DeltaX_Right,
    Delta_Color1,
    Delta_Color2,
    Delta_Color3,
    StartX,StartC: Longint;
    QX,QC: Word;
Begin
  If y1 > y3 then                          { y3 must be the largest y-value }
  Begin
    Temp := y3;
    y3 := y1;
    y1 := Temp;
    Temp := x3;
    x3 := x1;
    x1 := Temp;
    Temp := C3;
    C3 := C1;
    C1 := Temp;
  End;
  If y1 > y2 then                          { y1 must be the smallest y-value }
  Begin
    Temp := y2;
    y2 := y1;
    y1 := Temp;
    Temp := x2;
    x2 := x1;
    x1 := Temp;
    Temp := C2;
    C2 := C1;
    C1 := Temp;
  End;
  If y2 > y3 then                          { y2 must be the middle value }
  Begin
    Temp := y2;
    y2 := y3;
    y3 := Temp;
    Temp := x2;
    x2 := x3;
    x3 := Temp;
    Temp := C2;
    C2 := C3;
    C3 := Temp;
  End;

  If y2-y1 <> 0 then DeltaX_Left1 := ((x2-x1) shl 8) div (y2-y1) else DeltaX_Left1 := 0;
  If y2-y1 <> 0 then Delta_Color1 := ((c2-c1) shl 8) div (y2-y1) else Delta_Color1 := 0;

  StartX := X1 shl 8;
  StartC := C1 shl 8;
  For Loop1 := y1 to y2 do                 { Calculate first small side edges }
  Begin
    LeftX[Loop1] := StartX shr 8;
    Inc(StartX,DeltaX_Left1);
    Color_L[Loop1] := StartC shr 8;
    Inc(StartC,Delta_Color1);
  End;

  If y3-y2 <> 0 then DeltaX_Left2 := ((x3-x2) shl 8) div (y3-y2) else DeltaX_Left2 := 0;
  If y3-y2 <> 0 then Delta_Color2 := ((c3-c2) shl 8) div (y3-y2) else Delta_Color2 := 0;

  StartX := X2 shl 8;
  StartC := C2 shl 8;
  For Loop1 := y2+1 to y3 do               { Calculate second small side edges }
  Begin
    LeftX[Loop1] := StartX shr 8;
    Inc(StartX,DeltaX_Left2);
    Color_L[Loop1] := StartC shr 8;
    Inc(StartC,Delta_Color2);
  End;

  If y3-y1 <> 0 then DeltaX_Right := ((x3-x1) shl 8) div (y3-y1) else DeltaX_Right := 0;
  If y3-y1 <> 0 then Delta_Color3 := ((c3-c1) shl 8) div (y3-y1) else Delta_Color3 := 0;

  StartX := X1 shl 8;
  StartC := C1 shl 8;
  For Loop1 := y1 to y3 do                 { Calculate large side edges }
  Begin
    If Loop1 = y2 then                     { Get info on point Q ! }
    Begin
      QX := StartX shr 8;
      QC := StartC shr 8;
    End;
    RightX[Loop1] := StartX shr 8;
    Inc(StartX,DeltaX_Right);
    Color_R[Loop1] := StartC shr 8;
    Inc(StartC,Delta_Color3);
  End;

  If (X2-QX) <> 0 then Delta := ((C2-QC) shl 8) div (X2-QX) else Exit;

  For Loop1 := y1 to y3 do
    HLine(LeftX[Loop1],RightX[Loop1],Loop1,Color_L[Loop1],Color_R[Loop1],Where);
End;

Begin
  Randomize;
  Videomode($13);
  For Loop1 := 0 to 63 Do                  { Set colors for shading }
    Set_Color(Loop1,Loop1,Loop1,Loop1);

  Repeat
    Gouraud_Triangle(Random(320),Random(200),Random(320),Random(200),Random(320),Random(200),
                     Random(63),Random(63),Random(63),Vga);
  Until Keypressed;

  Videomode($3);
  Writeln('        ');
  Writeln('                    - An Outlaw Triad Production (c) 1997 -');
  Writeln;
  Writeln('                             CodeVulture');
  Writeln('                             TextInopia');
  Writeln;
  Writeln('                            -= Outlaw Triad Is =-');
  Writeln;
  Writeln('Vulture/code  Archangel/artist  Priest/objects  Xplorer/artist  Inopia/code');
  Writeln;
  Writeln('');
End.


{
   For usage in your 3d engine:

   Calculate the colors of the three 3d points of the triangle by taking the
   dotproduct of the rotated vertex normal and the lightvector, then use this
   triangle routine. You should have a nice little 3d gouraud engine running.

   Ah, this little example program might just contain a few errors. Take a
   good look at the colors and discover that it sometimes gets out of range.
   (uses colors outside the colors we selected for the shading...)

   Read OTLIGHT.DOC and OTREMOVE.DOC for more info on normals.

                    -Vulture/OT-
}