/* Graphics stuff */
#include <wgt5.h>

/* Audio stuff */
#include "audio.h"
#include "import.h"
#include "timer.h"

/* Kosmic Music Explorer

 Written by Chris Egerter

 Project start: May 1, 12:35pm
 Washroom break: 1:30pm
 Finished interface and added Music system: 1:36pm
 Testing...
 Project end: 1:45pm

*/

/* Button regions */
#define BUTTON_EXIT 2,18,50,32
#define BUTTON_VOLUME_UP 107,18,123,32
#define BUTTON_VOLUME_DOWN 127,18,143,32
#define BUTTON_PAUSE 161,18,215,32

#define INFO_BAR 1,190,318,198

char *song_names[] =
 {"believe.s3m", "flyer.s3m", "vision.s3m", "deliver.s3m",
  "lost.s3m", "effect.s3m",
  "groove.s3m", "deep.s3m", "house.s3m", "mystical.s3m",
  "werewolf.s3m", "intoswmp.s3m"};

wgtfont teenyweeny;

block background;
color pal[256];

#define KEY_ESC 1


/* Music system */
SoundCard SC;
Driver *D;
MHdr *P;
DSM *M=NULL;
int playingsong = -1;
extern void SetupProgram (SoundCard *SC);


void timer (void)
{
 dPoll ();
}

void start_music_system (void)
{
  SetupProgram (&SC);
  dRegisterDrivers();
}


void start_playing_music (char *songname)
{
 int form;
 short i;
 

  if (M != NULL)
    {
     stop_playing_music ();
     M = NULL;
    }

   /* initialize the sound system */
  if (dInit (&SC))
    {
     wfreeblock (background);
     moff ();
     uninstallkbd ();
     mdeinit ();
     wsetmode (3);
     printf("Error initializing the sound system.\n");
     exit(-1);
    }

  dInitTimer();
  dStartTimer(timer,TICKS(70.1));
   
  /* load module file */
  if (!(M = dImportModule(songname, FORM_S3M))) {
        stop_music_system ();
        wfreeblock (background);
        moff ();
        uninstallkbd ();
        mdeinit ();
	wsetmode (3);
	printf("Error (%03d) loading %s module file: %s.\n",
               dError, songname, dErrorMsg[dError]);
	exit(-1);
     }

  /* setup voices and start playing the module */
  dSetupVoices (M->Header.NumTracks, M->Header.MasterVolume);
 
  M->Header.ReStart = 0;
  dPlayMusic (M);
  P = dGetMusicStruc ();
}


void stop_playing_music (void)
{
 dSetMusicVolume (0);
 dStopMusic ();
 dFreeModule (M);
 M = NULL;

 dStopTimer();
 dDone ();
 dDoneTimer ();
}


void stop_music_system (void)
{
 dSetMusicVolume (0);
 dStopTimer();
 dDone ();
 dDoneTimer ();
}



int over_title (int x, int y)
/* Returns the song number the mouse is over, otherwise returns -1 */
{
int i;
int choice;

  choice = -1;

  if (x < 186)  /* Left set */
    {
     for (i = 0; i < 6; i++)
       if ((x >= 4) && (x <= 156) && (y >= i * 21 + 46) && (y <= i * 21 + 60))
         choice = i;
    }
  else           /* Right set */
    {
     for (i = 0; i < 6; i++)
       if ((x >= 186) && (x <= 316) && (y >= i * 21 + 46) && (y <= i * 21 + 60))
         choice = i + 6;
    }
  return (choice);
}


int hit_button (int x1, int y1, int x2, int y2)
/* Returns 1 if the mouse is inside the region */
{
 if ((mouse.mx >= x1) && (mouse.mx <= x2) &&
     (mouse.my >= y1) && (mouse.my <= y2))
   return 1;
 else
   return 0;
}





void main (void)
{
int buttons;
int clicked;
int song;
int volume;
int oldsong=-2;

  /* See if a mouse exists */
  buttons = minit ();
  if (buttons < 1)
    {
     printf ("You need a mouse with at least one button! :)\n");
     exit (1);
    }

  start_music_system ();

  /* Install the custom keyboard handler */
  installkbd ();

  vga256 ();

  background = wloadpcx ("musex.pcx", pal);
  wsetpalette (0, 255, pal);
  wputblock (0, 0, background, 0);

  teenyweeny = wloadfont ("little.wfn");


  mon ();

  do {
   clicked = -1;
   if (mouse.but)
     {
      if (hit_button (BUTTON_EXIT))
        clicked = 0;
      else if (hit_button (BUTTON_VOLUME_UP))
        {
         volume = P->MusicVolume;
         if ((volume += 4) >= 256)
           volume = 256;
         dSetMusicVolume (volume);
        }
      else if (hit_button (BUTTON_VOLUME_DOWN))
        {
         volume = P->MusicVolume;
         if ((volume -= 4) <= 0)
           volume = 0;
         dSetMusicVolume (volume);
        }
      else if (hit_button (BUTTON_PAUSE))
        {
         if (dGetMusicStatus () == PS_PLAYING)
           dPauseMusic ();
         else dResumeMusic ();
         noclick ();
        }

     }

   song = over_title (mouse.mx, mouse.my);
   if ((song >= 0) && (!mouse.but) && (oldsong != song))
     {  /* Over a song but not clicking on it */
      oldsong = song;
      wsetcolor (31);
      wbar (INFO_BAR);
      wgtprintf (3,190, teenyweeny,
          "http://kosmic.org/songs/gooroo/%s", song_names[song]);
     }
   if ((song >= 0) && (mouse.but))
     {  /* Over a song AND clicking on it */
      start_playing_music (song_names[song]);
     }


   wretrace ();
  } while ((!kbdon[KEY_ESC]) && (clicked != 0));


  stop_music_system ();
  wfreeblock (background);
  moff ();
  uninstallkbd ();
  mdeinit ();

  wsetmode (3);
  printf ("Kosmic Music Explorer\n");
  printf ("All songs composed by Chris Egerter\n");
  printf ("WGT 5.1 by Egerter Software (http://www.wwdc.com/egerter)\n");
  printf ("DSIK 2 by Carlos Hasan\n");
}
