{$G+}
program ShadeBob3;

uses crt;

const VGA : word = $A000;
      SinOfs = 40;        { Offset                     }
      SinAmp = 50;        { Amplitude                  }
      SinLen = 255;       { und Lnge der Sinustabelle }
      SprPic : array[0..15,0..15] of byte = (
        (0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0),
        (0,0,0,0,2,2,3,3,3,3,2,2,0,0,0,0),
        (0,0,0,2,3,3,3,3,3,3,3,3,2,0,0,0),
        (0,0,2,3,3,3,3,3,3,3,3,3,3,2,0,0),
        (0,2,3,3,3,3,3,3,3,3,3,3,3,3,2,0),
        (0,2,3,3,3,3,3,3,3,3,3,3,3,3,2,0),
        (2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2),
        (2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2),
        (2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2),
        (2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2),
        (0,2,3,3,3,3,3,3,3,3,3,3,3,3,2,0),
        (0,2,3,3,3,3,3,3,3,3,3,3,3,3,2,0),
        (0,0,2,3,3,3,3,3,3,3,3,3,3,2,0,0),
        (0,0,0,2,3,3,3,3,3,3,3,3,2,0,0,0),
        (0,0,0,0,2,2,3,3,3,3,2,2,0,0,0,0),
        (0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0)
      );

var SinTab : array[0..SinLen] of word;
    Pal : array[0..767] of byte;
    X,Y,n       : integer;
    I1,I2,J1,J2 : byte;

procedure SetPalette;assembler;    { Setzt die Palette in Pal }
asm
  mov     dx,3C8h
  xor     al,al
  out     dx,al
  mov     cx,768
  mov     dx,3C9h
  mov     si,offset pal
@Jmp1:
  lodsb
  out     dx,al
  loop    @Jmp1
end;

procedure BluePal;   { Schreibt eine blaue Palette in Pal setzt sie mittels }
var loop : integer;  { SetPalette }

begin
  for loop := 0 to 31 do begin
    pal[loop*3+2] := loop * 2;
    pal[(63-loop)*3+2] := loop * 2;
    pal[(loop+64)*3+2] := loop * 2;
    pal[(127-loop)*3+2] := loop * 2;
    pal[(loop+128)*3+2] := loop * 2;
    pal[(191-loop)*3+2] := loop * 2;
    pal[(loop+192)*3+2] := loop * 2;
    pal[(255-loop)*3+2] := loop * 2;
  end;
  setpalette;
end;

procedure CalcSinus(SinPar:byte);
begin
  for n := 0 to SinLen do
    SinTab[n] := round(sin(n*SinPar*pi/SinLen)*SinAmp)+SinOfs;
end;

procedure WaitRetrace;assembler;
asm
  mov     dx,3DAh
@loop1:
  in      al,dx
  and     al,08h
  jz      @loop1
@loop2:
  in      al,dx
  and     al,08h
  jz      @loop2
end;

procedure SetBob(X,Y:word;W,H:byte;Sprite:pointer);assembler;
asm
  push    ds                       { DS sichern }
  lds     si,[Sprite]              { DS:SI mit dem Spritepointer laden }
  mov     es,vga                   { VGA-Segment nach ES }
  cld
  mov     ax,Y                     { Offset des Bobs berechnen }
  shl     ax,6
  mov     di,ax
  shl     ax,2
  add     di,ax
  add     di,X
  mov     bh,H
  mov     cx,320
  sub     cl,W
  sbb     ch,0
@L:
  mov     bl,W
@L2:
  lodsb                            { Wert laden }
  or      al,al                    { Wert = 0 ? }
  jz      @S                       { Wenn ja, nicht erhhen }
  mov     dl,es:[di]               { Pixelwert vom VGA holen }
  add     dl,al                    { Wert erhhen }
  and     dl,63
  mov     es:[di],dl               { und neuen Pixelwert schreiben }
@S:
  inc     di                       { nchste Pixelposition }
  dec     bl                       { Zhler dekrementieren }
  jnz     @L2                      { wenn <> 0 dann innerer Loop }
  add     di,cx                    { nchste Zeile auf VGA }
  dec     bh                       { Zhler dekrementieren }
  jnz     @L                       { wenn <> 0 dann uerer Loop }
  pop     ds
end;


begin
  asm mov ax,13h; int 10h end;
  BluePal;
  randomize;
  CalcSinus(random(8));  { Sinustabelle berechnen }
  I1 := 0;               { Indizes fr Sinustabelle }
  I2 := 200;
  J1 := 0;
  J2 := 200;
  repeat
    X := SinTab[I1]+SinTab[I2];  { Werte addieren }
    Y := SinTab[J1]+SinTab[J2];
    inc(I1,2);                   { Neue Indexwerte }
    inc(I2,3);
    inc(J1);
    inc(J2,2);
    waitretrace;
    SetBob(80+X,Y,16,16,addr(SprPic)); { Bob zeichnen }
  until keypressed;
  readkey;
  asm mov ax,3; int 10h end;
end.
