{$G+}
program Fading;

uses crt;

var Pal   : array[0..255,1..3] of byte;
    n1,n2 : word;

procedure PutPixel(x,y:integer;col:byte);assembler;
asm
  mov     ax,0A000h
  mov     es,ax
  mov     bx,[x]
  mov     dx,[y]
  mov     di,bx
  mov     bx,dx
  shl     dx,8
  shl     bx,6
  add     dx,bx
  add     di,dx
  mov     al,[col]
  stosb                          
end;

procedure SetPal(col,R,G,B:byte);
begin
  port[$3C8] := col;
  port[$3C9] := R;
  port[$3C9] := G;
  port[$3C9] := B;
end;

procedure GetPal(col:byte;var R,G,B:byte);
begin
  port[$3C7] := col;
  R := port[$3C9];
  G := port[$3C9];
  B := port[$3C9];
end;

procedure WaitRetrace;assembler;
asm
  mov     dx,3DAh
@x:
  in      al,dx
  test    al,08h
  jnz     @x
@y:
  in      al,dx
  test    al,08h
  jz      @y
end;

procedure BlackPal;
var n : byte;

begin
  WaitRetrace;
  for n := 0 to 255 do SetPal(n,0,0,0);
end;

procedure GrabPal;
var n : byte;

begin
  for n := 0 to 255 do GetPal(n,Pal[n,1],Pal[n,2],Pal[n,3]);
end;

procedure FadeUp;
var n1,n2 : byte;
    Tmp   : array[1..3] of byte;

begin
  for n1 := 1 to 64 do begin
    WaitRetrace;
    For n2 := 0 to 255 do begin
      GetPal(n2,Tmp[1],Tmp[2],Tmp[3]);
      if Tmp[1] < Pal[n2,1] then inc (Tmp[1]);
      if Tmp[2] < Pal[n2,2] then inc (Tmp[2]);
      if Tmp[3] < Pal[n2,3] then inc (Tmp[3]);
      SetPal(n2,Tmp[1],Tmp[2],Tmp[3]);
    end;
  end;
end;

procedure FadeDown;
var n1,n2 : byte;
    Tmp   : array[1..3] of byte;

begin
  for n1 := 1 to 64 do begin
    WaitRetrace;
    For n2 := 0 to 255 do begin
      GetPal(n2,Tmp[1],Tmp[2],Tmp[3]);
      if Tmp[1] > 0 then dec (Tmp[1]);
      if Tmp[2] > 0 then dec (Tmp[2]);
      if Tmp[3] > 0 then dec (Tmp[3]);
      SetPal(n2,Tmp[1],Tmp[2],Tmp[3]);
    end;
  end;
end;

procedure SetMCGAMode;assembler;
asm
  mov     ax,13h
  int     10h
end;

procedure SetTextMode;assembler;
asm
  mov     ax,3
  int     10h
end;


begin
  SetMCGAMode;
  GrabPal;
  BlackPal;
  for n1 := 0 to 319 do
    for n2 := 0 to 199 do PutPixel(n1,n2,random(256));
  FadeUp;
  readkey;
  FadeDown;
  SetTextMode;
end.
