;

;Yay, binary trees and radix sorts

;

palette dd 256 dup ( 0 )

;

struc   split_node
value           dd ?
component       dd ?
lighter         dd ?
darker          dd ?
ends

;
;In:
;       Setup the colourlist(len).  This is an array of 32 bit r,g,b
;       truecolour colours

align 32
proc    build_palette n

        msg     "Building palette"
        endl

        mov     ecx, 511 * size split_node
        call    new
        jc      error
        mov     [split_tree], eax

        mov     ecx, [colourlistlen]
        imul    ecx, size radix_node
        call    new
        jc      error
        mov     [mem_src], eax

        call    new
        jc      error
        mov     [mem_dest], eax

        ;an 8 level binary tree - 256 leaf nodes at the end
        mov     eax, 8
        xor     ecx, ecx
        mov     edx, [split_tree]

@@sort_levels:
        push    eax ecx
        call    do_level
        pop     ecx eax
        inc     ecx
        dec     eax
        jnz     @@sort_levels

        mov     edi, o palette
        call    do_level

        call    build_split_tree

        mov     eax, [mem_src]
        call    delete
        jc      error
        mov     eax, [mem_dest]
        call    delete
        jc      error

        ret            

endp

split_tree      dd ?

;
;This just builds another binary tree of r,g,b space divisions

align 32
proc    build_split_tree n

        msg     " Building palette-tree"
        endl

        xor     eax, eax
        mov     ecx, 256
        mov     esi, [split_tree]
        add     esi, (511-256) * size split_node

@@make_leaves:
        mov     [esi + split_node.darker], eax
        add     esi, size split_node
        dec     ecx
        jnz     @@make_leaves

        mov     ecx, 1
        mov     esi, [split_tree]
        lea     edi, [esi + size split_node]
        mov     ebp, 8

@@do_row:
        push    ecx

@@do_links:
        mov     [esi + split_node.darker], edi
        add     edi, size split_node
        mov     [esi + split_node.lighter], edi
        add     edi, size split_node
        add     esi, size split_node
        dec     ecx
        jnz     @@do_links

        pop     ecx

        add     ecx, ecx

        dec     ebp
        jnz     @@do_row

        ret

endp

;
;Add another level to the binary tree

;In
;       ecx: level

align 32
proc    do_level n

        mov     eax, 1
        shl     eax, cl
        xor     ebx, ebx

        cmp     ecx, 8  
        je      @@level8

@@do_1sort:
        push    eax ebx ecx
        call    sort_startend
        call    get_major_axis

        mov     [edx + split_node.component], eax

        mov     ebx, esi
        mov     ecx, edi
        sub     ebx, [colourlist]
        sub     ecx, [colourlist]
        shr     ebx, 2
        shr     ecx, 2
        add     ebx, ecx
        shr     ebx, 1
        shl     ebx, 2
        add     ebx, [colourlist]

        push    ebx edx
        call    sort_list
        pop     edx ebx

        mov     eax, [ebx]
        mov     [edx + split_node.value], eax
        add     edx, size split_node

        pop     ecx ebx eax
        inc     ebx
        dec     eax
        jnz     @@do_1sort

        ret

@@level8:
        push    eax ebx ecx
        push    edi

        push    ebx
        call    sort_startend
        pop     ebx

        mov     [edx + split_node.value], ebx
        add     edx, size split_node

        push    edx
        call    mean
        pop     edx

        pop     edi
        mov     [edi], eax
        add     edi, 4

        pop     ecx ebx eax
        inc     ebx
        dec     eax
        jnz     @@level8

        ret

endp

;
;In:
;       ebx: sort number
;       ecx: sort level

align 32
proc    sort_startend n

        xor     esi, esi
        mov     edi, [colourlistlen]
        test    ecx, ecx
        jz      @@gotit

        mov     ebp, ecx
        sub     ecx, 8
        neg     ecx
        shl     ebx, cl

@@recurse:
        lea     eax, [esi + edi]
        shr     eax, 1
        add     bl, bl
        jc      @@left

@@right:
        mov     edi, eax
        jmp     @@done_lr

@@left:
        mov     esi, eax

@@done_lr:
        dec     ebp
        jnz     @@recurse

@@gotit:
        shl     esi, 2       
        shl     edi, 2       
        add     esi, [colourlist]
        add     edi, [colourlist]
        ret

endp

;
;In:
;       esi, edi: start, end
;Out:
;       eax: major axis > 0, 1, 2 > r, g, b

align 32
proc    get_major_axis n

        mov     ebx, esi
        mov     ecx, edi
        sub     ecx, esi
        shr     ecx, 2
        jz      @@done

        mov     eax, -1  
        mov     [@@rmin], eax
        mov     [@@gmin], eax
        mov     [@@bmin], eax
        xor     eax, eax
        mov     [@@rmax], eax
        mov     [@@gmax], eax
        mov     [@@bmax], eax

@@get_1:
        mov     al, [ebx]
        cmp     eax, [@@rmin]
        jae     @@rmin_ok

        mov     [@@rmin], eax

@@rmin_ok:
        cmp     eax, [@@rmax]
        jbe     @@rmax_ok

        mov     [@@rmax], eax

@@rmax_ok:
        mov     al, [ebx + 1]
        cmp     eax, [@@gmin]
        jae     @@gmin_ok

        mov     [@@gmin], eax

@@gmin_ok:
        cmp     eax, [@@gmax]
        jbe     @@gmax_ok

        mov     [@@gmax], eax

@@gmax_ok:
        mov     al, [ebx + 2]
        cmp     eax, [@@bmin]
        jae     @@bmin_ok

        mov     [@@bmin], eax

@@bmin_ok:
        cmp     eax, [@@bmax]
        jbe     @@bmax_ok

        mov     [@@bmax], eax

@@bmax_ok:
        add     ebx, 4
        dec     ecx
        jnz     @@get_1

        mov     eax, [@@rmax]
        mov     ebx, [@@gmax]
        mov     ecx, [@@bmax]
        sub     eax, [@@rmin]
        sub     ebx, [@@gmin]
        sub     ecx, [@@bmin]

        cmp     eax, ebx
        jl      @@not_r
        cmp     eax, ecx
        jl      @@not_r
        jmp     @@r

@@not_r:
        cmp     ebx, ecx
        jl      @@not_g
        jmp     @@g

@@not_g:
        ;jmp     @@b

@@b:
        mov     eax, 2  
        ret
@@g:
        mov     eax, 1  
        ret
@@r:
@@done:
        xor     eax, eax
        ret

@@rmin  dd ?  
@@rmax  dd ?
@@gmin  dd ?  
@@gmax  dd ?
@@bmin  dd ?
@@bmax  dd ?

endp

;
;In:
;       esi, edi: start, end
;Out:
;       eax: mean r, g, b

align 32
proc    mean n

        xor     eax, eax

        mov     ebx, esi
        mov     ecx, edi
        sub     ecx, esi
        shr     ecx, 2
        jz      @@done

        push    ecx esi
        xor     eax, eax
        xor     ebx, ebx
        xor     edx, edx

@@red:
        mov     bl, [esi]
        add     eax, ebx
        adc     edx, 0
        add     esi, 4
        dec     ecx
        jnz     @@red

        pop     esi ecx

        div     ecx
        mov     [@@r], al

        push    ecx esi
        xor     eax, eax
        xor     ebx, ebx
        xor     edx, edx

@@green:
        mov     bl, [esi + 1]
        add     eax, ebx
        adc     edx, 0
        add     esi, 4
        dec     ecx
        jnz     @@green

        pop     esi ecx

        div     ecx
        mov     [@@g], al

        push    ecx esi
        xor     eax, eax
        xor     ebx, ebx
        xor     edx, edx

@@blue:
        mov     bl, [esi + 2]
        add     eax, ebx
        adc     edx, 0
        add     esi, 4
        dec     ecx
        jnz     @@blue

        pop     esi ecx

        div     ecx
        mov     [@@b], al

        xor     eax, eax
        mov     ah, [@@b]
        shl     eax, 8
        mov     ah, [@@g]
        mov     al, [@@r]

@@done:
        ret

@@r     db ?
@@g     db ?
@@b     db ?

endp

;
;In:
;       eax: r,g,b 24 bit colour
;Out:
;       eax: 8bit palette colour

align 32
proc    quantize_colour n

        wait_esc

        mov     [@@rgb], eax
        mov     esi, [split_tree]

@@recurse_split_tree:
        cmp     [esi + split_node.darker], 0
        je      @@got_it
        
        mov     eax, [esi + split_node.component]
        lea     ebx, [eax + esi]
        mov     al, [eax + o @@rgb]
        cmp     al, [b ebx + split_node.value]
        jb      @@goto_darker

@@goto_lighter:
        mov     esi, [esi + split_node.lighter]
        jmp     @@recurse_split_tree

@@goto_darker:
        mov     esi, [esi + split_node.darker]
        jmp     @@recurse_split_tree

@@got_it:
        mov     eax, [esi + split_node.value]
        ret

@@rgb   dd ?

endp

;
;In:
;       esi, edi: start, end of array
;       eax: sort_key > 0, 1, 2 > r, g, b

align 32
proc    sort_list n

        cmp     eax, 1
        jb      @@red
        ja      @@blue
        je      @@green

@@red:
        mov     [masks], 00ffh
        mov     [shifts], 0
        jmp     @@ok

@@green:
        mov     [masks], 0ff00h
        mov     [shifts], 8
        jmp     @@ok

@@blue:
        mov     [masks], 0ff0000h
        mov     [shifts], 16

@@ok:
        push    esi edi
        call    init_radix
        pop     edi esi

        push    esi edi
        mov     eax, edi
        sub     eax, esi
        shr     eax, 2
        jz      @@done
                  
@@add_nodes:
        mov     ecx, [esi]
        push    eax esi
        call    add_radix_node
        pop     esi eax
        add     esi, 4
        dec     eax
        jnz     @@add_nodes

        call    radix_sort
        pop     edi esi

        push    esi edi
        mov     edi, esi
        call    combine_bins

@@done:
        pop     edi esi
        ret

endp

;

struc   radix_node
sort_key        dd ?
next            dd ?
ends

align 32
proc    init_radix n

        mov     eax, [mem_dest]
        mov     [dest_mem_tail], eax

        xor     eax, eax
        mov     ecx, [bins]
        mov     edi, o dest_bin_heads
        rep stosd

        mov     [pass], eax
        ret

endp

align 4
passes          dd 1
pass            dd ?
bits            dd 8
bins            dd 256
masks           dd 0ffh
shifts          dd 0

src_bin_heads   dd 256 dup ( ? )
dest_bin_heads  dd 256 dup ( ? )
dest_bin_tails  dd 256 dup ( ? )

mem_src         dd ?
mem_dest        dd ?
dest_mem_tail   dd ?

;
;In:
;       ecx: sort key
;       
align 32
proc    add_radix_node n

        mov     ebp, ecx
        mov     edx, [pass]
        xor     esi, esi
        mov     edi, [dest_mem_tail]

        mov     ebx, ecx
        and     ebx, [edx*4 + o masks]
        mov     ecx, [edx*4 + o shifts]
        shr     ebx, cl
        shl     ebx, 2

        cmp     [ebx + o dest_bin_heads], esi
        jne     @@not_first_in_bin

        mov     [ebx + o dest_bin_heads], edi
        mov     [ebx + o dest_bin_tails], edi

@@not_first_in_bin:
        mov     edx, [ebx + o dest_bin_tails]
        mov     [edx + radix_node.next], edi
        mov     [ebx + o dest_bin_tails], edi

        mov     [edi + radix_node.sort_key], ebp
        mov     [edi + radix_node.next], esi

        add     [dest_mem_tail], size radix_node
        ret

endp

;

align 32
proc    radix_sort n

        mov     ebp, [passes]
        dec     ebp
        jz      @@done

        inc     [pass]

@@radix_pass:
        mov     edx, [pass]
        shl     edx, 2

        mov     esi, o dest_bin_heads
        mov     edi, o src_bin_heads
        mov     ecx, [edx + o bins - 4]
        rep movsd

        xor     eax, eax
        mov     ecx, [edx + o bins - 4]
        mov     edi, o dest_bin_heads
        rep stosd

        mov     eax, [mem_src]
        xchg    eax, [mem_dest]
        mov     [mem_src], eax

        mov     eax, [mem_dest]
        mov     [dest_mem_tail], eax

        push    ebp
        mov     eax, [edx + o bins - 4]
        shl     eax, 2
        xor     ecx, ecx

@@do_1bin:
        mov     esi, [ecx + o src_bin_heads]

        push    eax ecx
        call    transfer_bin
        pop     ecx eax

        add     ecx, 4
        cmp     ecx, eax
        jb      @@do_1bin

        pop     ebp
        inc     [pass]
        dec     ebp
        jnz     @@radix_pass

@@done:
        ret

endp

;

align 32
proc    transfer_bin n

@@transfer:
        test    esi, esi
        jz      @@done

        mov     ecx, [esi + radix_node.sort_key]
        push    esi
        call    add_radix_node
        pop     esi
        mov     esi, [esi + radix_node.next]
        jmp     @@transfer

@@done:
        ret

endp

;
;If you want to use this to sort complex data types, just add
;a '.data' or something to the radix_node struc and pass in an
;extra pointer to add_radix_node that is stored in radix_node.data

;You'll have to update all references to .sort_key to include .data
;e.g. transfer_bin and combine_bins so that it keeps track of the
;extra data in the struck

;You could then use .data as a pointer to a polygon, etc.

;In:
;       edi: ptr to dest list of sort_keys

align 32
proc    combine_bins n

        mov     ecx, [passes]
        dec     ecx
        mov     ecx, [ecx*4 + o bins]

        xor     edx, edx
        mov     esi, o dest_bin_heads

@@cbin:
        push    esi

        mov     esi, [esi]
        test    esi, esi
        jz      @@done1

@@pnum:
        mov     eax, [esi + radix_node.sort_key]
        mov     [edi], eax
        add     edi, 4
        mov     esi, [esi + radix_node.next]
        test    esi, esi
        jnz     @@pnum

@@done1:
        pop     esi
        add     esi, 4
        inc     edx
        dec     ecx
        jnz     @@cbin

        ret

endp

;
