{$D-,L-,Y-,N+,E-}
program _3d_convert;
uses tools3d;

procedure error(s:string);
begin
  writeln(s);
  halt(1);
end;

function Check(var s: string; what: string): boolean;
var
  p: byte;
begin
  p := pos(what,s);
  check := true;
  if p = 1 then
    delete(s,1,length(what))
  else
    check := false;
end;

function GetStr(var s: string; del: string): string;
var
  p: byte;
begin
  p := pos(del, s);
  if p <> 0 then
  begin
    GetStr := copy(s,1,p-1);
    delete(s,1,p+length(del)-1);
  end
  else
    error('bad file');
end;

function GetReal(var s: string; del: string): real;
var
  temps: string;
  tempn: real;
  p,e: integer;
begin
  p := pos(del, s);
  if p <> 0 then
  begin
    temps := copy(s,1,p-1);
    delete(s,1,p+length(del)-1);
    val(temps,tempn,e);
    GetReal := tempn;
  end
  else
  begin
    val(s, tempn, e);
    GetReal := tempn;
  end;
  if e <> 0 then
    error('bad file');
end;

function GetWord(var s: string; del: string): word;
var
  temps: string;
  tempn: word;
  p,e: integer;
begin
  p := pos(del, s);
  if p <> 0 then
  begin
    temps := copy(s,1,p-1);
    delete(s,1,p+length(del)-1);
    val(temps,tempn,e);
    GetWord := tempn;
  end
  else
  begin
    val(s, tempn, e);
    GetWord := tempn;
  end;
  if e <> 0 then
    error('bad file');
end;

type
  vert = record x,y,z : real end;
  vertmap = record x,y,z,u,v: real end;
  face = record a,b,c: word end;
var
  f: text;
  l, objname: string;
  fn: string;
  mapped: boolean;

procedure grabvertex( m: string; max: word );
var
  vn: word;
  v: vert;
  vm: vertmap;
begin
  if not check(m,'list') then
  begin
    vn := GetWord(m,':  X:');
    if mapped then
    begin
      vm.x := GetReal(m,'     Y:');
      vm.y := GetReal(m,'     Z:');
      vm.z := GetReal(m,'     U:');
      vm.u := GetReal(m,'     V:');
      vm.v := GetReal(m,'');
      triad(round(vm.x), round(vm.y), round(vm.z), vn = max-1 );
      if vn = max-1 then
        faceheader;
    end
    else
    begin
      v.x := GetReal(m,'     Y:');
      v.y := GetReal(m,'     Z:');
      v.z := GetReal(m,'     U:');
      triad(round(v.x), round(v.y), round(v.z), vn = max-1 );
      if vn = max-1 then
        faceheader;
    end
  end;
end;

procedure grabface(m: string; max: word );
var
 fn: word;
 f: face;
begin
  if not check(m,'list') then
  begin
    fn := GetWord(m, ':    A:');
    f.a := GetWord(m, ' B:');
    f.b := GetWord(m, ' C:');
    f.c := GetWord(m, ' AB:');
    triad(f.a, f.b, f.c, fn = max-1);
  end;
end;

procedure dumpobject( name: string );
var
  nv, nf, i: integer;
  m : string;
begin
  writeln('processing object ''',name,'''');
  nv := GetWord(l,'     Faces: ');
  nf := GetWord(l,'');
  openout(name);
  header(nv,nf);
  readln(f,l);
  mapped := check(l,'Mapped');
  readln(f,l);
  m := l;
  while not (check(m,'Named object') or eof(f)) do
  begin
    if Check(m,'Vertex ') then
      grabvertex(m,nv)
    else
      if Check(m, 'Face ') then
        grabface(m,nf);
    readln(f,l);
    m := l;
  end;
  ending;
  closeout;
end;

begin
  getcfg;
  if paramcount <> 1 then
  begin
    write('enter the filename: ');
    readln(fn);
  end
  else
    fn := paramstr(1);
  assign(f,fn);
  {$I-}
  reset(f);
  if ioresult <> 0 then
    error('file '+fn+' not found');
  {$I+}
  readln(f,l);
  while not eof(f) do
  begin
    if Check(l, 'Named object: "') then
    begin
      objname := getstr(l,'"');
      readln(f,l);
      if Check(l, 'Tri-mesh, Vertices: ') then
        dumpobject(objname)
      else
        readln(f,l)
    end
    else
      readln(f,l);
  end
end.