//THE KING MAGAZINE UNIT FOR C               //
//WRITING BY THE KING IN 01/02/96            //
#include <stdio.h>
#include <process.h>
#include <dos.h>
#include <conio.h>
#include <mem.h>

#define FALSE        0
#define TRUE         1

#define M_NONE       0
#define M_LEFT       1
#define M_RIGHT      2
#define M_LEFTRIGHT  3

#ifdef __cplusplus
    #define __CPPARGS ...
#else
    #define __CPPARGS
#endif*/

//struct for the 3 values of the palettes.
struct sRGB {
    char red,green,blue;
};
//struct of 256 colors of the color type.
typedef sRGB PaletteType [256];

//mouse struct
struct mousestruct {
    unsigned int x,y;
    char buttons;
};

//CEL format header.
struct sCelHeader {
    int sign;                     //sign of the .CEL format.
    int w,h,x,y;                  //size and place..
    char depth,compress;          //compression type..
    long data;                    //size of BITMAP.
    char filler[16];              //Not use...
    PaletteType pal;              //The Pallette of the .CEL.
};

//keyboard keys.

char keys[128];
mousestruct mouse;
void interrupt(*old9int)(__CPPARGS);

//-------------------Set Modes Routines----------------//

//set mode to 320x200x256 colors..
void SetMode()
{
    asm {
        mov ah,0x00
        mov al,0x13
        int 0x10
    }

}

//set to 80x25 text mode.
void SetTextMode()
{
    asm {
        mov ah,0x00
        mov al,0x03
        int 0x10
    }

}

//----------------------------Graphics Routines-----------------------------//

//------------------------------------------------//
//Plot a single pixel on the screen .             //
//------------------------------------------------//
void PutPixel(int X,int Y,unsigned char Col) {
    asm {
    mov ax,0xa000     //Ax = SEGMENT OF THE SCREEN//
    mov es,ax         //Es = SEGMENT OF THE SCREEN//
    mov ax,320        //Ax = MAX VERTICAL LINE//
    mul Y             //Ax = AX * Y = HORIZONTAL LINE//
    add ax,X          //Ax = VERTICAL LINE + HORIZONTAL LINE = OFFSET//
    mov di,ax         //DI = OFFSET//
    mov al,Col        //AL = COLOR//
    stosb             //[0A000h:OFFSET] = COLOR//
    }
}

//-----------------------------------------//
// Show Picture On Screen .                //
//-----------------------------------------//

void ShowPic(unsigned char *Pic)
{
asm {
    push ds
    mov ax,word(Pic+2)                //Take The Segment Of Pic
    mov ds,ax
    xor si,si                         //Si = 0
    mov ax,0xa000
    mov es,ax
    xor di,di                         //Di = 0
    mov cx,32000                      //32000*2 = 64000
    rep movsw                         //Move 32000*2 Bytes
    pop ds
    }
}

//------------------------------Palette Routines----------------------------//

//-------------------------------------------------------//
//Get Red Green And Blue From a Color                    //
//-------------------------------------------------------//

void GetColor(unsigned char Col,char &R,char &G,char &B)
{
    asm {
    mov dx,0x3c7                  //Set To GET COLOR
    mov al,Col
    out dx,al
    inc dx                       //Dx = 3c8H
    inc dx                       //Dx = 3c9H
    les di,R                     //Es:Di = R
    in al,dx                     //Get Red Value
    mov [es:di],al               //R = Red Value
    in al,dx                     //Get Green Value
    les di,G                     //Es:Di = G
    mov [es:di],al               //G = Green Value
    in al,dx                     //Get Blue Value
    les di,B                     //Es:Di = B
    mov [es:di],al               //B = Blue Value
    }
}

//-------------------------------------------------------//
//Set Red Green And Blue To a Color                      //
//-------------------------------------------------------//

void SetColor(unsigned char Col,char R,char G,char B)
{
asm {
    mov dx,0x3c8                 //SET TO SET COLOR
    mov al,Col
    out dx,al
    inc dx                       //DX = 3c9h
    mov al,R                     //Senting Red Value
    out dx,al
    mov al,G                     //Senting Green Value
    out dx,al
    mov al,B                     //Senting Blue Value
    out dx,al
    }
}

//---------------------------------------------------//
// Show The Palette                                  //
//---------------------------------------------------//
void ShowPal(PaletteType Pal)
{
unsigned char t;

    for(t=0;t<255;t++)
    {
        SetColor(t,Pal[t].red,Pal[t].green,Pal[t].blue);
    }
}

//---------------------------------------------------//
// Get The Use Palette From The Screen               //
//---------------------------------------------------//

void GetPal(PaletteType Pal)
{
unsigned char t;
    for (t=0;t<255;t++)
    {
        GetColor(t,Pal[t].red,Pal[t].green,Pal[t].blue);
    }
}

//---------------------------------------------------//
// Fade To The Screen From Palette To Palette.       //
//---------------------------------------------------//
void FadeTo(PaletteType Pal,PaletteType ToPal)
{
unsigned char t,t1;
    for(t1=1;t1<63;t++)
    {
        for(t=1;t1<255;t++)
        {
            if (Pal[t].red > ToPal[t].red)
                Pal[t].red--;
            if (Pal[t].red < ToPal[t].red)
                Pal[t].red++;
            if (Pal[t].green > ToPal[t].green)
                Pal[t].green--;
            if (Pal[t].green < ToPal[t].green)
                Pal[t].green++;
            if (Pal[t].blue > ToPal[t].blue)
                Pal[t].blue--;
            if (Pal[t].blue < ToPal[t].blue)
                Pal[t].blue++;
        }
        ShowPal(Pal);
    }
}

//-------------------------------File Formats-------------------------------//

char LoadCel(const char *name,unsigned char *Where,PaletteType Pal)
{
FILE *f;
sCelHeader Cel;
char loaded;

    if((f = fopen(name,"rb")) != NULL) {
        loaded = TRUE;
        fread(&Cel,sizeof(sCelHeader)-768,1,f);
        fread(Pal,sizeof(PaletteType),1,f);
        fread(Where,64000,1,f);
        fclose(f);
    }
    else
    {
        loaded = FALSE;
    }
    return(loaded);
}

//---------------------------------Effects----------------------------------//

//---------------------------------------------//
//Build The Picture Of The Cross Fade          //
//---------------------------------------------//

void MakeCrossFade(unsigned char *Pic1,unsigned char *Pic2,
                   unsigned char *Pic3,PaletteType PalP1,
                   PaletteType PalP2,PaletteType PalCp1,
                   PaletteType PalCp2)
{
    struct pixels {
        unsigned char Pix1,Pix2;
    };
    pixels Colors[255];

    unsigned int T;
    unsigned int T1;
    unsigned int Word;
    unsigned char Pix1,Pix2;
    unsigned int Num;
    T=0;
    Num = 1;
    do{
        Pix1 = Pic1[T];
        Pix2 = Pic2[T];
        for(T1=0;T1<Num-1;T1++){
            if ((Num != 1) && (Pix1==Colors[T1].Pix1) && (Pix2==Colors[T1].Pix2))
            {
                Pic1[T] = T1;
                T1=256;
                break;
            }
        }

        if (T1 != 256)
        {
            Pic3[T] = Num;
            PalCp1[Num] = PalP1[Pix1];
            PalCp2[Num] = PalP2[Pix2];
            Colors[Num].Pix1 = Pix1;
            Colors[Num].Pix2 = Pix2;
            Num ++;
        }
        T++;
        if(Num > 255)   {
            printf("More Then 256 Colors . ");
            exit;
        }
    } while (T != 64000);
}
//-----------------------------Keyboard Routines------------------------------//

//--------------------------------------------//
//New Interrupt 9 for handle with the keyboard//
//--------------------------------------------//
void interrupt new9int(__CPPARGS){
    asm  {
        mov ax,0x40
        mov es,ax
        mov di,0x17
        mov ax,0
        mov [es:di],ax
    }
    keys[inp(0x60) % 128] = (inp(0x60) < 128);
    old9int();
    asm {
        mov al,0x20
        out 0x20,al
    }
    asm {
        mov ax,0x40
        mov es,ax
        mov di,0x1A
        mov ds,ax
        mov si,0x1c
        mov ax,[ds:si]
        mov [es:di],ax
        }
}

//-------------------------------------------//
//         Init The new interrupt            //
//-------------------------------------------//

void InitKeyboard(){
    memset(keys,0,sizeof(keys));
    old9int = getvect(0x9);
    setvect(0x9,new9int);
}
//--------------------------------------//
//      Restore The Old interrupt       //
//--------------------------------------//

void RestoreKeyBoard(){
    setvect(0x9,old9int);
}

//------------------------------Mouse Routines------------------------------//

//--------------------------------------//
//         Get the mouse status         //
//--------------------------------------//

void GetMouse(mousestruct &Mouse)
{
    asm {
        push ds                 //Saving DS
        mov ax,0x0003            //Function 0003H INT 33H GET STATUS
        int 0x33
        lds si,Mouse            //[DS:SI] = MOUSE
        shr cx,3                //FOR DIVIDE IT WITH 8
        shr dx,3
        mov [ds:si],cx          //[DS:SI] = X = CX
        mov [ds:si+2],dx        //[DS:SI+2] = Y = DX
        mov [ds:si+4],bx        //[DS:SI+4] = BUTTON = BX
        pop ds                  //Restoring DS
    }
}

//Thus function Reseting the mouse and return true if the mouse is installed//

char ResetMouse()
{
char rett;
    asm {
        mov ax,0x0000
        int 0x33
        mov rett,al
    }
    return(rett);
}

//Show the mouse on the screen//
void ShowMouse(){
    asm {
        mov ax,0x0001
        int 0x33
    }
}

//Hide the mouse from the screen//
void HideMouse(){
    asm {
        mov ax,0x0002
        int 0x33
    }
}

