main_seg	segment	byte	public
	assume cs:main_seg; ds:main_seg

org	100h
start:	jmp	entry

blank1  db      0ffh  ;because if we access this intro in COM format
                    ; and as a file of word, the far_jump_addr will begin
                    ; in the 2. word. (4.byte) If the counting is zero-
                    ; based, like in Turbo Pascal. Then will be enough, for
                    ; example, write : var intro:file of word;
                    ;                  assign(intro,'intro.com');
                    ;                  seek(intro,2);
                    ;                  write(intro,old_ip);
                    ;                  write(intro,old_cs); {3rd. word}
far_jump_adr    dd 0    ; this is a common jump adress back to the EXE, it
                        ; fills automagically the intromerger prg. The form
                        ; of it : offset : segment, of course with the
                        ; reversed (low:high) byte-format. Certainly this is
                        ; not modified - it's the original CS:IP. We must
                        ; modify it before jumping back to the normal, infected
			; EXE.
filename        db 'SIN_PLUS.EXE',00   ; for calling the internal overlay.
                                       ; It must be always the current filename!
					; it is a BIG drawback in this intro as
					; if the LUSER changes the name of the
					; infected EXE file, it will no longer run.
colorok 	db 0,2,9,4,63,6,7,8,9,10,11,12,13,14,15,14,0
sinuspointx	db 2                   ; from here : variables to sinuswaves
sinuspointy	db 6h
sinuspointx2	db 0
sinuspointy2	db 64
scposx		db 0
scposy		db 64
temp2:	        dw 0
fix2	        dw 0000
temp:	        dw 0
fix	        dw 0000
bitek:          db 128,64,32,16,8,4,2,1
roww	        dw 0                   ; from here : variables to text-disp.
altrow	        dw 0
textsinus	db 64
countdown	db 0
actualrow 	dw 0

entry:  push ds                 ; saving ds
        push cs
        push cs
        pop ds
        pop es                 ; ds,es:=cs - we are in COM program
        call message
	mov dx,3ceh
	mov al,7
	out dx,al	; Graphics Controller Index reg, selects which register
			;  to be accessed with port 3cf. (here : 7. reg.)
	mov al,0fh	; to be send to 7. register (Color Don't care reg.)
	inc dx		; 3cf - VGA Graph. Contr. Data register
	out dx,al	; 0f : all of the maps are compared - look CHAPTER 5;
                        ; row 295.
        mov ax,0010h     ; 640*350 graphics
	int 10h
	call picout
	mov ax,ds
	mov es,ax
	mov dx,offset colorok
	mov ax,1002h    ; set palette registers on EGA,
                        ; AL=subservice: 02h=set all palette registers and
                        ; overscan register. ES:DX points to a 17-byte color
                        ; list, where the first 16 bytes contains the new
                        ; values for the 16 palette registers and the last
                        ; byte is the new overscan register value.
	int 10h
sass:	mov dx,3dah     ; feature control register
				; This is an external control register (check e.g.
				; EGA.NG), and the D3 bit is the VERTICAL 
				; RETRACE bit (if it is set, then the electron
				; beam is off, it's moving back to the upper
				; left of the screen).
				;  The D0. bit is the Display Enable bit.
ras0:	in al,dx
	and al,8        ; and 00001000b -> if the 3. bit is 0, then jump back
                        ; to wait while the electron beam is off
	je ras0
ras:	in al,dx
	and al,1        ; if the 0. bit is 0, then jump back, and when it becomes
                        ; 1, the display becomes disabled (HORIZONTAL RETRACE).
	je ras

	mov ah,2h       ; check the control-keys (shift etc...)
	int 16h
	test al,3
	je bill2
	jmp dead        ; if shift is pressed, exit.
bill2:	call sinloc
	call replot    ; erasing on the left side the previous sinuspoints
	call replot2   ; erasing on the right side the previous sinuspoints
	call pixel     ; draw the next 60 sinuspoints on left
	call pixel2             ; it cuts the text, too.
	call rebuild            ; erases 14 pixelrow at the position of
                                ; altrow-this was the previous text
	call print
	add sinuspointx,2       ; in every cycle we add 2 to sinpointx
                                ; (byte, in beg. : 2)
	jmp sass
dead:				; exiting the intro section, jumping back to the
				; code area of the 'infected' file
	mov ax,3
	int 10h
	pop ds			; restore DS - we saved it at the beginning of
				; the intro.
	mov ax,ds
	mov es,ax		; es:=ds (pointing to PSP)
	mov si,offset far_jump_adr
				; We grab the double-word address
				; for the long jump to the original program's
				; entry. This double-word adress contains
                                ; the original CS:IP can be found in EXE header,
                                ; so we have to update CS (add the actual CS to it).
	mov ax,ds               ; this is the original ds (pointing the EXE's
                                ; PSP). Its value depends on the machine, the
                                ; amount of free RAM etc...
	add ax,0010h		; increasing ax with 0010h (this is the
                                ; far between CS and DS in the EXE programs,
                                ; (=100h byte), cause DS points to PSP).
        add ax,word ptr cs:[si+2]  ; increasing ax with the original
				; beginning segment (look the original EXE
				; header !). F.e. if it was 2000:0000, this
				; is 2000.  
	mov cs:[si+2],ax	; storing the target segment - this is now
                                ; ready to jump.
	;mov ax,3		; set cursor pos = CLS
	;int 10h
	jmp dword ptr cs:[far_jump_adr]  ; far jump to the EXE begin

;--------planes----------------

plane3:	mov dx,3c4h            ; to store the TEXT.
	mov al,2
	out dx,al
	mov al,1
	inc dx
	out dx,al
	ret

plane2:	mov dx,3c4h             ; to strore the STATIC PICTURE.
	mov al,2
	out dx,al
	mov al,2
	inc dx
	out dx,al
	ret

plane1:	mov dx,3c4h             ; to store the SINUSPOINTS.
	mov al,2
	out dx,al
	mov al,4
	inc dx
	out dx,al
	ret


;-------pixeltest------------------------------

pixel:	
	call plane1
	mov ax,0
	mov si,offset temp
	mov [si],ax                     ; temp:=ax=0
	mov ax,0a000h
	mov es,ax                       ; es:=a000
	add sinuspointx,2              ; sinuspointx:=sinuspointx+2
	add sinuspointy,1              ; sinuspointy:=sinuspointy+1
                                       ; (xadd1 and yadd1)
	xor ax,ax
	mov al,sinuspointx
	mov si,ax
	mov al,sinuspointy
	mov di,ax
	mov dl,8
	mov cx,60
        add si, offset sintab           ; >>>>>>>>>>>
        add di, offset sintab           ; >>>>>>>>>>>

plt:	xor ah,ah
	mov al,[si]                     ; [sintab+sinuspointx]
	div dl                          ; divide vith 8
	push ax                         ; save the result
	xor bh,bh
	mov bl,[di]                     ; from sintab (the default reading:
                                        ; DS:DI)
	xor ah,ah
	mov al,80
	mul bl
	mov bx,ax
	pop ax
	push bx
	xor bh,bh
	mov bl,ah
	push si
	mov si,offset bitek
	mov dh,cs:[si+bx]       ; which bit to set in vidmem ?
	pop si                  ; pointing to sintab
	mov bl,al
	xor ah,ah
	pop bx
	add bx,ax
	add bx,cs:[fix]
	mov es:[bx+1],dh
	push cx
	mov cx,bx
	mov bx,offset temp
	add word ptr cs:[bx],2  ; temp:=temp+0002
	mov bx,cs:[bx]          ; pointing to sintab
        add bx,offset sintab      
	mov [bx+256],cx           ; write to sintab (the DS is the default)
	pop cx                    ; how many points have been remain ?
	add si,3
	cmp si,offset sintab+0ffh ; if we've gone along the entire sinustable,
                                  ; always go to the begin.
	jng noos
	sub si,100h
noos:	add di,2						;tv
	cmp di,offset sintab+0ffh ; di points sinustable, like si, too.
	jng noos2
	sub di,100h
noos2:	loop plt                ; we plot max. 60 points
	ret

replot:                         ; erases the old sinuspoints
	call plane1
	mov ax,0a000h
	mov es,ax               ; es:=a000
        mov si,offset sintab
	mov cx,60               ; cx:=60d, at one time we display only
                                ; 60d points on both side.
	xor al,al	        ; al:=0

cll:	add si,2                ; si:=si+2
	mov bx,[si+256]         ; we peek the old values of screen-sinus from
                                ; the puffer of sintab+100h
	mov es:[bx+1],al        ; storing 0 to the vidmem to the found adress
	loop cll
	ret

;-------pixeltest------------------------------

pixel2:
	call plane1
	mov ax,0
	mov si,offset temp2
	mov cs:[si],ax
	mov ax,0a000h
	mov es,ax
	add sinuspointx2,81h   ;xadd2
	add sinuspointy2,3     ;yadd2
	xor ax,ax
	mov al,sinuspointx2
	mov si,ax
	mov al,sinuspointy2
	mov di,ax
	mov dl,8
	mov cx,60
        add si, offset sintab           ; >>>>>>>>>>
        add di, offset sintab           ; >>>>>>>>>>

plt2:	xor ah,ah
	mov al,[si]
	div dl
	push ax
	xor bh,bh
	mov bl,[di]
	xor ah,ah
	mov al,80
	mul bl
	mov bx,ax
	pop ax
	push bx
	xor bh,bh
	mov bl,ah
	push si
	mov si,offset bitek
	mov dh,cs:[si+bx]
	pop si
	mov bl,al
	xor ah,ah
	pop bx
	add bx,ax
	add bx,cs:[fix2]
	mov es:[bx+1],dh
	push cx
	mov cx,bx
	mov bx,offset temp2
	add word ptr cs:[bx],2
	mov bx,cs:[bx]
        add bx,offset sintab      ; !!!!!!!!!!!!!!!!!!!
	mov [bx+256+128],cx
	pop cx	

	add si,3
	cmp si,offset sintab+0ffh
	jng noo2
	sub si,100h
noo2:	add di,2						;distance
	cmp di,offset sintab+0ffh
	jng noo22
	sub di,100h
noo22:	loop plt2

	ret

replot2:
	call plane1
	mov ax,0a000h
	mov es,ax
        mov si,offset sintab            ; >>>>>>>>>>>
	mov cx,60
	xor al,al	
cll2:	add si,2
	mov bx,[si+256+128]             ; the second halfscreen's sinusvalues
	mov es:[bx+1],al
	loop cll2
	ret

;-------sinuslocation----------------
; 1., increases scposx and scposy with 1. The beginning value of them is
;  0 and 40h - the difference (between [00]=80 and [40]=ff) is 1/4 sinuscycle.
; 2., [fix]:=[sintab:scposx]*50h*2
; 3., [fix2]:=[sintab:scposy]*50h*2+2dh (where the +2dh=45d moves the points
;  horizontally to the second half of screen).

sinloc:	inc scposx                   ; at begin, 0
	inc scposy                   ; at begin, 64
	xor ah,ah
	mov al,scposx
        add ax,offset sintab            ; >>>>>>>>
	mov si,ax                   ; si:=offs. sintab+scposx
        xor ax,ax
	mov al,scposy
        add ax,offset sintab            ; >>>>>>>>
	mov di,ax                   ; di:=scposy
	mov al,[si]                 ; al:=[offs.sintab+scposx]
	mov cl,80                    ; cl:=50h, lenght of a row
	mul cl                       ; ax <- 50h * al (when a source is byte)
	clc                          ; c:=0
	rol ax,1                     ; rotate left : ax:=2*ax
	mov [fix],ax              ; a000:0000; fix = 0000 at begin; now
                                     ; [fix]:=[sintab:scposx]*50h*2
	xor ah,ah                    ; drop the high order byte
	mov al,[di]                  ; di=scposy, from sinustable
	mul cl                       ; ax <- 50h * al
	clc
	rol ax,1                     ; ax:=2*ax
	add ax,45                    ; ax:=ax+2d
	mov [fix2],ax             ; [fix2]:=[sintab:scposy]*50h*2+2dh
	ret
;--------picture-----------------

picout:
	call plane2     ; the first bit map will be used to store the
                        ; normal graphics.
                ; 1., open file with handle - we opens the 'infected' file
                ; to read -as an internal overlay- the graphics to the EGA/VGA
                ; RAM.
        mov dx,offset filename  ; DS:DX points to ASCIIZ filename
        mov ah,3dh              ; DOS function (open file)
        mov al,0                ; read
        int 21h
        jnc move_read           ; the opening was succesful. If it wasn't,
                                ; probably the filename has been changed - we
                                ; exit.
        mov ah,4ch
        int 21h
move_read:     ; we move file read pointer to the beginning of graphics. For-
               ; tunately, DOS lets us count down from the end of file,
               ; so we needn't compute the DOS lenght of the program and
               ; subtract from it the lenght of internal overlay.
               ;  In this case, we must pay attention to the function, which requires
               ; a signed 32-bit number, (where is normal byte-order is used).
               ;  If you want to count down 13824d bytes from the end of the
               ; main program, you must give the offset as -13824, which is
               ; to ffffca00h in 32 bit. (You can easily convert a negative
               ; decimal value to a 32-bit signed value with any calcutator
		; program).
        mov bx,ax         ; file handle
        mov ah,42h
        mov al,2          ; offset from the end
        mov cx,0ffffh
        mov dx,0ca00h          ; cx:dx : signed offset in bytes (-13824)
        int 21h
               ;read from file with handle
        mov ah,3fh
        mov cx,6d60h
        mov dx,0a000h
        mov ds,dx
        mov dx,0000h      ; ds:dx points to buffer - here is the vidmem
        int 21h           ; reading

        mov ax,cs
        mov ds,ax         ; ds:=cs


        ; Why do we have to avoid loading the entire intro into the file?
	; Because this is a CHAINABLE intro, where the
        ; memory requirement is the most important parameter.
        ;  If we store with a normal intro the 13k long screen to the
        ; normal RAM (we not use internal overlays -or external screenfile-),
        ; it will steal a lot of valuable memory, and than easily occurs
        ; that the main program will report insufficient memory.

	ret

;--------print---------------------

print:
	call plane3
	dec countdown           ; a byte, in begin it's 0
	je veges
	inc textsinus           ; a byte, in begin it's 40h
	xor bh,bh
	mov bl,textsinus        ; bx:=00xx, xx=textsinus
        add bx,offset sintab                     ; >>>>>>>>
	mov al,[bx]             ; al:=[sintab+00xx], where xx=textsinus
	xor ah,ah               ; ax:=00yy , we need only a byte-sinusvalue
	mov dl,80
	mul dl                  ; AX:=DL (80) * AL; we have multiplied the
                                ; sinusvalue with the number of coloumns
	add ax,8024             ; 1f57h. We add this value to the begin-byte:
                                ;  1.; 8000=80*100= the highest point of the
                                ;    text will begin in the 100th. rasterrow;
                                ;  2., 24 = because 2*24+32=80, and we write
                                ;    the 32 char-text symmetrical.
	mov [roww],ax           ;
	mov [altrow],ax         ; store the pixelrow-value - for the later
                                ; erasing.
	mov bx,actualrow        ; word containing 0 at begin, it's pointing
                                ; to text (which row to be read) in byte-mode
	                        ; bx:=actualrow, the next 32 char long text
                                ; to display
	mov cx,32               ; 32d character will be displayed
	mov ax,0a000h
	mov es,ax               ; es:=a000
        add bx,offset text      ; we'll access the text with actualrow*32+cx.

kirak:
	mov al,[bx]             ; reading a text character
	cmp al,0                ; is it 0 ?
	je scrveg               ; yes, jmp to scrveg (initialization)
	mov dl,14               ; dl:=14, the EGA character height
	xor ah,ah               ; ax=00xx, where xx=char to display
	mul dl                  ; ax:=14*ord(char) - the proper adress for
                                ; the 14-byte character matrix
	mov si,ax               ; si:=ax
	add si,7                ; si:=si+7 (?)
        add si,offset font      ; we'll get the proper font
	mov di,[roww]           ; ES:DI pointing to screen, di consists the
                                ; computed pixelrow-value
	push cx                 ; the outer cycle's (write the 32 char) counter
	mov cx,14               ; a char height
brain:
	movsb                   ; DS:SI->ES:DI, byte (one pixelrow of a char)
	add di,79               ; the next pixelrow (just behind the previous)
	loop brain              ; write the entire character
	pop cx
	inc [roww]
	inc bx                  ; the textpointer
	loop kirak              ; cx was the counter with beginning value 32
	ret
scrveg: 
	mov actualrow,0                 ; storing the beginning values
	mov textsinus,64
	mov countdown,0
	ret

veges:
	add actualrow,32                ; the next 32-byte text for print
	mov textsinus,64                ; we begin to display it from beneath
                                        ; the screen, where we can't see it.
	mov countdown,0
	ret
;-----------------------------------
rebuild:
	call plane3
	mov ax,0a000h
	mov es,ax               ; es:=a000h
	mov di,[altrow]      ; at begin, it's 0000h (a word)
	mov ax,0
	mov dx,14               ; a character's height
sail:	mov cx,32               ; 32 character
sail2:	mov es:[di],ax          ; store 32*0 word to vidmem - in the entire
                                ; 32-char long row at the row position of
                                ; [altrow] (=oldrow?)
	inc di
	loop sail2
	add di,48
	dec dx                  ; we are executing the delete 14 times,
                                ; cause in the inner cycle we ONLY delete
                                ; a PIXEL, and not a CHARACTER (14 pixelrow
                                ; high) row.
	jne sail
	ret


message:
        mov ax,3
        int 10h         ; cls
	mov cx,szovegveg-offset messtext
	mov ax,0b000h
	mov es,ax
	mov si,00000h
	mov bx,0
	mov di,08000h
printit:
	mov al,cs:[messtext+bx]
	mov es:[si],al
	mov es:[di],al
	add si,2
	add di,2
	inc bx
	loop printit
	ret

sintab:  db      128,131,134,137,140,143,146,149,152,156,159,162,165,168,171,174
       db      176,179,182,185,188,191,193,196,199,201,204,206,209,211,213,216
       db      218,220,222,224,226,228,230,232,234,236,237,239,240,242,243,245
       db      246,247,248,249,250,251,252,252,253,254,254,255,255,255,255,255
       db      255,255,255,255,255,255,254,254,253,252,252,251,250,249,248,247
       db      246,245,243,242,240,239,237,236,234,232,230,228,226,224,222,220
       db      218,216,213,211,209,206,204,201,199,196,193,191,188,185,182,179
       db      176,174,171,168,165,162,159,156,152,149,146,143,140,137,134,131
       db      128,124,121,118,115,112,109,106,103,99,96,93,90,87,84,81
       db      79,76,73,70,67,64,62,59,56,54,51,49,46,44,42,39
       db      37,35,33,31,29,27,25,23,21,19,18,16,15,13,12,10
       db      9,8,7,6,5,4,3,3,2,1,1,0,0,0,0,0
       db      0,0,0,0,0,0,1,1,2,3,3,4,5,6,7,8
       db      9,10,12,13,15,16,18,19,21,23,25,27,29,31,33,35
       db      37,39,42,44,46,49,51,54,56,59,62,64,67,70,73,76
       db      79,81,84,87,90,93,96,99,103,106,109,112,115,118,121,124
       db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

messtext	db 'Sorry, you have neither EGA nor VGA...! Press any SHIFT. '
szovegkezdet   equ    $
text:  db      '   Dirkki@iRC presents the 1st  '
       DB      '     of his IntroMaker Packs    '
	db     '                                '
       db      '   Quite obsolete, but it was   '
	db     '     written in Sep, 1991...    '
	db     ' This version is registered to: '
       db      '   Slasher@iRC  from Sweden     '
	db     '       He LOVES Finland!        '
	db     '          (obviously)           '
       db      'Warning, this pack was released '
       db      '  quite a long ago. I haven''t  '
	db     ' corrected the lame English of  '
	db     '     the comments. Sorry.       '
	db     '   http://www.fok.hu/~dirk      '
	db     '                                ',0
  ; the message MUST be terminated with a 0 byte!
szovegveg    equ  $

include font.inc   ; one can define his/her own charset. The present one is designed for EGA
include graph.inc  ; and monochrome pics can also be included.

main_seg	ends
end		start
       END




