CHAN readerreply[n.r],ostoreader[n.r],readertoscheduler[n.r],
     schedulertoreader[n.r],
     printertoscheduler[n.p],schedulertoprinter[n.p],
     printerreply[n.p],
     discreply[n.d],ostodisc[n.d],disctoscheduler[n.d],
     schedulertodisc[n.d],ostodirectory[n.d],directorytoos[n.d],
     directorytodisc[n.d],disctodirectory[n.d] :

  -- reader process

PROC readerprocess(VALUE i)=

  PROC outtodisc=
  -- code for sending stream to disc
  :

  PROC outtoprinter=
  -- code for sending stream to printer
  :

  WHILE TRUE
    VAR cmnd,param1,ch :
    SEQ
      readerreply[i]!ANY                         -- signal reader free
      ostoreader[i]?cmnd                         -- wait for command
        IF
           cmnd= 'R'                             -- R command
              SEQ
                 ostoreader[i]?ch               -- send to disc param1
                 ch:=((i*n.d)+ch)
                 outtodisc                      -- send stream to appropriate channel
           cmnd= 'L'                            -- T command
              SEQ
                 readertoscheduler[i]!ANY       -- request printer channel
                 schedulertoreader[i]?ch        -- get printer channel
                 outtoprinter                   -- send stream to printer
           TRUE
              SKIP :

  -- printer processes

PROC printerprocess(VALUE i)=

  PROC receive=
  -- code to receive stream from disc or reader
  :

  WHILE TRUE
    VAR Ch :
    SEQ
      printertoscheduler[i]!ANY                 -- signal free
      schedulertoprinter[i]?ch                  -- receive allocated channel
      receive
      printerreply[i]!ANY :                     -- tell os resource free

PROC printerscheduler=

  -- connection process

  PROC conn(VALUE i,j,x,source)=
     VAR z :
     SEQ
       IF
         source='R'
            SEQ
               z:=(i*n.r)+j
               schedulertoreader[j]!z
               schedulertoprinter[i]!z
         TRUE
            SEQ
               z:=((i+n.r)*x)+j
               schedulertodisc[j]!z
               schedulertoprinter[i]!z.

  WHILE TRUE
     ALT
        ALT j=[0 FOR n.p]
            printertoscheduler[j]?ANY
               ALT
                  ALT i=[0 FOR n.r]
                     readertoscheduler[i]?ANY
                        conn(j,i,n.r,'R')
                  ALT i=[0 FOR n.d]
                     disctoscheduler[j]?ANY
                        conn(j,i,n.d,'D')   :

  -- directory process
PROC directoryprocess(VALUE i)=

  PROC boolsearch=
  -- code to search directory for param and return TRUE or FALSE
  :

  PROC positionsearch=
  -- return position of param in directory in addr
  :

  PROC makeentry=
  -- enter new name(param) and disc address(addr) in directory
  :

  PROC delete=
  -- delete param from directory

  VAR cmnd,param,result,addr:
  SEQ
     -- initialise directory here
     WHILE TRUE
        SEQ
          ostodirectory[i]?cmnd;param
          IF
            cmnd='E'
               delete
            cmnd='R'
              SEQ
                  boolsearch
                  directorytoos[i]!result
            cmnd='P'
              SEQ
                  positionsearch
                  directorytodisc[i)!addr
            cmnd='W'
              SEQ
                  disctodirectory[i]?addr
                  makeentry
            TRUE
              SKIP :

  -- disc process
PROC discproce55(VALUE i)=

  PROC outfile=
  -- send stream to printer
  :

  PROC readfromreader=
  -- receive stream of chars from reader
  :
  WHILE TRUE
     VAR cmnd,ch,param,discaddr  :
     SEQ
        discreply[i]!ANY
        ostodisc[i]?cmnd
        IF
           cmnd='P'
              SEQ
                 directorytodisc[i]?discaddr
                 disctoscheduler[i]!ANY
                 schedulertodisc[i]?ch
                 outfile
           cmnd='R'
              SEQ
                 ostodisc[i]?param
                 ch:=i+(n.d*param)
                 readfromreader
                 disctodirectory[i)!discaddr
           TRUE
              SKIP :

  -- operating system process
PROC osaction=

  PROC osprocess=
     VAR no, flag, found[n.d),use :
     SEQ
       IF
          cmnd='E'
             PAR i=[0 FOR n.d]
                ostodirectory[i]!'E';paraml
          cmnd='L'
             IF
                (reader[paraml]=free) AND (printersinuse < n.p)
                   SEQ
                     ostoreader[paraml)!'L'
                     reader(paraml]:=busy
                     printersinuse:=printersinuse+1
                TRUE
                   outqueue!'L';paraml
          cmnd='P'
             SEQ
                PAR i=[0 FOR n.d]
                   ostodirectory[i]!'R';paraml
                   directorytoos[i]?found[i]
                use:=-1
                SEQ i=[0 FOR n.d]
                   IF
                     found(i)=TRUE
                        use:=i
                     TRUE
                        SKIP
                IF
                   use=(-1)
                      outerr("file does not exist")
                   TRUE
                      IF
                        (disc[use]=free) AND (printersinuse<n.p)
                          SEQ
                            ostodisc[use]!'P'
                            ostodirectory[use]!'P';paraml
                            disc[use]:=busy
                            printersinuse:=printersinuse+1
                        TRUE
                          outqueue!'P';paraml
          cmnd='R'
             SEQ
               IF
                   reader(paraml)=free
                      SEQ
                        no:=0
                        flag:=TRUE
                        WHILE flag
                          IF
                            disc[no]=free
                              SEQ
                                 ostoreader[paraml]!'R';no
                                 ostodirectory[no]!'w';param2
                                 ostodisc[no)!'R';param1
                                 reader[param1]:=busy
                                 disc[no]:=busy
                                 flag:=FALSE
                            TRUE
                              IF
                                 no=n.d
                                   SEQ
                                      outqueue!'R';param1;param2
                                      flag:=FALSE
                                 TRUE
                                   no:=no+1
               TRUE
                  outqueue!'R';param1;param2
          TRUE
            SKIP :

VAR cmnd,paraml,param2,printersinuse,reader[n.r],disc[n.d) :
SEQ
   printersinuse:=0
   WHILE TRUE
     PRI ALT
        ALT i=[0 FOR n.r]
           readerreply[i]?ANY
              reader[i]:=free
        ALT i=[0 FOR n.d]
           discreply[i]?ANY
              disc[i]:=free
        ALT i=[0 FOR n.p]
           printerreply[i]?ANY
              printersinuse:=printersinuse-1
        inqueue?cmnd;param1
           SEQ
             IF
                cmnd='R'
                   inqueue?param2
                TRUE
                   SKIP
             osprocess
        interminal?cmnd;param1
           SEQ
             IF
                cmnd='R'
                   interminal?param2
                TRUE
                  SKIP
           osprocess :

PAR
  PAR i=[0 FOR n.r]
     readerprocess(i)
  PAR i=[0 FOR n.p]
     printerprocess(i)
  PAR i=[0 FOR n.d]
     PAR
        directoryprocess(i)
        discprocess(i)
  printerscheduler
  osaction
  queue                              -- process to queue delayed requests
  input                              -- process to input commands and send to interminal
