DEF empty =... :                    -- initial node value
DEF n =... :                        -- maximum number of nodes
DEF nxn = n*n :                     -- total connection
DEF insert = ...,                   -- code for insert command
    print =  ...,                   -- code for print command
    check =...,                     -- code for check command
    pend  =  ...,                   -- code for end of printing data
    nclients =...,                  -- no. of client processes
    iack =...,                      -- code for insert acknowledgement
    cack =...,                      -- code for check acknowledgement
    pack =...,                      -- code for print acknowledgement
    ackpos =...,                    -- code for positive acknowledgement
    ackneg =...,                    -- code for negative acknowledgement
    allnodesused =...:              -- code for out of node storage
DEF m1 =...,                        -- codes for rebalancing -- node B case 1
    m2 =...,                        -- node B case 3
    m3 =...,                        -- node B case 2
    m4 =...,                        -- node B case 9
    m5 =...,                        -- node C case 3
    m6 =... :                       -- node C case 4
CHAN link[nxn] :                    -- total connection both ways
CHAN connection[n],free[n],alloc[n] :
                                    -- channels to channel and node manager
PAR
   PAR i=[1 FOR n-1]                -- nodes except interface
      VAR parent,rchild,lchild,rplength,lplength,cmnd,
          val,v,bi,templ,temp,ralloc,lalloc,cchan,ack :
      SEQ
          val := empty             -- initially node is empty
          free[i]!ANY              -- message to node manager
          connection[i]?parent     -- find out who parent is
          rchild := empty
          ralloc := FALSE          -- no children at present
          lchild := empty
          lalloc := FALSE
          lplength := 0            -- initial path length from left child
          rplength := 0            -- initial path length from right child
          WHILE TRUE
             ALT
               link[(parent*n) + i]?cmnd    -- command from parent
                  IF
                     cmnd=insert   -- insert command
                        SEQ
                          link[(parent*n) + i]?v  -- insert value
                          IF
                              val=empty
                                 SEQ
                                    val := v
                                    link[(i*n) + parent]!iack;0;'B'
                                    -- reply path length and balanced
                              v<val              -- go left
                                 SEQ
                                    IF
                                       lchild=empty -- get new link
                                          SEQ
                                             alloc[i]!ANY  -- get free node
                                             connection[i]?lchild
                                             lalloc := TRUE
                                       TRUE
                                          SKIP
                                    IF
                                       lchild<>allnodesused -- free node
                                          link[(i*n) + lchild]!insert;v
                                       TRUE -- no free nodes
                                          link[(i*n)+parent]!iack;
                                             allnodesused;'B'
                              TRUE -- go right and same action as above
                                 SEQ
                                    IF
                                       rchild=empty
                                          SEQ
                                            alloc[i]!ANY
                                            connection[i]?rchild
                                            ralloc := TRUE
                                       TRUE
                                          SKIP
                                    IF
                                       rchild<>allnodesused
                                          link[(i*n)+rchild]!insert;v
                                       TRUE
                                          link[(i*n)+parent]!iack;
                                             allnodesused;'B'
  cmnd=m1 -- node B position case 1 in rebalancing
   SEQ -- relink as diagram of case 1
      link[(parent*n)+i]?temp
      rplength := lplength
      link[(i*n)+parent]!rchild
      rchild := parent
      parent := temp
      link[(i*n)+parent]!rplength;'B'
  cmnd=m2 -- node B case 3 relinking
   SEQ
      link[(parent*n)+i]?temp
      link[(i*n)+parent]!rchild
      link[(i*n)+rchild]!m5;temp;parent
      link[(rchild*n)+i]?temp
      parent := rchild
      rchild := temp
      rplength := lplength
  cmnd=m5 -- node C position case 3 relinking
   SEQ
     link[(parent*n)+i]?temp1;temp
     link[(i*n)+parent]!lchild
     parent := temp1
     link[(i*n)+temp]!rchild
     rchild := temp
     lplength := lplength + 1
     rplength := lplength
     link[(i*n)+parent]!lplength;'B'
  cmnd=m3 -- node B position case 2 relinking
   SEQ
     link[(parent*n)+i]?temp
     lplength := rplength
     link[(i*n)+parent]!lchild
     lchild := parent
     parent := temp
     link[(i*n)+parent]!lplength;'B'
  cmnd=m4 -- node B position case 4 relinking
   SEQ
     link[(parent*n)+i]?temp
     link[(i*n)+parent]!lchild
     link[(i*n)+lchild]!m6;temp;parent
     link[(lchild*n)+i]?temp
     parent := lchild
     lchild := temp
     lplength := rplength
  cmnd=m6 -- node C position case 4 relinking
   SEQ
     link[(parent*n)+i]?temp1;temp
     link[(i*n)+parent]!rchild
     parent := temp1
     link[(i*n)+temp]!lchild
     lchild := temp
     rplength := rplength + 1
     lplength := rplength
     link[(i*n)+parent]!rplength;'B'
  cmnd=check    -- check command from parent
   SEQ
     link[(parent*n)+i]?v;cchan -- value to check
     IF
        val=empty               -- negative result
           link[(i*n)+parent]!cack;ackneg;v;cchan
        val=v                   -- positive result
           link[(i*n)+parent]!cack;ackpos;v;cchan
        val<v                   -- go down tree left
           SEQ
             IF
               link[(i*n)+lchild]=empty
                  link[(i*n)+parent]!cack;ackneg;v;cchan
               TRUE
                  link[(i*n)+lchild]!check;v;cchan
        TRUE                    -- go down tree right
           SEQ
             IF
               link[(i*n)+rchild]=empty
                  link[(i*n)+parent]!cack;ackneg;v;cchan
               TRUE
                  link[(i*n)+rchild]!check;v;cchan
  cmnd=print -- print command from parent
   IF
      link[(i*n)+lchild]=empty    -- go left if possible
          SEQ
            link[(i*n)+parent)!pack;val
               IF
                  link[(i*n)+rchild]=empty
                     link[(i*n)+parent]!print
                  TRUE
                     link[(i*n)+rchild]!print
      TRUE
          link[(i*n)+lchild]!print
lalloc & link[(lchild*n)+i]?cmnd   --reply from left child
    IF
       cmnd=iack - ack of insert command
          SEQ
             link[(lchild*n) + i]?lplength;bi
               IF
                 (lplength-rplength)=2     -- rebalancing reqd?
                    SEQ
                      IF
                        bi='L' -- yes
                          SEQ
                             link[(i*n)+lchild]!ml;parent
                             -- new parent node for lchild
                             link[(lchild*n)+i]?temp
                             parent := lchild
                             lchild := temp
                             lplength := rplength
                        TRUE -- yes
                          SEQ
                             link[(i*n)+lchild]!m2;parent
                             -- req node no of left child
                             -- and send parents id
                             link[(lchild*n)+i]?parent
                             link[(parent*n)+i]?lchild
                             lplength := rplength-1
                 TRUE -- no
                    SEQ
                       lplength := lplength + 1
                       IF
                         lplength>rplength
                            link[(i*n)+parent]!iack;lplength;'L'
                         lplength=rplength
                            link[(i*n)+parent]!iack;lplength;'B'
                         TRUE
                            link[(i*n)+parent]!iack;rplength;'R'
  cmnd=cack                          -- ack of check command
     SEQ
         link[(lchild*n)+i]?ack;v;cchan
         link[(i*n)+parent]!cmnd;ack;v;cchan
  cmnd=print                         -- print token
     SEQ
         link[(i*n)+parent]!pack;val
         IF
            link[(i*n)+rchild]=empty
               link[(i*n)+parent]!print
            TRUE
               link[(i*n)+rchild]!print
  cmnd=pack                          -- print acknowledge
     SEQ
         link[(lchild*n)+i]?v
         link[(i*n)+parent]!pack;v
  TRUE
     SKIP
ralloc & link[(rchild*n)+i]?cmnd    --reply from right child
 IF                                -- code basically same as left child
  cmnd=iack
    SEQ
      link[(rchild*n)+i]?rplength;bi
      IF
        (rplength-lplength)=2
          SEQ
            IF
              bi='R'
                SEQ
                  link[(i*n)+rchild]!m3;parent
                  link[(rchild*n)+i]?temp
                  parent := rchild
                  rchild := temp
                  rplength := lplength
              TRUE
                SEQ
                  link[(i*n)+rchild]!m4;parent
                  link[(rchild*n)+i]?parent
                  link[(parent*n)+i]?rchild
                  rplength := lplength-1
        TRUE
          SEQ
             lplength := lplength + 1
             IF
               lplength>rplength
                  link[(i*n)+parent]!iack;lplength;'L'
               lplength=rplength
                  link[(i*n)+parent]!iack;lplength;'B'
               TRUE
                  link[(i*n)+parent]!iack;rplength;'R'
  cmnd=cack
     SEQ
        link[(rchild*n)+i]?ack;v;cchan
        link[(i*n)+parent]!cmnd;ack;v;cchan
  cmnd=print
     link[(i*n)+parent]!print
  cmnd=pack
     SEQ
         link[(rchild*n)+i]?v
         link[(i*n)+parent]!pack;v
  TRUE
     SKIP
-- channel and node manager
VAR used :
SEQ    -- scheduler
   used := 1 -- initially root used
   ALT i=[0 FOR n]
      alloc[i]?ANY
         SEQ
           IF
              used<>n
                 ALT j=[1 FOR n-1]
                    free[j]?ANY
                       SEQ
                         connection[i]!j
                         connection[j)!i
              TRUE
                 connection[i]!allnodesused
VAR clienti[nclient] clientir[nclient],clientp[nclient], clientpr[nclient],
    clientc[nclient],clientcr[nclient] :
PAR      -- for interface and clients
    VAR root,v,temp,pending,insertprintallowed :
    SEQ
       insertprintallowed := TRUE
       root := empty
       WHILE TRUE      -- remember separate channels for diff commands
         ALT
           ALT i=[0 FOR nclients]
              ALT
                 insertprintallowed & clienti[i]?v    -- insert command
                    SEQ
                       insertprintallowed := FALSE
                       IF
                          root=empty
                             SEQ
                               alloc[0]!ANY      -- get free node
                               connection[0]?temp
                               IF
                                  temp<>allnodesused
                                    SEQ
                                      link[temp]!insert;v
                                      root := temp
                                      pending := i
                                  TRUE
                                    SEQ
                                      clientir[i]!fail
                                      insertprintallowed := TRUE
                               TRUE
                                 link[root]!insert;v
       insertprintallowed & clientp[i]?ANY -- print request
          IF
             root=empty
                clientpr[i]!pend
             TRUE
               SEQ
                  link[root]!print
                  pendinq := i
                  insertprintallowed := FALSE
       clientc[i]?v                             -- check request
          IF
              root=empty
                 clientcr[i]!ackneg;v
              TRUE
                 link[root)!check;v;i
link[root*n]?reply                              -- reply from tree
   IF
      reply=iack                                -- insert acknowledge
         SEQ
            link[root*n]?lplenqth;bi
            IF
               lplength=allnodesused
                  clientir[pending)!ackneg
               TRUE
                  clientir[pending]!ackpos
            insertprintallowed := TRUE
      reply=cack                                -- check acknowledge
         SEQ
            link[root*n]?ack;v;cl
            clientcr[cl]!ack;v
      reply=pack                                -- print acknowledge
         SEQ
            link[root*n]?v
            clientpr[pending]!v
            IF
               v=print
                  SEQ
                     insertprintallowed := TRUE
               TRUE
                  SKIP
