--
-- occam 1 program to simulate circuit of figure 7.1
-- using flush tokens
--
DEF Endbuffer = -3 :
DEF flushtoken = ... :          -- unique data value for token
DEF size =...                   -- max no of gate inputs
CHAN Screen AT 1 :
CHAN Keyboard AT 2 :
--
-- process definitions
--
--
-- process to buffer two processes
--
PROC wire(CHAN in,out)=
   WHILE TRUE
      VAR buffer :
      SEQ
         in?buffer
         out!buffer
--
-- process to simulate n input OR gate
--
PROC orgate(VALUE n,CHAN in[],out)=
   VAR outp :
   SEQ
      outp := 0
      WHILE TRUE
        VAR lvalue[size],flushcount :
        SEQ
           SEQ i=[0 FOR n]
             in[i]?lvalue[i]
           flushcount := 0
           WHILE TRUE
             VAR temp :
             SEQ
               temp := 0
               SEQ i=[0 FOR n]
                  temp := temp \/ lvalue[i]
               IF
                  temp <> outp
                     SEQ
                        outp := temp
                        out!outp
                  TRUE
                     SKIP
               eoi := TRUE
               WHILE eoi
                  VAR val :
                  ALT i=[0 FOR n]
                     in[i]?val
                        SEQ
                           IF
                             val = flushtoken
                                IF
                                   flushcount = (n - 1)
                                      SEQ
                                         out!flushtoken
                                         eoi := FALSE
                                         flushcount := 0
                                   TRUE
                                      flushcount := (flushcount+1)
                             TRUE
                                SEQ
                                   lvalue[i] := FALSE
                                   eoi := FALSE
--
-- process to simulate n input AND gate
--
PROC andgate(VALUE n,CHAN in[],out)=
   VAR outp :
   SEQ
      outp := 0
      WHILE TRUE
         VAR lvalue[size],flushcount :
         SEQ
            SEQ i=[0 FOR n]
              in[i]?lvalue[i]
            flushcount := 0
            WHILE TRUE
              VAR temp :
              SEQ
                 temp := 1
                 SEQ i=[0 FOR n]
                    temp := temp /\ lvalue[i]
                 IF
                    temp <> outp
                        SEQ
                           outp := temp
                           out!outp
                    TRUE
                        SKIP
                 eoi := TRUE
                 WHILE eoi
                    VAR val :
                    ALT i=[0 FOR n]
                       in[i]?val
                          SEQ
                            IF
                              val = flushtoken
                                 IF
                                   flushcount = n - 1
                                     SEQ
                                       out!flushtoken
                                       eoi := FALSE
                                       flushcount := 0
                                   TRUE
                                     flushcount := flushcount+1

                              TRUE
                                 SEQ
                                   lvalue[i] := FALSE
                                   eoi := FALSE  :
--
-- output process
--
PROC outputmodule(CHAN in)=
   WHILE TRUE
      VAR lastout :
      SEQ
        in?lastout
        IF
          lastout=flushtoken
             SEQ
                Screen!(lastout+'0')
                Screen!#A
                Screen!#D
                Screen!Endbuffer
          TRUE
             SKIP :
--
-- process to translate from single input to
-- multiple output including flushtokens
--
PROC inputmodule(VALUE ninp,CHAN inchar,out[])=
  VAR outv [size] :
  SEQ
     SEQ i=[0 FOR ninp]
         outv[i]:=0
     WHILE TRUE
         SEQ i=[0 FOR ninp]
             inchar?outv[i]
             out[i]!outv[i]
             out[i]!flushtoken :
--
-- process to input a char from terminal
--
PROC input(CHAN outchar)=
  WHILE TRUE
     VAR character :
     SEQ
        Keyboard?character
        character := character - '0'
        outchar!character :
--
-- channels as in figure
--
CHAN a,b[3],d[2],e:
--
-- process instantiations
--
-- do processes concurrently
--
PAR
   input (a)
   inputmodule(3,a,b)
   andgate(2,b,d[0])
   orgate (2,d,e)
   wire(b[2],d[1])
   outputmodule(e)
