DEF n =... :        -- number of writers
DEF m =... :        -- number of readers
DEF c =... :        -- number of couriers
DEF nxc = n*c :     -- number of writer-courier channels
DEF cxm = c*m :     -- number of courier-reader channels
CHAN ptoc[n*c], ctoc[c*m], ptos[n], stoc[c], ctos[n],
     stocon[m], ptosreq[n], stocreq[c],ctosreq[c],stoconreq[m] :
PAR

  -- producer scheduler

  WHILE TRUE
  VAR x, i :
    SEQ
      ALT
         ALT k=[0 FOR n]
            ptosreq[k]?ANY
               -- search for least busy courier
               -- and store channel no in x
               i:=k
         ALT k=[0 FOR C]
           ctosfree[k]?ANY -- free message from courier
             -- update use count for couriers
      -- calc x from i and j
      ptos[i]!x

  -- producers

  PAR i=[0 FOR n]
    WHILE TRUE
          VAR x :
          SEQ
             ptosreq[i]!ANY
             ptos[i]?x
             -- use ptoc[x] to send dest then message
                .
                .


  -- consumers

  PAR i=[0 FOR m]
    WHILE TRUE
      VAR x :
      SEQ
         -- read next input from buffer into j
         ctocreq[j]!ANY -- req input from courier
         -- loop to receive message

  -- couriers

  PAR i=[0 FOR c]
     WHILE TRUE
        VAR x,y,z :
        ALT
           ALT j=[0 FOR n]
              ptoc[j]?dest
                -- send i to buffer for consumer[dest]
           ALT j=[0 FOR m]
              ctocfree [j]?ANY
                -- accept any offer from consumer
                -- send message from producer to
                -- consumer via ctoc[j]
                ctosfree[i]!ANY -- free mess to scheduler
