DEF n =... :        -- number of writers
DEF m =... :        -- number of readers
DEF c =... :        -- number of couriers
DEF nxc = n*c :     -- number of writer-courier channels
DEF cxm = c*m :     -- number of courier-reader channels
CHAN ptoc[nxc], ctoc[cxm], ptos[n], stoc[c], ctos[n],
     stocon[m], ptosreq[n], stocreq[c],ctosreq[c], stoconreq[m] :
PAR

  -- producer scheduler

  WHILE TRUE
   VAR x, i, j :
   SEQ
    ALT k=[0 FOR n]
       ptosreq[k]?ANY
         i:=k
    ALT k=[0 FOR c]
       stocreq[k]?ANY
         j:=k
    -- calc x from i and j
    ptos[i]!x
    stoc[j]!x

  -- producers

  PAR i=[0 FOR n]
    WHILE TRUE
          VAR x :
          SEQ
             ptosreq[i]!ANY
             ptos[i]?x
             -- use ptoc[x] to send dest then message
                .
                .
  -- consumers

  PAR i=[0 FOR m]
     WHILE TRUE
        VAR x :
        ALT j=[(i*c) FOR c] -- receive from any courier
           ctoc[j]?x
               SKIP

  -- couriers

  PAR i=[0 FOR C]
    WHILE TRUE
       VAR x :
       SEQ
          stocreq[i]!ANY
          stoc[i]?X
          ptoc[x]?dest
          ptoc[x]?z
          -- calc y from dest
          y := (c * dest) + i
          ctoc[y]!z
