DEF n =... :        -- number of writers
DEF m =... :        -- number of readers
DEF d =... :        -- number of buffer slots
CHAN pw[n] vw[n],pr[m],vr[m],xw[n],xr[m],recxw[n],depxr[m],
     depxw[n],recxr[m] :
VAR b [d] :
PAR

  -- communications buffer

  PAR
    VAR k,l,j :
    SEQ
      k:=0             -- no of buffer full slots
      l:=0             -- no of writing slots allocated
                       -- but not yet used
      j:=0             -- no of reading slots allocated
                       -- but not yet used
      WHILE TRUE
        ALT
          ALT i=[0 FOR n]
            (k+1)<d & pw[i]?ANY     -- req to write and
                                    -- slot empty
            l:=l+1                  -- slot allocated
          vw[i]?ANY                 -- end of write
            SEQ
               k:=k+1               -- update slot count
               l:=l-1               -- decrement allocation
          ALT i=[0 FOR m]
            (k-j)>0 & pr[i]?ANY     -- req to read and
                                    -- full slot avail
               j:=j+1               -- slot allocated
            vr[i]?ANY               -- end of read
              SEQ
                 k:=k-1             -- decrement slot count
                 j:=j-1             -- decrement allocation
    -- write index
    VAR count,slotno[d] :
    SEQ
      SEQ i=[0 FOR d]
        slotno[i]:=i                -- initially all slots can be written
      count := d
      WHILE TRUE
        ALT
          ALT i=[0 FOR n]
              recxw[i]?ANY          -- request for a write slot no.
                 SEQ
                   xw[i]!slotno[count-1]
                   count := count - 1
              depxw[i]?slotno[count] -- return of slot no.
                 count := count + 1
    -- read index
    VAR count,slotno[d] :
    SEQ
      count := 0                    -- initially no read slots
      WHILE TRUE
         ALT
            ALT i=[0 FOR m]
                recxr[i]?ANY        -- request for read slot no.
                   SEQ
                     xr[i]!slotno[count-1]
                     count := count - 1
                depxr[i]?slotno[count] -- return of slot no
                   count := count + 1

    -- interface protocols

    PROC put(VALUE v,i)=
      VAR j :
      SEQ
         pw[i]!ANY                    -- req to write
         recxw[i]!ANY                 -- req write slot no
         xw[i]?j                      -- obtain slot no
         b[j] :=v                     -- write to slot
         depxr[i]!j                   -- put index back into read set
         vw[i]!ANY  :                 -- signal end of write

    PROC get(VALUE i,VAR v)=
      VAR j :
      SEQ
         pr[i]!ANY                    -- req to read
         recxr[i]!ANY                 -- req read slot no
         xr[i]?j                      -- obtain slot no
         v:=b[j]                      -- read from buffer
         depxw[i]!j                   -- put index back into write set
         vr[i]!ANY  :                 -- signal end of read

  -- client processes

  PAR
    PAR i=[0 FOR n]
       VAR x :
       ....put(x,i)....

    PAR i=[0 FOR m]
       VAR y :
       ....get(y,i)....
