#ifndef example_h_included
#define example_h_included

struct keywordT { char* name; int token; };

#define KEYWORD(name) {"<"#name">",o##name },{"</"#name">",c##name }
/* this makro expands name to:
  {"<name>", oname }, {"</name>", cname }				*/

#define DEFAULT_KEYWORDS						\
  KEYWORD(HTML),	KEYWORD(HEAD),	KEYWORD(TITLE),	KEYWORD(BODY),  \
  KEYWORD(BLINK),	KEYWORD(BIG),	KEYWORD(BR)
/* note: this way is uncool if you want to make a real html-parser.	*/

#define YYERROR_VERBOSE	1
#define YYDEBUG		1
#define YYSTYPE		char*

extern struct keywordT	keywords[];
/* declared in example.y or example.l					*/
extern int		yylineno;
extern void		yyerror(char* s);

#define FONTSIZE 1
#define FONTMAX	 2
#define FONTMIN  0

#endif
