/* ex03.cpp */

#include <iostream>
#include <cstring>

class Object {
  private:
   char *Name;
   int Number;
  public:
   Object();
   Object(const Object& copy);
   Object(const char *TheName,const int TheNumber);
   ~Object();
   Object& operator=(const Object& copy);
   Object& operator=(const char* NewName);
   Object& operator=(const int NewNumber);
   void Print(void);
};

Object::Object()
{
  Name = new char[strlen("Richard")];
  strcpy(Name,"Richard");
  Number=3;
}

Object::Object(const char *TheName,const int TheNumber)
{
  Name = new char[strlen(TheName)];
  strcpy(Name,TheName);
  Number=TheNumber;
}

Object::~Object()
{
  delete[] Name;
}

Object::Object(const Object& copy)
{
  Name = new char[strlen(copy.Name)];
  strcpy(Name,copy.Name);
  Number=copy.Number;
}

Object& Object::operator=(const Object& copy)
{
  delete[] Name;
  Name = new char[strlen(copy.Name)];
  strcpy(Name,copy.Name);
  Number=copy.Number;
  return *this;
}

Object& Object::operator=(const char* NewName)
{
  delete[] Name;
  Name = new char[strlen(NewName)];
  strcpy(Name,NewName);
  return *this;
}

Object& Object::operator=(const int NewNumber)
{
  Number=NewNumber;
  return *this;
}

void Object::Print(void)
{
  cout << "The Name: " << Name << "\nThe Number: " << Number << "\n";
}

void main(void)
{
  Object One("Linda",3);
  Object Two("Jeffrey",65);
  One.Print();
  One="Andrew";
  One=5;
  One.Print();
  One=Two;
  One.Print();
}

/* ex03.cpp */