program Floppy_Disk_Drive_Tools;
uses dos,crt;

type
  dosreg=record
               ax,bx,cx,dx,bp,di,si,ds,es,flags: integer;
               end;

  szparam=record
                sav,oldal,szektor,hossz: byte;
                end;

var
  hibakod: byte;
  menupont: char;
  egyseg,
  lemezform: integer;
  is_at: boolean;
  z: char;

function hl_olvasas(egyseg,
                    oldal,
                    sav,
                    szektor,
                    nszek,
                    adat_sz,
                    adat_of: integer) : integer;
  var
    reg: dosreg;
  begin
    reg.ax := 2 shl 8 + nszek;

    reg.dx := oldal shl 8 + egyseg;

    reg.cx := sav shl 8 + egyseg;

    reg.es := adat_sz;

    reg.bx := adat_of;

    intr($13, Dos.registers(reg));
    hl_olvasas := hi(reg.ax);
  end;

function hl_iras(egyseg,
                 oldal,
                 sav,
                 szektor,
                 nszek,
                 adat_sz,
                 adat_of: integer) : integer;
  var
    reg: dosreg;
  begin
    reg.ax := 3 shl 8 + nszek;

    reg.dx := oldal shl 8 + egyseg;

    reg.cx := sav shl 8 + szektor;

    reg.es := adat_sz;

    reg.bx := adat_of;

    intr($13, Dos.registers(reg));
    hl_iras := hi(reg.ax);
  end;

function hl_form(egyseg,
                 oldal,
                 sav,
                 nszek,
                 hossz: integer) : integer;
  var
    reg: dosreg;
    format: array[1..15] of szparam;
    i: integer;
  begin
    for i := 1 to nszek do
      begin
        format[i].sav := sav;
        format[i].oldal := oldal;
        format[i].szektor := i;
        format[i].hossz := hossz;
      end;

    reg.ax := 5 shl 8 + nszek;

    reg.dx := oldal shl 8 + egyseg;

    reg.cx := sav shl 8;

    reg.es := seg(format[1]);

    reg.bx := ofs(format[1]);

    intr($13, Dos.registers(reg));
    hl_form := hi(reg.ax);
  end;

procedure uzenet(statusz: integer);
  begin
    if statusz <> 0 then
      begin
        writeln;
        write('Hiba lepett fel: ');
        case statusz of
          $01: writeln('nem megengedett funkcioszam');
          $02: writeln('cimjeloles nem talalhato');
          $03: writeln('irasvedett lemez');
          $04: writeln('szektor nem talalhato');
          $08: writeln('DMA tulcsordulas');
          $09: writeln('adatatvitel szegmenshataron tul');
          $10: writeln('olvasasi hiba');
          $20: writeln('lemezvezerlo hiba');
          $40: writeln('sav nem talalhato');
          $80: writeln('idotullepes');
          $FF: writeln('hibas parameter megadas');
          else writeln('a ',statusz,' kodnal');
        end
      end
  end;

procedure help;
  begin
    clrscr;
    writeln('ͻ');
    writeln('                                                    ');
    writeln('               MONITOR PARANCSOK:                   ');
    writeln('                                                    ');
    writeln(' Kilepes: Q (Quit)                                  ');
    writeln(' Segitseg: ? (Help)                                 ');
    writeln(' Szektor olvasas: O (Read sector)                   ');
    writeln(' Szektor inicializalas: I (Init sector)             ');
    writeln(' Alapallapotba vezerles: R (Reset FDD)              ');
    writeln(' Sav formazas: F (Format track)                     ');
    writeln(' Parameterek: P (Parameters)                        ');
    writeln('                                                    ');
    writeln('ͼ');
  end;

function hexvalue(decvalue: integer) : char;
  begin
    if decvalue < 10 then
      hexvalue := chr(decvalue + 48)
    else
      case decvalue of
        10: hexvalue := 'A';
        11: hexvalue := 'B';
        12: hexvalue := 'C';
        13: hexvalue := 'D';
        14: hexvalue := 'E';
        15: hexvalue := 'F';
      end;
  end;

procedure olvasas;
  var
    adatok: array[1..512] of char;
    oldal,
    sav,
    szektor,
    h,i,j: integer;
  begin
    writeln;
    write('Oldal: ');
    readln(oldal);
    write('Sav: ');
    readln(sav);
    write('Szektor: ');
    readln(szektor);
    hibakod := hl_olvasas(egyseg,oldal,sav,szektor,1,seg(adatok),ofs(adatok));
    if hibakod = 0 then
      for h := 0 to 1 do
        begin
          clrscr;
          gotoxy(1,4);
          write(' Oldal: ',oldal,' Sav: ',sav,' Szektor: ',szektor);
          if h=0 then writeln('     also 256 Byte')
                 else writeln('     felso 256 Byte');
          write('Ŀ');
          for i := 0 to 15 do
            begin
              write(' ');
              write(hexvalue((i*16) mod 16), hexvalue((i*16) div 16));
              write(' - ');
              write(hexvalue((i*16+15) div 16), hexvalue((i*16+15) mod 16));
              write('  ');
              for j := 1 to 16 do
                begin
                  write(' ');
                  write(hexvalue((integer(adatok[h*256+i*16+j])) div 16));
                  write(hexvalue((integer(adatok[h*256+i*16+j])) mod 16));
                end;
              write('   ');
              for j := 1 to 16 do
                if adatok[h*256+i*16+j] < ' ' then
                  write('.')
                else
                  write(adatok[h*256+i*16+j]);
              write(' ');
            end;
          write('');
          if h=0 then
            begin
              write('Nyomjon meg egy billentyut ...');
              z := readkey;
            end
        end
      else
        uzenet(hibakod);
  end;

procedure inic;
  var
    adatok: array[1..512] of char;
    oldal,
    sav,
    szektor: integer;
    inikar: char;
    i: integer;
  begin
    writeln;
    write('Oldal: ');
    readln(oldal);
    write('Sav: ');
    readln(sav);
    write('Szektor: ');
    readln(szektor);
    write('Inicializalo karakter: ');
    readln(inikar);
    for i := 1 to 512 do
      adatok[i] := inikar;
    uzenet(hl_iras(egyseg,oldal,sav,szektor,1,seg(adatok),ofs(adatok)));
  end;

function reset : integer;
  var
    reg: dosreg;
  begin
    reg.ax := 0;
    intr($13, Dos.registers(reg));
    reset := hi(reg.ax);
  end;

procedure formazas;
  var
    reg: dosreg;
    oldal,
    sav,
    nszek: integer;
  begin
    writeln;
    write('Oldal: ');
    readln(oldal);
    write('Sav: ');
    readln(sav);
    write('Szektorok szama: ');
    readln(nszek);
    if is_at then
      begin

        reg.ax := $17 shl 8 + lemezform;

        reg.dx := egyseg;

        intr($13, Dos.registers(reg));
      end;
    uzenet(hl_form(egyseg,oldal,sav,nszek,2));
  end;

procedure param;
  begin
    writeln;
    write('Meghajto sorszama (0=A: , 1=B: , ...) : ');
    readln(egyseg);
    if is_at then
      begin
        writeln;
        writeln('Valaszthato formazasi parameterek:');
        writeln;
        writeln('1: 360 KiloByte-os FDD');
        writeln('2: 1,2 MegaByte-os FDD');
        writeln('3: 1,44 MegaByte-os FDD');
        writeln;
        write('Valasztasa: ');
        readln(lemezform);
      end;
  end;

begin
  egyseg := 0;
  lemezform := 3;
  clrscr;
  if mem[$F000:$FFFE] = $FC then is_at := true
                            else is_at := false;

  uzenet(reset);
  menupont := '?';
  repeat
    case menupont of
      '?': help;
      'O': olvasas;
      'I': inic;
      'R': uzenet(reset);
      'F': formazas;
      'P': param;
      else writeln('Ez a parancs ebben a verzioban ervenytelen !');
    end;
    writeln;
    writeln('Monitor prompt (segitseg=?) ');
    readln(menupont);
    if menupont = '' then menupont := ' ';
    menupont := upcase(menupont);
  until menupont = 'Q';
end.