		ideal
		p386
		model	large,pascal

TTEST		=	0

MY_FX_SEQ	=	1

USUALVGA	=	0

NCOLORS		=	8

NPOINTS		=	200;128;256*3/2


PSEG		equ	DGROUP

MACRO	udata
		;ufardata	
		udataseg
ENDM
MACRO	code
		codeseg	FFX
ENDM

public		set_fast_fx
public		draw_fast_fx
public		next_fast_fx

		code

; -- set_fast_fx -----------------------------------------------
;
MAXROTSPEED	=	4096*1/5
ROTSPEEDSHIFT	=	6
ROTACCELLERATE	=	3
		udata
fastfx_color	db	?
		db	?	; Used as align 2
rotate_time	dw	?	; Rotate picture variables
rotate_speed	dw	?
rotate_accel	dw	?
ROTCENTER_RAD	=	25	; Radius where rotation occurs
CROTTIMESTEP	=	20
crot_time	dw	?	; Rotate center time

WEIGHTSHIFT	=	8
MAXWEIGHT	=	1 shl WEIGHTSHIFT
PAUSETIME	=	50
fx0_weight	dw	?
fx0_proc	dw	?
fx1_weight	dw	?
fx1_proc	dw	?
pause_time	dw	?
chg_radius	dw	?
chg_rad_step	dw	?
randomnumb	dw	?

fx_zoom	dd	?
fx_zstep	dd	?
DOWNZOOM	=	_FRACMUL*3/4
UPZOOM		=	_FRACMUL+_FRACMUL/4
		code
proc		set_fast_fx	far
	push	ds
	mov	ax,PSEG
	mov	ds,ax
	assume	ds:PSEG
	xor	eax,eax
	mov	[rotate_time],ax
	mov	[rotate_speed],ax
	mov	[crot_time],ax
	mov	[rotate_accel],ROTACCELLERATE
	mov	[pause_time],PAUSETIME
	mov	[fx0_weight],MAXWEIGHT
	mov	[fx_zoom],_FRACMUL
	mov	[fx_zstep],-_FRACMUL/256
	mov	[fx1_weight],ax
IF	MY_FX_SEQ eq 0
	push	ds
	xor	ax,ax
	mov	ds,ax
	mov	ax,[ds:46ch]
	pop	ds
ELSE
	xor	ax,ax
ENDIF
	mov	[randomnumb],ax
	call	get_rand_fx
	mov	[fx0_proc],ax
	call	get_rand_fx
	mov	[fx1_proc],ax
	mov	[chg_radius],_FRACMUL/2
	mov	[chg_rad_step],4
	pop	ds
	assume	ds:nothing
	ret
endp		set_fast_fx
; -- get_rand_fx -----------------------------------------------
;
label		different_fx	word
IF	MY_FX_SEQ
dw	_8_fx0,cycloid_4_fx,spiral_fx,square_fx,_8_fx0,_o_fx
dw	cycloid_9_fx,cycloid_1_fx,_8_fx
dw	0
ELSE
dw	cycloid_4_fx,cycloid_9_fx,_8_fx,spiral_fx,_8_fx0,_o_fx,square_fx,cycloid_1_fx
ENDIF
max_fx_number	=	($-different_fx)/2
proc		get_rand_fx	near
		assume	ds:PSEG
IF	MY_FX_SEQ eq 0
	imul	ax,[randomnumb],133
	add	ax,1
	mov	[randomnumb],ax
	xchg	al,ah
	xor	dx,dx
	mov	cx,max_fx_number
	div	cx
	movzx	edx,dx
	mov	ax,[different_fx+edx*2]
ELSE
@@agen:
	movzx	edx,[randomnumb]
	add	[randomnumb],2
	mov	ax,[different_fx+edx]
	or	ax,ax
	jnz	@@10
	mov	[randomnumb],0
	jmp	@@agen
@@10:
ENDIF
	assume	ds:NOTHING
	ret
endp		get_rand_fx

; -- draw_fast_fx ----------------------------------------------
;
		code
proc		draw_fast_fx	far
	pushad
	push	ds es fs gs
	mov	bx,PSEG
	mov	ds,bx
	mov	es,bx
	assume	ds:PSEG,es:PSEG
	call	clear_page
	push	ax
	call	compute_fx_points
	pop	es
	call	draw_fx_points
	pop	gs fs es ds
	popad
	nop	; Just for case
	ret
endp		draw_fast_fx
; -- next_fast_fx ----------------------------------------------
;
proc		next_fast_fx	far
	push	ds es
	mov	ax,PSEG
	mov	ds,ax
	mov	es,ax
	call	next_rotate_time
	call	next_weights
	call	next_radius
	call	next_zoom
	pop	es ds
	ret
endp		next_fast_fx
; -- next_rotate_time ------------------------------------------
;
proc		next_rotate_time	near
	mov	ax,[rotate_speed]
	add	ax,[rotate_accel]
	cwd
	xor	ax,dx
	sub	ax,dx
	cmp	ax,MAXROTSPEED
	jb	@@1
	neg	[rotate_accel]
@@1:
	xor	ax,dx
	sub	ax,dx
	mov	[rotate_speed],ax
	sar	ax,ROTSPEEDSHIFT
	add	[rotate_time],ax
	add	[crot_time],CROTTIMESTEP
	ret
endp		next_rotate_time
; -- new_fx ----------------------------------------------------
;
proc		new_fx	near
	mov	[fx0_weight],MAXWEIGHT
	mov	[fx1_weight],0
	mov	ax,[fx1_proc]
	mov	[fx0_proc],ax
	call	get_rand_fx
	mov	[fx1_proc],ax
	ret
endp		new_fx
; -- next_weights ----------------------------------------------
;
proc		next_weights	near
	cmp	[pause_time],0
	je	@@work
	; Wait a lot show second fx
	dec	[pause_time]
	jnz	@@exit
	; Get new FX for show
	jmp	@@exit
@@work:
	inc	[fx1_weight]
	dec	[fx0_weight]
	jnz	@@exit
	; Out of weight for first FX - pause the second
	call	new_fx
	mov	[pause_time],PAUSETIME
@@exit:
	ret
endp		next_weights
; -- next_radius -----------------------------------------------
;
proc		next_radius	near
	xor	cx,cx
	mov	ax,[chg_rad_step]
	add	ax,[chg_radius]
	jg	@@1
	xor	ax,ax	; Zero anyway
	inc	cx
@@1:
	cmp	ax,_FRACMUL
	jl	@@2
	inc	cx
	mov	ax,_FRACMUL
@@2:
	mov	[chg_radius],ax
	jcxz	@@keepstep
	neg	[chg_rad_step]
@@keepstep:
	ret
endp		next_radius
; -- next_zoom -------------------------------------------------
;
proc		next_zoom	near
	mov	eax,[fx_zoom]
	add	eax,[fx_zstep]
	cmp	eax,UPZOOM
	jae	@@20
	cmp	eax,DOWNZOOM
	jg	@@10
@@20:
	neg	[fx_zstep]
@@10:
	mov	[fx_zoom],eax
	ret
endp		next_zoom

; -- clear_page ------------------------------------------------
;
proc		clear_page	near
	cld
	push	es ax
	mov	es,ax
	xor	di,di
	IF	USUALVGA
	mov	cx,64000/4
	ELSE
	mov	dx,03c4h
	mov	ax,0f02h
	out	dx,ax
	mov	cx,64000/4/4
	ENDIF
	xor	eax,eax
	rep	stosd
	pop	ax es
	ret
endp		clear_page
; -- compute_fx_points -----------------------------------------
;
		udata
diff_centerx	dw	?
diff_centery	dw	?
fx_points	dw	NPOINTS*2 dup(?)
		code
label		sine_table	word
include	"sinetbl.inc"
proc		compute_fx_points	near
	mov	bx,[crot_time]
	shr	bx,1
	and	bx,_TWOPI-1
	add	bx,bx
	movsx	eax,[bx+sine_table]
	mov	ecx,ROTCENTER_RAD
	imul	ecx
	sar	eax,_FRACBITS
	mov	[diff_centerx],ax
	sub	bx,_TWOPI/4*2
	neg	bx
	and	bx,(_TWOPI-1)*2
	movsx	eax,[bx+sine_table]
	imul	ecx
	sar	eax,_FRACBITS
	mov	[diff_centery],ax
; --------------
	mov	di,offset fx_points
	push	di
	xor	ebp,ebp
@@loop0:
	push	di
	call	[fx0_proc]
MACRO	testdraw	color
IF	TTEST
	push	ax bx es
	mov	cx,0a000h
	mov	es,cx
	mov	cl,color
	add	ax,320/2
	add	bx,200/2
	call	draw_point
	pop	es bx ax
ENDIF
ENDM
	testdraw	0
	pop	di
	mov	[di],ax
	mov	[di+2],bx
	add	di,4
	inc	bp
	cmp	bp,NPOINTS
	jb	@@loop0
	pop	di
; --------------
IF	1
	xor	ebp,ebp
@@loop1:
	push	di
	call	[fx1_proc]
testdraw	1
	pop	di
	push	ebp
	movsx	esi,[fx0_weight]
	movsx	ebp,[fx1_weight]
	movsx	eax,ax
	imul	ebp
	mov	ecx,eax
	movsx	eax,[word di]
	imul	esi
	add	eax,ecx
	sar	eax,WEIGHTSHIFT
	mov	[di],ax
	movsx	eax,bx
	imul	ebp
	mov	ecx,eax
	movsx	eax,[word di+2]
	imul	esi
	add	eax,ecx
	sar	eax,WEIGHTSHIFT
	mov	[di+2],ax
	pop	ebp
	add	di,4
	inc	bp
	cmp	bp,NPOINTS
	jb	@@loop1
ENDIF
; --------------
	xor	ebp,ebp
	mov	bx,[rotate_time]
	and	bx,_TWOPI-1
	add	bx,bx
	movsx	esi,[sine_table+bx]	; ESI-sine
	sub	bx,_TWOPI/4*2
	neg	bx
	and	bx,(_TWOPI-1)*2
	movsx	edi,[sine_table+bx]	; EDI-cosine
@@rotloop:
	movsx	ecx,[word ds:ebp*4+fx_points+2]
	movsx	eax,[word ds:ebp*4+fx_points]
	imul	edi
	mov	ebx,eax
	mov	eax,esi
	imul	ecx
	sub	ebx,eax
	sar	ebx,_FRACBITS
	xchg	[word ds:ebp*4+fx_points],bx
	movsx	eax,bx
	imul	esi
	mov	ebx,eax
	mov	eax,edi
	imul	ecx
	add	eax,ebx
	sar	eax,_FRACBITS
	mov	[word ds:ebp*4+fx_points+2],ax
	inc	bp
	cmp	bp,NPOINTS
	jnz	@@rotloop
	ret
endp		compute_fx_points

; -- cycloid_9_fx ----------------------------------------------
;
C14INRAD	=	50
C14OUTRAD	=	18
proc		cycloid_9_fx	near
	mov	edx,_TWOPI*2*10
_all_cycloids:
	movzx	eax,bp
	mul	edx
	mov	ecx,NPOINTS
	div	ecx
	mov	ebx,eax
	and	ebx,_TWOPI-1
	movsx	eax,[ebx*2+sine_table]
	mov	ecx,C14OUTRAD
	imul	ecx
	mov	esi,eax	; TX'=OUTRAD*sin((nrays+1)*realtime)
	sub	bx,_TWOPI/4
	neg	bx
	and	bx,_TWOPI-1
	movsx	eax,[ebx*2+sine_table]
	imul	ecx
	mov	edi,eax	; TY'
	mov	ax,_TWOPI
	mul	bp
	mov	cx,NPOINTS
	div	cx
	mov	bx,ax
	movsx	eax,[ebx*2+sine_table]
	mov	cx,C14INRAD
	imul	ecx
	add	esi,eax
	sub	bx,_TWOPI/4
	neg	bx
	and	bx,_TWOPI-1
	movsx	eax,[ebx*2+sine_table]
	imul	ecx
	add	edi,eax
	sar	esi,_FRACBITS
	sar	edi,_FRACBITS
	mov	ax,si
	mov	bx,di
	ret
endp		cycloid_9_fx

; -- cycloid_4_fx ----------------------------------------------
;
proc		cycloid_4_fx	near
	mov	edx,_TWOPI*5*2
	jmp	_all_cycloids
endp		cycloid_4_fx
; -- cycloid_1_fx ----------------------------------------------
;
proc		cycloid_1_fx	near
	mov	edx,_TWOPI*2*4
	jmp	_all_cycloids
endp		cycloid_1_fx

; -- spiral_fx -------------------------------------------------
;
SPINRAD		=	0
SPDIFRAD	=	70
proc		spiral_fx	near
	mov	eax,SPDIFRAD*_FRACMUL
	movzx	edx,bp
	mul	edx
	mov	ebx,NPOINTS
	div	ebx
	add	eax,SPINRAD*_FRACMUL
	mov	ecx,eax
	movzx	eax,bp
	mov	edx,_TWOPI
	mul	edx
	div	ebx
	mov	ebx,eax
	movsx	eax,[ebx*2+sine_table]
	imul	ecx
	shrd	eax,edx,_FRACBITS
	sar	eax,_FRACBITS
	push	ax
	sub	bx,_TWOPI/4
	neg	bx
	and	bx,_TWOPI-1
	movsx	eax,[ebx*2+sine_table]
	imul	ecx
	shrd	eax,edx,_FRACBITS
	mov	ebx,eax
	pop	ax
	sar	ebx,_FRACBITS
	ret
endp		spiral_fx

; -- _o_fx -----------------------------------------------------
;
CIRCRAD		=	60
proc		_o_fx	near
	mov	cx,NPOINTS
	mov	ax,_TWOPI
	mul	bp
	div	cx
	movzx	ebx,ax
	movsx	eax,[ebx*2+sine_table]
	mov	ecx,CIRCRAD
	imul	ecx
	push	eax
	sub	bx,_TWOPI/4
	neg	bx
	and	bx,_TWOPI-1
	movsx	eax,[ebx*2+sine_table]
	imul	ecx
	sar	eax,_FRACBITS
	xchg	bx,ax
	pop	eax
	sar	eax,_FRACBITS
	ret
endp		_o_fx
; -- _8_fx -----------------------------------------------------
;
_8XRAD		=	80
_8YRAD		=	60
proc		_8_fx	near
	movzx	eax,bp
	mov	edx,_TWOPI
	mul	edx
	mov	ecx,NPOINTS
	div	ecx
	mov	esi,eax
	and	esi,_TWOPI-1
	movsx	eax,[esi*2+sine_table]
	mov	edx,_8YRAD
	imul	edx
	shrd	eax,edx,_FRACBITS
	mov	bx,ax
	imul	si,3
	sub	si,_TWOPI/2/2
	neg	si
	and	esi,_TWOPI-1
	movsx	eax,[esi*2+sine_table]
	mov	edx,_8XRAD
	imul	edx
	shrd	eax,edx,_FRACBITS
	ret
endp		_8_fx
; -- _8_fx0 -----------------------------------------------------
;
_8XRAD0		=	45
_8YRAD		=	60
proc		_8_fx0	near
	movzx	eax,bp
	mov	edx,_TWOPI
	mul	edx
	mov	ecx,NPOINTS
	div	ecx
	mov	esi,eax
	and	esi,_TWOPI-1
	push	esi
	imul	si,4
	and	si,_TWOPI-1
	movsx	eax,[esi*2+sine_table]
	mov	edx,_8XRAD0
	imul	edx
	mov	ecx,eax
	add	ecx,_8XRAD0*_FRACMUL
	pop	esi
	push	esi
	sub	si,_TWOPI/2/2
	neg	si
	and	si,_TWOPI-1
	movsx	eax,[esi*2+sine_table]
	imul	ecx
	shrd	eax,edx,_FRACBITS*2
	mov	bx,ax
	pop	esi
	movsx	eax,[esi*2+sine_table]
	imul	ecx
	shrd	eax,edx,_FRACBITS*2
	ret
endp		_8_fx0
; -- square_fx -------------------------------------------------
;
proc		square_fx	near
	add	ax,NPOINTS/2/4
	mov	ax,bp
	mov	cx,NPOINTS/4
	xor	dx,dx
	div	cx
	mov	bx,ax
	mov	ax,100
	mul	dx
	div	cx
	xchg	ax,dx
	add	bx,bx
	jmp	[bx+@@jumps]
@@jumps	dw	@@1_1,@@_1_1,@@_11,@@11,@@1_1
@@1_1:
	mov	ax,50
	mov	bx,-50
	sub	ax,dx
	jmp	@@comm
@@11:
	mov	ax,50
	mov	bx,50
	sub	bx,dx
	jmp	@@comm
@@_11:
	mov	ax,-50
	mov	bx,50
	add	ax,dx
	jmp	@@comm
@@_1_1:
	mov	ax,-50
	mov	bx,-50
	add	bx,dx
@@comm:
	ret
endp		square_fx

; **************************************************************
; -- draw_point ------------------------------------------------
;
proc		draw_point	near
	IF	USUALVGA
	imul	di,bx,320
	add	di,ax
	mov	al,cl
	inc	ax
	mov	ah,al
	mov	[es:di+320],ax
	stosw
	ELSE
;	cmp	ax,160
	cmp	ax,319
	ja	@@exit
	mov	di,ax
;	shr	di,1
	shr	di,2
	imul	bx,bx,320/2/2
	add	di,bx
;	and	eax,1
	and	eax,3
	mov	al,[eax+@@masks]
	out	dx,al
	mov	ax,cx
	inc	ax
	stosb
;	mov	[es:di-1+50h],al
	ENDIF
@@exit:
	ret
@@masks	db	1,2,4,8;
;@@masks	db	3,0c0h
endp		draw_point

; -- draw_fx_points --------------------------------------------
;
proc		draw_fx_points	far
	movzx	ax,[fastfx_color]
	push	ax
	xor	ebp,ebp
	mov	cx,ax
	IF	USUALVGA eq 0
	mov	dx,03c4h
	mov	al,2
	out	dx,al
	inc	dx
	ENDIF
	mov	si,[word  fx_zoom]
@@loop:
	push	dx
	mov	ax,[ds:ebp*4+fx_points]
	imul	si
	shrd	ax,dx,_FRACBITS
	add	ax,[diff_centerx]
	add	ax,320/2;/2
	push	ax
	mov	ax,[ds:ebp*4+fx_points+2]
	imul	si
	shrd	ax,dx,_FRACBITS
	mov	bx,[diff_centery]
	add	bx,ax
	add	bx,200/2;/2
	pop	ax
	pop	dx
	push	cx
	shr	cx,1
	call	draw_point
	pop	cx
	inc	cx
	cmp	cl,NCOLORS*2
	sbb	al,al
	and	cl,al
	inc	bp
	cmp	bp,NPOINTS
	jb	@@loop
	pop	ax
	inc	ax
	cmp	al,NCOLORS*2
	sbb	ah,ah
	and	al,ah
	mov	[fastfx_color],al
	ret
endp		draw_fx_points

		end