{ (c) Nmeth kos 1995 }

program VESATest;

{$M 16000 16000 65000 }
{$G+ $X+ }

uses Crt;

const
  SVGAModes: Array[$0100..$0114] of String[41] =
    ('100h  GRAPH 640x400   256 color      512K',
     '101h  GRAPH 640x480   256 color      512K',
     '102h  GRAPH 800x600   16 color       512K',
     '103h  GRAPH 800x600   256 color      512K',
     '104h  GRAPH 1024x768  16 color       512K',
     '105h  GRAPH 1024x768  256 color      1M',
     '106h  GRAPH 1280x1024 16 color       1M',
     '107h  GRAPH 1280x1024 256 color      2M',
     '108h  TEXT  80x60     16  color      512K',
     '109h  TEXT  132x25    16 color       512K',
     '10Ah  TEXT  132x43    16 color       512K',
     '10Bh  TEXT  132x50    16 color       512K',
     '10Ch  TEXT  132x60    16 color       512K',
     '10Dh  GRAPH 320x200   32K hi-color   512K',
     '10Eh  GRAPH 320x200   64K hi-color   512K',
     '10Fh  GRAPH 320x200   16M true-color 512K',
     '110h  GRAPH 640x480   32K hi-color   1M',
     '111h  GRAPH 640x480   64K hi-color   1M',
     '112h  GRAPH 640x480   16M true-color 1M',
     '113h  GRAPH 800x600   32K hi-color   1M',
     '114h  GRAPH 800x600   64K hi-color   1M');
Type
  PSVGAInfo = ^SVGAInfo;
  SVGAInfo = record
     Signature: Array[0..3] of Char;
     Version: Word;
     POEMName: PChar;
     Capabilities: Array[0..3] of Byte;
     PVideoModes: PChar;
     Reserved: Array[1..238] of Byte;
  end;

  PModeInfo = ^ModeInfo;
  ModeInfo = record
     ModeAttributes: Word;
     WindowAAttributes: Byte;
     WindowBAttributes: Byte;
     WindowGranularity: Word;
     WindowSize: Word;
     WindowASegment: Word;
     WindowBSegment: Word;
     PWindowPosRoutine: Pointer;
     BytesPerScanLine: Word;
{the following part is optional for OEM modes}
     Width: Word;
     Height: Word;
     WidthInChars: Byte;
     HeightInChars: Byte;
     NumberOfPlanes: Byte;
     NumberOfBitsPerPixel: Byte;
     NumberOfBanks: Byte;
     MemoryModel: Byte;
     SizeOfBank: Byte;
     Reserved: Array[1..228] of Byte;
  end;

var
  Secret,
  Quit: Boolean;
  VideoMode: Word;
  Mode: PModeInfo;

{ Ez az eljrs a Strings unitbl szrmazik }
function StrPas(Str: PChar): String; assembler;
asm
	PUSH	DS
	CLD
	LES	DI,Str
	MOV	CX,0FFFFH
	XOR	AL,AL
	REPNE	SCASB
	NOT	CX
	DEC	CX
	LDS	SI,Str
	LES	DI,@Result
	MOV	AL,CL
	STOSB
	REP	MOVSB
	POP	DS
end;


function Hex(Value: Word): String;
const
  HexChars: String[16] = '0123456789ABCDEF';
var
  A, I: Integer;
  S: String;
begin
  S[0] := #04;
  For I := 1 to 4 do
    begin
      A := Value and $0F;
      S[5 - I] := HexChars[A + 1];
      Value := Value shr 4;
    end;
  Hex := S;
end;

function St(Value: Word): String;
var
  S: String;
begin
  Str(Value, S);
  St := S;
end;

function GetModeInfo(InfoPtr: Pointer; Mode: Word): boolean; assembler;
asm
    PUSHA
    PUSH ES
    PUSH DS
    MOV AX, $4F01
    MOV CX, Mode
    LES DI, InfoPtr    { es:di <- InfoPtr }
    INT $10            { load the vesa info to the InfoRecord }
    CMP AH, 0
    JNE @@NOTSUCCESFUL
    MOV AL, 0
    JMP @@END
@@NOTSUCCESFUL:
    MOV AL, 1
@@END:
    POP DS
    POP ES
    POPA
end;

procedure SetSVGAMode(Mode: Word);
begin
  asm
    MOV AX, $4F02
    MOV BX, Mode
    INT $10
  end;
end;


procedure WriteTx(S: String);
var
  I: Integer;
  High: Boolean;
begin
  High := false;
  For I := 1 to byte(S[0]) do
    begin
      If S[I] = '~' then
        begin
          High := not High;
          If High then HighVideo else NormVideo;
        end
        else
          begin
            Write(S[I]);
          end;
    end;
    NormVideo;
end;

procedure WriteIt(S: String);
begin
  WriteTx(S);
  WriteLn;
end;

function GetVesaInfo(InfoPtr: Pointer): Boolean; assembler;
asm
    PUSHA
    PUSH ES
    PUSH DS
    MOV AX, $4F00
    LES DI, InfoPtr    { es:di <- InfoPtr }
    INT $10            { load the vesa info to the InfoRecord }
    CMP AH, 0
    JNE @@NOTSUCCESFUL
    MOV AL, 0
    JMP @@END
@@NOTSUCCESFUL:
    mov al, 1
@@END:
    POP DS
    POP ES
    POPA
end;

procedure WriteVesaInfo;
var
  Next: Boolean;
  I: Integer;
  VESA: PSVGAInfo;
  C: Char;
  S: String;
begin
  New(VESA);
  If VESA = nil then RunError(203);
  If not GetVESAInfo(VESA) then
    begin
      WriteLn('VESA function $4F00 failed');
      Exit;
    end;
  ClrScr;
  WriteIt('~VESA EXTENSION INFORMATIONS:~');
  WriteLn('----------------------------');
  WriteTx('VESA signature: ');
  S := '';
  For I := 0 to 3 do S := S + VESA^.Signature[I];
  WriteIt('"~' + S  + '~".');
  WriteIt('VESA version number: ~' +   St(Hi(VESA^.Version)) + '.'
    + St(Lo(VESA^.Version)) + '~.');
  S := StrPas(VESA^.POEMName);
  WriteIt('VESA OEM name: "~' + S + '~".');
  WriteIt('Capabilities bytes: ~' + St(VESA^.Capabilities[0]) + ', ' +
                                    St(VESA^.Capabilities[1]) + ', ' +
                                    St(VESA^.Capabilities[2]) + ', ' +
                                    St(VESA^.Capabilities[3]) + '~.');
  S := StrPas(VESA^.PVideoModes);
  If Secret then
    WriteIt('VESA SVGA video modes: ~' + S);
  Dispose(VESA);
  WriteLn;
  WriteIt('Press ~SPACE~ to see the video modes or ~ESC~ to exit!');

  Next := false;
    repeat
     If Keypressed then
       begin
         C := ReadKey;
         If C = ' ' then Next := true;
         If C = #27 then
           begin
             Next := true;
             Quit := true;
           end;
       end;
   until Next;
end;


procedure WriteInfo(Mode: Word);
var
  C: Char;
  S: String;
  Info: PModeInfo;
  Next, Wait: Boolean;
begin
  Wait := false;
  New(Info);
  If Info = nil then RunError(203);
  If not GetModeInfo(Info, Mode) then
    begin
      WriteLn('VESA function $4F01 failed');
      Exit;
    end;
  If Info^.ModeAttributes and $01 <> $01 then Exit;
  If Info^.ModeAttributes > 32 then Exit;
  Wait := true;
  ClrScr;
  WriteIt('Mode: ~' + SVGAModes[Mode]);
  WriteLn('-----------------------------------------------');
  WriteLn('Mode features:');
  If Info^.ModeAttributes and $04 = $04 then WriteIt('  * ~BIOS~ output supported.');
  If Info^.ModeAttributes and $08 = $08 then WriteTx('  * this is a ~color~ ') else
    WriteTx('  * this is a ~monochrome~ ');
  If Info^.ModeAttributes and $10 = $10 then WriteIt('and ~graphics~ mode.') else
    WriteIt('and ~text~ mode.');
  If Info^.WindowAAttributes and $01 = $01 then
    begin
      WriteIt('Window ~"A"~ exist at ~' + Hex(Info^.WindowASegment) + 'h~.');
    end;
  If Info^.WindowBAttributes and $01 = $01 then
    begin
      WriteIt('Window "B" axist at ~' + Hex(Info^.WindowBSegment) + '~h.');
    end;
  WriteIt('Window granularity is ~'+ St(Info^.WindowGranularity) + 'Kb~.');
  WriteIt('Window size is ~'+ St(Info^.WindowSize) + 'Kb~.');
  WriteIt('The adress of the Window positioning routine at ~' + Hex(Seg(Info^.PWindowPosRoutine)) + ':' +
    Hex(Ofs(Info^.PWindowPosRoutine)) + '~.');
  WriteIt('A scan line is set up by ~' + St(Info^.BytesPerScanLine) + '~ byte.');
  WriteLn;
  If Info^.ModeAttributes and $02 = $02 then
   If Info^.ModeAttributes and $10 = $10 then
    begin
      WriteIt('Optional OEM informations:');
      WriteIt('--------------------------');
      WriteIt('Width in pixels: ~' + St(Info^.Width) + '~.' );
      WriteIt('Height in pixels: ~' + St(Info^.Height) + '~.');
      WriteIt('Character Width in pixels: ~' + St(Info^.WidthInChars) + '~.');
      WriteIt('Character Height in pixel: ~' + St(Info^.HeightInChars) + '~.');
      WriteIt('Number of planes: ~' + St(Info^.NumberOfPlanes) + '~.');
      WriteIt('A pixel is set up by ~' + St(Info^.NumberOfBitsPerPixel) + '~ bits.');

{     This informations are not correct in my OAK 067/77 video card    }
      If Secret then
        begin
          WriteIt('Number of video banks: ~' + St(Info^.NumberOfBanks));
          WriteIt('Memory model code byte: ~' + St(Info^.MemoryModel));
          WriteIt('Size of a bank: ~' + St(Info^.SizeOfBank));
        end;
    end else
    begin
      WriteIt('Optional OEM informations:');
      WriteIt('--------------------------');
      WriteIt('Width in characters: ~' + St(Info^.Width) + '~.');
      WriteIt('Height in characters: ~' + St(Info^.Height) + '~.');
      WriteIt('Character Width in pixels: ~' + St(Info^.WidthInChars) + '~.');
      WriteIt('Character Height in pixel: ~' + St(Info^.HeightInChars) + '~.');
      WriteIt('Number of planes: ~' + St(Info^.NumberOfPlanes) + '~.');
      WriteIt('A pixel is set up by ~' + St(Info^.NumberOfBitsPerPixel) + '~ bits.');
    end;
  Dispose(Info);
  If Wait then
    begin
      WriteLn;
      WriteIt('Press ~SPACE~ to see the next mode or ~ESC~ to exit!');
      Next := false;
      repeat
        If Keypressed then
          begin
            C := ReadKey;
            If C = ' ' then Next := true;
            If C = #27 then
              begin
                Next := true;
                Quit := true;
              end;
          end;
      until Next;
    end;
end;

procedure CheckVESA;
var
  I: Integer;
  S: String;
  VESA: PSVGAInfo;
begin
  New(VESA);
  If VESA = nil then RunError(203);
  If not GetVESAInfo(VESA) then
    begin
      WriteLn('VESA function $4F00 failed');
      Exit;
    end;
  S := '';
  For I := 0 to 3 do S := S + VESA^.Signature[I];
  Dispose(VESA);
  If S <> 'VESA' then
    begin
      WriteIt('Sorry your ~VESA~ extensions is not installed!');
      Halt(1);
    end;
end;

begin
  If ParamStr(1) = '/SECRET' then Secret := true else Secret := false;
  ClrScr;
  WriteIt('~VESA~ test program, written by ~Nmeth kos~ in 1994/25/12');
  WriteLn;
  CheckVESA;
  WriteIt('This program will show you the all SVGA video modes that your');
  WriteIt('video card and BIOS can treat.');
  WriteLn;
  WriteIt('If you want to quit while runing the test, just press ~ESC~');
  WriteIt('Press ~a key~ to start!');
  repeat
  until KeyPressed;
  ReadKey;
  WriteVESAInfo;
  If Quit then Exit;
  Quit := false;
  VideoMode := $100;
  repeat
    WriteInfo(VideoMode);
    Inc(VideoMode);
  until (VideoMode = $115) or Quit;
  TextMode(co80);
end.