#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <i86.h>

#include "pm.h"
#include "vesa.h"

unsigned short xres,granul,curbank;
unsigned char *LFBadr;

void settextmode()
{
  _asm {
     xor ah,ah
     mov al,3
     int 10h
    }
}

vinfo * get_vesa_info()
{
 static vinfo vesinfo;
 REAL_REGS regs;
 dos_mem omem;
 char far *str;

 allocate_dos_mem(32,&omem);
 memset(&regs,0,sizeof(regs));

 regs.EAX=0x00004f00;
 regs.ES=omem.segment;
 regs.EDI=0;
 call_dos_int(0x10,regs);

 if (regs.EAX==0x4F00) {

 memset(&vesinfo,0,sizeof(vinfo));
 str=(char far *)MK_FP(omem.selector,0);
 _fmemmove(&vesinfo,str,256);

 vesinfo.oemstr=real_to_pm_ptr(vesinfo.oemstr);
 vesinfo.videomodeptr=(unsigned short *)real_to_pm_ptr((unsigned char *)vesinfo.videomodeptr);
 vesinfo.oemvendorname=real_to_pm_ptr(vesinfo.oemvendorname);
 vesinfo.oemproductname=real_to_pm_ptr(vesinfo.oemproductname);
 vesinfo.oemrevptr=real_to_pm_ptr(vesinfo.oemrevptr);
 free_dos_mem(&omem);

 return (&vesinfo);

 } else  {  free_dos_mem(&omem); return NULL; };

}

vesamodeinfo * get_mode_info(unsigned short mode)
{
 REAL_REGS regs;
 static vesamodeinfo mode_info;
 dos_mem omem;
 char far *str;

 allocate_dos_mem(32,&omem);

 regs.EAX=0x00004f01;
 regs.ECX=mode;
 regs.ES=omem.segment;
 regs.EDI=0;

 call_dos_int(0x10,regs);

 memset(&mode_info,0,sizeof(vesamodeinfo));
 str=(char far *)MK_FP(omem.selector,0);
_fmemmove(&mode_info,str,sizeof(vesamodeinfo));

 free_dos_mem(&omem);
 return (&mode_info);
}

short search_video_mode(short x,short y,char bits,vinfo *vesa_info)
{
  short a;
  unsigned short *vidptr;
  vesamodeinfo *mode_info;

  vidptr=vesa_info->videomodeptr;
  while( *vidptr!=0xFFFF) {
    mode_info=get_mode_info(*vidptr);
   if ((mode_info->Xres==x) && (mode_info->Yres==y) &&
       (mode_info->bitsperpix==bits)) return(*vidptr);
    vidptr++;
  };
   return 0;
};

char set_svga_mode(short x,short y,char bits,char lfb)
{
  vinfo *vesa_info;
  vesamodeinfo *mode_info;
  short mode,fl;

  vesa_info=get_vesa_info();
  mode=search_video_mode(x,y,bits,vesa_info);

  if (!mode) { printf("\nfatal: can't find %ux%ux%u video mode",x,y,bits); exit(0); };
  if (lfb==USELFB) mode+=0x4000;
  mode_info=get_mode_info(mode);

 _asm {
      mov ax,04f02h
      mov bx,[mode]
      int 10h
      mov [fl],ax
   };


    if (fl==0x4F) {
     if (lfb==USELFB)
       if (!SetupLFB(mode_info->physbaseptr,(x*y)*(bits>>3))) {
          settextmode();
          printf("\nfatal: can't init %ux%ux%u LFB mode\n",x,y,bits);exit(0); }

       xres=mode_info->Xres;
       granul=64/mode_info->wingranul;
       return 1;
      } else
      {  settextmode();
         printf("fatal : can't init %ux%ux%u %s mode \n",x,y,bits,
         lfb == USELFB ? "LFB" : "NOLFB" ); exit (0); }

}

void close_svga()
{
   if (LFBadr) CloseLFB(LFBadr);
   settextmode();
}

char SetupLFB(unsigned long adress,unsigned long size)
{
 _asm {
            mov ebx,[adress]
            mov cx,bx
            shr ebx,16
            mov esi,[size]
            mov di,si
            shr esi,16
            mov ax,800h
            int 31h
            jc nach
            mov ax,bx
            shl eax,16
            mov ax,cx
            mov [LFBadr],eax
            mov al,1
            jmp end
nach:
            xor ax,ax
end:
 };
}

void CloseLFB(unsigned long adres)
{
 _asm {
            mov ebx,[adres]
            mov cx,bx
            shr ebx,16
            mov ax,801h
            int 31h
    };
}

void putpixel(unsigned short x,unsigned short y,unsigned char color,unsigned char *where)
{
 _asm {
        xor eax,eax
        xor ecx,ecx
        xor edx,edx
        mov dx,[xres]
        mov ax,[y]
        mul edx
        mov cx,[x]
        add eax,ecx
        mov edi,where
        cmp edi,0A0000h
        jne short buffer
        add di,ax
        shr eax,16
        cmp [granul],64
        je short nomul
        imul ax,[granul]
nomul:
        cmp ax,[curbank]
        je short noswapbank
        mov dx,ax
        mov ax,4f05h
        xor bx,bx
        int 10h
        mov [curbank],dx
noswapbank:
        jmp short end
buffer:
        add edi,eax
end:
        mov al,[color]
        mov [edi],al
  }
}


unsigned short convrgb16(short r,short g,short b)
{
 _asm {
           mov ax,[r]
           shr ax,3
           shl ax,11
           mov bx,[g]
           shr bx,2
           shl bx,5
           mov dx,[b]
           shr dx,3
      //   shl dx,0
           add ax,bx
           add ax,dx
 };
     return;
}

