/*
 * Decompiled with CFR 0.152.
 */
class obj3d {
    point3d[] point;
    point3d[] normal;
    polygon[] poly;
    point3d origin = new point3d(0, 0, 0);
    int numPoints;
    int numNormals;
    int numPolys;
    int[] trig = new int[6];
    int xDeg;
    int yDeg;
    int zDeg;

    public obj3d(int n, int n2, int n3, int n4, int n5) {
        this.point = new point3d[n4];
        this.normal = new point3d[n5 * 3];
        this.poly = new polygon[n5];
        this.origin = new point3d(n, n2, n3);
        this.numPoints = 0;
        this.numNormals = 0;
        this.numPolys = 0;
        this.xDeg = 0;
        this.yDeg = 0;
        this.zDeg = 0;
    }

    public void addLocalPoint(int n, int n2, int n3) {
        ++this.numPoints;
        this.point[this.numPoints - 1] = new point3d(n, n2, n3);
        this.point[this.numPoints - 1].globalXform2origin(this.origin);
    }

    public void addLocalPoint(point3d point3d2) {
        point3d2.globalXform2origin(this.origin);
        ++this.numPoints;
        this.point[this.numPoints - 1] = point3d2;
    }

    public void addGlobalPoint(int n, int n2, int n3) {
        this.addLocalPoint(n - this.origin.x3d, n2 - this.origin.y3d, n3 - this.origin.z3d);
    }

    public void addGlobalPoint(point3d point3d2) {
        point3d2.setNewOrigin(this.origin);
        this.addLocalPoint(point3d2);
    }

    public void addLocalPoly(polygon polygon2) {
        ++this.numPolys;
        this.poly[this.numPolys - 1] = polygon2;
        this.addNormal(polygon2.normal);
    }

    public void addLocalPoly(int n, int n2, int n3, int n4, int n5, int n6) {
        polygon polygon2 = new polygon(this.point[n], this.point[n2], this.point[n3], n4, n5, n6);
        this.addLocalPoly(polygon2);
    }

    public void addGlobalPoly(polygon polygon2) {
        polygon2.setNewOrigin(this.origin);
        this.addLocalPoly(polygon2);
    }

    public int getPointNum(long l, long l2, long l3) {
        int n = 0;
        while (n < this.numPoints) {
            if ((long)this.point[n].localX == l && (long)this.point[n].localY == l2 && (long)this.point[n].localZ == l3) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getPointNum(point3d point3d2) {
        int n = 0;
        while (n < this.numPoints) {
            if (this.point[n] == point3d2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void AroundpRotate(int n, int n2, int n3, point3d point3d2, SinCos sinCos) {
        int n4 = 0;
        while (n4 < this.numPoints) {
            this.point[n4].AroundpRotate(n, n2, n3, point3d2, sinCos);
            this.point[n4].xform2d();
            ++n4;
        }
        int n5 = 0;
        while (n5 < this.numNormals) {
            this.normal[n5].AroundpRotate(n, n2, n3, point3d2, sinCos);
            ++n5;
        }
    }

    public void ResetTurn2() {
        int n = 0;
        while (n < this.numPoints) {
            this.point[n].ResetTurn2();
            ++n;
        }
    }

    public void localRotate(int n, int n2, int n3, SinCos sinCos) {
        this.xDeg += n;
        this.yDeg += n2;
        this.zDeg += n3;
        this.xDeg %= 360;
        this.yDeg %= 360;
        this.zDeg %= 360;
        this.trig[0] = sinCos.zDSin(this.xDeg);
        this.trig[1] = sinCos.zDCos(this.xDeg);
        this.trig[2] = sinCos.zDSin(this.yDeg);
        this.trig[3] = sinCos.zDCos(this.yDeg);
        this.trig[4] = sinCos.zDSin(this.zDeg);
        this.trig[5] = sinCos.zDCos(this.zDeg);
        int n4 = 0;
        while (n4 < this.numPoints) {
            this.point[n4].localRotate(this.trig, sinCos);
            this.point[n4].xform2d();
            ++n4;
        }
        int n5 = 0;
        while (n5 < this.numNormals) {
            this.normal[n5].localRotate(this.trig, sinCos);
            ++n5;
        }
    }

    public void globalRotate(int[] nArray, SinCos sinCos) {
        this.origin.globalRotate(nArray, sinCos);
        int n = 0;
        while (n < this.numPoints) {
            this.point[n].globalRotate(nArray, sinCos);
            this.point[n].xform2d();
            ++n;
        }
        int n2 = 0;
        while (n2 < this.numNormals) {
            this.normal[n2].globalRotate(nArray, sinCos);
            ++n2;
        }
    }

    public void translate(int n, int n2, int n3) {
        this.origin.translate(n, n2, n3);
        int n4 = 0;
        while (n4 < this.numPoints) {
            this.point[n4].translate(n, n2, n3);
            this.point[n4].xform2d();
            ++n4;
        }
        int n5 = 0;
        while (n5 < this.numNormals) {
            this.normal[n5].translate(n, n2, n3);
            ++n5;
        }
    }

    public void localtranslate(int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < this.numPoints) {
            this.point[n4].localtranslate(n, n2, n3);
            ++n4;
        }
        int n5 = 0;
        while (n5 < this.numNormals) {
            this.normal[n5].localtranslate(n, n2, n3);
            ++n5;
        }
    }

    public void sortPlanes() {
        int n = 0;
        while (n < this.numPolys - 1) {
            int n2 = n;
            int n3 = n2 + 1;
            while (n3 < this.numPolys) {
                if (this.poly[n3].avgZ() > this.poly[n2].avgZ()) {
                    n2 = n3;
                }
                ++n3;
            }
            if (n2 != n) {
                polygon polygon2 = this.poly[n];
                this.poly[n] = this.poly[n2];
                this.poly[n2] = polygon2;
            }
            ++n;
        }
    }

    public void setLocation(int n, int n2, int n3) {
        this.origin.setTo(n, n2, n3);
        int n4 = 0;
        while (n4 < this.numPoints) {
            this.point[n4].setNewOrigin(this.origin);
            ++n4;
        }
    }

    public void setGNormals() {
        int n = 0;
        while (n < this.numPolys) {
            this.poly[n].setGNormals();
            ++n;
        }
        int n2 = 0;
        while (n2 < this.numPoints) {
            this.point[n2].avgNormal();
            ++n2;
        }
        int n3 = this.numPoints;
        int n4 = 0;
        while (n4 < n3) {
            if (this.point[n4].nCount > 0) {
                this.addNormal(this.point[n4].nX, this.point[n4].nY, this.point[n4].nZ);
                this.point[n4].normal = this.normal[this.numNormals - 1];
            }
            ++n4;
        }
    }

    public void addNormal(int n, int n2, int n3) {
        ++this.numNormals;
        this.normal[this.numNormals - 1] = new point3d(n, n2, n3);
        this.normal[this.numNormals - 1].globalXform2origin(this.origin);
    }

    public void addNormal(point3d point3d2) {
        point3d2.globalXform2origin(this.origin);
        ++this.numNormals;
        this.normal[this.numNormals - 1] = point3d2;
    }

    public void matRotate(int n, int n2, int n3, int[] nArray, SinCos sinCos) {
        this.xDeg += n;
        this.yDeg += n2;
        this.zDeg += n3;
        this.xDeg %= 360;
        this.yDeg %= 360;
        this.zDeg %= 360;
        int n4 = sinCos.zDSin(this.xDeg);
        int n5 = sinCos.zDCos(this.xDeg);
        int n6 = sinCos.zDSin(this.yDeg);
        int n7 = sinCos.zDCos(this.yDeg);
        int n8 = sinCos.zDSin(this.zDeg);
        int n9 = sinCos.zDCos(this.zDeg);
        nArray[0] = (n9 * n7 << 8) + n4 * n8 * n6;
        nArray[1] = (-n8 * n7 << 8) + n4 * n9 * n6;
        nArray[2] = n5 * n6 << 8;
        nArray[3] = n5 * n8 << 8;
        nArray[4] = n5 * n9 << 8;
        nArray[5] = -n4 << 16;
        nArray[6] = (-n9 * n6 << 8) + n4 * n8 * n7;
        nArray[7] = (n8 * n6 << 8) + n4 * n9 * n7;
        nArray[8] = n5 * n7 << 8;
        nArray[0] = nArray[0] >> 16;
        nArray[1] = nArray[1] >> 16;
        nArray[2] = nArray[2] >> 16;
        nArray[3] = nArray[3] >> 16;
        nArray[4] = nArray[4] >> 16;
        nArray[5] = nArray[5] >> 16;
        nArray[6] = nArray[6] >> 16;
        nArray[7] = nArray[7] >> 16;
        nArray[8] = nArray[8] >> 16;
        int n10 = 0;
        while (n10 < this.numPoints) {
            this.point[n10].matRotate(nArray, sinCos);
            this.point[n10].xform2d();
            ++n10;
        }
        int n11 = 0;
        while (n11 < this.numNormals) {
            this.normal[n11].matRotate(nArray, sinCos);
            ++n11;
        }
    }
}

